/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.state.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.typed.scaladsl.adapter.package;
import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.query.DeletedDurableState;
import akka.persistence.query.DurableStateChange;
import akka.persistence.query.Offset;
import akka.persistence.query.TimestampOffset;
import akka.persistence.query.UpdatedDurableState;
import akka.persistence.query.scaladsl.DurableStateStorePagedPersistenceIdsQuery;
import akka.persistence.query.typed.scaladsl.DurableStateStoreBySliceQuery;
import akka.persistence.r2dbc.ConnectionFactoryProvider;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.R2dbcSettings$;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.ContinuousQuery$;
import akka.persistence.r2dbc.state.scaladsl.DurableStateDao;
import akka.persistence.r2dbc.state.scaladsl.DurableStateDao$;
import akka.persistence.r2dbc.state.scaladsl.R2dbcDurableStateStore$;
import akka.persistence.state.scaladsl.DurableStateUpdateStore;
import akka.persistence.state.scaladsl.GetObjectResult;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.stream.scaladsl.Source;
import com.typesafe.config.Config;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\rw!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006\"\u0002.\u0002\t\u0003Y\u0006b\u0002/\u0002\u0005\u0004%\t!\u0018\u0005\u0007M\u0006\u0001\u000b\u0011\u00020\u0007\t\u001d\fa\t\u001b\u0005\tq\u0016\u0011)\u001a!C\u0001s\"AQ0\u0002B\tB\u0003%!\u0010\u0003\u0005\u007f\u000b\tU\r\u0011\"\u0001z\u0011!yXA!E!\u0002\u0013Q\bBCA\u0001\u000b\tU\r\u0011\"\u0001\u0002\u0004!Q\u00111C\u0003\u0003\u0012\u0003\u0006I!!\u0002\t\u0015\u0005UQA!f\u0001\n\u0003\t9\u0002\u0003\u0006\u0002 \u0015\u0011\t\u0012)A\u0005\u00033AaAW\u0003\u0005\u0002\u0005\u0005\u0002\"CA\u0018\u000b\u0005\u0005I\u0011AA\u0019\u0011%\tY$BI\u0001\n\u0003\ti\u0004C\u0005\u0002T\u0015\t\n\u0011\"\u0001\u0002>!I\u0011QK\u0003\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u00037*\u0011\u0013!C\u0001\u0003;B\u0001\"!\u0019\u0006\u0003\u0003%\t%\u0018\u0005\t\u0003G*\u0011\u0011!C\u0001s\"I\u0011QM\u0003\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003g*\u0011\u0011!C!\u0003kB\u0011\"a!\u0006\u0003\u0003%\t!!\"\t\u0013\u0005=U!!A\u0005B\u0005E\u0005\"CAK\u000b\u0005\u0005I\u0011IAL\u0011%\tI*BA\u0001\n\u0003\nY\nC\u0005\u0002\u001e\u0016\t\t\u0011\"\u0011\u0002 \u001eI\u00111U\u0001\u0002\u0002#%\u0011Q\u0015\u0004\tO\u0006\t\t\u0011#\u0003\u0002(\"1!L\bC\u0001\u0003\u007fC\u0011\"!'\u001f\u0003\u0003%)%a'\t\u0013\u0005\u0005g$!A\u0005\u0002\u0006\r\u0007\"CAg=\u0005\u0005I\u0011QAh\u0011%\t\tOHA\u0001\n\u0013\t\u0019OB\u0003S\u000b\u0002\tY\u000f\u0003\u0006\u0003(\u0011\u0012\t\u0011)A\u0005\u0005SA!B!\u000e%\u0005\u0003\u0005\u000b\u0011\u0002B\u001c\u0011)\u0011I\u0005\nB\u0001B\u0003%\u0011Q\u0001\u0005\u00075\u0012\"\tAa\u0013\t\u0013\tUCE1A\u0005\n\t]\u0003\u0002\u0003B5I\u0001\u0006IA!\u0017\t\u0011\t-DE1A\u0005\nuCqA!\u001c%A\u0003%a\fC\u0005\u0003p\u0011\u0012\r\u0011\"\u0003\u0003r!A!1\u0010\u0013!\u0002\u0013\u0011\u0019\bC\u0005\u0003~\u0011\u0012\r\u0011\"\u0003\u0003\u0000!A!1\u0012\u0013!\u0002\u0013\u0011\t\tC\u0005\u0003\u000e\u0012\u0012\r\u0011\"\u0003\u0003\u0010\"A!1\u0014\u0013!\u0002\u0013\u0011\t\nC\u0005\u0003\u001e\u0012\u0012\r\u0011\"\u0003\u0003 \"A!\u0011\u0016\u0013!\u0002\u0013\u0011\t\u000bC\u0005\u0003,\u0012\u0012\r\u0011\"\u0003\u0003.\"A!Q\u0017\u0013!\u0002\u0013\u0011y\u000bC\u0005\u00038\u0012\u0012\r\u0011\"\u0003\u0003:\"A!\u0011\u001f\u0013!\u0002\u0013\u0011Y\fC\u0004\u0003t\u0012\"\tE!>\t\u000f\r5A\u0005\"\u0011\u0004\u0010!91q\u0006\u0013\u0005B\rE\u0002bBB\u0018I\u0011\u00053\u0011\n\u0005\b\u0007\u001f\"C\u0011IB)\u0011\u001d\u0019)\u0006\nC!\u0007/Bqaa\u001c%\t\u0003\u001a\t\bC\u0004\u0004\u001e\u0012\"\tea(\t\u000f\r%F\u0005\"\u0011\u0004,\"91\u0011\u0016\u0013\u0005\u0002\re\u0006bBBUI\u0011\u00051\u0011Y\u0001\u0017%J\"'m\u0019#ve\u0006\u0014G.Z*uCR,7\u000b^8sK*\u0011aiR\u0001\tg\u000e\fG.\u00193tY*\u0011\u0001*S\u0001\u0006gR\fG/\u001a\u0006\u0003\u0015.\u000bQA\u001d\u001aeE\u000eT!\u0001T'\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0002\u001d\u0006!\u0011m[6b\u0007\u0001\u0001\"!U\u0001\u000e\u0003\u0015\u0013aC\u0015\u001aeE\u000e$UO]1cY\u0016\u001cF/\u0019;f'R|'/Z\n\u0003\u0003Q\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001Q\u0003)IE-\u001a8uS\u001aLWM]\u000b\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0005Y\u0006twMC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0004'AB*ue&tw-A\u0006JI\u0016tG/\u001b4jKJ\u0004#\u0001\u0007)feNL7\u000f^3oG\u0016LEm])vKJL8\u000b^1uKN!Q\u0001V5m!\t)&.\u0003\u0002l-\n9\u0001K]8ek\u000e$\bCA7v\u001d\tq7O\u0004\u0002pe6\t\u0001O\u0003\u0002r\u001f\u00061AH]8pizJ\u0011aV\u0005\u0003iZ\u000bq\u0001]1dW\u0006<W-\u0003\u0002wo\na1+\u001a:jC2L'0\u00192mK*\u0011AOV\u0001\u000bcV,'/_\"pk:$X#\u0001>\u0011\u0005U[\u0018B\u0001?W\u0005\rIe\u000e^\u0001\fcV,'/_\"pk:$\b%\u0001\u0005s_^\u001cu.\u001e8u\u0003%\u0011xn^\"pk:$\b%A\u0005mCR,7\u000f\u001e)jIV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tyA\u0004\u0003\u0002\n\u0005-\u0001CA8W\u0013\r\tiAV\u0001\u0007!J,G-\u001a4\n\u0007\u0015\f\tBC\u0002\u0002\u000eY\u000b!\u0002\\1uKN$\b+\u001b3!\u0003\u0019!\u0018M\u00197fgV\u0011\u0011\u0011\u0004\t\u0006[\u0006m\u0011QA\u0005\u0004\u0003;9(\u0001\u0002'jgR\fq\u0001^1cY\u0016\u001c\b\u0005\u0006\u0006\u0002$\u0005\u001d\u0012\u0011FA\u0016\u0003[\u00012!!\n\u0006\u001b\u0005\t\u0001\"\u0002=\u000f\u0001\u0004Q\b\"\u0002@\u000f\u0001\u0004Q\bbBA\u0001\u001d\u0001\u0007\u0011Q\u0001\u0005\b\u0003+q\u0001\u0019AA\r\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\r\u00121GA\u001b\u0003o\tI\u0004C\u0004y\u001fA\u0005\t\u0019\u0001>\t\u000fy|\u0001\u0013!a\u0001u\"I\u0011\u0011A\b\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003+y\u0001\u0013!a\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002@)\u001a!0!\u0011,\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0014W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\n9EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e#\u0006BA\u0003\u0003\u0003\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002`)\"\u0011\u0011DA!\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA5\u0003_\u00022!VA6\u0013\r\tiG\u0016\u0002\u0004\u0003:L\b\u0002CA9-\u0005\u0005\t\u0019\u0001>\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\b\u0005\u0004\u0002z\u0005}\u0014\u0011N\u0007\u0003\u0003wR1!! W\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAD\u0003\u001b\u00032!VAE\u0013\r\tYI\u0016\u0002\b\u0005>|G.Z1o\u0011%\t\t\bGA\u0001\u0002\u0004\tI'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u00010\u0002\u0014\"A\u0011\u0011O\r\u0002\u0002\u0003\u0007!0\u0001\u0005iCND7i\u001c3f)\u0005Q\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u000ba!Z9vC2\u001cH\u0003BAD\u0003CC\u0011\"!\u001d\u001d\u0003\u0003\u0005\r!!\u001b\u00021A+'o]5ti\u0016t7-Z%egF+XM]=Ti\u0006$X\rE\u0002\u0002&y\u0019RAHAU\u0003k\u0003B\"a+\u00022jT\u0018QAA\r\u0003Gi!!!,\u000b\u0007\u0005=f+A\u0004sk:$\u0018.\\3\n\t\u0005M\u0016Q\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m&-\u0001\u0002j_&\u0019a/!/\u0015\u0005\u0005\u0015\u0016!B1qa2LHCCA\u0012\u0003\u000b\f9-!3\u0002L\")\u00010\ta\u0001u\")a0\ta\u0001u\"9\u0011\u0011A\u0011A\u0002\u0005\u0015\u0001bBA\u000bC\u0001\u0007\u0011\u0011D\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t.!8\u0011\u000bU\u000b\u0019.a6\n\u0007\u0005UgK\u0001\u0004PaRLwN\u001c\t\n+\u0006e'P_A\u0003\u00033I1!a7W\u0005\u0019!V\u000f\u001d7fi!I\u0011q\u001c\u0012\u0002\u0002\u0003\u0007\u00111E\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAs!\ry\u0016q]\u0005\u0004\u0003S\u0004'AB(cU\u0016\u001cG/\u0006\u0003\u0002n\u0006}8\u0003\u0003\u0013U\u0003_\u0014YA!\b\u0011\r\u0005E\u0018q_A~\u001b\t\t\u0019PC\u0002G\u0003kT!\u0001S&\n\t\u0005e\u00181\u001f\u0002\u0018\tV\u0014\u0018M\u00197f'R\fG/Z+qI\u0006$Xm\u0015;pe\u0016\u0004B!!@\u0002\u00002\u0001Aa\u0002B\u0001I\t\u0007!1\u0001\u0002\u0002\u0003F!!QAA5!\r)&qA\u0005\u0004\u0005\u00131&a\u0002(pi\"Lgn\u001a\t\u0007\u0005\u001b\u0011I\"a?\u000e\u0005\t=!b\u0001$\u0003\u0012)!!1\u0003B\u000b\u0003\u0015!\u0018\u0010]3e\u0015\r\u00119bS\u0001\u0006cV,'/_\u0005\u0005\u00057\u0011yAA\u000fEkJ\f'\r\\3Ti\u0006$Xm\u0015;pe\u0016\u0014\u0015p\u00157jG\u0016\fV/\u001a:z!\u0019\u0011yBa\t\u0002|6\u0011!\u0011\u0005\u0006\u0004\r\nU\u0011\u0002\u0002B\u0013\u0005C\u0011\u0011\u0006R;sC\ndWm\u0015;bi\u0016\u001cFo\u001c:f!\u0006<W\r\u001a)feNL7\u000f^3oG\u0016LEm])vKJL\u0018AB:zgR,W\u000e\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y#T\u0001\u0006C\u000e$xN]\u0005\u0005\u0005g\u0011iCA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005s\u0011)%\u0004\u0002\u0003<)!!Q\u0007B\u001f\u0015\u0011\u0011yD!\u0011\u0002\u0011QL\b/Z:bM\u0016T!Aa\u0011\u0002\u0007\r|W.\u0003\u0003\u0003H\tm\"AB\"p]\u001aLw-A\u0004dM\u001e\u0004\u0016\r\u001e5\u0015\u0011\t5#q\nB)\u0005'\u0002B!\u0015\u0013\u0002|\"9!q\u0005\u0015A\u0002\t%\u0002b\u0002B\u001bQ\u0001\u0007!q\u0007\u0005\b\u0005\u0013B\u0003\u0019AA\u0003\u0003\rawnZ\u000b\u0003\u00053\u0002BAa\u0017\u0003f5\u0011!Q\f\u0006\u0005\u0005?\u0012\t'A\u0003tY\u001a$$N\u0003\u0002\u0003d\u0005\u0019qN]4\n\t\t\u001d$Q\f\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0011g\"\f'/\u001a3D_:4\u0017n\u001a)bi\"\f\u0011c\u001d5be\u0016$7i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003!\u0019X\r\u001e;j]\u001e\u001cXC\u0001B:!\u0011\u0011)Ha\u001e\u000e\u0003%K1A!\u001fJ\u00055\u0011&\u0007\u001a2d'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\fif\u0004X\rZ*zgR,W.\u0006\u0002\u0003\u0002B1!1\u0011BD\u0005\u000bi!A!\"\u000b\t\tM!QF\u0005\u0005\u0005\u0013\u0013)IA\u0006BGR|'oU=ti\u0016l\u0017\u0001\u0004;za\u0016$7+_:uK6\u0004\u0013!D:fe&\fG.\u001b>bi&|g.\u0006\u0002\u0003\u0012B!!1\u0013BL\u001b\t\u0011)JC\u0002\u0003\u000e6KAA!'\u0003\u0016\ni1+\u001a:jC2L'0\u0019;j_:\fab]3sS\u0006d\u0017N_1uS>t\u0007%\u0001\bqKJ\u001c\u0018n\u001d;f]\u000e,W\t\u001f;\u0016\u0005\t\u0005\u0006\u0003\u0002BR\u0005Kk\u0011aS\u0005\u0004\u0005O[%a\u0003)feNL7\u000f^3oG\u0016\fq\u0002]3sg&\u001cH/\u001a8dK\u0016CH\u000fI\u0001\tgR\fG/\u001a#b_V\u0011!q\u0016\t\u0004#\nE\u0016b\u0001BZ\u000b\nyA)\u001e:bE2,7\u000b^1uK\u0012\u000bw.A\u0005ti\u0006$X\rR1pA\u00059!-_*mS\u000e,WC\u0001B^!!\u0011iLa1\u0003H\n%XB\u0001B`\u0015\r\u0011\t-S\u0001\tS:$XM\u001d8bY&!!Q\u0019B`\u00051\u0011\u0015p\u00157jG\u0016\fV/\u001a:z!\u0011\u0011IMa9\u000f\t\t-'q\u001c\b\u0005\u0005\u001b\u0014iN\u0004\u0003\u0003P\nmg\u0002\u0002Bi\u00053tAAa5\u0003X:\u0019qN!6\n\u00039K!\u0001T'\n\u0005)[\u0015B\u0001%J\u0013\t1u)C\u0002\u0003b\u0016\u000bq\u0002R;sC\ndWm\u0015;bi\u0016$\u0015m\\\u0005\u0005\u0005K\u00149O\u0001\nTKJL\u0017\r\\5{K\u0012\u001cF/\u0019;f%><(b\u0001Bq\u000bB1!1\u001eBw\u0003wl!A!\u0006\n\t\t=(Q\u0003\u0002\u0013\tV\u0014\u0018M\u00197f'R\fG/Z\"iC:<W-\u0001\u0005csNc\u0017nY3!\u0003%9W\r^(cU\u0016\u001cG\u000f\u0006\u0003\u0003x\u000e%\u0001C\u0002B}\u0005\u007f\u001c\u0019!\u0004\u0002\u0003|*\u0019!Q ,\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0004\u0002\tm(A\u0002$viV\u0014X\r\u0005\u0004\u0002r\u000e\u0015\u00111`\u0005\u0005\u0007\u000f\t\u0019PA\bHKR|%M[3diJ+7/\u001e7u\u0011\u001d\u0019Y!\u000fa\u0001\u0003\u000b\tQ\u0002]3sg&\u001cH/\u001a8dK&#\u0017\u0001D;qg\u0016\u0014Ho\u00142kK\u000e$HCCB\t\u00077\u0019iba\n\u0004,A1!\u0011 B\u0000\u0007'\u0001Ba!\u0006\u0004\u00185\tQ*C\u0002\u0004\u001a5\u0013A\u0001R8oK\"911\u0002\u001eA\u0002\u0005\u0015\u0001bBB\u0010u\u0001\u00071\u0011E\u0001\te\u00164\u0018n]5p]B\u0019Qka\t\n\u0007\r\u0015bK\u0001\u0003M_:<\u0007bBB\u0015u\u0001\u0007\u00111`\u0001\u0006m\u0006dW/\u001a\u0005\b\u0007[Q\u0004\u0019AA\u0003\u0003\r!\u0018mZ\u0001\rI\u0016dW\r^3PE*,7\r\u001e\u000b\u0005\u0007#\u0019\u0019\u0004C\u0004\u0004\fm\u0002\r!!\u0002)\u0017m\u001a9d!\u0010\u0004@\r\r3Q\t\t\u0004+\u000ee\u0012bAB\u001e-\nQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u00121\u0011I\u00015+N,\u0007\u0005\u001e5fA\u0011,G.\u001a;f\u001f\nTWm\u0019;!_Z,'\u000f\\8bI\u0002:\u0018\u000e\u001e5!e\u00164\u0018n]5p]\u0002Jgn\u001d;fC\u0012t\u0013!B:j]\u000e,\u0017EAB$\u0003\u0015\td\u0006\r\u00181)\u0019\u0019\tba\u0013\u0004N!911\u0002\u001fA\u0002\u0005\u0015\u0001bBB\u0010y\u0001\u00071\u0011E\u0001\u0016g2L7-\u001a$peB+'o]5ti\u0016t7-Z%e)\rQ81\u000b\u0005\b\u0007\u0017i\u0004\u0019AA\u0003\u0003-\u0019H.[2f%\u0006tw-Z:\u0015\t\re31\u000e\t\u0007\u00077\u001a\tg!\u001a\u000e\u0005\ru#\u0002BB0\u0003w\n\u0011\"[7nkR\f'\r\\3\n\t\r\r4Q\f\u0002\u0004'\u0016\f\bcA7\u0004h%\u00191\u0011N<\u0003\u000bI\u000bgnZ3\t\r\r5d\b1\u0001{\u00039qW/\u001c2fe>3'+\u00198hKN\facY;se\u0016tGo\u00115b]\u001e,7OQ=TY&\u001cWm\u001d\u000b\u000b\u0007g\u001a9ia#\u0004\u0010\u000eM\u0005\u0003CB;\u0007{\u0012Io!!\u000e\u0005\r]$b\u0001$\u0004z)\u001911P'\u0002\rM$(/Z1n\u0013\u0011\u0019yha\u001e\u0003\rM{WO]2f!\u0011\u0019)ba!\n\u0007\r\u0015UJA\u0004O_R,6/\u001a3\t\u000f\r%u\b1\u0001\u0002\u0006\u0005QQM\u001c;jif$\u0016\u0010]3\t\r\r5u\b1\u0001{\u0003!i\u0017N\\*mS\u000e,\u0007BBBI\u007f\u0001\u0007!0\u0001\u0005nCb\u001cF.[2f\u0011\u001d\u0019)j\u0010a\u0001\u0007/\u000baa\u001c4gg\u0016$\b\u0003\u0002Bv\u00073KAaa'\u0003\u0016\t1qJ\u001a4tKR\fqb\u00195b]\u001e,7OQ=TY&\u001cWm\u001d\u000b\u000b\u0007g\u001a\tka)\u0004&\u000e\u001d\u0006bBBE\u0001\u0002\u0007\u0011Q\u0001\u0005\u0007\u0007\u001b\u0003\u0005\u0019\u0001>\t\r\rE\u0005\t1\u0001{\u0011\u001d\u0019)\n\u0011a\u0001\u0007/\u000bQcY;se\u0016tG\u000fU3sg&\u001cH/\u001a8dK&#7\u000f\u0006\u0004\u0004.\u000e=6Q\u0017\t\t\u0007k\u001ai(!\u0002\u0004\u0002\"91\u0011W!A\u0002\rM\u0016aB1gi\u0016\u0014\u0018\n\u001a\t\u0006+\u0006M\u0017Q\u0001\u0005\b\u0007o\u000b\u0005\u0019AB\u0011\u0003\u0015a\u0017.\\5u)!\u0019ika/\u0004>\u000e}\u0006bBBE\u0005\u0002\u0007\u0011Q\u0001\u0005\b\u0007c\u0013\u0005\u0019ABZ\u0011\u001d\u00199L\u0011a\u0001\u0007C!\"a!,")
public class R2dbcDurableStateStore<A>
implements DurableStateUpdateStore<A>,
DurableStateStoreBySliceQuery<A>,
DurableStateStorePagedPersistenceIdsQuery<A> {
    private final ExtendedActorSystem system;
    private final Logger log;
    private final String sharedConfigPath;
    private final R2dbcSettings settings;
    private final akka.actor.typed.ActorSystem<Nothing$> typedSystem;
    private final Serialization serialization;
    private final Persistence persistenceExt;
    private final DurableStateDao stateDao;
    private final BySliceQuery<DurableStateDao.SerializedStateRow, DurableStateChange<A>> bySlice;

    public static String Identifier() {
        return R2dbcDurableStateStore$.MODULE$.Identifier();
    }

    private Logger log() {
        return this.log;
    }

    private String sharedConfigPath() {
        return this.sharedConfigPath;
    }

    private R2dbcSettings settings() {
        return this.settings;
    }

    private akka.actor.typed.ActorSystem<Nothing$> typedSystem() {
        return this.typedSystem;
    }

    private Serialization serialization() {
        return this.serialization;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private DurableStateDao stateDao() {
        return this.stateDao;
    }

    private BySliceQuery<DurableStateDao.SerializedStateRow, DurableStateChange<A>> bySlice() {
        return this.bySlice;
    }

    public Future<GetObjectResult<A>> getObject(String persistenceId) {
        ExecutionContextExecutor ec = this.system.dispatcher();
        return this.stateDao().readState(persistenceId).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return new GetObjectResult((Option)None$.MODULE$, 0L);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DurableStateDao.SerializedStateRow serializedRow = (DurableStateDao.SerializedStateRow)some.value();
                Option payload = serializedRow.payload().map((Function1 & Serializable)bytes -> this.serialization().deserialize(bytes, serializedRow.serId(), serializedRow.serManifest()).get());
                return new GetObjectResult(payload, serializedRow.revision());
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)ec);
    }

    public Future<Done> upsertObject(String persistenceId, long revision, A value, String tag) {
        A valueAnyRef = value;
        byte[] serialized = (byte[])this.serialization().serialize(valueAnyRef).get();
        Serializer serializer = this.serialization().findSerializerFor(valueAnyRef);
        String manifest = Serializers$.MODULE$.manifestFor(serializer, valueAnyRef);
        DurableStateDao.SerializedStateRow serializedRow = new DurableStateDao.SerializedStateRow(persistenceId, revision, DurableStateDao$.MODULE$.EmptyDbTimestamp(), DurableStateDao$.MODULE$.EmptyDbTimestamp(), (Option<byte[]>)new Some((Object)serialized), serializer.identifier(), manifest, (Set<String>)(tag.isEmpty() ? Predef$.MODULE$.Set().empty() : (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tag}))));
        return this.stateDao().upsertState(serializedRow, value);
    }

    public Future<Done> deleteObject(String persistenceId) {
        return this.deleteObject(persistenceId, 0L);
    }

    public Future<Done> deleteObject(String persistenceId, long revision) {
        return this.stateDao().deleteState(persistenceId, revision);
    }

    public int sliceForPersistenceId(String persistenceId) {
        return this.persistenceExt().sliceForPersistenceId(persistenceId);
    }

    public Seq<Range> sliceRanges(int numberOfRanges) {
        return this.persistenceExt().sliceRanges(numberOfRanges);
    }

    public Source<DurableStateChange<A>, NotUsed> currentChangesBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        return this.bySlice().currentBySlices("currentChangesBySlices", entityType, minSlice, maxSlice, offset);
    }

    public Source<DurableStateChange<A>, NotUsed> changesBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        return this.bySlice().liveBySlices("changesBySlices", entityType, minSlice, maxSlice, offset);
    }

    public Source<String, NotUsed> currentPersistenceIds(Option<String> afterId, long limit) {
        return this.stateDao().persistenceIds(afterId, limit);
    }

    public Source<String, NotUsed> currentPersistenceIds(String entityType, Option<String> afterId, long limit) {
        return this.stateDao().persistenceIds(entityType, afterId, limit);
    }

    public Source<String, NotUsed> currentPersistenceIds() {
        List customTables = ((List)this.settings().durableStateTableByEntityTypeWithSchema().toList().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$2 -> (String)x$2._2());
        String string = this.settings().durableStateTableWithSchema();
        List tables = customTables.$colon$colon((Object)string);
        return ContinuousQuery$.MODULE$.apply(new PersistenceIdsQueryState(0, 0, "", (List<String>)tables), (Function2 & Serializable)(state, pid) -> R2dbcDurableStateStore.updateState$1(state, pid), (Function1 & Serializable)x$3 -> None$.MODULE$, (Function1 & Serializable)state -> this.nextQuery$1((PersistenceIdsQueryState)state), ContinuousQuery$.MODULE$.apply$default$5()).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    private static final PersistenceIdsQueryState updateState$1(PersistenceIdsQueryState state, String pid) {
        int x$1 = state.rowCount() + 1;
        String x$2 = pid;
        int x$3 = state.copy$default$1();
        List<String> x$4 = state.copy$default$4();
        return state.copy(x$3, x$1, x$2, x$4);
    }

    private final Tuple2 next$1(PersistenceIdsQueryState newState) {
        boolean x$1 = false;
        int x$2 = newState.queryCount() + 1;
        String x$3 = newState.copy$default$3();
        List<String> x$4 = newState.copy$default$4();
        PersistenceIdsQueryState newState2 = newState.copy(x$2, 0, x$3, x$4);
        if (newState.queryCount() != 0 && this.log().isDebugEnabled()) {
            package.LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(this.log()), "persistenceIds query [{}] after [{}]. Found [{}] rows in previous query.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newState.queryCount()), newState.latestPid(), BoxesRunTime.boxToInteger((int)newState.rowCount())}));
        }
        String string = newState.latestPid();
        String string2 = "";
        None$ afterPid = !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)newState.latestPid());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newState2), (Object)new Some(this.stateDao().persistenceIds((Option<String>)afterPid, this.settings().querySettings().persistenceIdsBufferSize(), (String)newState.tables().head())));
    }

    private final Tuple2 nextQuery$1(PersistenceIdsQueryState state) {
        block2: {
            if ((long)state.queryCount() == 0L || state.rowCount() >= this.settings().querySettings().persistenceIdsBufferSize()) {
                return this.next$1(state);
            }
            if (((IterableOnceOps)state.tables().tail()).nonEmpty()) {
                List x$1 = (List)state.tables().tail();
                String x$2 = "";
                int x$3 = state.copy$default$1();
                int x$4 = state.copy$default$2();
                return this.next$1(state.copy(x$3, x$4, "", (List<String>)x$1));
            }
            if (!this.log().isDebugEnabled()) break block2;
            this.log().debug("persistenceIds query [{}] completed. Found [{}] rows in previous query.", (Object)BoxesRunTime.boxToInteger((int)state.queryCount()), (Object)BoxesRunTime.boxToInteger((int)state.rowCount()));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)None$.MODULE$);
    }

    public R2dbcDurableStateStore(ExtendedActorSystem system, Config config, String cfgPath) {
        this.system = system;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.sharedConfigPath = cfgPath.replaceAll("\\.state$", "");
        this.settings = R2dbcSettings$.MODULE$.apply(system.settings().config().getConfig(this.sharedConfigPath()));
        this.typedSystem = package.ClassicActorSystemOps$.MODULE$.toTyped$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.ClassicActorSystemOps((ActorSystem)system));
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system);
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply((ActorSystem)system);
        this.stateDao = new DurableStateDao(this.settings(), ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(this.typedSystem())).connectionFactoryFor(new StringBuilder(19).append(this.sharedConfigPath()).append(".connection-factory").toString()), (ExecutionContext)this.typedSystem().executionContext(), this.typedSystem());
        Function2 & Serializable createEnvelope = (Function2 & Serializable)(offset, row) -> {
            Option<byte[]> option = row.payload();
            if (option == null) {
                return new UpdatedDurableState(row.persistenceId(), row.revision(), null, (Offset)offset, row.dbTimestamp().toEpochMilli());
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                Object payload = this.serialization().deserialize(bytes, row.serId(), row.serManifest()).get();
                return new UpdatedDurableState(row.persistenceId(), row.revision(), payload, (Offset)offset, row.dbTimestamp().toEpochMilli());
            }
            if (None$.MODULE$.equals(option)) {
                return new DeletedDurableState(row.persistenceId(), row.revision(), (Offset)offset, row.dbTimestamp().toEpochMilli());
            }
            throw new MatchError(option);
        };
        Function1 & Serializable extractOffset = (Function1 & Serializable)env -> (TimestampOffset)env.offset();
        this.bySlice = new BySliceQuery(this.stateDao(), createEnvelope, extractOffset, this.settings(), this.log(), (ExecutionContext)this.typedSystem().executionContext());
    }

    private static final class PersistenceIdsQueryState
    implements Product,
    Serializable {
        private final int queryCount;
        private final int rowCount;
        private final String latestPid;
        private final List<String> tables;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int queryCount() {
            return this.queryCount;
        }

        public int rowCount() {
            return this.rowCount;
        }

        public String latestPid() {
            return this.latestPid;
        }

        public List<String> tables() {
            return this.tables;
        }

        public PersistenceIdsQueryState copy(int queryCount, int rowCount, String latestPid, List<String> tables) {
            return new PersistenceIdsQueryState(queryCount, rowCount, latestPid, tables);
        }

        public int copy$default$1() {
            return this.queryCount();
        }

        public int copy$default$2() {
            return this.rowCount();
        }

        public String copy$default$3() {
            return this.latestPid();
        }

        public List<String> copy$default$4() {
            return this.tables();
        }

        public String productPrefix() {
            return "PersistenceIdsQueryState";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.queryCount());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.rowCount());
                }
                case 2: {
                    return this.latestPid();
                }
                case 3: {
                    return this.tables();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PersistenceIdsQueryState;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "queryCount";
                }
                case 1: {
                    return "rowCount";
                }
                case 2: {
                    return "latestPid";
                }
                case 3: {
                    return "tables";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.queryCount());
            n = Statics.mix((int)n, (int)this.rowCount());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.latestPid()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tables()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PersistenceIdsQueryState)) return false;
            boolean bl = true;
            if (!bl) return false;
            PersistenceIdsQueryState persistenceIdsQueryState = (PersistenceIdsQueryState)x$1;
            if (this.queryCount() != persistenceIdsQueryState.queryCount()) return false;
            if (this.rowCount() != persistenceIdsQueryState.rowCount()) return false;
            String string = this.latestPid();
            String string2 = persistenceIdsQueryState.latestPid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<String> list = this.tables();
            List<String> list2 = persistenceIdsQueryState.tables();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public PersistenceIdsQueryState(int queryCount, int rowCount, String latestPid, List<String> tables) {
            this.queryCount = queryCount;
            this.rowCount = rowCount;
            this.latestPid = latestPid;
            this.tables = tables;
            Product.$init$((Product)this);
        }
    }
}

