/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.csv.impl;

import akka.annotation.InternalApi;
import akka.stream.alpakka.csv.impl.CsvFormatter$;
import akka.stream.alpakka.csv.scaladsl.CsvQuotingStyle;
import akka.stream.alpakka.csv.scaladsl.CsvQuotingStyle$Always$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import java.nio.charset.Charset;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!B\u000b\u0017\u0001a\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u00191\u0002A\u0011!A\u0003\u0006\u0003\u0005\u000b\u0011B\u0015\t\u00195\u0002A\u0011!A\u0003\u0006\u0003\u0005\u000b\u0011B\u0015\t\u00119\u0002!\u0011!Q\u0001\n=B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")1\n\u0001C\u0001\u0019\"1q\u000b\u0001Q\u0001\naCa!\u0018\u0001!\u0002\u0013q\u0006B\u00023\u0001A\u0003%a\f\u0003\u0004f\u0001\u0001\u0006IA\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00020\t\r\u001d\u0004\u0001\u0015!\u0003_\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u00159\b\u0001\"\u0003y\u0011\u0015Q\b\u0001\"\u0003|\u000f)\tiBFA\u0001\u0012\u0003A\u0012q\u0004\u0004\n+Y\t\t\u0011#\u0001\u0019\u0003CAaa\u0013\n\u0005\u0002\u0005\r\u0002\"CA\u0013%E\u0005I\u0011AA\u0014\u00051\u00195O\u001e$pe6\fG\u000f^3s\u0015\t9\u0002$\u0001\u0003j[Bd'BA\r\u001b\u0003\r\u00197O\u001e\u0006\u00037q\tq!\u00197qC.\\\u0017M\u0003\u0002\u001e=\u000511\u000f\u001e:fC6T\u0011aH\u0001\u0005C.\\\u0017m\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\f\u0011\u0002Z3mS6LG/\u001a:\u0004\u0001A\u0011!EK\u0005\u0003W\r\u0012Aa\u00115be\u0006!\u0014m[6bIM$(/Z1nI\u0005d\u0007/Y6lC\u0012\u001a7O\u001e\u0013j[BdGeQ:w\r>\u0014X.\u0019;uKJ$C%];pi\u0016\u001c\u0005.\u0019:\u0002k\u0005\\7.\u0019\u0013tiJ,\u0017-\u001c\u0013bYB\f7n[1%GN4H%[7qY\u0012\u001a5O\u001e$pe6\fG\u000f^3sI\u0011*7oY1qK\u000eC\u0017M]\u0001\nK:$wJ\u001a'j]\u0016\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a$\u001b\u0005\u0019$B\u0001\u001b)\u0003\u0019a$o\\8u}%\u0011agI\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027G\u0005a\u0011/^8uS:<7\u000b^=mKB\u0011AhP\u0007\u0002{)\u0011a\bG\u0001\tg\u000e\fG.\u00193tY&\u0011\u0001)\u0010\u0002\u0010\u0007N4\u0018+^8uS:<7\u000b^=mK\u000691\r[1sg\u0016$\bCA\"J\u001b\u0005!%BA!F\u0015\t1u)A\u0002oS>T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\t\n91\t[1sg\u0016$\u0018A\u0002\u001fj]&$h\bF\u0004N\u001fB\u0013F+\u0016,\u0011\u00059\u0003Q\"\u0001\f\t\u000b\u001d:\u0001\u0019A\u0015\t\u000bE;\u0001\u0019A\u0015\u0002\u0013E,x\u000e^3DQ\u0006\u0014\b\"B*\b\u0001\u0004I\u0013AC3tG\u0006\u0004Xm\u00115be\")af\u0002a\u0001_!)!h\u0002a\u0001w!9\u0011i\u0002I\u0001\u0002\u0004\u0011\u0015aC2iCJ\u001cX\r\u001e(b[\u0016\u0004\"!\u0017/\u000e\u0003iS!aW$\u0002\t1\fgnZ\u0005\u0003qi\u000b1\u0002Z3mS6LG/\u001a:CgB\u0011qLY\u0007\u0002A*\u0011\u0011MH\u0001\u0005kRLG.\u0003\u0002dA\nQ!)\u001f;f'R\u0014\u0018N\\4\u0002\u000fE,x\u000e^3Cg\u0006yA-\u001e9mS\u000e\fG/\u001a3Rk>$X-\u0001\tekBd\u0017nY1uK\u0012,5oY1qK\u0006YQM\u001c3PM2Kg.\u001a\"t\u0003\u0015!xnQ:w)\tq&\u000eC\u0003l\u001d\u0001\u0007A.\u0001\u0004gS\u0016dGm\u001d\t\u0004[J$X\"\u00018\u000b\u0005=\u0004\u0018!C5n[V$\u0018M\u00197f\u0015\t\t8%\u0001\u0006d_2dWm\u0019;j_:L!a\u001d8\u0003\u0011%#XM]1cY\u0016\u0004\"AI;\n\u0005Y\u001c#aA!os\u0006ian\u001c8F[B$\u0018\u0010V8DgZ$\"AX=\t\u000b-|\u0001\u0019\u00017\u0002+I,\u0017/^5sKN\fVo\u001c;fg>\u00138\u000b\u001d7jiR\u0019A0a\u0003\u0011\u000b\tjx0!\u0002\n\u0005y\u001c#A\u0002+va2,'\u0007E\u0002#\u0003\u0003I1!a\u0001$\u0005\u001d\u0011un\u001c7fC:\u00042AIA\u0004\u0013\r\tIa\t\u0002\u0004\u0013:$\bBBA\u0007!\u0001\u0007q&A\u0003gS\u0016dG\rK\u0002\u0001\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/q\u0012AC1o]>$\u0018\r^5p]&!\u00111DA\u000b\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0002\u0019\r\u001bhOR8s[\u0006$H/\u001a:\u0011\u00059\u00132C\u0001\n\")\t\ty\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003SQ3AQA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005]RBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\fG%!\u0011\u0011HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
@InternalApi
public class CsvFormatter {
    private final char delimiter;
    public final char akka$stream$alpakka$csv$impl$CsvFormatter$$quoteChar;
    public final char akka$stream$alpakka$csv$impl$CsvFormatter$$escapeChar;
    private final CsvQuotingStyle quotingStyle;
    private final String charsetName;
    private final ByteString delimiterBs;
    private final ByteString quoteBs;
    private final ByteString duplicatedQuote;
    private final ByteString duplicatedEscape;
    private final ByteString endOfLineBs;

    public static Charset $lessinit$greater$default$6() {
        return CsvFormatter$.MODULE$.$lessinit$greater$default$6();
    }

    public ByteString toCsv(Iterable<Object> fields) {
        return fields.nonEmpty() ? this.nonEmptyToCsv(fields) : this.endOfLineBs;
    }

    private ByteString nonEmptyToCsv(Iterable<Object> fields) {
        ByteStringBuilder builder = ByteString$.MODULE$.createBuilder();
        Iterator iterator = fields.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object next = iterator.next();
            Object object = next != null ? this.append$1(next.toString(), builder) : BoxedUnit.UNIT;
            hasNext = iterator.hasNext();
            Object object2 = hasNext ? builder.$plus$plus$eq(this.delimiterBs) : BoxedUnit.UNIT;
        }
        builder.$plus$plus$eq(this.endOfLineBs);
        return builder.result();
    }

    private Tuple2<Object, Object> requiresQuotesOrSplit(String field) {
        boolean quotes = CsvQuotingStyle$Always$.MODULE$.equals(this.quotingStyle);
        int split = -1;
        for (int index = 0; !(index >= field.length() || quotes && split != -1); ++index) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), index);
            if (c == this.akka$stream$alpakka$csv$impl$CsvFormatter$$quoteChar || c == this.akka$stream$alpakka$csv$impl$CsvFormatter$$escapeChar) {
                quotes = true;
                split = index;
                continue;
            }
            if (c != '\r' && c != '\n' && c != this.delimiter) continue;
            quotes = true;
        }
        return new Tuple2.mcZI.sp(quotes, split);
    }

    private final int indexOfQuoteOrEscape$1(int lastIndex, String field$1) {
        int found = -1;
        for (int index = lastIndex; index < field$1.length() && found == -1; ++index) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field$1), index);
            if (c != this.akka$stream$alpakka$csv$impl$CsvFormatter$$quoteChar && c != this.akka$stream$alpakka$csv$impl$CsvFormatter$$escapeChar) continue;
            found = index;
        }
        return found;
    }

    private final Object splitAndDuplicateQuotesAndEscapes$1(String field, int splitAt, ByteStringBuilder builder$1) {
        int lastIndex = 0;
        int index = splitAt;
        while (index > -1) {
            builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field.substring(lastIndex, index), this.charsetName));
            char c = field.charAt(index);
            ByteStringBuilder byteStringBuilder = c == this.akka$stream$alpakka$csv$impl$CsvFormatter$$quoteChar ? builder$1.$plus$plus$eq(this.duplicatedQuote) : builder$1.$plus$plus$eq(this.duplicatedEscape);
            lastIndex = index + 1;
            index = this.indexOfQuoteOrEscape$1(lastIndex, field);
        }
        return lastIndex < field.length() ? builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field.substring(lastIndex), this.charsetName)) : BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ByteStringBuilder append$1(String field, ByteStringBuilder builder$1) {
        ByteStringBuilder byteStringBuilder;
        block3: {
            int splitAt;
            block2: {
                Tuple2<Object, Object> tuple2 = this.requiresQuotesOrSplit(field);
                if (tuple2 == null) throw new MatchError(tuple2);
                boolean quoteIt = tuple2._1$mcZ$sp();
                int splitAt2 = tuple2._2$mcI$sp();
                Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(quoteIt, splitAt2);
                Tuple2.mcZI.sp sp3 = sp2;
                boolean quoteIt2 = sp3._1$mcZ$sp();
                splitAt = sp3._2$mcI$sp();
                if (quoteIt2) break block2;
                CsvQuotingStyle csvQuotingStyle = this.quotingStyle;
                CsvQuotingStyle$Always$ csvQuotingStyle$Always$ = CsvQuotingStyle$Always$.MODULE$;
                if (csvQuotingStyle != null ? !csvQuotingStyle.equals(csvQuotingStyle$Always$) : csvQuotingStyle$Always$ != null) break block3;
            }
            builder$1.$plus$plus$eq(this.quoteBs);
            Object object = splitAt != -1 ? this.splitAndDuplicateQuotesAndEscapes$1(field, splitAt, builder$1) : builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field, this.charsetName));
            byteStringBuilder = builder$1.$plus$plus$eq(this.quoteBs);
            return byteStringBuilder;
        }
        byteStringBuilder = builder$1.$plus$plus$eq(ByteString$.MODULE$.apply(field, this.charsetName));
        return byteStringBuilder;
    }

    public CsvFormatter(char delimiter, char quoteChar, char escapeChar, String endOfLine, CsvQuotingStyle quotingStyle, Charset charset) {
        this.delimiter = delimiter;
        this.akka$stream$alpakka$csv$impl$CsvFormatter$$quoteChar = quoteChar;
        this.akka$stream$alpakka$csv$impl$CsvFormatter$$escapeChar = escapeChar;
        this.quotingStyle = quotingStyle;
        this.charsetName = charset.name();
        this.delimiterBs = ByteString$.MODULE$.apply(String.valueOf(delimiter), this.charsetName);
        this.quoteBs = ByteString$.MODULE$.apply(String.valueOf(quoteChar), this.charsetName);
        this.duplicatedQuote = ByteString$.MODULE$.apply(String.valueOf(new char[]{quoteChar, quoteChar}), this.charsetName);
        this.duplicatedEscape = ByteString$.MODULE$.apply(String.valueOf(new char[]{escapeChar, escapeChar}), this.charsetName);
        this.endOfLineBs = ByteString$.MODULE$.apply(endOfLine, this.charsetName);
    }
}

