/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.dynamodb.impl;

import akka.actor.ActorSystem;
import akka.stream.alpakka.dynamodb.impl.DynamoSettings;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.typesafe.config.Config;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public final class DynamoSettings$
implements Serializable {
    public static DynamoSettings$ MODULE$;

    static {
        new DynamoSettings$();
    }

    public DynamoSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("akka.stream.alpakka.dynamodb"));
    }

    public DynamoSettings apply(Config resolvedConfig) {
        DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain;
        if (resolvedConfig.hasPath("credentials.access-key-id") && resolvedConfig.hasPath("credentials.secret-key-id")) {
            String accessKey = resolvedConfig.getString("credentials.access-key-id");
            String secretKey = resolvedConfig.getString("credentials.secret-key-id");
            defaultAWSCredentialsProviderChain = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        } else {
            defaultAWSCredentialsProviderChain = new DefaultAWSCredentialsProviderChain();
        }
        DefaultAWSCredentialsProviderChain awsCredentialsProvider = defaultAWSCredentialsProviderChain;
        return new DynamoSettings(resolvedConfig.getString("region"), resolvedConfig.getString("host"), resolvedConfig.getInt("port"), resolvedConfig.getInt("parallelism"), (AWSCredentialsProvider)awsCredentialsProvider);
    }

    public DynamoSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public DynamoSettings create(Config resolvedConfig) {
        return this.apply(resolvedConfig);
    }

    public DynamoSettings apply(String region, String host, int port, int parallelism, AWSCredentialsProvider credentialsProvider) {
        return new DynamoSettings(region, host, port, parallelism, credentialsProvider);
    }

    public Option<Tuple5<String, String, Object, Object, AWSCredentialsProvider>> unapply(DynamoSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.region(), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelism()), (Object)x$0.credentialsProvider()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamoSettings$() {
        MODULE$ = this;
    }
}

