/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.dynamodb;

import akka.actor.ActorSystem;
import akka.stream.alpakka.dynamodb.DynamoSettings;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.typesafe.config.Config;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;

public final class DynamoSettings$ {
    public static DynamoSettings$ MODULE$;
    private final String ConfigPath;

    static {
        new DynamoSettings$();
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public DynamoSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig(this.ConfigPath()));
    }

    public DynamoSettings apply(Config c) {
        DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain;
        None$ maxOpenRequests;
        String region = c.getString("region");
        String host = c.getString("host");
        int port = c.getInt("port");
        boolean tls = c.getBoolean("tls");
        int parallelism = c.getInt("parallelism");
        Object object = maxOpenRequests = c.hasPath("max-open-requests") ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)c.getInt("max-open-requests"))) : None$.MODULE$;
        if (c.hasPath("credentials.access-key-id") && c.hasPath("credentials.secret-key-id")) {
            String accessKey = c.getString("credentials.access-key-id");
            String secretKey = c.getString("credentials.secret-key-id");
            defaultAWSCredentialsProviderChain = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        } else {
            defaultAWSCredentialsProviderChain = new DefaultAWSCredentialsProviderChain();
        }
        DefaultAWSCredentialsProviderChain awsCredentialsProvider = defaultAWSCredentialsProviderChain;
        return new DynamoSettings(region, host, port, tls, parallelism, (Option<Object>)maxOpenRequests, (AWSCredentialsProvider)awsCredentialsProvider);
    }

    public DynamoSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public DynamoSettings create(Config resolvedConfig) {
        return this.apply(resolvedConfig);
    }

    public DynamoSettings apply(String region, String host) {
        return new DynamoSettings(region, host, 443, true, 4, (Option<Object>)None$.MODULE$, (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public DynamoSettings create(String region, String host) {
        return this.apply(region, host);
    }

    private DynamoSettings$() {
        MODULE$ = this;
        this.ConfigPath = "akka.stream.alpakka.dynamodb";
    }
}

