/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.elasticsearch.scaladsl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.alpakka.elasticsearch.ElasticsearchParams;
import akka.stream.alpakka.elasticsearch.MessageWriter;
import akka.stream.alpakka.elasticsearch.RetryLogic;
import akka.stream.alpakka.elasticsearch.RetryNever$;
import akka.stream.alpakka.elasticsearch.WriteMessage;
import akka.stream.alpakka.elasticsearch.WriteResult;
import akka.stream.alpakka.elasticsearch.WriteSettingsBase;
import akka.stream.alpakka.elasticsearch.impl.ElasticsearchSimpleFlowStage;
import akka.stream.alpakka.elasticsearch.scaladsl.ElasticsearchFlow;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.FlowWithContext;
import akka.stream.scaladsl.RetryFlow$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import spray.json.JsonWriter;

public final class ElasticsearchFlow$ {
    public static ElasticsearchFlow$ MODULE$;

    static {
        new ElasticsearchFlow$();
    }

    public <T> Flow<WriteMessage<T, NotUsed>, WriteResult<T, NotUsed>, NotUsed> create(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, JsonWriter<T> sprayJsonWriter) {
        return this.create(elasticsearchParams, settings, new ElasticsearchFlow.SprayJsonWriter<T>(sprayJsonWriter));
    }

    public <T> Flow<WriteMessage<T, NotUsed>, WriteResult<T, NotUsed>, NotUsed> create(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        return (Flow)((Flow)Flow$.MODULE$.apply().batch((long)settings.bufferSize(), (Function1 & Serializable & scala.Serializable)x$1 -> (Seq)new .colon.colon(x$1, (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq seq = (Seq)tuple2._1();
                WriteMessage wm = (WriteMessage)tuple2._2();
                return (Seq)seq.$colon$plus((Object)wm, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        })).via(this.stageFlow(elasticsearchParams, settings, writer)).mapConcat((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x));
    }

    public <T, C> Flow<WriteMessage<T, C>, WriteResult<T, C>, NotUsed> createWithPassThrough(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, JsonWriter<T> sprayJsonWriter) {
        return this.createWithPassThrough(elasticsearchParams, settings, new ElasticsearchFlow.SprayJsonWriter<T>(sprayJsonWriter));
    }

    public <T, C> Flow<WriteMessage<T, C>, WriteResult<T, C>, NotUsed> createWithPassThrough(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        return (Flow)((Flow)Flow$.MODULE$.apply().batch((long)settings.bufferSize(), (Function1 & Serializable & scala.Serializable)x$2 -> (Seq)new .colon.colon(x$2, (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq seq = (Seq)tuple2._1();
                WriteMessage wm = (WriteMessage)tuple2._2();
                return (Seq)seq.$colon$plus((Object)wm, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        })).via(this.stageFlow(elasticsearchParams, settings, writer)).mapConcat((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x));
    }

    public <T, C> Flow<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>, NotUsed> createBulk(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, JsonWriter<T> sprayJsonWriter) {
        return this.createBulk(elasticsearchParams, settings, new ElasticsearchFlow.SprayJsonWriter<T>(sprayJsonWriter));
    }

    public <T, C> Flow<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>, NotUsed> createBulk(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        return this.stageFlow(elasticsearchParams, settings, writer);
    }

    @ApiMayChange
    public <T, C> FlowWithContext<WriteMessage<T, NotUsed>, C, WriteResult<T, C>, C, NotUsed> createWithContext(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, JsonWriter<T> sprayJsonWriter) {
        return this.createWithContext(elasticsearchParams, settings, new ElasticsearchFlow.SprayJsonWriter<T>(sprayJsonWriter));
    }

    @ApiMayChange
    public <T, C> FlowWithContext<WriteMessage<T, NotUsed>, C, WriteResult<T, C>, C, NotUsed> createWithContext(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        return ((Flow)((Flow)Flow$.MODULE$.apply().batch((long)settings.bufferSize(), (Function1 & Serializable & scala.Serializable)x$3 -> (Seq)new .colon.colon(x$3, (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq seq = (Seq)tuple2._1();
                WriteMessage wm = (WriteMessage)tuple2._2();
                return (Seq)seq.$colon$plus((Object)wm, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        })).via(this.stageFlow(elasticsearchParams, settings, writer)).mapConcat((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x))).asFlowWithContext((Function2 & Serializable & scala.Serializable)(res, c) -> res.withPassThrough(c), (Function1 & Serializable & scala.Serializable)p -> p.message().passThrough());
    }

    @InternalApi
    private <T, C> Flow<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>, NotUsed> stageFlow(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        RetryLogic retryLogic = settings.retryLogic();
        RetryNever$ retryNever$ = RetryNever$.MODULE$;
        if (!(retryLogic != null ? !retryLogic.equals(retryNever$) : retryNever$ != null)) {
            Flow<Tuple2<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>>, Seq<WriteResult<T, C>>, NotUsed$> basicFlow = this.basicStageFlow(elasticsearchParams, settings, writer);
            return ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)messages -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(messages), (Object)Nil$.MODULE$))).via(basicFlow);
        }
        Flow<Tuple2<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>>, Seq<WriteResult<T, C>>, NotUsed$> basicFlow = this.basicStageFlow(elasticsearchParams, settings, writer);
        Flow retryFlow = RetryFlow$.MODULE$.withBackoff(settings.retryLogic().minBackoff(), settings.retryLogic().maxBackoff(), 0.0, settings.retryLogic().maxRetries(), basicFlow, (Function2 & Serializable & scala.Serializable)(x$7, results) -> ElasticsearchFlow$.retryLogic$1(results));
        return this.amendWithIndexFlow().via((Graph)retryFlow).via(this.applyOrderingFlow());
    }

    @InternalApi
    private <T, C> Flow<Seq<WriteMessage<T, C>>, Tuple2<Seq<WriteMessage<T, Tuple2<Object, C>>>, Seq<WriteResult<T, Tuple2<Object, C>>>>, NotUsed> amendWithIndexFlow() {
        return (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)messages -> {
            Seq indexedMessages = (Seq)((TraversableLike)messages.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    WriteMessage m = (WriteMessage)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    return m.withPassThrough(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), m.passThrough()));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexedMessages), (Object)Nil$.MODULE$);
        });
    }

    @InternalApi
    private <T, C> Flow<Seq<WriteResult<T, Tuple2<Object, C>>>, Seq<WriteResult<T, C>>, NotUsed> applyOrderingFlow() {
        return (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)results -> {
            Seq orderedResults = (Seq)results.sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ElasticsearchFlow$.$anonfun$applyOrderingFlow$2(x$8)), (Ordering)Ordering.Int$.MODULE$);
            Seq finalResults = (Seq)orderedResults.map((Function1 & Serializable & scala.Serializable)r -> new WriteResult(r.message().withPassThrough(((Tuple2)r.message().passThrough())._2()), r.error()), Seq$.MODULE$.canBuildFrom());
            return finalResults;
        });
    }

    @InternalApi
    private <T, C> Flow<Tuple2<Seq<WriteMessage<T, C>>, Seq<WriteResult<T, C>>>, Seq<WriteResult<T, C>>, NotUsed$> basicStageFlow(ElasticsearchParams elasticsearchParams, WriteSettingsBase<?, ?> settings, MessageWriter<T> writer) {
        return Flow$.MODULE$.fromMaterializer((Function2 & Serializable & scala.Serializable)(mat, x$9) -> {
            ActorSystem system = mat.system();
            HttpExt http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
            ExecutionContextExecutor ec = mat.executionContext();
            return Flow$.MODULE$.fromGraph(new ElasticsearchSimpleFlowStage(elasticsearchParams, settings, writer, http, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system), (ExecutionContext)ec));
        }).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$10 -> NotUsed$.MODULE$);
    }

    private static final Option retryLogic$1(Seq results) {
        Seq failed;
        Tuple2 tuple2 = results.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.success()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq successful = (Seq)tuple2._1();
        Seq failed2 = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)successful, (Object)failed2);
        Seq successful2 = (Seq)tuple22._1();
        Seq seq = failed = (Seq)tuple22._2();
        if (Nil$.MODULE$.equals(seq)) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(seq.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.message(), Seq$.MODULE$.canBuildFrom())), (Object)successful2));
    }

    public static final /* synthetic */ int $anonfun$applyOrderingFlow$2(WriteResult x$8) {
        return ((Tuple2)x$8.message().passThrough())._1$mcI$sp();
    }

    private ElasticsearchFlow$() {
        MODULE$ = this;
    }
}

