/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.file.impl.archive;

import akka.annotation.InternalApi;
import akka.stream.alpakka.file.TarArchiveMetadata;
import akka.stream.alpakka.file.TarArchiveMetadata$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class TarArchiveEntry$ {
    public static TarArchiveEntry$ MODULE$;
    private final int fileNameLength;
    private final int fileModeLength;
    private final int ownerIdLength;
    private final int groupIdLength;
    private final int fileSizeLength;
    private final int lastModificationLength;
    private final int headerChecksumLength;
    private final int linkIndicatorLength;
    private final int linkFileNameLength;
    private final int ustarIndicatorLength;
    private final int ustarVersionLength;
    private final int ownerNameLength;
    private final int groupNameLength;
    private final int deviceMajorNumberLength;
    private final int deviceMinorNumberLength;
    private final int fileNamePrefixLength;
    private final int headerLength;
    private final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1;
    private final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2;
    private final ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3;

    static {
        new TarArchiveEntry$();
    }

    public int fileNameLength() {
        return this.fileNameLength;
    }

    public int fileModeLength() {
        return this.fileModeLength;
    }

    public int ownerIdLength() {
        return this.ownerIdLength;
    }

    public int groupIdLength() {
        return this.groupIdLength;
    }

    public int fileSizeLength() {
        return this.fileSizeLength;
    }

    public int lastModificationLength() {
        return this.lastModificationLength;
    }

    public int headerChecksumLength() {
        return this.headerChecksumLength;
    }

    public int linkIndicatorLength() {
        return this.linkIndicatorLength;
    }

    public int linkFileNameLength() {
        return this.linkFileNameLength;
    }

    public int ustarIndicatorLength() {
        return this.ustarIndicatorLength;
    }

    public int ustarVersionLength() {
        return this.ustarVersionLength;
    }

    public int ownerNameLength() {
        return this.ownerNameLength;
    }

    public int groupNameLength() {
        return this.groupNameLength;
    }

    public int deviceMajorNumberLength() {
        return this.deviceMajorNumberLength;
    }

    public int deviceMinorNumberLength() {
        return this.deviceMinorNumberLength;
    }

    public int fileNamePrefixLength() {
        return this.fileNamePrefixLength;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1() {
        return this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2() {
        return this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3() {
        return this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$padded(ByteString bytes, int targetSize) {
        Predef$.MODULE$.require(bytes.size() <= targetSize, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(58).append("the padded data is ").append(bytes.size()).append(" bytes, which does not fit into  ").append(targetSize).append(" bytes").toString());
        if (bytes.size() < targetSize) {
            return bytes.$plus$plus(this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(targetSize - bytes.size()));
        }
        return bytes;
    }

    public ByteString akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(int size) {
        return ByteString$.MODULE$.fromArrayUnsafe(new byte[size]);
    }

    public TarArchiveMetadata parse(ByteString bs) {
        Predef$.MODULE$.require(bs.length() >= this.headerLength(), (Function0 & java.io.Serializable & Serializable)() -> "the tar archive header is expected to be at least 512 bytes");
        Predef$.MODULE$.require(bs.head() != 0, (Function0 & java.io.Serializable & Serializable)() -> "the file name may not be empty");
        String filename = this.getString(bs, 0, this.fileNameLength());
        String fileSizeString = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength(), this.fileSizeLength());
        long size = Long.parseUnsignedLong(fileSizeString, 8);
        String lastModificationString = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength(), this.lastModificationLength());
        Instant lastModification = Instant.ofEpochSecond(Long.parseUnsignedLong(lastModificationString, 8));
        byte tmp = bs.apply(this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength() + this.lastModificationLength() + this.headerChecksumLength());
        byte linkIndicatorByte = tmp == 0 ? TarArchiveMetadata$.MODULE$.linkIndicatorNormal() : tmp;
        String fileNamePrefix = this.getString(bs, this.fileNameLength() + this.fileModeLength() + this.ownerIdLength() + this.groupIdLength() + this.fileSizeLength() + this.lastModificationLength() + this.headerChecksumLength() + this.linkIndicatorLength() + this.linkFileNameLength() + this.ustarIndicatorLength() + this.ustarVersionLength() + this.ownerNameLength() + this.groupNameLength() + this.deviceMajorNumberLength() + this.deviceMinorNumberLength(), this.fileNamePrefixLength());
        return TarArchiveMetadata$.MODULE$.apply(fileNamePrefix, filename, size, lastModification, linkIndicatorByte);
    }

    private String getString(ByteString bs, int from, int maxLength) {
        ByteString dropped = bs.drop(from);
        int f = Math.min(dropped.indexWhere((Function1 & java.io.Serializable & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)TarArchiveEntry$.$anonfun$getString$1(BoxesRunTime.unboxToByte((Object)b)))), maxLength);
        return dropped.take(f).utf8String();
    }

    public int trailerLength(TarArchiveMetadata metadata) {
        long modulo = metadata.size() % 512L;
        if (modulo > 0L) {
            return (int)(512L - modulo);
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$getString$1(byte b) {
        return b == (byte)0 || b == (byte)32;
    }

    private TarArchiveEntry$() {
        MODULE$ = this;
        this.fileNameLength = 100;
        this.fileModeLength = 8;
        this.ownerIdLength = 8;
        this.groupIdLength = 8;
        this.fileSizeLength = 12;
        this.lastModificationLength = 12;
        this.headerChecksumLength = 8;
        this.linkIndicatorLength = 1;
        this.linkFileNameLength = 100;
        this.ustarIndicatorLength = 6;
        this.ustarVersionLength = 2;
        this.ownerNameLength = 32;
        this.groupNameLength = 32;
        this.deviceMajorNumberLength = 8;
        this.deviceMinorNumberLength = 8;
        this.fileNamePrefixLength = 155;
        this.headerLength = 512;
        this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData1 = this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$padded(ByteString$.MODULE$.apply("0755"), this.fileModeLength()).$plus$plus(this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(this.ownerIdLength() + this.groupIdLength()));
        this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData2 = ByteString$.MODULE$.apply("        ");
        this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$fixedData3 = this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(this.linkFileNameLength()).$plus$plus(ByteString$.MODULE$.apply("ustar")).$plus$plus(this.akka$stream$alpakka$file$impl$archive$TarArchiveEntry$$empty(1 + this.ustarVersionLength() + this.ownerNameLength() + this.groupNameLength() + this.deviceMajorNumberLength() + this.deviceMinorNumberLength()));
    }
}

