/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.hdfs.impl.writer;

import akka.annotation.InternalApi;
import akka.stream.alpakka.hdfs.FilePathGenerator;
import akka.stream.alpakka.hdfs.impl.writer.CompressedDataWriter$;
import akka.stream.alpakka.hdfs.impl.writer.HdfsWriter;
import akka.stream.alpakka.hdfs.impl.writer.HdfsWriter$;
import akka.util.ByteString;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5d!\u0002\u0017.\u00056J\u0004\u0002C$\u0001\u0005+\u0007I\u0011\t4\t\u0011)\u0004!\u0011#Q\u0001\n\u001dD\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\tk\u0002\u0011\t\u0012)A\u0005[\"Aa\u000f\u0001BK\u0002\u0013\u0005s\u000f\u0003\u0005}\u0001\tE\t\u0015!\u0003y\u0011!i\bA!f\u0001\n\u0003q\b\"CA\u0006\u0001\tE\t\u0015!\u0003\u0000\u0011)\ti\u0001\u0001BK\u0002\u0013\u0005\u0013q\u0002\u0005\u000b\u0003/\u0001!\u0011#Q\u0001\n\u0005E\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\u000b\u0003S\u0001\u0001R1A\u0005R\u0005-\u0002\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\ty\u0007\u0001C!\u0003cBq!a\u001e\u0001\t#\nI\bC\u0004\u0002\u0002\u0002!I!a!\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAK\u0001E\u0005I\u0011AAL\u0011%\ti\u000bAI\u0001\n\u0003\ty\u000bC\u0005\u00024\u0002\t\n\u0011\"\u0001\u00026\"I\u0011\u0011\u0018\u0001\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007f\u0003\u0011\u0013!C\u0001\u0003\u0003D\u0011\"!2\u0001\u0003\u0003%\t%a2\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAr\u0001\u0005\u0005I\u0011AAs\u0011%\t\t\u0010AA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0001\u0003\u0004!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005\u001b\u0001\u0011\u0011!C!\u0005\u001fA\u0011B!\u0005\u0001\u0003\u0003%\tEa\u0005\t\u0013\tU\u0001!!A\u0005B\t]q\u0001\u0003B\u0014[!\u0005\u0011G!\u000b\u0007\u000f1j\u0003\u0012A\u0019\u0003,!9\u0011\u0011\u0004\u0014\u0005\u0002\tU\u0002b\u0002B\u001cM\u0011\u0005!\u0011\b\u0005\n\u0005o1\u0013\u0011!CA\u0005\u0007B\u0011Ba\u0014'\u0003\u0003%\tI!\u0015\t\u0013\t}c%!A\u0005\n\t\u0005$\u0001F\"p[B\u0014Xm]:fI\u0012\u000bG/Y,sSR,'O\u0003\u0002/_\u00051qO]5uKJT!\u0001M\u0019\u0002\t%l\u0007\u000f\u001c\u0006\u0003eM\nA\u0001\u001b3gg*\u0011A'N\u0001\bC2\u0004\u0018m[6b\u0015\t1t'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002q\u0005!\u0011m[6b'\u0015\u0001!\b\u0011,Z!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fMB!\u0011I\u0011#Q\u001b\u0005i\u0013BA\".\u0005)AEMZ:Xe&$XM\u001d\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000b!AZ:\u000b\u0005%S\u0015A\u00025bI>|\u0007O\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<\u0017BA(G\u0005I15\u000bR1uC>+H\u000f];u'R\u0014X-Y7\u0011\u0005E#V\"\u0001*\u000b\u0005M;\u0014\u0001B;uS2L!!\u0016*\u0003\u0015\tKH/Z*ue&tw\r\u0005\u0002</&\u0011\u0001\f\u0010\u0002\b!J|G-^2u!\tQ6M\u0004\u0002\\C:\u0011A\fY\u0007\u0002;*\u0011alX\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tQ(\u0003\u0002cy\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0011G(F\u0001h!\t)\u0005.\u0003\u0002j\r\nQa)\u001b7f'f\u001cH/Z7\u0002\u0007\u0019\u001c\b%\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002s\u0011\u0006\u0011\u0011n\\\u0005\u0003i>\u0014\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007%A\u0007qCRDw)\u001a8fe\u0006$xN]\u000b\u0002qB\u0011\u0011P_\u0007\u0002c%\u001110\r\u0002\u0012\r&dW\rU1uQ\u001e+g.\u001a:bi>\u0014\u0018A\u00049bi\"<UM\\3sCR|'\u000fI\u0001\u0010[\u0006L(-\u001a+be\u001e,G\u000fU1uQV\tq\u0010E\u0003<\u0003\u0003\t)!C\u0002\u0002\u0004q\u0012aa\u00149uS>t\u0007cA#\u0002\b%\u0019\u0011\u0011\u0002$\u0003\tA\u000bG\u000f[\u0001\u0011[\u0006L(-\u001a+be\u001e,G\u000fU1uQ\u0002\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0016\u0005\u0005E\u0001cA\u001e\u0002\u0014%\u0019\u0011Q\u0003\u001f\u0003\u000f\t{w\u000e\\3b]\u0006QqN^3soJLG/\u001a\u0011\u0002\rqJg.\u001b;?)1\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014!\t\t\u0005\u0001C\u0003H\u0017\u0001\u0007q\rC\u0003l\u0017\u0001\u0007Q\u000eC\u0003w\u0017\u0001\u0007\u0001\u0010C\u0003~\u0017\u0001\u0007q\u0010C\u0004\u0002\u000e-\u0001\r!!\u0005\u0002\rQ\f'oZ3u+\t\t)!\u0001\u0006d_6\u0004(/Z:t_J,\"!!\r\u0011\u00079\f\u0019$C\u0002\u00026=\u0014!bQ8naJ,7o]8s\u0003-\u0019w.\u001c9sKN\u001cxN\u001d\u0011\u0002\u0013\rl\u0007oT;uaV$XCAA\u001f!\rq\u0017qH\u0005\u0004\u0003\u0003z'aF\"p[B\u0014Xm]:j_:|U\u000f\u001e9viN#(/Z1n\u0003)\u0019W\u000e](viB,H\u000fI\u0001\u0005gft7\r\u0006\u0002\u0002JA\u00191(a\u0013\n\u0007\u00055CH\u0001\u0003V]&$\u0018!B<sSR,GCBA*\u00033\ni\u0006E\u0002<\u0003+J1!a\u0016=\u0005\u0011auN\\4\t\r\u0005m#\u00031\u0001Q\u0003\u0015Ig\u000e];u\u0011\u001d\tyF\u0005a\u0001\u0003C\n\u0011b]3qCJ\fGo\u001c:\u0011\u000bm\n\t!a\u0019\u0011\u000bm\n)'!\u001b\n\u0007\u0005\u001dDHA\u0003BeJ\f\u0017\u0010E\u0002<\u0003WJ1!!\u001c=\u0005\u0011\u0011\u0015\u0010^3\u0002\rI|G/\u0019;f)\u0011\ti\"a\u001d\t\u000f\u0005U4\u00031\u0001\u0002T\u0005i!o\u001c;bi&|gnQ8v]R\faa\u0019:fCR,G#\u0002#\u0002|\u0005u\u0004\"B$\u0015\u0001\u00049\u0007bBA@)\u0001\u0007\u0011QA\u0001\u0005M&dW-A\fpkR\u0004X\u000f\u001e$jY\u0016<\u0016\u000e\u001e5FqR,gn]5p]R!\u0011QAAC\u0011\u001d\t)(\u0006a\u0001\u0003'\nAaY8qsRa\u0011QDAF\u0003\u001b\u000by)!%\u0002\u0014\"9qI\u0006I\u0001\u0002\u00049\u0007bB6\u0017!\u0003\u0005\r!\u001c\u0005\bmZ\u0001\n\u00111\u0001y\u0011\u001dih\u0003%AA\u0002}D\u0011\"!\u0004\u0017!\u0003\u0005\r!!\u0005\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0014\u0016\u0004O\u0006m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dF(\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0017\u0016\u0004[\u0006m\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003oS3\u0001_AN\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!0+\u0007}\fY*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\r'\u0006BA\t\u00037\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\fA\u0001\\1oO*\u0011\u00111[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002X\u00065'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002^B\u00191(a8\n\u0007\u0005\u0005HHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002h\u00065\bcA\u001e\u0002j&\u0019\u00111\u001e\u001f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002pz\t\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!>\u0011\r\u0005]\u0018Q`At\u001b\t\tIPC\u0002\u0002|r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty0!?\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u0011)\u0001C\u0005\u0002p\u0002\n\t\u00111\u0001\u0002h\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tIMa\u0003\t\u0013\u0005=\u0018%!AA\u0002\u0005u\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0012\te\u0001\"CAxI\u0005\u0005\t\u0019AAtQ\r\u0001!Q\u0004\t\u0005\u0005?\u0011\u0019#\u0004\u0002\u0003\")\u0019\u0011qU\u001c\n\t\t\u0015\"\u0011\u0005\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0001\u000bD_6\u0004(/Z:tK\u0012$\u0015\r^1Xe&$XM\u001d\t\u0003\u0003\u001a\u001aBA\n\u001e\u0003.A!!q\u0006B\u001a\u001b\t\u0011\tDC\u0002s\u0003#L1\u0001\u001aB\u0019)\t\u0011I#A\u0003baBd\u0017\u0010\u0006\u0006\u0002\u001e\tm\"Q\bB \u0005\u0003BQa\u0012\u0015A\u0002\u001dDQa\u001b\u0015A\u00025DQA\u001e\u0015A\u0002aDq!!\u0004)\u0001\u0004\t\t\u0002\u0006\u0007\u0002\u001e\t\u0015#q\tB%\u0005\u0017\u0012i\u0005C\u0003HS\u0001\u0007q\rC\u0003lS\u0001\u0007Q\u000eC\u0003wS\u0001\u0007\u0001\u0010C\u0003~S\u0001\u0007q\u0010C\u0004\u0002\u000e%\u0002\r!!\u0005\u0002\u000fUt\u0017\r\u001d9msR!!1\u000bB.!\u0015Y\u0014\u0011\u0001B+!%Y$qK4nq~\f\t\"C\u0002\u0003Zq\u0012a\u0001V;qY\u0016,\u0004\"\u0003B/U\u0005\u0005\t\u0019AA\u000f\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005G\u0002B!a3\u0003f%!!qMAg\u0005\u0019y%M[3di\"\u001aaE!\b)\u0007\u0015\u0012i\u0002")
@InternalApi
public final class CompressedDataWriter
implements HdfsWriter<FSDataOutputStream, ByteString>,
Product,
Serializable {
    private Path target;
    private final FileSystem fs;
    private final CompressionCodec compressionCodec;
    private final FilePathGenerator pathGenerator;
    private final Option<Path> maybeTargetPath;
    private final boolean overwrite;
    private final Compressor compressor;
    private final CompressionOutputStream cmpOutput;
    private FSDataOutputStream output;
    private Path temp;
    private volatile byte bitmap$0;

    public static Option<Tuple5<FileSystem, CompressionCodec, FilePathGenerator, Option<Path>, Object>> unapply(CompressedDataWriter compressedDataWriter) {
        return CompressedDataWriter$.MODULE$.unapply(compressedDataWriter);
    }

    public static CompressedDataWriter apply(FileSystem fileSystem, CompressionCodec compressionCodec, FilePathGenerator filePathGenerator, Option<Path> option, boolean bl) {
        return CompressedDataWriter$.MODULE$.apply(fileSystem, compressionCodec, filePathGenerator, option, bl);
    }

    public static CompressedDataWriter apply(FileSystem fileSystem, CompressionCodec compressionCodec, FilePathGenerator filePathGenerator, boolean bl) {
        return CompressedDataWriter$.MODULE$.apply(fileSystem, compressionCodec, filePathGenerator, bl);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean moveToTarget() {
        return HdfsWriter.moveToTarget$(this);
    }

    @Override
    public String targetPath() {
        return HdfsWriter.targetPath$(this);
    }

    private FSDataOutputStream output$lzycompute() {
        CompressedDataWriter compressedDataWriter = this;
        synchronized (compressedDataWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.output = (FSDataOutputStream)HdfsWriter.output$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.output;
    }

    @Override
    public FSDataOutputStream output() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.output$lzycompute() : this.output;
    }

    private Path temp$lzycompute() {
        CompressedDataWriter compressedDataWriter = this;
        synchronized (compressedDataWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.temp = HdfsWriter.temp$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.temp;
    }

    @Override
    public Path temp() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.temp$lzycompute() : this.temp;
    }

    @Override
    public FileSystem fs() {
        return this.fs;
    }

    public CompressionCodec compressionCodec() {
        return this.compressionCodec;
    }

    @Override
    public FilePathGenerator pathGenerator() {
        return this.pathGenerator;
    }

    public Option<Path> maybeTargetPath() {
        return this.maybeTargetPath;
    }

    @Override
    public boolean overwrite() {
        return this.overwrite;
    }

    private Path target$lzycompute() {
        CompressedDataWriter compressedDataWriter = this;
        synchronized (compressedDataWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.target = HdfsWriter$.MODULE$.getOrCreatePath(this.maybeTargetPath(), (Function0<Path>)(Function0 & Serializable)() -> this.outputFileWithExtension(0L));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.target;
    }

    @Override
    public Path target() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.target$lzycompute() : this.target;
    }

    private Compressor compressor() {
        return this.compressor;
    }

    private CompressionOutputStream cmpOutput() {
        return this.cmpOutput;
    }

    @Override
    public void sync() {
        ((FSDataOutputStream)this.output()).hsync();
    }

    @Override
    public long write(ByteString input, Option<byte[]> separator) {
        byte[] bytes = (byte[])input.toArray((ClassTag)ClassTag$.MODULE$.Byte());
        this.cmpOutput().write(bytes);
        separator.foreach((Function1 & Serializable)x$1 -> {
            CompressedDataWriter.$anonfun$write$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        return this.compressor().getBytesWritten();
    }

    public CompressedDataWriter rotate(long rotationCount) {
        this.cmpOutput().finish();
        ((FSDataOutputStream)this.output()).close();
        Some x$1 = new Some((Object)this.outputFileWithExtension(rotationCount));
        FileSystem x$2 = this.copy$default$1();
        CompressionCodec x$3 = this.copy$default$2();
        FilePathGenerator x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<Path>)x$1, x$5);
    }

    @Override
    public FSDataOutputStream create(FileSystem fs, Path file) {
        return fs.create(file, this.overwrite());
    }

    /*
     * WARNING - void declaration
     */
    private Path outputFileWithExtension(long rotationCount) {
        void var3_2;
        String codecExtension;
        Path candidatePath = HdfsWriter$.MODULE$.createTargetPath(this.pathGenerator(), rotationCount);
        String candidateExtension = new StringBuilder(1).append(".").append(FilenameUtils.getExtension((String)candidatePath.getName())).toString();
        String string = codecExtension = this.compressionCodec().getDefaultExtension();
        String string2 = candidateExtension;
        return (string == null ? string2 != null : !string.equals(string2)) ? candidatePath.suffix(codecExtension) : var3_2;
    }

    public CompressedDataWriter copy(FileSystem fs, CompressionCodec compressionCodec, FilePathGenerator pathGenerator, Option<Path> maybeTargetPath, boolean overwrite) {
        return new CompressedDataWriter(fs, compressionCodec, pathGenerator, maybeTargetPath, overwrite);
    }

    public FileSystem copy$default$1() {
        return this.fs();
    }

    public CompressionCodec copy$default$2() {
        return this.compressionCodec();
    }

    public FilePathGenerator copy$default$3() {
        return this.pathGenerator();
    }

    public Option<Path> copy$default$4() {
        return this.maybeTargetPath();
    }

    public boolean copy$default$5() {
        return this.overwrite();
    }

    public String productPrefix() {
        return "CompressedDataWriter";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.fs();
                break;
            }
            case 1: {
                object = this.compressionCodec();
                break;
            }
            case 2: {
                object = this.pathGenerator();
                break;
            }
            case 3: {
                object = this.maybeTargetPath();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompressedDataWriter;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "fs";
                break;
            }
            case 1: {
                string = "compressionCodec";
                break;
            }
            case 2: {
                string = "pathGenerator";
                break;
            }
            case 3: {
                string = "maybeTargetPath";
                break;
            }
            case 4: {
                string = "overwrite";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fs()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.compressionCodec()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathGenerator()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maybeTargetPath()));
        n = Statics.mix((int)n, (int)(this.overwrite() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompressedDataWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompressedDataWriter compressedDataWriter = (CompressedDataWriter)x$1;
        if (this.overwrite() != compressedDataWriter.overwrite()) return false;
        FileSystem fileSystem = this.fs();
        FileSystem fileSystem2 = compressedDataWriter.fs();
        if (fileSystem == null) {
            if (fileSystem2 != null) {
                return false;
            }
        } else if (!fileSystem.equals(fileSystem2)) return false;
        CompressionCodec compressionCodec = this.compressionCodec();
        CompressionCodec compressionCodec2 = compressedDataWriter.compressionCodec();
        if (compressionCodec == null) {
            if (compressionCodec2 != null) {
                return false;
            }
        } else if (!compressionCodec.equals(compressionCodec2)) return false;
        FilePathGenerator filePathGenerator = this.pathGenerator();
        FilePathGenerator filePathGenerator2 = compressedDataWriter.pathGenerator();
        if (filePathGenerator == null) {
            if (filePathGenerator2 != null) {
                return false;
            }
        } else if (!filePathGenerator.equals(filePathGenerator2)) return false;
        Option<Path> option = this.maybeTargetPath();
        Option<Path> option2 = compressedDataWriter.maybeTargetPath();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$write$1(CompressedDataWriter $this, byte[] x$1) {
        ((FilterOutputStream)$this.output()).write(x$1);
    }

    public CompressedDataWriter(FileSystem fs, CompressionCodec compressionCodec, FilePathGenerator pathGenerator, Option<Path> maybeTargetPath, boolean overwrite) {
        this.fs = fs;
        this.compressionCodec = compressionCodec;
        this.pathGenerator = pathGenerator;
        this.maybeTargetPath = maybeTargetPath;
        this.overwrite = overwrite;
        HdfsWriter.$init$(this);
        Product.$init$((Product)this);
        this.compressor = CodecPool.getCompressor((CompressionCodec)compressionCodec, (Configuration)fs.getConf());
        this.cmpOutput = compressionCodec.createOutputStream((OutputStream)this.output(), this.compressor());
        Predef$.MODULE$.require(this.compressor() != null, (Function0 & Serializable)() -> "Compressor cannot be null");
    }
}

