/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.influxdb.impl;

import akka.annotation.InternalApi;
import akka.stream.Outlet;
import akka.stream.SourceShape;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015aA\u0002\t\u0012\u0003C\t2\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003)\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011%\u0003!\u0011!Q\u0001\n)CQ!\u0014\u0001\u0005\u00029Cq!\u0016\u0001A\u0002\u0013\u0005a\u000bC\u0004[\u0001\u0001\u0007I\u0011A.\t\r\u0005\u0004\u0001\u0015)\u0003X\u0011\u001d\u0011\u0007\u00011A\u0005\u0002\rDqA\u001b\u0001A\u0002\u0013\u00051\u000e\u0003\u0004n\u0001\u0001\u0006K\u0001\u001a\u0005\u0006]\u0002!\te\u001c\u0005\u0006a\u0002!Ia\u001c\u0005\u0006c\u0002!\tB\u0016\u0005\u0006e\u0002!Ia\u001d\u0002\u0018\u0013:4G.\u001e=EE\n\u000b7/Z*pkJ\u001cW\rT8hS\u000eT!AE\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003)U\t\u0001\"\u001b8gYVDHM\u0019\u0006\u0003-]\tq!\u00197qC.\\\u0017M\u0003\u0002\u00193\u000511\u000f\u001e:fC6T\u0011AG\u0001\u0005C.\\\u0017-\u0006\u0002\u001d{M\u0019\u0001!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001:\u0012!B:uC\u001e,\u0017B\u0001\u0012 \u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007C\u0001\u0010%\u0013\t)sD\u0001\u0006PkRD\u0015M\u001c3mKJ\f\u0001\"\u001b8gYVDHIQ\u0002\u0001!\tIS&D\u0001+\u0015\t!2FC\u0001-\u0003\ry'oZ\u0005\u0003])\u0012\u0001\"\u00138gYVDHIQ\u0001\u0006cV,'/\u001f\t\u0003cQj\u0011A\r\u0006\u0003g)\n1\u0001\u001a;p\u0013\t)$GA\u0003Rk\u0016\u0014\u00180\u0001\u0004pkRdW\r\u001e\t\u0004qeZT\"A\f\n\u0005i:\"AB(vi2,G\u000f\u0005\u0002={1\u0001A!\u0002 \u0001\u0005\u0004y$!\u0001+\u0012\u0005\u00013\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%a\u0002(pi\"Lgn\u001a\t\u0003\u0003\u001eK!\u0001\u0013\"\u0003\u0007\u0005s\u00170A\u0003tQ\u0006\u0004X\rE\u00029\u0017nJ!\u0001T\f\u0003\u0017M{WO]2f'\"\f\u0007/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b=\u000b&k\u0015+\u0011\u0007A\u00031(D\u0001\u0012\u0011\u00151S\u00011\u0001)\u0011\u0015yS\u00011\u00011\u0011\u00151T\u00011\u00018\u0011\u0015IU\u00011\u0001K\u00035\tX/\u001a:z\u000bb,7-\u001e;fIV\tq\u000b\u0005\u0002B1&\u0011\u0011L\u0011\u0002\b\u0005>|G.Z1o\u0003E\tX/\u001a:z\u000bb,7-\u001e;fI~#S-\u001d\u000b\u00039~\u0003\"!Q/\n\u0005y\u0013%\u0001B+oSRDq\u0001Y\u0004\u0002\u0002\u0003\u0007q+A\u0002yIE\na\"];fef,\u00050Z2vi\u0016$\u0007%A\u0007eCR\f'+\u001a;sS\u00164X\rZ\u000b\u0002IB\u0019\u0011)Z4\n\u0005\u0019\u0014%AB(qi&|g\u000e\u0005\u00022Q&\u0011\u0011N\r\u0002\f#V,'/\u001f*fgVdG/A\teCR\f'+\u001a;sS\u00164X\rZ0%KF$\"\u0001\u00187\t\u000f\u0001T\u0011\u0011!a\u0001I\u0006qA-\u0019;b%\u0016$(/[3wK\u0012\u0004\u0013\u0001\u00039sKN#\u0018M\u001d;\u0015\u0003q\u000b\u0001B];o#V,'/_\u0001\u0015m\u0006d\u0017\u000eZ1uKR{G/\u00197SKN,H\u000e^:\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u000b\u00039RDQ!^\bA\u0002\u001d\faA]3tk2$\u0018f\u0001\u0001xs&\u0011\u00010\u0005\u0002\u0014\u0013:4G.\u001e=EEN{WO]2f\u0019><\u0017nY\u0005\u0003uF\u0011a#\u00138gYVDHIY*pkJ\u001cWMU1x\u0019><\u0017n\u0019\u0015\u0003\u0001q\u00042!`A\u0001\u001b\u0005q(BA@\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007q(aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public abstract class InfluxDbBaseSourceLogic<T>
extends GraphStageLogic
implements OutHandler {
    private final InfluxDB influxDB;
    private final Query query;
    private boolean queryExecuted;
    private Option<QueryResult> dataRetrieved;

    public void onDownstreamFinish() throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this);
    }

    public boolean queryExecuted() {
        return this.queryExecuted;
    }

    public void queryExecuted_$eq(boolean x$1) {
        this.queryExecuted = x$1;
    }

    public Option<QueryResult> dataRetrieved() {
        return this.dataRetrieved;
    }

    public void dataRetrieved_$eq(Option<QueryResult> x$1) {
        this.dataRetrieved = x$1;
    }

    public void preStart() {
        this.runQuery();
    }

    private void runQuery() {
        block2: {
            if (this.queryExecuted()) break block2;
            QueryResult queryResult = this.influxDB.query(this.query);
            if (!queryResult.hasError()) {
                this.failOnError(queryResult);
                this.dataRetrieved_$eq((Option<QueryResult>)new Some((Object)queryResult));
            } else {
                this.failStage((Throwable)new InfluxDBException(queryResult.getError()));
                this.dataRetrieved_$eq((Option<QueryResult>)None$.MODULE$);
            }
            this.queryExecuted_$eq(true);
        }
    }

    public boolean validateTotalResults() {
        return false;
    }

    private void failOnError(QueryResult result) {
        block0: {
            Buffer totalErrors;
            if (!this.validateTotalResults() || (totalErrors = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getResults()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.hasError()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getError(), Buffer$.MODULE$.canBuildFrom())).size() != result.getResults().size()) break block0;
            String errorMessage = (String)totalErrors.reduceLeft((Function2 & Serializable & scala.Serializable)(m1, m2) -> new StringBuilder(1).append((String)m1).append(";").append((String)m2).toString());
            this.failStage((Throwable)new InfluxDBException(errorMessage));
        }
    }

    public InfluxDbBaseSourceLogic(InfluxDB influxDB, Query query, Outlet<T> outlet, SourceShape<T> shape) {
        this.influxDB = influxDB;
        this.query = query;
        super(shape);
        OutHandler.$init$((OutHandler)this);
        this.setHandler(outlet, this);
        this.queryExecuted = false;
        this.dataRetrieved = None$.MODULE$;
    }
}

