/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.influxdb.impl;

import akka.annotation.InternalApi;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDBMapperException;
import org.influxdb.annotation.Column;
import org.influxdb.annotation.Measurement;
import org.influxdb.dto.Point;
import org.influxdb.dto.QueryResult;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r5c!B\u000f\u001f\u0001yA\u0003\"B\u0018\u0001\t\u0003\t\u0004b\u0002\u001b\u0001\u0005\u0004%\t!\u000e\u0005\u0007-\u0002\u0001\u000b\u0011\u0002\u001c\t\u000f]\u0003!\u0019!C\u00051\"1A\f\u0001Q\u0001\neCq!\u0018\u0001C\u0002\u0013%\u0001\f\u0003\u0004_\u0001\u0001\u0006I!\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019!\u0007\u0001)A\u0005C\"9Q\r\u0001b\u0001\n\u00131\u0007BB8\u0001A\u0003%q\r\u0003\u0004q\u0001\u0011\u0005a$\u001d\u0005\t\u0003\u000f\u0001A\u0011\u0001\u0010\u0002\n!A\u0011q\u0003\u0001\u0005\u0002y\tI\u0002\u0003\u0005\u0002:\u0001!\tAHA\u001e\u0011!\t\t\u0006\u0001C\u0001=\u0005M\u0003bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002p\u0002!I!!=\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005k\u0003A\u0011\u0002B\\\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqaa\b\u0001\t\u0013\u0019\t\u0003C\u0004\u00042\u0001!Iaa\r\u00033\u0005c\u0007/Y6lCJ+7/\u001e7u\u001b\u0006\u0004\b/\u001a:IK2\u0004XM\u001d\u0006\u0003?\u0001\nA![7qY*\u0011\u0011EI\u0001\tS:4G.\u001e=eE*\u00111\u0005J\u0001\bC2\u0004\u0018m[6b\u0015\t)c%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002O\u0005!\u0011m[6b'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0007\u0005\u00024\u00015\ta$A\tD\u0019\u0006\u001b6k\u0018$J\u000b2#ulQ!D\u0011\u0016+\u0012A\u000e\t\u0005oy\u00025*D\u00019\u0015\tI$(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty\u0004HA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\",\u001b\u0005!%BA#1\u0003\u0019a$o\\8u}%\u0011qiK\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002HWA!q\u0007\u0014!O\u0013\ti\u0005HA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bqA]3gY\u0016\u001cGO\u0003\u0002Ty\u0005!A.\u00198h\u0013\t)\u0006KA\u0003GS\u0016dG-\u0001\nD\u0019\u0006\u001b6k\u0018$J\u000b2#ulQ!D\u0011\u0016\u0003\u0013A\u0005$S\u0003\u000e#\u0016j\u0014(`\u001b&sulV%E)\"+\u0012!\u0017\t\u0003UiK!aW\u0016\u0003\u0007%sG/A\nG%\u0006\u001bE+S(O?6KejX,J\tRC\u0005%\u0001\nG%\u0006\u001bE+S(O?6\u000b\u0005lX,J\tRC\u0015a\u0005$S\u0003\u000e#\u0016j\u0014(`\u001b\u0006CvlV%E)\"\u0003\u0013!E!E\t~#UiQ%N\u00032{\u0006kT%O)V\t\u0011\r\u0005\u0002+E&\u00111m\u000b\u0002\b\u0005>|G.Z1o\u0003I\tE\tR0E\u000b\u000eKU*\u0011'`!>Ke\n\u0016\u0011\u0002#I35iM\u001a4s}3uJU'B)R+%+F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003Yr\nA\u0001^5nK&\u0011a.\u001b\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018A\u0005*G\u0007N\u001a4'O0G\u001fJk\u0015\t\u0016+F%\u0002\nA\u0002Z1uC\n\f7/\u001a(b[\u0016$\"\u0001\u0011:\t\u000bMd\u0001\u0019\u0001;\u0002\u000bA|\u0017N\u001c;1\u0005UT\bcA!wq&\u0011qO\u0013\u0002\u0006\u00072\f7o\u001d\t\u0003sjd\u0001\u0001B\u0005|e\u0006\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u0019\u0012\u0007u\f\t\u0001\u0005\u0002+}&\u0011qp\u000b\u0002\b\u001d>$\b.\u001b8h!\rQ\u00131A\u0005\u0004\u0003\u000bY#aA!os\u0006y!/\u001a;f]RLwN\u001c)pY&\u001c\u0017\u0010F\u0002A\u0003\u0017Aaa]\u0007A\u0002\u00055\u0001\u0007BA\b\u0003'\u0001B!\u0011<\u0002\u0012A\u0019\u00110a\u0005\u0005\u0017\u0005U\u00111BA\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\u0012\u0014aE2p]Z,'\u000f^'pI\u0016dGk\u001c)pS:$X\u0003BA\u000e\u0003k!B!!\b\u00020A!\u0011qDA\u0016\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012a\u00013u_*\u0019\u0011%a\n\u000b\u0005\u0005%\u0012aA8sO&!\u0011QFA\u0011\u0005\u0015\u0001v.\u001b8u\u0011\u001d\t\tD\u0004a\u0001\u0003g\tQ!\\8eK2\u00042!_A\u001b\t\u0019\t9D\u0004b\u0001y\n\tA+\u0001\tdC\u000eDWm\u00117bgN4\u0015.\u001a7egR!\u0011QHA\"!\rQ\u0013qH\u0005\u0004\u0003\u0003Z#\u0001B+oSRDq!!\u0012\u0010\u0001\u0004\t9%A\u0003dY\u0006T(\u0010\r\u0003\u0002J\u00055\u0003\u0003B!w\u0003\u0017\u00022!_A'\t-\ty%a\u0011\u0002\u0002\u0003\u0005)\u0011\u0001?\u0003\u0007}#C'A\u0007qCJ\u001cXmU3sS\u0016\u001c\u0018i]\u000b\u0005\u0003+\nY\u0007\u0006\u0005\u0002X\u00055\u0014\u0011OAB!\u0019\tI&a\u0019\u0002j9!\u00111LA0\u001d\r\u0019\u0015QL\u0005\u0002Y%\u0019\u0011\u0011M\u0016\u0002\u000fA\f7m[1hK&!\u0011QMA4\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u00054\u0006E\u0002z\u0003W\"a!a\u000e\u0011\u0005\u0004a\bbBA#!\u0001\u0007\u0011q\u000e\t\u0005\u0003Z\fI\u0007C\u0004\u0002tA\u0001\r!!\u001e\u0002\rM,'/[3t!\u0011\t9(! \u000f\t\u0005}\u0011\u0011P\u0005\u0005\u0003w\n\t#A\u0006Rk\u0016\u0014\u0018PU3tk2$\u0018\u0002BA@\u0003\u0003\u0013aaU3sS\u0016\u001c(\u0002BA>\u0003CAq!!\"\u0011\u0001\u0004\t9)A\u0005qe\u0016\u001c\u0017n]5p]B\u0019q'!#\n\u0007\u0005-\u0005H\u0001\u0005US6,WK\\5u\u0003=iW-Y:ve\u0016lWM\u001c;OC6,Gc\u0001!\u0002\u0012\"11/\u0005a\u0001\u0003'\u0003D!!&\u0002\u001aB!\u0011I^AL!\rI\u0018\u0011\u0014\u0003\f\u00037\u000b\t*!A\u0001\u0002\u000b\u0005APA\u0002`IU\n\u0001\u0002^5nKVs\u0017\u000e\u001e\u000b\u0005\u0003\u000f\u000b\t\u000b\u0003\u0004t%\u0001\u0007\u00111\u0015\u0019\u0005\u0003K\u000bI\u000b\u0005\u0003Bm\u0006\u001d\u0006cA=\u0002*\u0012Y\u00111VAQ\u0003\u0003\u0005\tQ!\u0001}\u0005\ryFEN\u0001\bg\u0016$H+[7f))\ti$!-\u0002D\u0006E\u00171\u001b\u0005\b\u0003g\u001b\u0002\u0019AA[\u00031\u0001x.\u001b8u\u0005VLG\u000eZ3s!\u0011\t9,!0\u000f\t\u0005}\u0011\u0011X\u0005\u0005\u0003w\u000b\t#A\u0003Q_&tG/\u0003\u0003\u0002@\u0006\u0005'a\u0002\"vS2$WM\u001d\u0006\u0005\u0003w\u000b\t\u0003C\u0004\u0002FN\u0001\r!a2\u0002\u0013\u0019LW\r\u001c3UsB,\u0007\u0007BAe\u0003\u001b\u0004B!\u0011<\u0002LB\u0019\u00110!4\u0005\u0017\u0005=\u00171YA\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012:\u0004bBAO'\u0001\u0007\u0011q\u0011\u0005\b\u0003+\u001c\u0002\u0019AA\u0001\u0003\u00151\u0018\r\\;f\u0003!\u0019X\r\u001e$jK2$GCCA\u001f\u00037\fi.!;\u0002n\"9\u00111\u0017\u000bA\u0002\u0005U\u0006bBAc)\u0001\u0007\u0011q\u001c\u0019\u0005\u0003C\f)\u000f\u0005\u0003Bm\u0006\r\bcA=\u0002f\u0012Y\u0011q]Ao\u0003\u0003\u0005\tQ!\u0001}\u0005\ryF\u0005\u000f\u0005\u0007\u0003W$\u0002\u0019\u0001!\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u0002VR\u0001\r!!\u0001\u0002CQD'o\\<Fq\u000e,\u0007\u000f^5p]&3W*[:tS:<\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\u0005u\u00121\u001f\u0005\b\u0003\u000b*\u0002\u0019AA{a\u0011\t90a?\u0011\t\u00053\u0018\u0011 \t\u0004s\u0006mHaCA\u007f\u0003g\f\t\u0011!A\u0003\u0002q\u00141a\u0018\u0013:\u0003)\u0001\u0018M]:f%><\u0018i]\u000b\u0005\u0005\u0007\u00119\u0001\u0006\u0006\u0003\u0006\t%!Q\u0002B\f\u0005;\u00012!\u001fB\u0004\t\u0019\t9D\u0006b\u0001y\"9\u0011Q\t\fA\u0002\t-\u0001\u0003B!w\u0005\u000bAqAa\u0004\u0017\u0001\u0004\u0011\t\"A\u0004d_2,XN\\:\u0011\u000b\tM!Q\u0003!\u000e\u0003iJ1!!\u001a;\u0011\u001d\u0011IB\u0006a\u0001\u00057\taA^1mk\u0016\u001c\b#\u0002B\n\u0005+I\u0003bBAC-\u0001\u0007\u0011qQ\u0001\u000eg\u0016$h)[3mIZ\u000bG.^3\u0016\t\t\r\"1\u0006\u000b\u000b\u0003{\u0011)C!\f\u00032\tM\u0002b\u0002B\u0014/\u0001\u0007!\u0011F\u0001\u0004_\nT\u0007cA=\u0003,\u00111\u0011qG\fC\u0002qDaAa\f\u0018\u0001\u0004q\u0015!\u00024jK2$\u0007bBAk/\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u000b;\u0002\u0019AADQ\u00159\"q\u0007B#!\u0015Q#\u0011\bB\u001f\u0013\r\u0011Yd\u000b\u0002\u0007i\"\u0014xn^:\u0011\t\t}\"\u0011I\u0007\u0002%&\u0019!1\t*\u0003-%cG.Z4bY\u0006\u001b7-Z:t\u000bb\u001cW\r\u001d;j_:\fdA\b!\u0003H\t-\u0014'C\u0012\u0003J\t=#\u0011\rB)+\u0011\u0011YE!\u0014\u0016\u0003\u0001#q!a\u000e1\u0005\u0004\u00119&\u0003\u0003\u0003R\tM\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0003V-\na\u0001\u001e5s_^\u001c\u0018cA?\u0003ZA!!1\fB/\u001d\rQ\u0013qL\u0005\u0005\u0005?\n9GA\u0005UQJ|w/\u00192mKFJ1Ea\u0019\u0003f\t\u001d$Q\u000b\b\u0004U\t\u0015\u0014b\u0001B+WE*!EK\u0016\u0003j\t)1oY1mCF\u001aaE!\u0010)\u000b]\u0011yGa\u001e\u0011\u000b)\u0012ID!\u001d\u0011\t\u0005e#1O\u0005\u0005\u0005k\n9G\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:\fdA\b!\u0003z\t}\u0014'C\u0012\u0003J\t=#1\u0010B)c%\u0019#1\rB3\u0005{\u0012)&M\u0003#U-\u0012I'M\u0002'\u0005c\nqDZ5fY\u00124\u0016\r\\;f\r>\u0014\bK]5nSRLg/Z:N_\u0012Lg-[3e+\u0011\u0011)I!'\u0015\u0013\u0005\u00149Ia%\u0003\u0016\nm\u0005bBAc1\u0001\u0007!\u0011\u0012\u0019\u0005\u0005\u0017\u0013y\t\u0005\u0003Bm\n5\u0005cA=\u0003\u0010\u0012Y!\u0011\u0013BD\u0003\u0003\u0005\tQ!\u0001}\u0005\u0011yF%\r\u0019\t\r\t=\u0002\u00041\u0001O\u0011\u001d\u00119\u0003\u0007a\u0001\u0005/\u00032!\u001fBM\t\u0019\t9\u0004\u0007b\u0001y\"9\u0011Q\u001b\rA\u0002\u0005\u0005\u0001&\u0002\r\u00038\t}\u0015G\u0002\u0010A\u0005C\u00139+M\u0005$\u0005\u0013\u0012yEa)\u0003REJ1Ea\u0019\u0003f\t\u0015&QK\u0019\u0006E)Z#\u0011N\u0019\u0004M\tu\u0002&\u0002\r\u0003p\t-\u0016G\u0002\u0010A\u0005[\u0013\u0019,M\u0005$\u0005\u0013\u0012yEa,\u0003REJ1Ea\u0019\u0003f\tE&QK\u0019\u0006E)Z#\u0011N\u0019\u0004M\tE\u0014A\n4jK2$g+\u00197vK\u001a{'\u000f\u0015:j[&$\u0018N^3Xe\u0006\u0004\b/\u001a:t\u001b>$\u0017NZ5fIV!!\u0011\u0018Bg)%\t'1\u0018Bd\u0005\u0013\u0014y\rC\u0004\u0002Ff\u0001\rA!01\t\t}&1\u0019\t\u0005\u0003Z\u0014\t\rE\u0002z\u0005\u0007$1B!2\u0003<\u0006\u0005\t\u0011!B\u0001y\n!q\fJ\u00192\u0011\u0019\u0011y#\u0007a\u0001\u001d\"9!qE\rA\u0002\t-\u0007cA=\u0003N\u00121\u0011qG\rC\u0002qDq!!6\u001a\u0001\u0004\t\t\u0001K\u0003\u001a\u0005o\u0011\u0019.\r\u0004\u001f\u0001\nU'1\\\u0019\nG\t%#q\nBl\u0005#\n\u0014b\tB2\u0005K\u0012IN!\u00162\u000b\tR3F!\u001b2\u0007\u0019\u0012i\u0004K\u0003\u001a\u0005_\u0012y.\r\u0004\u001f\u0001\n\u0005(q]\u0019\nG\t%#q\nBr\u0005#\n\u0014b\tB2\u0005K\u0012)O!\u00162\u000b\tR3F!\u001b2\u0007\u0019\u0012\t(\u0001\ngS\u0016dGMV1mk\u0016lu\u000eZ5gS\u0016$W\u0003\u0002Bw\u0007\u0003!2\"\u0019Bx\u0005w\u0014ipa\u0001\u0004\u0006!9\u0011Q\u0019\u000eA\u0002\tE\b\u0007\u0002Bz\u0005o\u0004B!\u0011<\u0003vB\u0019\u0011Pa>\u0005\u0017\te(q^A\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0005?\u0012\n$\u0007\u0003\u0004\u00030i\u0001\rA\u0014\u0005\b\u0005OQ\u0002\u0019\u0001B\u0000!\rI8\u0011\u0001\u0003\u0007\u0003oQ\"\u0019\u0001?\t\u000f\u0005U'\u00041\u0001\u0002\u0002!9\u0011Q\u0011\u000eA\u0002\u0005\u001d\u0005&\u0002\u000e\u00038\r%\u0011G\u0002\u0010A\u0007\u0017\u0019\t\"M\u0005$\u0005\u0013\u0012ye!\u0004\u0003REJ1Ea\u0019\u0003f\r=!QK\u0019\u0006E)Z#\u0011N\u0019\u0004M\tu\u0002&\u0002\u000e\u0003p\rU\u0011G\u0002\u0010A\u0007/\u0019i\"M\u0005$\u0005\u0013\u0012ye!\u0007\u0003REJ1Ea\u0019\u0003f\rm!QK\u0019\u0006E)Z#\u0011N\u0019\u0004M\tE\u0014AC4fi&s7\u000f^1oiRA11EB\u0016\u0007[\u0019y\u0003\u0005\u0003\u0004&\r\u001dR\"A6\n\u0007\r%2NA\u0004J]N$\u0018M\u001c;\t\r\t=2\u00041\u0001O\u0011\u001d\t)n\u0007a\u0001\u0003\u0003Aq!!\"\u001c\u0001\u0004\t9)\u0001\u0005u_6KG\u000e\\5t)\u0019\u0019)da\u000f\u0004>A\u0019!fa\u000e\n\u0007\re2F\u0001\u0003M_:<\u0007bBAk9\u0001\u00071Q\u0007\u0005\b\u0003\u000bc\u0002\u0019AADQ\r\u00011\u0011\t\t\u0005\u0007\u0007\u001aI%\u0004\u0002\u0004F)\u00191q\t\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004L\r\u0015#aC%oi\u0016\u0014h.\u00197Ba&\u0004")
@InternalApi
public class AlpakkaResultMapperHelper {
    private final ConcurrentHashMap<String, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private final int FRACTION_MIN_WIDTH;
    private final int FRACTION_MAX_WIDTH;
    private final boolean ADD_DECIMAL_POINT;
    private final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, this.FRACTION_MIN_WIDTH(), this.FRACTION_MAX_WIDTH(), this.ADD_DECIMAL_POINT()).appendZoneOrOffsetId().toFormatter();

    public ConcurrentHashMap<String, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE() {
        return this.CLASS_FIELD_CACHE;
    }

    private int FRACTION_MIN_WIDTH() {
        return this.FRACTION_MIN_WIDTH;
    }

    private int FRACTION_MAX_WIDTH() {
        return this.FRACTION_MAX_WIDTH;
    }

    private boolean ADD_DECIMAL_POINT() {
        return this.ADD_DECIMAL_POINT;
    }

    private DateTimeFormatter RFC3339_FORMATTER() {
        return this.RFC3339_FORMATTER;
    }

    public String databaseName(Class<?> point) {
        return point.getAnnotation(Measurement.class).database();
    }

    public String retentionPolicy(Class<?> point) {
        return point.getAnnotation(Measurement.class).retentionPolicy();
    }

    public <T> Point convertModelToPoint(T model) {
        Point point;
        this.throwExceptionIfMissingAnnotation(model.getClass());
        this.cacheClassFields(model.getClass());
        ConcurrentMap<String, Field> colNameAndFieldMap = this.CLASS_FIELD_CACHE().get(model.getClass().getName());
        try {
            Class<?> modelType = model.getClass();
            String measurement = this.measurementName(modelType);
            TimeUnit timeUnit = this.timeUnit(modelType);
            long time = timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            Point.Builder pointBuilder = Point.measurement((String)measurement).time(time, timeUnit);
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(colNameAndFieldMap.keySet()).asScala()).foreach((Function1 & Serializable)key -> {
                Field field = (Field)colNameAndFieldMap.get(key);
                Column column = field.getAnnotation(Column.class);
                String columnName = column.name();
                Class<?> fieldType = field.getType();
                boolean isAccessible = field.isAccessible();
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                Object value = field.get(model);
                if (column.tag()) {
                    return pointBuilder.tag(columnName, value.toString());
                }
                if ("time".equals(columnName)) {
                    if (value != null) {
                        this.setTime(pointBuilder, fieldType, timeUnit, value);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                this.setField(pointBuilder, fieldType, columnName, value);
                return BoxedUnit.UNIT;
            });
            point = pointBuilder.build();
        }
        catch (IllegalArgumentException e) {
            throw new InfluxDBMapperException((Throwable)e);
        }
        return point;
    }

    public void cacheClassFields(Class<?> clazz) {
        if (!this.CLASS_FIELD_CACHE().containsKey(clazz.getName())) {
            ConcurrentHashMap initialMap = new ConcurrentHashMap();
            ObjectRef influxColumnAndFieldMap = ObjectRef.create((Object)this.CLASS_FIELD_CACHE().putIfAbsent(clazz.getName(), initialMap));
            if ((ConcurrentMap)influxColumnAndFieldMap.elem == null) {
                influxColumnAndFieldMap.elem = initialMap;
            }
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])c.getDeclaredFields()), (Function1 & Serializable)field -> {
                    Column colAnnotation = field.getAnnotation(Column.class);
                    if (colAnnotation != null) {
                        return ((ConcurrentMap)influxColumnAndFieldMap$1.elem).put(colAnnotation.name(), field);
                    }
                    return BoxedUnit.UNIT;
                });
            }
            return;
        }
    }

    public <T> List<T> parseSeriesAs(Class<T> clazz, QueryResult.Series series, TimeUnit precision) {
        this.cacheClassFields(clazz);
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(series.getValues()).asScala()).map((Function1 & Serializable)v -> this.parseRowAs(clazz, series.getColumns(), (java.util.List<Object>)v, precision))).toList();
    }

    private String measurementName(Class<?> point) {
        return point.getAnnotation(Measurement.class).name();
    }

    private TimeUnit timeUnit(Class<?> point) {
        return point.getAnnotation(Measurement.class).timeUnit();
    }

    private void setTime(Point.Builder pointBuilder, Class<?> fieldType, TimeUnit timeUnit, Object value) {
        if (Instant.class.isAssignableFrom(fieldType)) {
            Instant instant = (Instant)value;
            long time = timeUnit.convert(instant.toEpochMilli(), TimeUnit.MILLISECONDS);
            pointBuilder.time(time, timeUnit);
            return;
        }
        throw new InfluxDBMapperException(new StringBuilder(53).append("Unsupported type ").append(fieldType).append(" for time: should be of Instant type").toString());
    }

    private void setField(Point.Builder pointBuilder, Class<?> fieldType, String columnName, Object value) {
        if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, BoxesRunTime.unboxToBoolean((Object)value));
            return;
        }
        if (Long.class.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, BoxesRunTime.unboxToLong((Object)value));
            return;
        }
        if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, BoxesRunTime.unboxToDouble((Object)value));
            return;
        }
        if (Integer.class.isAssignableFrom(fieldType) || Integer.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (long)BoxesRunTime.unboxToInt((Object)value));
            return;
        }
        if (String.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (String)value);
            return;
        }
        throw new InfluxDBMapperException(new StringBuilder(29).append("Unsupported type ").append(fieldType).append(" for column ").append(columnName).toString());
    }

    private void throwExceptionIfMissingAnnotation(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(Measurement.class)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Class ").append(clazz.getName()).append(" is not annotated with @").append(Measurement.class.getSimpleName()).toString());
        }
    }

    private <T> T parseRowAs(Class<T> clazz, java.util.List<String> columns, java.util.List<Object> values, TimeUnit precision) {
        Object t;
        try {
            ConcurrentMap<String, Field> fieldMap = this.CLASS_FIELD_CACHE().get(clazz.getName());
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), columns.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Field correspondingField = (Field)fieldMap.get(columns.get(i));
                if (correspondingField != null) {
                    this.setFieldValue(obj, correspondingField, values.get(i), precision);
                    return;
                }
            });
            t = obj;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InstantiationException ? true : throwable2 instanceof IllegalAccessException) {
                throw new InfluxDBMapperException(throwable2);
            }
            throw throwable;
        }
        return t;
    }

    private <T> void setFieldValue(T obj, Field field, Object value, TimeUnit precision) throws IllegalArgumentException, IllegalAccessException {
        if (value == null) {
            return;
        }
        Class<?> fieldType = field.getType();
        try {
            boolean isAccessible = field.isAccessible();
            if (!isAccessible) {
                field.setAccessible(true);
            }
            if (this.fieldValueModified(fieldType, field, obj, value, precision) || this.fieldValueForPrimitivesModified(fieldType, field, obj, value) || this.fieldValueForPrimitiveWrappersModified(fieldType, field, obj, value)) {
                return;
            }
            String msg = new StringBuilder(49).append("Class '").append(obj.getClass().getName()).append("' field '").append(field.getName()).append("' is from an unsupported type '").append(field.getType()).append("'.").toString();
            throw new InfluxDBMapperException(msg);
        }
        catch (ClassCastException e) {
            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(153).append("Class '").append(obj.getClass().getName()).append("' field '").append(field.getName()).append("' was defined with a different field type and caused a ClassCastException.\n             |The correct type is '").append(value.getClass().getName()).append("' (current field value: '").append(value).append("')").toString()));
            throw new InfluxDBMapperException(msg);
        }
    }

    private <T> boolean fieldValueForPrimitivesModified(Class<?> fieldType, Field field, T obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (Double.TYPE.isAssignableFrom(fieldType)) {
            field.setDouble(obj, BoxesRunTime.unboxToDouble((Object)value));
            return true;
        }
        if (Long.TYPE.isAssignableFrom(fieldType)) {
            field.setLong(obj, (long)BoxesRunTime.unboxToDouble((Object)value));
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(fieldType)) {
            field.setInt(obj, (int)BoxesRunTime.unboxToDouble((Object)value));
            return true;
        }
        if (Boolean.TYPE.isAssignableFrom(fieldType)) {
            field.setBoolean(obj, StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(String.valueOf(value))));
            return true;
        }
        return false;
    }

    private <T> boolean fieldValueForPrimitiveWrappersModified(Class<?> fieldType, Field field, T obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (Double.class.isAssignableFrom(fieldType)) {
            field.set(obj, value);
            return true;
        }
        if (Long.class.isAssignableFrom(fieldType)) {
            field.set(obj, BoxesRunTime.boxToLong((long)((long)BoxesRunTime.unboxToDouble((Object)value))));
            return true;
        }
        if (Integer.class.isAssignableFrom(fieldType)) {
            field.set(obj, (Integer)value);
            return true;
        }
        if (Boolean.class.isAssignableFrom(fieldType)) {
            field.set(obj, (Boolean)value);
            return true;
        }
        return false;
    }

    private <T> boolean fieldValueModified(Class<?> fieldType, Field field, T obj, Object value, TimeUnit precision) throws IllegalArgumentException, IllegalAccessException {
        if (String.class.isAssignableFrom(fieldType)) {
            field.set(obj, String.valueOf(value));
            return true;
        }
        if (Instant.class.isAssignableFrom(fieldType)) {
            Instant instant = this.getInstant(field, value, precision);
            field.set(obj, instant);
            return true;
        }
        return false;
    }

    private Instant getInstant(Field field, Object value, TimeUnit precision) {
        if (value instanceof String) {
            return Instant.from(this.RFC3339_FORMATTER().parse(String.valueOf(value)));
        }
        if (value instanceof Long) {
            return Instant.ofEpochMilli(this.toMillis(BoxesRunTime.unboxToLong((Object)value), precision));
        }
        if (value instanceof Double) {
            return Instant.ofEpochMilli(this.toMillis(((Double)value).longValue(), precision));
        }
        if (value instanceof Integer) {
            return Instant.ofEpochMilli(this.toMillis(((Integer)value).longValue(), precision));
        }
        throw new InfluxDBMapperException(new StringBuilder(28).append("Unsupported type ").append(field.getClass()).append(" for field ").append(field.getName()).toString());
    }

    private long toMillis(long value, TimeUnit precision) {
        return TimeUnit.MILLISECONDS.convert(value, precision);
    }

    public AlpakkaResultMapperHelper() {
        this.FRACTION_MIN_WIDTH = 0;
        this.FRACTION_MAX_WIDTH = 9;
        this.ADD_DECIMAL_POINT = true;
    }
}

