/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.jms;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.alpakka.jms.AcknowledgeMode;
import akka.stream.alpakka.jms.AcknowledgeMode$;
import akka.stream.alpakka.jms.ConnectionRetrySettings;
import akka.stream.alpakka.jms.ConnectionRetrySettings$;
import akka.stream.alpakka.jms.Credentials;
import akka.stream.alpakka.jms.Credentials$;
import akka.stream.alpakka.jms.Destination;
import akka.stream.alpakka.jms.JmsConsumerSettings;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;

public final class JmsConsumerSettings$ {
    public static final JmsConsumerSettings$ MODULE$ = new JmsConsumerSettings$();
    private static final String configPath = "alpakka.jms.consumer";

    public String configPath() {
        return configPath;
    }

    public JmsConsumerSettings apply(Config c2, ConnectionFactory connectionFactory) {
        ConnectionRetrySettings connectionRetrySettings = ConnectionRetrySettings$.MODULE$.apply(c2.getConfig("connection-retry"));
        None$ destination = None$.MODULE$;
        Option credentials = JmsConsumerSettings$.getOption$1("credentials", (Function1 & Serializable)c -> Credentials$.MODULE$.apply(c.getConfig("credentials")), c2);
        int sessionCount = c2.getInt("session-count");
        int bufferSize = c2.getInt("buffer-size");
        Option selector = JmsConsumerSettings$.getStringOption$1("selector", c2);
        Option acknowledgeMode = JmsConsumerSettings$.getOption$1("acknowledge-mode", (Function1 & Serializable)c -> AcknowledgeMode$.MODULE$.from(c.getString("acknowledge-mode")), c2);
        FiniteDuration ackTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c2.getDuration("ack-timeout")));
        Option maxAckIntervalDuration = JmsConsumerSettings$.getOption$1("max-ack-interval", (Function1 & Serializable)config -> JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("max-ack-interval"))), c2);
        Option maxAckInterval = maxAckIntervalDuration.map((Function1 & Serializable)duration -> FiniteDuration$.MODULE$.apply(duration.length(), duration.unit()));
        int maxPendingAcks = c2.getInt("max-pending-acks");
        boolean failStreamOnAckTimeout = c2.getBoolean("fail-stream-on-ack-timeout");
        FiniteDuration connectionStatusSubscriptionTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c2.getDuration("connection-status-subscription-timeout")));
        return new JmsConsumerSettings(connectionFactory, connectionRetrySettings, (Option<Destination>)destination, (Option<Credentials>)credentials, sessionCount, bufferSize, (Option<String>)selector, (Option<AcknowledgeMode>)acknowledgeMode, (Duration)ackTimeout, (Option<FiniteDuration>)maxAckInterval, maxPendingAcks, failStreamOnAckTimeout, connectionStatusSubscriptionTimeout);
    }

    public JmsConsumerSettings apply(ActorSystem actorSystem, ConnectionFactory connectionFactory) {
        return this.apply(actorSystem.settings().config().getConfig(this.configPath()), connectionFactory);
    }

    public JmsConsumerSettings apply(ClassicActorSystemProvider actorSystem, ConnectionFactory connectionFactory) {
        return this.apply(actorSystem.classicSystem(), connectionFactory);
    }

    public JmsConsumerSettings create(Config c, ConnectionFactory connectionFactory) {
        return this.apply(c, connectionFactory);
    }

    public JmsConsumerSettings create(ActorSystem actorSystem, ConnectionFactory connectionFactory) {
        return this.apply(actorSystem, connectionFactory);
    }

    public JmsConsumerSettings create(ClassicActorSystemProvider actorSystem, ConnectionFactory connectionFactory) {
        return this.apply(actorSystem.classicSystem(), connectionFactory);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Option getOption$1(String path, Function1 read, Config c$1) {
        None$ none$;
        block2: {
            block3: {
                if (!c$1.hasPath(path)) break block2;
                ConfigValueType configValueType = c$1.getValue(path).valueType();
                ConfigValueType configValueType2 = ConfigValueType.STRING;
                if (configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null) break block3;
                String string = c$1.getString(path);
                String string2 = "off";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
            }
            none$ = new Some(read.apply((Object)c$1));
            return none$;
        }
        none$ = None$.MODULE$;
        return none$;
    }

    private static final Option getStringOption$1(String path, Config c$1) {
        return c$1.hasPath(path) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(c$1.getString(path))) ? new Some((Object)c$1.getString(path)) : None$.MODULE$;
    }

    private JmsConsumerSettings$() {
    }
}

