/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.jms.impl;

import akka.annotation.InternalApi;
import akka.stream.alpakka.jms.Destination;
import akka.stream.alpakka.jms.JmsByteMessagePassThrough;
import akka.stream.alpakka.jms.JmsByteStringMessagePassThrough;
import akka.stream.alpakka.jms.JmsCorrelationId;
import akka.stream.alpakka.jms.JmsDeliveryMode;
import akka.stream.alpakka.jms.JmsEnvelope;
import akka.stream.alpakka.jms.JmsExpiration;
import akka.stream.alpakka.jms.JmsHeader;
import akka.stream.alpakka.jms.JmsMapMessagePassThrough;
import akka.stream.alpakka.jms.JmsMessageId;
import akka.stream.alpakka.jms.JmsObjectMessagePassThrough;
import akka.stream.alpakka.jms.JmsPassThrough;
import akka.stream.alpakka.jms.JmsPriority;
import akka.stream.alpakka.jms.JmsProducerSettings;
import akka.stream.alpakka.jms.JmsRedelivered;
import akka.stream.alpakka.jms.JmsReplyTo;
import akka.stream.alpakka.jms.JmsTextMessagePassThrough;
import akka.stream.alpakka.jms.JmsTimeToLive;
import akka.stream.alpakka.jms.JmsTimestamp;
import akka.stream.alpakka.jms.JmsType;
import akka.stream.alpakka.jms.UnsupportedMapMessageEntryType;
import akka.stream.alpakka.jms.UnsupportedMessagePropertyType;
import akka.stream.alpakka.jms.impl.JmsMessageProducer$;
import akka.stream.alpakka.jms.impl.JmsProducerSession;
import akka.stream.alpakka.jms.impl.SoftReferenceCache;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\u000b\u0016\t\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00037\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u001d\u0001\u0005A1A\u0005\n\u0005Ca!\u0012\u0001!\u0002\u0013\u0011\u0005b\u0002$\u0001\u0005\u0004%Ia\u0012\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0001)\t\u000b\u0015\u0004A\u0011\u00024\t\r%\u0004A\u0011A\fk\u0011\u0019)\b\u0001\"\u0001\u0018m\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u000f\u0001\u0011%\u0011qD\u0004\t\u0003#*\u0002\u0012A\u000b\u0002T\u00199A#\u0006E\u0001+\u0005U\u0003B\u0002\u001e\u0012\t\u0003\t9\u0006C\u0004\u0002ZE!\t!a\u0017\u0003%)k7/T3tg\u0006<W\r\u0015:pIV\u001cWM\u001d\u0006\u0003-]\tA![7qY*\u0011\u0001$G\u0001\u0004U6\u001c(B\u0001\u000e\u001c\u0003\u001d\tG\u000e]1lW\u0006T!\u0001H\u000f\u0002\rM$(/Z1n\u0015\u0005q\u0012\u0001B1lW\u0006\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\f1B[7t!J|G-^2feB\u0011\u0011&L\u0007\u0002U)\u0011\u0001d\u000b\u0006\u0002Y\u0005)!.\u0019<bq&\u0011aF\u000b\u0002\u0010\u001b\u0016\u001c8/Y4f!J|G-^2fe\u0006Q!.\\:TKN\u001c\u0018n\u001c8\u0011\u0005E\u0012T\"A\u000b\n\u0005M*\"A\u0005&ngB\u0013x\u000eZ;dKJ\u001cVm]:j_:\fQ!\u001a9pG\",\u0012A\u000e\t\u0003E]J!\u0001O\u0012\u0003\u0007%sG/\u0001\u0004fa>\u001c\u0007\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqjdh\u0010\t\u0003c\u0001AQaJ\u0003A\u0002!BQaL\u0003A\u0002ABQ\u0001N\u0003A\u0002Y\n!\u0003Z3gCVdG\u000fR3ti&t\u0017\r^5p]V\t!\t\u0005\u0002*\u0007&\u0011AI\u000b\u0002\f\t\u0016\u001cH/\u001b8bi&|g.A\neK\u001a\fW\u000f\u001c;EKN$\u0018N\\1uS>t\u0007%\u0001\teKN$\u0018N\\1uS>t7)Y2iKV\t\u0001\n\u0005\u00032\u0013.\u0013\u0015B\u0001&\u0016\u0005I\u0019vN\u001a;SK\u001a,'/\u001a8dK\u000e\u000b7\r[3\u0011\u00051kU\"A\f\n\u0005\u0011;\u0012!\u00053fgRLg.\u0019;j_:\u001c\u0015m\u00195fA\u0005!1/\u001a8e)\t\tF\u000b\u0005\u0002#%&\u00111k\t\u0002\u0005+:LG\u000fC\u0003V\u0015\u0001\u0007a+\u0001\u0003fY\u0016l\u0007GA,]!\ra\u0005LW\u0005\u00033^\u00111BS7t\u000b:4X\r\\8qKB\u00111\f\u0018\u0007\u0001\t%iF+!A\u0001\u0002\u000b\u0005aLA\u0002`IE\n\"a\u00182\u0011\u0005\t\u0002\u0017BA1$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AI2\n\u0005\u0011\u001c#aA!os\u00061An\\8lkB$\"AQ4\t\u000b!\\\u0001\u0019A&\u0002\t\u0011,7\u000f^\u0001\u000eGJ,\u0017\r^3NKN\u001c\u0018mZ3\u0015\u0005-t\u0007CA\u0015m\u0013\ti'FA\u0004NKN\u001c\u0018mZ3\t\u000b=d\u0001\u0019\u00019\u0002\u000f\u0015dW-\\3oiB\u0012\u0011o\u001d\t\u0004\u0019b\u0013\bCA.t\t%!h.!A\u0001\u0002\u000b\u0005aLA\u0002`II\n\u0011\u0004]8qk2\fG/Z'fgN\fw-\u001a)s_B,'\u000f^5fgR\u0019\u0011k^=\t\u000bal\u0001\u0019A6\u0002\u000f5,7o]1hK\")!0\u0004a\u0001w\u0006Q!.\\:NKN\u001c\u0018mZ31\u0005qt\bc\u0001'Y{B\u00111L \u0003\n\u007ff\f\t\u0011!A\u0003\u0002y\u00131a\u0018\u00134\u0003I\u0001x\u000e];mCR,W*\u00199NKN\u001c\u0018mZ3\u0015\u000bE\u000b)!!\u0004\t\rat\u0001\u0019AA\u0004!\rI\u0013\u0011B\u0005\u0004\u0003\u0017Q#AC'ba6+7o]1hK\"1!P\u0004a\u0001\u0003\u001f\u0001D!!\u0005\u0002\u001aA)A*a\u0005\u0002\u0018%\u0019\u0011QC\f\u00031)k7/T1q\u001b\u0016\u001c8/Y4f!\u0006\u001c8\u000f\u00165s_V<\u0007\u000eE\u0002\\\u00033!1\"a\u0007\u0002\u000e\u0005\u0005\t\u0011!B\u0001=\n\u0019q\f\n\u001b\u0002+A|\u0007/\u001e7bi\u0016lUm]:bO\u0016DU-\u00193feR)\u0011+!\t\u0002$!)\u0001p\u0004a\u0001W\"9\u0011QE\bA\u0002\u0005\u001d\u0012a\u00025fC\u0012,'o\u001d\t\u0007\u0003S\t9$!\u0010\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[\u0019SBAA\u0018\u0015\r\t\tdH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U2%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYDA\u0002TKRT1!!\u000e$!\ra\u0015qH\u0005\u0004\u0003\u0003:\"!\u0003&ng\"+\u0017\rZ3sQ\r\u0001\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0005%#aC%oi\u0016\u0014h.\u00197Ba&\f!CS7t\u001b\u0016\u001c8/Y4f!J|G-^2feB\u0011\u0011'E\n\u0003#\u0005\"\"!a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fq\ni&a\u0018\u0002j!)qf\u0005a\u0001a!9\u0011\u0011M\nA\u0002\u0005\r\u0014\u0001C:fiRLgnZ:\u0011\u00071\u000b)'C\u0002\u0002h]\u00111CS7t!J|G-^2feN+G\u000f^5oONDQ\u0001N\nA\u0002YB3!EA#Q\r\u0001\u0012Q\t")
@InternalApi
public class JmsMessageProducer {
    private final MessageProducer jmsProducer;
    private final JmsProducerSession jmsSession;
    private final int epoch;
    private final javax.jms.Destination defaultDestination;
    private final SoftReferenceCache<Destination, javax.jms.Destination> destinationCache;

    public static JmsMessageProducer apply(JmsProducerSession jmsSession, JmsProducerSettings settings, int epoch) {
        return JmsMessageProducer$.MODULE$.apply(jmsSession, settings, epoch);
    }

    public int epoch() {
        return this.epoch;
    }

    private javax.jms.Destination defaultDestination() {
        return this.defaultDestination;
    }

    private SoftReferenceCache<Destination, javax.jms.Destination> destinationCache() {
        return this.destinationCache;
    }

    public void send(JmsEnvelope<?> elem) {
        javax.jms.Destination destination;
        Set headersBeforeSend;
        Set sendHeaders;
        Message message;
        block8: {
            Tuple2 tuple2;
            block7: {
                message = this.createMessage(elem);
                this.populateMessageProperties(message, elem);
                tuple2 = elem.headers().partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.usedDuringSend()));
                if (tuple2 == null) break block7;
                sendHeaders = (Set)tuple2._1();
                headersBeforeSend = (Set)tuple2._2();
                if (headersBeforeSend != null) break block8;
            }
            throw new MatchError((Object)tuple2);
        }
        Set set = headersBeforeSend;
        Tuple2 tuple2 = new Tuple2((Object)sendHeaders, (Object)set);
        Tuple2 tuple22 = tuple2;
        Set sendHeaders2 = (Set)tuple22._1();
        Set headersBeforeSend2 = (Set)tuple22._2();
        this.populateMessageHeader(message, (Set<JmsHeader>)headersBeforeSend2);
        int deliveryMode = BoxesRunTime.unboxToInt((Object)sendHeaders2.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JmsHeader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof JmsDeliveryMode) {
                    JmsDeliveryMode jmsDeliveryMode = (JmsDeliveryMode)A1;
                    object = BoxesRunTime.boxToInteger((int)jmsDeliveryMode.deliveryMode());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JmsHeader x1) {
                JmsHeader jmsHeader = x1;
                boolean bl = jmsHeader instanceof JmsDeliveryMode;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.jmsProducer.getDeliveryMode()));
        int priority = BoxesRunTime.unboxToInt((Object)sendHeaders2.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JmsHeader, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof JmsPriority) {
                    JmsPriority jmsPriority = (JmsPriority)A1;
                    object = BoxesRunTime.boxToInteger((int)jmsPriority.priority());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JmsHeader x2) {
                JmsHeader jmsHeader = x2;
                boolean bl = jmsHeader instanceof JmsPriority;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.jmsProducer.getPriority()));
        long timeToLive = BoxesRunTime.unboxToLong((Object)sendHeaders2.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends JmsHeader, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof JmsTimeToLive) {
                    JmsTimeToLive jmsTimeToLive = (JmsTimeToLive)A1;
                    object = BoxesRunTime.boxToLong((long)jmsTimeToLive.timeInMillis());
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JmsHeader x3) {
                JmsHeader jmsHeader = x3;
                boolean bl = jmsHeader instanceof JmsTimeToLive;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.jmsProducer.getTimeToLive()));
        Option<Destination> option = elem.destination();
        if (option instanceof Some) {
            Some some = (Some)option;
            Destination messageDestination = (Destination)some.value();
            destination = this.lookup(messageDestination);
        } else if (None$.MODULE$.equals(option)) {
            destination = this.defaultDestination();
        } else {
            throw new MatchError(option);
        }
        javax.jms.Destination destination2 = destination;
        this.jmsProducer.send(destination2, message, deliveryMode, priority, timeToLive);
    }

    private javax.jms.Destination lookup(Destination dest) {
        return this.destinationCache().lookup(dest, (Function0<javax.jms.Destination>)(Function0 & Serializable)() -> (javax.jms.Destination)dest.create().apply((Object)$this.jmsSession.session()));
    }

    public Message createMessage(JmsEnvelope<?> element) {
        TextMessage textMessage;
        JmsEnvelope<?> jmsEnvelope = element;
        if (jmsEnvelope instanceof JmsTextMessagePassThrough) {
            JmsTextMessagePassThrough jmsTextMessagePassThrough = (JmsTextMessagePassThrough)jmsEnvelope;
            textMessage = this.jmsSession.session().createTextMessage(jmsTextMessagePassThrough.body());
        } else if (jmsEnvelope instanceof JmsByteMessagePassThrough) {
            JmsByteMessagePassThrough jmsByteMessagePassThrough = (JmsByteMessagePassThrough)jmsEnvelope;
            BytesMessage newMessage = this.jmsSession.session().createBytesMessage();
            newMessage.writeBytes(jmsByteMessagePassThrough.bytes());
            textMessage = newMessage;
        } else if (jmsEnvelope instanceof JmsByteStringMessagePassThrough) {
            JmsByteStringMessagePassThrough jmsByteStringMessagePassThrough = (JmsByteStringMessagePassThrough)jmsEnvelope;
            BytesMessage newMessage = this.jmsSession.session().createBytesMessage();
            newMessage.writeBytes((byte[])jmsByteStringMessagePassThrough.bytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
            textMessage = newMessage;
        } else if (jmsEnvelope instanceof JmsMapMessagePassThrough) {
            JmsMapMessagePassThrough jmsMapMessagePassThrough = (JmsMapMessagePassThrough)jmsEnvelope;
            MapMessage newMessage = this.jmsSession.session().createMapMessage();
            this.populateMapMessage(newMessage, jmsMapMessagePassThrough);
            textMessage = newMessage;
        } else if (jmsEnvelope instanceof JmsObjectMessagePassThrough) {
            JmsObjectMessagePassThrough jmsObjectMessagePassThrough = (JmsObjectMessagePassThrough)jmsEnvelope;
            textMessage = this.jmsSession.session().createObjectMessage(jmsObjectMessagePassThrough.serializable());
        } else {
            if (jmsEnvelope instanceof JmsPassThrough) {
                throw new IllegalArgumentException("can't create message for JmsPassThrough");
            }
            throw new MatchError(jmsEnvelope);
        }
        return textMessage;
    }

    public void populateMessageProperties(Message message, JmsEnvelope<?> jmsMessage) {
        jmsMessage.properties().foreach((Function1 & Serializable)x0$1 -> {
            JmsMessageProducer.$anonfun$populateMessageProperties$1(message, jmsMessage, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void populateMapMessage(MapMessage message, JmsMapMessagePassThrough<?> jmsMessage) {
        jmsMessage.body().foreach((Function1 & Serializable)x0$1 -> {
            JmsMessageProducer.$anonfun$populateMapMessage$1(message, jmsMessage, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void populateMessageHeader(Message message, Set<JmsHeader> headers) {
        headers.foreach((Function1 & Serializable)x0$1 -> {
            JmsMessageProducer.$anonfun$populateMessageHeader$1(this, message, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$populateMessageProperties$1(Message message$1, JmsEnvelope jmsMessage$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Object v = tuple2._2();
        Object object = v;
        if (object instanceof String) {
            String string = (String)object;
            message$1.setStringProperty(key, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            message$1.setIntProperty(key, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            message$1.setBooleanProperty(key, bl);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            message$1.setByteProperty(key, by);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            message$1.setShortProperty(key, s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            message$1.setFloatProperty(key, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            message$1.setLongProperty(key, l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            message$1.setDoubleProperty(key, d);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            message$1.setObjectProperty(key, (Object)byArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (object != null) throw new UnsupportedMessagePropertyType(key, v, jmsMessage$1);
            message$1.setObjectProperty(key, null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$populateMapMessage$1(MapMessage message$2, JmsMapMessagePassThrough jmsMessage$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Object v = tuple2._2();
        Object object = v;
        if (object instanceof String) {
            String string = (String)object;
            message$2.setString(key, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            message$2.setInt(key, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            message$2.setBoolean(key, bl);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            message$2.setByte(key, by);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            message$2.setShort(key, s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            message$2.setFloat(key, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            message$2.setLong(key, l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            message$2.setDouble(key, d);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            message$2.setBytes(key, byArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (object != null) throw new UnsupportedMapMessageEntryType(key, v, jmsMessage$2);
            message$2.setObject(key, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$populateMessageHeader$1(JmsMessageProducer $this, Message message$3, JmsHeader x0$1) {
        JmsHeader jmsHeader = x0$1;
        if (jmsHeader instanceof JmsType) {
            JmsType jmsType = (JmsType)jmsHeader;
            String jmsType2 = jmsType.jmsType();
            message$3.setJMSType(jmsType2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsHeader instanceof JmsReplyTo) {
            JmsReplyTo jmsReplyTo = (JmsReplyTo)jmsHeader;
            Destination destination = jmsReplyTo.jmsDestination();
            message$3.setJMSReplyTo((javax.jms.Destination)destination.create().apply((Object)$this.jmsSession.session()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsHeader instanceof JmsCorrelationId) {
            JmsCorrelationId jmsCorrelationId = (JmsCorrelationId)jmsHeader;
            String jmsCorrelationId2 = jmsCorrelationId.jmsCorrelationId();
            message$3.setJMSCorrelationID(jmsCorrelationId2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsHeader instanceof JmsExpiration) {
            JmsExpiration jmsExpiration = (JmsExpiration)jmsHeader;
            long jmsExpiration2 = jmsExpiration.jmsExpiration();
            message$3.setJMSExpiration(jmsExpiration2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = jmsHeader instanceof JmsDeliveryMode ? true : (jmsHeader instanceof JmsPriority ? true : (jmsHeader instanceof JmsTimeToLive ? true : (jmsHeader instanceof JmsTimestamp ? true : (jmsHeader instanceof JmsRedelivered ? true : jmsHeader instanceof JmsMessageId))));
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)jmsHeader);
            }
        }
    }

    public JmsMessageProducer(MessageProducer jmsProducer, JmsProducerSession jmsSession, int epoch) {
        this.jmsProducer = jmsProducer;
        this.jmsSession = jmsSession;
        this.epoch = epoch;
        this.defaultDestination = jmsSession.jmsDestination();
        this.destinationCache = new SoftReferenceCache();
    }
}

