/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.jms.impl;

import akka.annotation.InternalApi;
import akka.stream.alpakka.jms.Destination;
import akka.stream.alpakka.jms.Destination$;
import akka.stream.alpakka.jms.JmsCorrelationId;
import akka.stream.alpakka.jms.JmsDeliveryMode;
import akka.stream.alpakka.jms.JmsExpiration;
import akka.stream.alpakka.jms.JmsHeader;
import akka.stream.alpakka.jms.JmsMessageId;
import akka.stream.alpakka.jms.JmsPriority;
import akka.stream.alpakka.jms.JmsRedelivered;
import akka.stream.alpakka.jms.JmsReplyTo;
import akka.stream.alpakka.jms.JmsTimestamp;
import akka.stream.alpakka.jms.JmsType;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@InternalApi
public final class JmsMessageReader$ {
    public static final JmsMessageReader$ MODULE$ = new JmsMessageReader$();

    public ByteString readBytes(BytesMessage message, int bufferSize) {
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            throw package$.MODULE$.error(new StringBuilder(48).append("Message too large, unable to read ").append(message.getBodyLength()).append(" bytes of data").toString());
        }
        byte[] buff = new byte[(int)Math.min(message.getBodyLength(), (long)bufferSize)];
        return this.read$1(ByteString$.MODULE$.empty(), message, buff);
    }

    public int readBytes$default$2() {
        return 4096;
    }

    public byte[] readArray(BytesMessage message, int bufferSize) {
        return (byte[])this.readBytes(message, bufferSize).toArray((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public int readArray$default$2() {
        return 4096;
    }

    private Map<String, Object> createMap(Enumeration<?> keys, Function1<String, Object> accessor) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(keys).asScala().map((Function1 & Serializable)key -> {
            Object object;
            Object object2 = Predef$.MODULE$.ArrowAssoc(key);
            Object object3 = accessor.apply(key);
            if (object3 instanceof Boolean) {
                Boolean bl = (Boolean)object3;
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else if (object3 instanceof Byte) {
                Byte by = (Byte)object3;
                object = BoxesRunTime.boxToByte((byte)by);
            } else if (object3 instanceof Short) {
                Short s = (Short)object3;
                object = BoxesRunTime.boxToShort((short)s);
            } else if (object3 instanceof Integer) {
                Integer n = (Integer)object3;
                object = BoxesRunTime.boxToInteger((int)n);
            } else if (object3 instanceof Long) {
                Long l = (Long)object3;
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object3 instanceof Float) {
                Float f = (Float)object3;
                object = BoxesRunTime.boxToFloat((float)f.floatValue());
            } else if (object3 instanceof Double) {
                Double d = (Double)object3;
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object3;
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, object);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> readMap(MapMessage message) {
        return this.createMap(message.getMapNames(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> message.getObject(x$1));
    }

    public Map<String, Object> readProperties(Message message) {
        return this.createMap(message.getPropertyNames(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> message.getObjectProperty(x$1));
    }

    public Set<JmsHeader> readHeaders(Message message) {
        return (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{JmsMessageReader$.messageId$1(message), JmsMessageReader$.timestamp$1(message), JmsMessageReader$.correlationId$1(message), JmsMessageReader$.replyTo$1(message), JmsMessageReader$.deliveryMode$1(message), JmsMessageReader$.redelivered$1(message), JmsMessageReader$.jmsType$1(message), JmsMessageReader$.expiration$1(message), JmsMessageReader$.priority$1(message)}))).flatten(Predef$.MODULE$.$conforms());
    }

    private final ByteString read$1(ByteString data, BytesMessage message$1, byte[] buff$1) {
        while (message$1.getBodyLength() != (long)data.length()) {
            int len = message$1.readBytes(buff$1);
            byte[] d = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(buff$1), len);
            data = data.$plus$plus(ByteString$.MODULE$.apply(d));
        }
        return data;
    }

    private static final Option messageId$1(Message message$4) {
        return Option$.MODULE$.apply((Object)message$4.getJMSMessageID()).map((Function1 & Serializable)x$1 -> new JmsMessageId((String)x$1));
    }

    private static final Some timestamp$1(Message message$4) {
        return new Some((Object)new JmsTimestamp(message$4.getJMSTimestamp()));
    }

    private static final Option correlationId$1(Message message$4) {
        return Option$.MODULE$.apply((Object)message$4.getJMSCorrelationID()).map((Function1 & Serializable)x$2 -> new JmsCorrelationId((String)x$2));
    }

    private static final Option replyTo$1(Message message$4) {
        return Option$.MODULE$.apply((Object)message$4.getJMSReplyTo()).map((Function1 & Serializable)x$3 -> Destination$.MODULE$.apply((javax.jms.Destination)x$3)).map((Function1 & Serializable)x$4 -> new JmsReplyTo((Destination)x$4));
    }

    private static final Some deliveryMode$1(Message message$4) {
        return new Some((Object)new JmsDeliveryMode(message$4.getJMSDeliveryMode()));
    }

    private static final Some redelivered$1(Message message$4) {
        return new Some((Object)new JmsRedelivered(message$4.getJMSRedelivered()));
    }

    private static final Option jmsType$1(Message message$4) {
        return Option$.MODULE$.apply((Object)message$4.getJMSType()).map((Function1 & Serializable)x$5 -> new JmsType((String)x$5));
    }

    private static final Some expiration$1(Message message$4) {
        return new Some((Object)new JmsExpiration(message$4.getJMSExpiration()));
    }

    private static final Some priority$1(Message message$4) {
        return new Some((Object)new JmsPriority(message$4.getJMSPriority()));
    }

    private JmsMessageReader$() {
    }
}

