/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.jms.scaladsl;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.alpakka.jms.AckEnvelope;
import akka.stream.alpakka.jms.Destination;
import akka.stream.alpakka.jms.JmsBrowseSettings;
import akka.stream.alpakka.jms.JmsConsumerSettings;
import akka.stream.alpakka.jms.TxEnvelope;
import akka.stream.alpakka.jms.impl.InternalConnectionState;
import akka.stream.alpakka.jms.impl.JmsAckSourceStage;
import akka.stream.alpakka.jms.impl.JmsBrowseStage;
import akka.stream.alpakka.jms.impl.JmsConsumerMatValue;
import akka.stream.alpakka.jms.impl.JmsConsumerStage;
import akka.stream.alpakka.jms.impl.JmsTxSourceStage;
import akka.stream.alpakka.jms.scaladsl.JmsConnectorState;
import akka.stream.alpakka.jms.scaladsl.JmsConsumerControl;
import akka.stream.alpakka.jms.scaladsl.package$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public final class JmsConsumer$ {
    public static final JmsConsumer$ MODULE$ = new JmsConsumer$();

    public Source<Message, JmsConsumerControl> apply(JmsConsumerSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noConsumerDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Source source = Source$.MODULE$.fromGraph((Graph)new JmsConsumerStage(settings, destination)).mapMaterializedValue((Function1 & Serializable)internal -> MODULE$.toConsumerControl((JmsConsumerMatValue)internal));
        return source;
    }

    public Source<String, JmsConsumerControl> textSource(JmsConsumerSettings settings) {
        return (Source)this.apply(settings).map((Function1 & Serializable)msg -> ((TextMessage)msg).getText());
    }

    public Source<Map<String, Object>, JmsConsumerControl> mapSource(JmsConsumerSettings settings) {
        return (Source)this.apply(settings).map((Function1 & Serializable)msg -> {
            MapMessage mapMessage = (MapMessage)msg;
            return (Map)CollectionConverters$.MODULE$.EnumerationHasAsScala(mapMessage.getMapNames()).asScala().foldLeft(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(result, key) -> {
                String keyAsString = key.toString();
                Object value = mapMessage.getObject(keyAsString);
                return (Map)result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyAsString), value));
            });
        });
    }

    public Source<byte[], JmsConsumerControl> bytesSource(JmsConsumerSettings settings) {
        return (Source)this.apply(settings).map((Function1 & Serializable)msg -> {
            void var2_2;
            BytesMessage byteMessage = (BytesMessage)msg;
            byte[] byteArray = new byte[(int)byteMessage.getBodyLength()];
            byteMessage.readBytes(byteArray);
            return var2_2;
        });
    }

    public Source<Serializable, JmsConsumerControl> objectSource(JmsConsumerSettings settings) {
        return (Source)this.apply(settings).map((Function1 & Serializable)msg -> ((ObjectMessage)msg).getObject());
    }

    public Source<AckEnvelope, JmsConsumerControl> ackSource(JmsConsumerSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noConsumerDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Source source = Source$.MODULE$.fromGraph((Graph)new JmsAckSourceStage(settings, destination)).mapMaterializedValue((Function1 & Serializable)internal -> MODULE$.toConsumerControl((JmsConsumerMatValue)internal));
        return source;
    }

    public Source<TxEnvelope, JmsConsumerControl> txSource(JmsConsumerSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noConsumerDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Source source = Source$.MODULE$.fromGraph((Graph)new JmsTxSourceStage(settings, destination)).mapMaterializedValue((Function1 & Serializable)internal -> MODULE$.toConsumerControl((JmsConsumerMatValue)internal));
        return source;
    }

    public Source<Message, NotUsed> browse(JmsBrowseSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noBrowseDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Source source = Source$.MODULE$.fromGraph((Graph)new JmsBrowseStage(settings, destination));
        return source;
    }

    private String noConsumerDestination(JmsConsumerSettings settings) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(195).append("Unable to create JmsConsumer: its needs a destination to read messages from, but none was provided in\n       |").append(settings).append("\n       |Please use withQueue, withTopic or withDestination to specify a destination.").toString()));
    }

    private String noBrowseDestination(JmsBrowseSettings settings) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(192).append("Unable to create JmsConsumer browser: its needs a destination to read messages from, but none was provided in\n       |").append(settings).append("\n       |Please use withQueue or withDestination to specify a destination.").toString()));
    }

    private JmsConsumerControl toConsumerControl(JmsConsumerMatValue internal) {
        return new JmsConsumerControl(internal){
            private final JmsConsumerMatValue internal$1;

            public void shutdown() {
                this.internal$1.shutdown();
            }

            public void abort(Throwable ex) {
                this.internal$1.abort(ex);
            }

            public Source<JmsConnectorState, NotUsed> connectorState() {
                return package$.MODULE$.transformConnectorState((Source<InternalConnectionState, NotUsed>)this.internal$1.connected());
            }
            {
                this.internal$1 = internal$1;
            }
        };
    }

    private JmsConsumer$() {
    }
}

