/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.jms.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.alpakka.jms.Destination;
import akka.stream.alpakka.jms.JmsByteMessage$;
import akka.stream.alpakka.jms.JmsByteStringMessage$;
import akka.stream.alpakka.jms.JmsEnvelope;
import akka.stream.alpakka.jms.JmsMapMessage$;
import akka.stream.alpakka.jms.JmsMessage;
import akka.stream.alpakka.jms.JmsObjectMessage$;
import akka.stream.alpakka.jms.JmsProducerSettings;
import akka.stream.alpakka.jms.JmsTextMessage$;
import akka.stream.alpakka.jms.impl.JmsProducerMatValue;
import akka.stream.alpakka.jms.impl.JmsProducerStage;
import akka.stream.alpakka.jms.scaladsl.JmsConnectorState;
import akka.stream.alpakka.jms.scaladsl.JmsProducerStatus;
import akka.stream.alpakka.jms.scaladsl.package$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.Future;

public final class JmsProducer$ {
    public static final JmsProducer$ MODULE$ = new JmsProducer$();

    public <T extends JmsMessage> Flow<T, T, JmsProducerStatus> flow(JmsProducerSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noProducerDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Flow flow = Flow$.MODULE$.apply().viaMat((Graph)Flow$.MODULE$.fromGraph(new JmsProducerStage(settings, destination)), Keep$.MODULE$.right()).mapMaterializedValue((Function1 & Serializable)internal -> MODULE$.toProducerStatus((JmsProducerMatValue)internal));
        return flow;
    }

    public <PassThrough> Flow<JmsEnvelope<PassThrough>, JmsEnvelope<PassThrough>, JmsProducerStatus> flexiFlow(JmsProducerSettings settings) {
        Option<Destination> option = settings.destination();
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(this.noProducerDestination(settings));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Destination destination = (Destination)some.value();
        Flow flow = Flow$.MODULE$.fromGraph(new JmsProducerStage(settings, destination)).mapMaterializedValue((Function1 & Serializable)internal -> MODULE$.toProducerStatus((JmsProducerMatValue)internal));
        return flow;
    }

    public Sink<JmsMessage, Future<Done>> sink(JmsProducerSettings settings) {
        return this.flow(settings).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public Sink<String, Future<Done>> textSink(JmsProducerSettings settings) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)s -> JmsTextMessage$.MODULE$.apply((String)s)).via(this.flow(settings)).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public Sink<byte[], Future<Done>> bytesSink(JmsProducerSettings settings) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)s -> JmsByteMessage$.MODULE$.apply((byte[])s)).via(this.flow(settings)).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public Sink<ByteString, Future<Done>> byteStringSink(JmsProducerSettings settings) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)s -> JmsByteStringMessage$.MODULE$.apply((ByteString)s)).via(this.flow(settings)).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public Sink<Map<String, Object>, Future<Done>> mapSink(JmsProducerSettings settings) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)s -> JmsMapMessage$.MODULE$.apply((Map<String, Object>)s)).via(this.flow(settings)).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public Sink<Serializable, Future<Done>> objectSink(JmsProducerSettings settings) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)s -> JmsObjectMessage$.MODULE$.apply((Serializable)s)).via(this.flow(settings)).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    private JmsProducerStatus toProducerStatus(JmsProducerMatValue internal) {
        return new JmsProducerStatus(internal){
            private final JmsProducerMatValue internal$1;

            public Source<JmsConnectorState, NotUsed> connectorState() {
                return package$.MODULE$.transformConnectorState(this.internal$1.connected());
            }
            {
                this.internal$1 = internal$1;
            }
        };
    }

    private String noProducerDestination(JmsProducerSettings settings) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(198).append("Unable to create JmsProducer: it needs a default destination to send messages to, but none was provided in\n      |").append(settings).append("\n      |Please use withQueue, withTopic or withDestination to specify a destination.").toString()));
    }

    private JmsProducer$() {
    }
}

