/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.kinesis;

import akka.stream.alpakka.kinesis.ShardIterator;
import akka.stream.alpakka.kinesis.ShardSettings$;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0013'\u0005=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u00039\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011a\u0003!Q1A\u0005\u0002eC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011)\u0019!C\u0001?\"A\u0011\u000e\u0001B\u0001B\u0003%\u0001\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!!\bA!A!\u0002\u0013a\u0007\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011!Q\u0001\n]DQa\u001f\u0001\u0005\nqDq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u0015\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003B\u0011\"!\u0015\u0001#\u0003%I!a\u0015\t\u0013\u0005%\u0004!%A\u0005\n\u0005M\u0003\"CA6\u0001E\u0005I\u0011BA7\u0011%\t\t\bAI\u0001\n\u0013\t\u0019\bC\u0005\u0002x\u0001\t\n\u0011\"\u0003\u0002z!I\u0011Q\u0010\u0001\u0012\u0002\u0013%\u0011q\u0010\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0005\u0003\u000bCq!!#\u0001\t\u0003\nYiB\u0004\u0002\u0018\u001aB\t!!'\u0007\r\u00152\u0003\u0012AAN\u0011\u0019Y\b\u0005\"\u0001\u0002\u001e\"9\u0011q\u0014\u0011\u0005\u0002\u0005\u0005\u0006bBAPA\u0011\u0005\u0011q\u0015\u0005\b\u0003_\u0003C\u0011AAY\u00055\u0019\u0006.\u0019:e'\u0016$H/\u001b8hg*\u0011q\u0005K\u0001\bW&tWm]5t\u0015\tI#&A\u0004bYB\f7n[1\u000b\u0005-b\u0013AB:ue\u0016\fWNC\u0001.\u0003\u0011\t7n[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0002\u0015M$(/Z1n\u001d\u0006lW-F\u00019!\tI\u0004I\u0004\u0002;}A\u00111HM\u0007\u0002y)\u0011QHL\u0001\u0007yI|w\u000e\u001e \n\u0005}\u0012\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001a\u0002\u0017M$(/Z1n\u001d\u0006lW\rI\u0001\bg\"\f'\u000fZ%e\u0003!\u0019\b.\u0019:e\u0013\u0012\u0004\u0013!E:iCJ$\u0017\n^3sCR|'\u000fV=qKV\t\u0001\n\u0005\u0002J+6\t!J\u0003\u0002L\u0019\u0006)Qn\u001c3fY*\u0011q%\u0014\u0006\u0003\u001d>\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003!F\u000ba!Y<tg\u0012\\'B\u0001*T\u0003\u0019\tW.\u0019>p]*\tA+\u0001\u0005t_\u001a$x/\u0019:f\u0013\t1&JA\tTQ\u0006\u0014H-\u0013;fe\u0006$xN\u001d+za\u0016\f!c\u001d5be\u0012LE/\u001a:bi>\u0014H+\u001f9fA\u000512\u000f^1si&twmU3rk\u0016t7-\u001a(v[\n,'/F\u0001[!\r\t4\fO\u0005\u00039J\u0012aa\u00149uS>t\u0017aF:uCJ$\u0018N\\4TKF,XM\\2f\u001dVl'-\u001a:!\u0003-\tG\u000fV5nKN$\u0018-\u001c9\u0016\u0003\u0001\u00042!M.b!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0003uS6,'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u000e\u0014q!\u00138ti\u0006tG/\u0001\u0007biRKW.Z:uC6\u0004\b%A\bsK\u001a\u0014Xm\u001d5J]R,'O^1m+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003!!WO]1uS>t'BA93\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003g:\u0014aBR5oSR,G)\u001e:bi&|g.\u0001\tsK\u001a\u0014Xm\u001d5J]R,'O^1mA\u0005)A.[7jiV\tq\u000f\u0005\u00022q&\u0011\u0011P\r\u0002\u0004\u0013:$\u0018A\u00027j[&$\b%\u0001\u0004=S:LGO\u0010\u000b\u000f{~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006!\tq\b!D\u0001'\u0011\u00151t\u00021\u00019\u0011\u0015!u\u00021\u00019\u0011\u00151u\u00021\u0001I\u0011\u0015Av\u00021\u0001[\u0011\u0015qv\u00021\u0001a\u0011\u0015Qw\u00021\u0001m\u0011\u0015)x\u00021\u0001x\u000399\u0018\u000e\u001e5TiJ,\u0017-\u001c(b[\u0016$2!`A\t\u0011\u0019\t\u0019\u0002\u0005a\u0001q\u0005)a/\u00197vK\u0006Yq/\u001b;i'\"\f'\u000fZ%e)\ri\u0018\u0011\u0004\u0005\u0007\u0003'\t\u0002\u0019\u0001\u001d\u0002#]LG\u000f[*iCJ$\u0017\n^3sCR|'\u000fF\u0002~\u0003?Aq!!\t\u0013\u0001\u0004\t\u0019#A\u0007tQ\u0006\u0014H-\u0013;fe\u0006$xN\u001d\t\u0004}\u0006\u0015\u0012bAA\u0014M\ti1\u000b[1sI&#XM]1u_J\f1c^5uQJ+gM]3tQ&sG/\u001a:wC2$2!`A\u0017\u0011\u0019\t\u0019b\u0005a\u0001YR\u0019Q0!\r\t\u000f\u0005MA\u00031\u0001\u00024A\u0019!-!\u000e\n\u0007\u0005]2M\u0001\u0005EkJ\fG/[8o\u0003%9\u0018\u000e\u001e5MS6LG\u000fF\u0002~\u0003{Aa!a\u0005\u0016\u0001\u00049\u0018\u0001B2paf$r\"`A\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013q\n\u0005\bmY\u0001\n\u00111\u00019\u0011\u001d!e\u0003%AA\u0002aBqA\u0012\f\u0011\u0002\u0003\u0007\u0001\nC\u0004Y-A\u0005\t\u0019\u0001.\t\u000fy3\u0002\u0013!a\u0001A\"9!N\u0006I\u0001\u0002\u0004a\u0007bB;\u0017!\u0003\u0005\ra^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u00029\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u0012\u0014AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u001c+\u0007!\u000b9&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005U$f\u0001.\u0002X\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA>U\r\u0001\u0017qK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\t\tIK\u0002m\u0003/\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0002\b*\u001aq/a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%f\u0003\u0011a\u0017M\\4\n\u0007\u0005\u000b\t*A\u0007TQ\u0006\u0014HmU3ui&twm\u001d\t\u0003}\u0002\u001a\"\u0001\t\u0019\u0015\u0005\u0005e\u0015!B1qa2LH#B?\u0002$\u0006\u0015\u0006\"\u0002\u001c#\u0001\u0004A\u0004\"\u0002##\u0001\u0004ADcB?\u0002*\u0006-\u0016Q\u0016\u0005\u0006m\r\u0002\r\u0001\u000f\u0005\u0006\t\u000e\u0002\r\u0001\u000f\u0005\b\u0003C\u0019\u0003\u0019AA\u0012\u0003\u0019\u0019'/Z1uKR)Q0a-\u00026\")a\u0007\na\u0001q!)A\t\na\u0001q\u0001")
public final class ShardSettings {
    private final String streamName;
    private final String shardId;
    private final ShardIteratorType shardIteratorType;
    private final Option<String> startingSequenceNumber;
    private final Option<Instant> atTimestamp;
    private final FiniteDuration refreshInterval;
    private final int limit;

    public static ShardSettings create(String string, String string2) {
        return ShardSettings$.MODULE$.create(string, string2);
    }

    public static ShardSettings apply(String string, String string2, ShardIterator shardIterator) {
        return ShardSettings$.MODULE$.apply(string, string2, shardIterator);
    }

    public static ShardSettings apply(String string, String string2) {
        return ShardSettings$.MODULE$.apply(string, string2);
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardId() {
        return this.shardId;
    }

    public ShardIteratorType shardIteratorType() {
        return this.shardIteratorType;
    }

    public Option<String> startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public Option<Instant> atTimestamp() {
        return this.atTimestamp;
    }

    public FiniteDuration refreshInterval() {
        return this.refreshInterval;
    }

    public int limit() {
        return this.limit;
    }

    public ShardSettings withStreamName(String value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ShardSettings withShardId(String value) {
        String x$1 = value;
        String x$2 = this.copy$default$1();
        ShardIteratorType x$3 = this.copy$default$3();
        Option<String> x$4 = this.copy$default$4();
        Option<Instant> x$5 = this.copy$default$5();
        FiniteDuration x$6 = this.copy$default$6();
        int x$7 = this.copy$default$7();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
    }

    public ShardSettings withShardIterator(ShardIterator shardIterator) {
        ShardIteratorType x$1 = shardIterator.shardIteratorType();
        Option<Instant> x$2 = shardIterator.timestamp();
        Option<String> x$3 = shardIterator.startingSequenceNumber();
        String x$4 = this.copy$default$1();
        String x$5 = this.copy$default$2();
        FiniteDuration x$6 = this.copy$default$6();
        int x$7 = this.copy$default$7();
        return this.copy(x$4, x$5, x$1, x$3, x$2, x$6, x$7);
    }

    public ShardSettings withRefreshInterval(FiniteDuration value) {
        FiniteDuration x$1 = value;
        String x$2 = this.copy$default$1();
        String x$3 = this.copy$default$2();
        ShardIteratorType x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        Option<Instant> x$6 = this.copy$default$5();
        int x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
    }

    public ShardSettings withRefreshInterval(Duration value) {
        FiniteDuration x$1 = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value));
        String x$2 = this.copy$default$1();
        String x$3 = this.copy$default$2();
        ShardIteratorType x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        Option<Instant> x$6 = this.copy$default$5();
        int x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
    }

    public ShardSettings withLimit(int value) {
        int x$1 = value;
        String x$2 = this.copy$default$1();
        String x$3 = this.copy$default$2();
        ShardIteratorType x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$4();
        Option<Instant> x$6 = this.copy$default$5();
        FiniteDuration x$7 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1);
    }

    private ShardSettings copy(String streamName, String shardId, ShardIteratorType shardIteratorType, Option<String> startingSequenceNumber, Option<Instant> atTimestamp, FiniteDuration refreshInterval, int limit) {
        return new ShardSettings(streamName, shardId, shardIteratorType, startingSequenceNumber, atTimestamp, refreshInterval, limit);
    }

    private String copy$default$1() {
        return this.streamName();
    }

    private String copy$default$2() {
        return this.shardId();
    }

    private ShardIteratorType copy$default$3() {
        return this.shardIteratorType();
    }

    private Option<String> copy$default$4() {
        return this.startingSequenceNumber();
    }

    private Option<Instant> copy$default$5() {
        return this.atTimestamp();
    }

    private FiniteDuration copy$default$6() {
        return this.refreshInterval();
    }

    private int copy$default$7() {
        return this.limit();
    }

    public String toString() {
        return new StringBuilder(115).append("ShardSettings(").append("streamName=").append(this.streamName()).append(",").append("shardId=").append(this.shardId()).append(",").append("shardIteratorType=").append(this.shardIteratorType()).append(",").append("startingSequenceNumber=").append(this.startingSequenceNumber()).append(",").append("atTimestamp=").append(this.atTimestamp()).append(",").append("refreshInterval=").append(this.refreshInterval().toCoarsest()).append(",").append("limit=").append(this.limit()).append(")").toString();
    }

    public ShardSettings(String streamName, String shardId, ShardIteratorType shardIteratorType, Option<String> startingSequenceNumber, Option<Instant> atTimestamp, FiniteDuration refreshInterval, int limit) {
        block1: {
            ShardIteratorType shardIteratorType2;
            block0: {
                this.streamName = streamName;
                this.shardId = shardId;
                this.shardIteratorType = shardIteratorType;
                this.startingSequenceNumber = startingSequenceNumber;
                this.atTimestamp = atTimestamp;
                this.refreshInterval = refreshInterval;
                this.limit = limit;
                Predef$.MODULE$.require(limit >= 1 && limit <= 10000, (Function0 & java.io.Serializable & Serializable)() -> "Limit must be between 0 and 10000. See: http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html");
                shardIteratorType2 = shardIteratorType;
                if (!(ShardIteratorType.AFTER_SEQUENCE_NUMBER.equals(shardIteratorType2) ? true : ShardIteratorType.AT_SEQUENCE_NUMBER.equals(shardIteratorType2))) break block0;
                Predef$.MODULE$.require(startingSequenceNumber.nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "a starting sequence number must be set (try using just `withStartingSequenceNumber` or `withStartingAfterSequenceNumber`)");
                break block1;
            }
            if (!ShardIteratorType.AT_TIMESTAMP.equals(shardIteratorType2)) break block1;
            Predef$.MODULE$.require(atTimestamp.nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "a timestamp must be set (try using just `withAtTimestamp`)");
        }
    }
}

