/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.kinesis.scaladsl;

import akka.NotUsed;
import akka.dispatch.ExecutionContexts$;
import akka.stream.ActorAttributes$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Graph;
import akka.stream.alpakka.kinesis.CommittableRecord;
import akka.stream.alpakka.kinesis.CommittableRecord$;
import akka.stream.alpakka.kinesis.KinesisSchedulerCheckpointSettings;
import akka.stream.alpakka.kinesis.KinesisSchedulerSourceSettings;
import akka.stream.alpakka.kinesis.impl.KinesisSchedulerSourceStage;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.SubFlow;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public final class KinesisSchedulerSource$ {
    public static KinesisSchedulerSource$ MODULE$;
    private final Flow<Seq<CommittableRecord>, KinesisClientRecord, NotUsed> checkpointRecordBatch;
    private final int MAX_KINESIS_SHARDS;

    static {
        new KinesisSchedulerSource$();
    }

    public Source<CommittableRecord, Future<Scheduler>> apply(Function1<ShardRecordProcessorFactory, Scheduler> schedulerBuilder, KinesisSchedulerSourceSettings settings) {
        return Source$.MODULE$.fromMaterializer((Function2 & Serializable & scala.Serializable)(mat, x$1) -> Source$.MODULE$.fromGraph((Graph)new KinesisSchedulerSourceStage(settings, schedulerBuilder, (ExecutionContext)mat.executionContext()))).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$2 -> x$2.flatMap((Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x), ExecutionContexts$.MODULE$.parasitic()));
    }

    public SubFlow<CommittableRecord, Future<Scheduler>, ?, RunnableGraph<Future<Scheduler>>> sharded(Function1<ShardRecordProcessorFactory, Scheduler> schedulerBuilder, KinesisSchedulerSourceSettings settings) {
        return this.apply(schedulerBuilder, settings).groupBy(this.MAX_KINESIS_SHARDS(), (Function1 & Serializable & scala.Serializable)x$3 -> x$3.processorData().shardId());
    }

    public Flow<CommittableRecord, KinesisClientRecord, NotUsed> checkpointRecordsFlow(KinesisSchedulerCheckpointSettings settings) {
        return (Flow)((SubFlow)Flow$.MODULE$.apply().groupBy(this.MAX_KINESIS_SHARDS(), (Function1 & Serializable & scala.Serializable)x$4 -> x$4.processorData().shardId()).groupedWithin(settings.maxBatchSize(), settings.maxBatchWait()).via(this.checkpointRecordBatch())).mergeSubstreams();
    }

    private Flow<Seq<CommittableRecord>, KinesisClientRecord, NotUsed> checkpointRecordBatch() {
        return this.checkpointRecordBatch;
    }

    public Sink<CommittableRecord, NotUsed> checkpointRecordsSink(KinesisSchedulerCheckpointSettings settings) {
        return this.checkpointRecordsFlow(settings).to((Graph)Sink$.MODULE$.ignore());
    }

    private int MAX_KINESIS_SHARDS() {
        return this.MAX_KINESIS_SHARDS;
    }

    private KinesisSchedulerSource$() {
        MODULE$ = this;
        this.checkpointRecordBatch = ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)records -> {
            ((CommittableRecord)records.max(CommittableRecord$.MODULE$.orderBySequenceNumber())).tryToCheckpoint();
            return records;
        }).mapConcat((Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.record())).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)ActorAttributes$.MODULE$.IODispatcher()));
        this.MAX_KINESIS_SHARDS = 500;
    }
}

