/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.kinesisfirehose.scaladsl;

import akka.NotUsed;
import akka.dispatch.ExecutionContexts$;
import akka.stream.ThrottleMode;
import akka.stream.alpakka.kinesisfirehose.KinesisFirehoseErrors;
import akka.stream.alpakka.kinesisfirehose.KinesisFirehoseFlowSettings;
import akka.stream.alpakka.kinesisfirehose.KinesisFirehoseFlowSettings$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClient;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.services.firehose.model.Record;

public final class KinesisFirehoseFlow$ {
    public static KinesisFirehoseFlow$ MODULE$;

    static {
        new KinesisFirehoseFlow$();
    }

    public Flow<Record, PutRecordBatchResponseEntry, NotUsed> apply(String streamName, KinesisFirehoseFlowSettings settings, FirehoseAsyncClient kinesisClient) {
        return (Flow)Flow$.MODULE$.apply().throttle(settings.maxRecordsPerSecond(), new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), settings.maxRecordsPerSecond(), (ThrottleMode)ThrottleMode.Shaping$.MODULE$).throttle(settings.maxBytesPerSecond(), new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), settings.maxBytesPerSecond(), (Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)KinesisFirehoseFlow$.MODULE$.getByteSize(record)), (ThrottleMode)ThrottleMode.Shaping$.MODULE$).batch((long)settings.maxBatchSize(), (Function1 & Serializable & scala.Serializable)x$1 -> Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{x$1})), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (Queue)x$2.$colon$plus(x$3, Queue$.MODULE$.canBuildFrom())).mapAsync(settings.parallelism(), (Function1 & Serializable & scala.Serializable)records -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)kinesisClient.putRecordBatch((PutRecordBatchRequest)PutRecordBatchRequest.builder().deliveryStreamName(streamName).records(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)records).asJavaCollection()).build()))).transform((Function1 & Serializable & scala.Serializable)x -> (PutRecordBatchResponse)Predef$.MODULE$.identity(x), (Function1 & Serializable & scala.Serializable)x$4 -> new KinesisFirehoseErrors.FailurePublishingRecords((Throwable)x$4), ExecutionContexts$.MODULE$.parasitic())).mapConcat((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.requestResponses()).asScala()).toIndexedSeq());
    }

    public KinesisFirehoseFlowSettings apply$default$2() {
        return KinesisFirehoseFlowSettings$.MODULE$.Defaults();
    }

    private int getByteSize(Record record) {
        return record.data().asByteBuffer().position();
    }

    private KinesisFirehoseFlow$() {
        MODULE$ = this;
    }
}

