/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.mqtt.impl;

import akka.Done;
import akka.Done$;
import akka.event.LoggingAdapter;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.Shape;
import akka.stream.alpakka.mqtt.MqttConnectionSettings;
import akka.stream.alpakka.mqtt.MqttMessage;
import akka.stream.alpakka.mqtt.MqttMessage$;
import akka.stream.alpakka.mqtt.MqttOfflinePersistenceSettings;
import akka.stream.alpakka.mqtt.MqttQoS;
import akka.stream.alpakka.mqtt.MqttQoS$AtLeastOnce$;
import akka.stream.alpakka.mqtt.MqttQoS$AtMostOnce$;
import akka.stream.alpakka.mqtt.MqttQoS$ExactlyOnce$;
import akka.stream.alpakka.mqtt.impl.MqttFlowStageLogic$;
import akka.stream.alpakka.mqtt.scaladsl.MqttMessageWithAck;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.StageLogging;
import akka.util.ByteString$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001da!B*U\u0003\u0003y\u0006\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0015\u0005\u001d\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003;A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\tI\u0004\u0001B\u0001B\u0003%\u00111\b\u0005\u000b\u0003\u0007\u0002!\u0011!Q\u0001\n\u0005\u0015\u0003BCA4\u0001\t\u0005\t\u0015!\u0003\u0002j!Q\u0011q\u000e\u0001\u0003\u0002\u0003\u0006I!!\u0019\t\u0015\u0005E\u0004A!A!\u0002\u0013\t\u0019\bC\u0004\u0002z\u0001!\t!a\u001f\t\u0013\u0005M\u0005A1A\u0005\n\u0005U\u0005\u0002CAU\u0001\u0001\u0006I!a&\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\"CA[\u0001\u0001\u0007I\u0011BA\\\u0011!\t\u0019\r\u0001Q!\n\u0005=\u0006\"CAc\u0001\t\u0007I\u0011BAd\u0011!\tI\u000e\u0001Q\u0001\n\u0005%\u0007\"CAn\u0001\t\u0007I\u0011BAo\u0011!\tY\u000f\u0001Q\u0001\n\u0005}\u0007bBAw\u0001\u0011E\u0011q\u001e\u0005\n\u0005#\u0001!\u0019!C\u0005\u0005'A\u0001Ba\u000b\u0001A\u0003%!Q\u0003\u0005\n\u0005[\u0001!\u0019!C\u0005\u0005_A\u0001B!\u000f\u0001A\u0003%!\u0011\u0007\u0005\n\u0005w\u0001!\u0019!C\u0005\u0005{A\u0001Ba\u0015\u0001A\u0003%!q\b\u0005\n\u0005+\u0002!\u0019!C\u0005\u0005/B\u0001Ba\u0017\u0001A\u0003%!\u0011\f\u0005\n\u0005;\u0002!\u0019!C\u0005\u0005'A\u0001Ba\u0018\u0001A\u0003%!Q\u0003\u0005\b\u0005C\u0002A\u0011\u0002B2\u0011%\ty\u0010\u0001b\u0001\n\u0013\u0011)\b\u0003\u0005\u0003~\u0001\u0001\u000b\u0011\u0002B<\u0011\u001d\u0011y\b\u0001C\u0005\u0005kB\u0011B!!\u0001\u0005\u0004%IAa!\t\u0011\r\u001d\u0007\u0001)A\u0005\u0005\u000bCqa!3\u0001\t\u0003\u001aY\rC\u0004\u0004N\u0002!\tea3\t\u000f\r=\u0007\u0001\"\u0011\u0004R\"91q\u001b\u0001\u0005B\r-\u0007bBBm\u0001\u0011\u000531\u001c\u0005\b\u0007C\u0004A\u0011ABr\u0011\u001d\u0019y\u000f\u0001C\u0001\u0007cDqa!>\u0001\t\u0013\u00199\u0010C\u0004\u0004~\u0002!Iaa@\t\u000f\u0011\r\u0001\u0001\"\u0011\u0004L\"9AQ\u0001\u0001\u0005B\r-w\u0001\u0003BP)\"\u0005aK!)\u0007\u000fM#\u0006\u0012\u0001,\u0003$\"9\u0011\u0011P\u0019\u0005\u0002\t-\u0006\"\u0003BWc\t\u0007I\u0011\u0002BX\u0011!\u0011i,\rQ\u0001\n\tEfA\u0002B`c\u0019\u0013\t\r\u0003\u0006\u0003PV\u0012)\u001a!C\u0001\u0005#D!Ba56\u0005#\u0005\u000b\u0011BA5\u0011)\u0011).\u000eBK\u0002\u0013\u0005!q\u001b\u0005\u000b\u00053,$\u0011#Q\u0001\n\u0005\u0005\u0004B\u0003Bnk\tU\r\u0011\"\u0001\u0003^\"Q!q\\\u001b\u0003\u0012\u0003\u0006I!!\n\t\u000f\u0005eT\u0007\"\u0001\u0003b\"I!Q^\u001b\u0002\u0002\u0013\u0005!q\u001e\u0005\n\u0005o,\u0014\u0013!C\u0001\u0005sD\u0011ba\u00046#\u0003%\ta!\u0005\t\u0013\rUQ'%A\u0005\u0002\r]\u0001\"CB\u000ek\u0005\u0005I\u0011IB\u000f\u0011%\u0019I#NA\u0001\n\u0003\u0011\t\u000eC\u0005\u0004,U\n\t\u0011\"\u0001\u0004.!I1\u0011G\u001b\u0002\u0002\u0013\u000531\u0007\u0005\n\u0007{)\u0014\u0011!C\u0001\u0007\u007fA\u0011ba\u00116\u0003\u0003%\te!\u0012\t\u0013\r%S'!A\u0005B\r-\u0003\"CB'k\u0005\u0005I\u0011IB(\u0011%\u0019\t&NA\u0001\n\u0003\u001a\u0019fB\u0005\u0004XE\n\t\u0011#\u0003\u0004Z\u0019I!qX\u0019\u0002\u0002#%11\f\u0005\b\u0003sZE\u0011AB:\u0011%\u0019ieSA\u0001\n\u000b\u001ay\u0005C\u0005\u0004v-\u000b\t\u0011\"!\u0004x!I1qP&\u0002\u0002\u0013\u00055\u0011\u0011\u0005\n\u0007\u001f[\u0015\u0011!C\u0005\u0007#Cqa!'2\t\u0003\u0019Y\nC\u0004\u0004&F\"\taa*\u0003%5\u000bH\u000f\u001e$m_^\u001cF/Y4f\u0019><\u0017n\u0019\u0006\u0003+Z\u000bA![7qY*\u0011q\u000bW\u0001\u0005[F$HO\u0003\u0002Z5\u00069\u0011\r\u001c9bW.\f'BA.]\u0003\u0019\u0019HO]3b[*\tQ,\u0001\u0003bW.\f7\u0001A\u000b\u0003A^\u001cR\u0001A1hU6\u0004\"AY3\u000e\u0003\rT!\u0001\u001a.\u0002\u000bM$\u0018mZ3\n\u0005\u0019\u001c'aD$sCBD7\u000b^1hK2{w-[2\u0011\u0005\tD\u0017BA5d\u00051\u0019F/Y4f\u0019><w-\u001b8h!\t\u00117.\u0003\u0002mG\nI\u0011J\u001c%b]\u0012dWM\u001d\t\u0003E:L!a\\2\u0003\u0015=+H\u000fS1oI2,'/\u0001\u0002j]B\u0019!o];\u000e\u0003iK!\u0001\u001e.\u0003\u000b%sG.\u001a;\u0011\u0005Y<H\u0002\u0001\u0003\u0006q\u0002\u0011\r!\u001f\u0002\u0002\u0013F\u0019!0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0003u\fQa]2bY\u0006L!a ?\u0003\u000f9{G\u000f[5oOB\u001910a\u0001\n\u0007\u0005\u0015APA\u0002B]f\f1a\\;u!\u0015\u0011\u00181BA\b\u0013\r\tiA\u0017\u0002\u0007\u001fV$H.\u001a;\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006W\u0003!\u00198-\u00197bINd\u0017\u0002BA\r\u0003'\u0011!#T9ui6+7o]1hK^KG\u000f[!dW\u0006)1\u000f[1qKB\u0019!/a\b\n\u0007\u0005\u0005\"LA\u0003TQ\u0006\u0004X-A\ntk\n\u001c8M]5qi&|g\u000e\u0015:p[&\u001cX\r\u0005\u0004\u0002(\u00055\u0012\u0011G\u0007\u0003\u0003SQ1!a\u000b}\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003_\tICA\u0004Qe>l\u0017n]3\u0011\t\u0005M\u0012QG\u0007\u00029&\u0019\u0011q\u0007/\u0003\t\u0011{g.Z\u0001\u0013G>tg.Z2uS>t7+\u001a;uS:<7\u000f\u0005\u0003\u0002>\u0005}R\"\u0001,\n\u0007\u0005\u0005cK\u0001\fNcR$8i\u001c8oK\u000e$\u0018n\u001c8TKR$\u0018N\\4t\u00035\u0019XOY:de&\u0004H/[8ogBA\u0011qIA+\u00037\n\tG\u0004\u0003\u0002J\u0005E\u0003cAA&y6\u0011\u0011Q\n\u0006\u0004\u0003\u001fr\u0016A\u0002\u001fs_>$h(C\u0002\u0002Tq\fa\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u00121!T1q\u0015\r\t\u0019\u0006 \t\u0005\u0003\u000f\ni&\u0003\u0003\u0002`\u0005e#AB*ue&tw\r\u0005\u0003\u0002>\u0005\r\u0014bAA3-\n9Q*\u001d;u#>\u001c\u0016A\u00032vM\u001a,'oU5{KB\u001910a\u001b\n\u0007\u00055DPA\u0002J]R\f!\u0002Z3gCVdG/U8T\u0003)i\u0017M\\;bY\u0006\u001b7n\u001d\t\u0004w\u0006U\u0014bAA<y\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u000b\u0002~\u0005\u0005\u00151QAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0015\u0011\u0013\t\u0005\u0003\u007f\u0002Q/D\u0001U\u0011\u0015\u0001(\u00021\u0001r\u0011\u001d\t9A\u0003a\u0001\u0003\u0013Aq!a\u0007\u000b\u0001\u0004\ti\u0002C\u0004\u0002$)\u0001\r!!\n\t\u000f\u0005e\"\u00021\u0001\u0002<!9\u00111\t\u0006A\u0002\u0005\u0015\u0003bBA4\u0015\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003_R\u0001\u0019AA1\u0011\u001d\t\tH\u0003a\u0001\u0003g\naCY1dWB\u0014Xm]:ve\u0016\u0004\u0016\r[8DY&,g\u000e^\u000b\u0003\u0003/\u0003B!!'\u0002&6\u0011\u00111\u0014\u0006\u0005\u0003W\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001B;uS2T!!a)\u0002\t)\fg/Y\u0005\u0005\u0003O\u000bYJA\u0005TK6\f\u0007\u000f[8sK\u00069\"-Y2laJ,7o];sKB\u000b\u0007n\\\"mS\u0016tG\u000fI\u0001\u000ba\u0016tG-\u001b8h\u001bN<WCAAX!\u0011Y\u0018\u0011W;\n\u0007\u0005MFP\u0001\u0004PaRLwN\\\u0001\u000fa\u0016tG-\u001b8h\u001bN<w\fJ3r)\u0011\tI,a0\u0011\u0007m\fY,C\u0002\u0002>r\u0014A!\u00168ji\"I\u0011\u0011\u0019\b\u0002\u0002\u0003\u0007\u0011qV\u0001\u0004q\u0012\n\u0014a\u00039f]\u0012LgnZ'tO\u0002\nQ!];fk\u0016,\"!!3\u0011\r\u0005-\u0017Q[A\b\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'd\u0018AC2pY2,7\r^5p]&!\u0011q[Ag\u0005\u0015\tV/Z;f\u0003\u0019\tX/Z;fA\u0005yQO\\1dW\u0016$W*Z:tC\u001e,7/\u0006\u0002\u0002`B!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006m\u0015AB1u_6L7-\u0003\u0003\u0002j\u0006\r(!D!u_6L7-\u00138uK\u001e,'/\u0001\tv]\u0006\u001c7.\u001a3NKN\u001c\u0018mZ3tA\u00051\u0002.\u00198eY\u0016$U\r\\5wKJL8i\\7qY\u0016$X\r\u0006\u0003\u0002:\u0006E\bbBAz)\u0001\u0007\u0011Q_\u0001\u0006i>\\WM\u001c\t\u0005\u0003o\u0014i!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003\u0019i\u0017\u000f\u001e;wg)!\u0011q B\u0001\u0003\u0019\u0019G.[3oi*!!1\u0001B\u0003\u0003\u0011\u0001\u0018\r[8\u000b\t\t\u001d!\u0011B\u0001\bK\u000ed\u0017\u000e]:f\u0015\t\u0011Y!A\u0002pe\u001eLAAa\u0004\u0002z\n\u0011\u0012*T9ui\u0012+G.\u001b<fef$vn[3o\u0003-ygnU;cg\u000e\u0014\u0018NY3\u0016\u0005\tU\u0001#\u00022\u0003\u0018\tm\u0011b\u0001B\rG\ni\u0011i]=oG\u000e\u000bG\u000e\u001c2bG.\u0004bA!\b\u0003\"\t\u0015RB\u0001B\u0010\u0015\r\ty\n`\u0005\u0005\u0005G\u0011yBA\u0002Uef\u0004B!a>\u0003(%!!\u0011FA}\u0005)IU*\u001d;u)>\\WM\\\u0001\r_:\u001cVOY:de&\u0014W\rI\u0001\n_:\u001cuN\u001c8fGR,\"A!\r\u0011\u000b\t\u00149Ba\r\u0011\t\u0005](QG\u0005\u0005\u0005o\tIP\u0001\tJ\u001bF$H/Q:z]\u000e\u001cE.[3oi\u0006QqN\\\"p]:,7\r\u001e\u0011\u0002!=t7i\u001c8oK\u000e$\u0018n\u001c8M_N$XC\u0001B !\u0015\u0011'q\u0003B!!\u0011\u0011\u0019E!\u0014\u000f\t\t\u0015#\u0011\n\b\u0005\u0003\u0017\u00129%C\u0001~\u0013\r\u0011Y\u0005`\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yE!\u0015\u0003\u0013QC'o\\<bE2,'b\u0001B&y\u0006\trN\\\"p]:,7\r^5p]2{7\u000f\u001e\u0011\u0002-=tW*Z:tC\u001e,\u0017i]=oG\u000e\u000bG\u000e\u001c2bG.,\"A!\u0017\u0011\u000b\t\u00149\"a\u0004\u0002/=tW*Z:tC\u001e,\u0017i]=oG\u000e\u000bG\u000e\u001c2bG.\u0004\u0013aC8o!V\u0014G.[:iK\u0012\fAb\u001c8Qk\nd\u0017n\u001d5fI\u0002\nqc\u0019:fCR,\u0007+\u00195p\u0005V4g-\u001a:PaRLwN\\:\u0015\t\t\u0015$1\u000e\t\u0005\u0003o\u00149'\u0003\u0003\u0003j\u0005e(!\u0007#jg\u000e|gN\\3di\u0016$')\u001e4gKJ|\u0005\u000f^5p]NDqA!\u001c \u0001\u0004\u0011y'\u0001\u0005tKR$\u0018N\\4t!\u0011\tiD!\u001d\n\u0007\tMdK\u0001\u0010NcR$xJ\u001a4mS:,\u0007+\u001a:tSN$XM\\2f'\u0016$H/\u001b8hgV\u0011!q\u000f\t\u0005\u0003o\u0014I(\u0003\u0003\u0003|\u0005e(aD'riR\f5/\u001f8d\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005QQ.\u001d;u\u00072LWM\u001c;\u0002\u001d\r|W.\\5u\u0007\u0006dGNY1dWV\u0011!Q\u0011\t\u0006E\n]!q\u0011\t\u0004\u0005\u0013+db\u0001BFa9!!Q\u0012BO\u001d\u0011\u0011yIa'\u000f\t\tE%\u0011\u0014\b\u0005\u0005'\u00139J\u0004\u0003\u0002L\tU\u0015\"A/\n\u0005mc\u0016BA-[\u0013\t9\u0006,\u0003\u0002V-\u0006\u0011R*\u001d;u\r2|wo\u0015;bO\u0016dunZ5d!\r\ty(M\n\u0004c\t\u0015\u0006cA>\u0003(&\u0019!\u0011\u0016?\u0003\r\u0005s\u0017PU3g)\t\u0011\t+\u0001\tTk\u000e\u001cWm]:gk2d\u0017\u0010R8oKV\u0011!\u0011\u0017\t\u0007\u0005;\u0011\u0019La.\n\t\tU&q\u0004\u0002\b'V\u001c7-Z:t\u001d\u0011\t\u0019D!/\n\u0007\tmF,\u0001\u0003E_:,\u0017!E*vG\u000e,7o\u001d4vY2LHi\u001c8fA\t92i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\\u0017I]4v[\u0016tGo]\n\bk\t\u0015&1\u0019Be!\rY(QY\u0005\u0004\u0005\u000fd(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005\u0007\u0012Y-\u0003\u0003\u0003N\nE#\u0001D*fe&\fG.\u001b>bE2,\u0017!C7fgN\fw-Z%e+\t\tI'\u0001\u0006nKN\u001c\u0018mZ3JI\u0002\n1!]8t+\t\t\t'\u0001\u0003r_N\u0004\u0013a\u00029s_6L7/Z\u000b\u0003\u0003K\t\u0001\u0002\u001d:p[&\u001cX\r\t\u000b\t\u0005G\u00149O!;\u0003lB\u0019!Q]\u001b\u000e\u0003EBqAa4=\u0001\u0004\tI\u0007C\u0004\u0003Vr\u0002\r!!\u0019\t\u000f\tmG\b1\u0001\u0002&\u0005!1m\u001c9z)!\u0011\u0019O!=\u0003t\nU\b\"\u0003Bh{A\u0005\t\u0019AA5\u0011%\u0011).\u0010I\u0001\u0002\u0004\t\t\u0007C\u0005\u0003\\v\u0002\n\u00111\u0001\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B~U\u0011\tIG!@,\u0005\t}\b\u0003BB\u0001\u0007\u0017i!aa\u0001\u000b\t\r\u00151qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0003}\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u001b\u0019\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0014)\"\u0011\u0011\rB\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"a!\u0007+\t\u0005\u0015\"Q`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r}\u0001\u0003BB\u0011\u0007Oi!aa\t\u000b\t\r\u0015\u0012\u0011U\u0001\u0005Y\u0006tw-\u0003\u0003\u0002`\r\r\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\u0019y\u0003C\u0005\u0002B\u000e\u000b\t\u00111\u0001\u0002j\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00046A11qGB\u001d\u0003\u0003i!!!5\n\t\rm\u0012\u0011\u001b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\r\u0005\u0003\"CAa\u000b\u0006\u0005\t\u0019AA\u0001\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r}1q\t\u0005\n\u0003\u00034\u0015\u0011!a\u0001\u0003S\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007?\ta!Z9vC2\u001cH\u0003BA:\u0007+B\u0011\"!1J\u0003\u0003\u0005\r!!\u0001\u0002/\r{W.\\5u\u0007\u0006dGNY1dW\u0006\u0013x-^7f]R\u001c\bc\u0001Bs\u0017N)1j!\u0018\u0004jAa1qLB3\u0003S\n\t'!\n\u0003d6\u00111\u0011\r\u0006\u0004\u0007Gb\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007O\u001a\tGA\tBEN$(/Y2u\rVt7\r^5p]N\u0002Baa\u001b\u0004r5\u00111Q\u000e\u0006\u0005\u0007_\n\t+\u0001\u0002j_&!!QZB7)\t\u0019I&A\u0003baBd\u0017\u0010\u0006\u0005\u0003d\u000ee41PB?\u0011\u001d\u0011yM\u0014a\u0001\u0003SBqA!6O\u0001\u0004\t\t\u0007C\u0004\u0003\\:\u0003\r!!\n\u0002\u000fUt\u0017\r\u001d9msR!11QBF!\u0015Y\u0018\u0011WBC!%Y8qQA5\u0003C\n)#C\u0002\u0004\nr\u0014a\u0001V;qY\u0016\u001c\u0004\"CBG\u001f\u0006\u0005\t\u0019\u0001Br\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007'\u0003Ba!\t\u0004\u0016&!1qSB\u0012\u0005\u0019y%M[3di\u0006\u0001\u0012m]\"p]:,7\r^(qi&|gn\u001d\u000b\u0005\u0007;\u001b\u0019\u000b\u0005\u0003\u0002x\u000e}\u0015\u0002BBQ\u0003s\u0014!#T9ui\u000e{gN\\3di>\u0003H/[8og\"9\u0011\u0011H)A\u0002\u0005m\u0012\u0001E1t\u0003\u000e$\u0018n\u001c8MSN$XM\\3s)\u0011\u0019Ika,\u0011\t\u0005]81V\u0005\u0005\u0007[\u000bIPA\nJ\u001bF$H/Q2uS>tG*[:uK:,'\u000fC\u0004\u00042J\u0003\raa-\u0002\t\u0019,hn\u0019\t\bw\u000eU&1DA]\u0013\r\u00199\f \u0002\n\rVt7\r^5p]FB3!MB^!\u0011\u0019il!1\u000e\u0005\r}&bAB\u00059&!11YB`\u0005-Ie\u000e^3s]\u0006d\u0017\t]5)\u0007A\u001aY,A\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6!\u0003\u0019yg\u000eU;tQR\u0011\u0011\u0011X\u0001\u0011_:,\u0006o\u001d;sK\u0006lg)\u001b8jg\"\f\u0011c\u001c8VaN$(/Z1n\r\u0006LG.\u001e:f)\u0011\tIla5\t\u000f\rUw\u00051\u0001\u0003B\u0005\u0011Q\r_\u0001\u0007_:\u0004V\u000f\u001c7\u0002%=tGi\\<ogR\u0014X-Y7GS:L7\u000f\u001b\u000b\u0005\u0003s\u001bi\u000eC\u0004\u0004`&\u0002\rA!\u0011\u0002\u000b\r\fWo]3\u0002\u001bA,(\r\\5tQR{W*\u001d;u)\u0011\t)p!:\t\u000f\r\u001d(\u00061\u0001\u0004j\u0006\u0019Qn]4\u0011\t\u0005u21^\u0005\u0004\u0007[4&aC'riRlUm]:bO\u0016\fa\u0002];cY&\u001c\b\u000eU3oI&tw\r\u0006\u0003\u0002:\u000eM\bBBBtW\u0001\u0007Q/\u0001\bqkNDGi\\<ogR\u0014X-Y7\u0015\t\u0005e6\u0011 \u0005\b\u0007wd\u0003\u0019AA\b\u0003\u001diWm]:bO\u0016\fQBZ1jYN#\u0018mZ3XSRDG\u0003BA]\t\u0003Aqa!6.\u0001\u0004\u0011\t%\u0001\u0005qe\u0016\u001cF/\u0019:u\u0003!\u0001xn\u001d;Ti>\u0004\b")
public abstract class MqttFlowStageLogic<I>
extends GraphStageLogic
implements StageLogging,
InHandler,
OutHandler {
    public final Inlet<I> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in;
    private final Outlet<MqttMessageWithAck> out;
    private final Promise<Done> subscriptionPromise;
    public final MqttConnectionSettings akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings;
    private final Map<String, MqttQoS> subscriptions;
    private final int bufferSize;
    private final MqttQoS defaultQoS;
    private final boolean manualAcks;
    private final Semaphore akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient;
    private Option<I> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg;
    private final Queue<MqttMessageWithAck> queue;
    private final AtomicInteger unackedMessages;
    private final AsyncCallback<Try<IMqttToken>> onSubscribe;
    private final AsyncCallback<IMqttAsyncClient> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnect;
    private final AsyncCallback<Throwable> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost;
    private final AsyncCallback<MqttMessageWithAck> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onMessageAsyncCallback;
    private final AsyncCallback<Try<IMqttToken>> onPublished;
    private final MqttAsyncClient client;
    private final AsyncCallback<CommitCallbackArguments> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$commitCallback;
    private LoggingAdapter akka$stream$stage$StageLogging$$_log;

    public static IMqttActionListener asActionListener(Function1<Try<IMqttToken>, BoxedUnit> func) {
        return MqttFlowStageLogic$.MODULE$.asActionListener(func);
    }

    public static MqttConnectOptions asConnectOptions(MqttConnectionSettings connectionSettings) {
        return MqttFlowStageLogic$.MODULE$.asConnectOptions(connectionSettings);
    }

    public void onDownstreamFinish() throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this);
    }

    public Class<?> logSource() {
        return StageLogging.logSource$((StageLogging)this);
    }

    public LoggingAdapter log() {
        return StageLogging.log$((StageLogging)this);
    }

    public LoggingAdapter akka$stream$stage$StageLogging$$_log() {
        return this.akka$stream$stage$StageLogging$$_log;
    }

    public void akka$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$stream$stage$StageLogging$$_log = x$1;
    }

    public Semaphore akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient;
    }

    public Option<I> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg;
    }

    public void akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg_$eq(Option<I> x$1) {
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg = x$1;
    }

    private Queue<MqttMessageWithAck> queue() {
        return this.queue;
    }

    private AtomicInteger unackedMessages() {
        return this.unackedMessages;
    }

    public void handleDeliveryComplete(IMqttDeliveryToken token) {
    }

    private AsyncCallback<Try<IMqttToken>> onSubscribe() {
        return this.onSubscribe;
    }

    public AsyncCallback<IMqttAsyncClient> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnect() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnect;
    }

    public AsyncCallback<Throwable> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost;
    }

    public AsyncCallback<MqttMessageWithAck> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onMessageAsyncCallback() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onMessageAsyncCallback;
    }

    private AsyncCallback<Try<IMqttToken>> onPublished() {
        return this.onPublished;
    }

    private DisconnectedBufferOptions createPahoBufferOptions(MqttOfflinePersistenceSettings settings) {
        DisconnectedBufferOptions disconnectedBufferOptions = new DisconnectedBufferOptions();
        disconnectedBufferOptions.setBufferEnabled(true);
        disconnectedBufferOptions.setBufferSize(settings.bufferSize());
        disconnectedBufferOptions.setDeleteOldestMessages(settings.deleteOldestMessage());
        disconnectedBufferOptions.setPersistBuffer(settings.persistBuffer());
        return disconnectedBufferOptions;
    }

    private MqttAsyncClient client() {
        return this.client;
    }

    public MqttAsyncClient akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient() {
        Option<MqttOfflinePersistenceSettings> option = this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings.offlinePersistenceSettings();
        if (option instanceof Some) {
            Some some = (Some)option;
            MqttOfflinePersistenceSettings bufferOpts = (MqttOfflinePersistenceSettings)some.value();
            this.client().setBufferOpts(this.createPahoBufferOptions(bufferOpts));
            return this.client();
        }
        return this.client();
    }

    public AsyncCallback<CommitCallbackArguments> akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$commitCallback() {
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$commitCallback;
    }

    public void onPush() {
        Object msg = this.grab(this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in);
        try {
            this.publishPending(msg);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof MqttException && this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings.automaticReconnect()) {
                this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg_$eq((Option<I>)new Some(msg));
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw e;
            }
            throw throwable;
        }
    }

    public void onUpstreamFinish() {
        this.setKeepGoing(true);
        if (this.queue().isEmpty() && this.unackedMessages().get() == 0) {
            InHandler.onUpstreamFinish$((InHandler)this);
            return;
        }
    }

    public void onUpstreamFailure(Throwable ex) {
        this.setKeepGoing(true);
        if (this.queue().isEmpty() && this.unackedMessages().get() == 0) {
            InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            return;
        }
    }

    public void onPull() {
        if (this.queue().nonEmpty()) {
            this.pushDownstream((MqttMessageWithAck)this.queue().dequeue());
            if (this.unackedMessages().get() == 0 && this.isClosed(this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in)) {
                this.completeStage();
                return;
            }
            return;
        }
    }

    public void onDownstreamFinish(Throwable cause) {
        this.setKeepGoing(true);
        if (this.unackedMessages().get() == 0) {
            OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            return;
        }
    }

    public IMqttDeliveryToken publishToMqtt(MqttMessage msg) {
        org.eclipse.paho.client.mqttv3.MqttMessage pahoMsg = new org.eclipse.paho.client.mqttv3.MqttMessage((byte[])msg.payload().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        pahoMsg.setQos(((MqttQoS)msg.qos().getOrElse((Function0 & Serializable)() -> $this.defaultQoS)).value());
        pahoMsg.setRetained(msg.retained());
        return this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().publish(msg.topic(), pahoMsg, (Object)msg, MqttFlowStageLogic$.MODULE$.asActionListener((Function1<Try<IMqttToken>, BoxedUnit>)(Function1 & Serializable)t -> {
            MqttFlowStageLogic.$anonfun$publishToMqtt$2(this, t);
            return BoxedUnit.UNIT;
        }));
    }

    public void publishPending(I msg) {
    }

    private void pushDownstream(MqttMessageWithAck message) {
        this.push(this.out, message);
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient().release();
        if (this.manualAcks) {
            this.unackedMessages().incrementAndGet();
            return;
        }
    }

    private void failStageWith(Throwable ex) {
        this.subscriptionPromise.tryFailure(ex);
        this.failStage(ex);
    }

    public void preStart() {
        try {
            this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().connect(MqttFlowStageLogic$.MODULE$.asConnectOptions(this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings), (Object)BoxedUnit.UNIT, new IMqttActionListener(this){
                private final /* synthetic */ MqttFlowStageLogic $outer;

                public void onSuccess(IMqttToken v) {
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnect().invoke((Object)v.getClient());
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable ex) {
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost().invoke((Object)ex);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable e) {
            this.failStageWith(e);
        }
    }

    public void postStop() {
        Object object = !this.subscriptionPromise.isCompleted() ? BoxesRunTime.boxToBoolean((boolean)this.subscriptionPromise.tryFailure((Throwable)new IllegalStateException("Cannot complete subscription because the stage is about to stop or fail"))) : BoxedUnit.UNIT;
        try {
            this.log().debug("stage stopped, disconnecting");
            this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().disconnect(this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings.disconnectQuiesceTimeout().toMillis(), null, new IMqttActionListener(this){
                private final /* synthetic */ MqttFlowStageLogic $outer;

                public void onSuccess(IMqttToken asyncActionToken) {
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().close();
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().disconnectForcibly(0L, this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings.disconnectTimeout().toMillis());
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (MqttException mqttException) {
            try {
                this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().close();
            }
            catch (MqttException mqttException2) {}
        }
    }

    public static final /* synthetic */ void $anonfun$onSubscribe$1(MqttFlowStageLogic $this, Try conn) {
        if ($this.subscriptionPromise.isCompleted()) {
            $this.log().debug("subscription re-established");
            return;
        }
        $this.subscriptionPromise.complete(conn.map((Function1 & Serializable)x$1 -> {
            $this.log().debug("subscription established");
            return Done$.MODULE$;
        }));
        $this.pull($this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in);
    }

    public static final /* synthetic */ void $anonfun$onConnect$3(MqttFlowStageLogic $this, Try t) {
        $this.onSubscribe().invoke((Object)t);
    }

    public static final /* synthetic */ void $anonfun$onConnect$1(MqttFlowStageLogic $this, IMqttAsyncClient client) {
        $this.log().debug("connected");
        if ($this.subscriptions.nonEmpty()) {
            Tuple2 tuple2;
            if ($this.manualAcks) {
                client.setManualAcks(true);
            }
            if ((tuple2 = $this.subscriptions.unzip(Predef$.MODULE$.$conforms())) == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable topics = (Iterable)tuple2._1();
            Iterable qoses = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topics, (Object)qoses);
            Iterable topics2 = (Iterable)tuple22._1();
            Iterable qoses2 = (Iterable)tuple22._2();
            client.subscribe((String[])topics2.toArray(ClassTag$.MODULE$.apply(String.class)), (int[])((IterableOnceOps)qoses2.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.value()))).toArray((ClassTag)ClassTag$.MODULE$.Int()), (Object)BoxedUnit.UNIT, MqttFlowStageLogic$.MODULE$.asActionListener((Function1<Try<IMqttToken>, BoxedUnit>)(Function1 & Serializable)t -> {
                MqttFlowStageLogic.$anonfun$onConnect$3($this, t);
                return BoxedUnit.UNIT;
            }));
            return;
        }
        $this.subscriptionPromise.complete(MqttFlowStageLogic$.MODULE$.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$SuccessfullyDone());
        $this.pull($this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in);
    }

    public static final /* synthetic */ void $anonfun$onMessageAsyncCallback$1(MqttFlowStageLogic $this, MqttMessageWithAck message) {
        if ($this.isAvailable($this.out)) {
            $this.pushDownstream(message);
            return;
        }
        if ($this.queue().size() + 1 > $this.bufferSize) {
            $this.failStageWith(new RuntimeException(new StringBuilder(28).append("Reached maximum buffer size ").append($this.bufferSize).toString()));
            return;
        }
        $this.queue().enqueue((Object)message);
    }

    public static final /* synthetic */ void $anonfun$onPublished$1(MqttFlowStageLogic $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            if (!$this.hasBeenPulled($this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in)) {
                $this.pull($this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in);
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.failStageWith(ex);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$commitCallback$1(MqttFlowStageLogic $this, CommitCallbackArguments args) {
        try {
            $this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().messageArrivedComplete(args.messageId(), args.qos().value());
            if ($this.unackedMessages().decrementAndGet() == 0 && ($this.isClosed($this.out) || $this.isClosed($this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in) && $this.queue().isEmpty())) {
                $this.completeStage();
            }
            args.promise().complete(MqttFlowStageLogic$.MODULE$.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$SuccessfullyDone());
        }
        catch (Throwable e) {
            args.promise().failure(e);
        }
    }

    public static final /* synthetic */ void $anonfun$publishToMqtt$2(MqttFlowStageLogic $this, Try t) {
        $this.onPublished().invoke((Object)t);
    }

    public MqttFlowStageLogic(Inlet<I> in, Outlet<MqttMessageWithAck> out, Shape shape, Promise<Done> subscriptionPromise, MqttConnectionSettings connectionSettings, Map<String, MqttQoS> subscriptions, int bufferSize, MqttQoS defaultQoS, boolean manualAcks) {
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in = in;
        this.out = out;
        this.subscriptionPromise = subscriptionPromise;
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings = connectionSettings;
        this.subscriptions = subscriptions;
        this.bufferSize = bufferSize;
        this.defaultQoS = defaultQoS;
        this.manualAcks = manualAcks;
        super(shape);
        StageLogging.$init$((StageLogging)this);
        InHandler.$init$((InHandler)this);
        OutHandler.$init$((OutHandler)this);
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient = new Semaphore(bufferSize);
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg = Option$.MODULE$.empty();
        this.queue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unackedMessages = new AtomicInteger();
        this.onSubscribe = this.getAsyncCallback((Function1 & Serializable)conn -> {
            MqttFlowStageLogic.$anonfun$onSubscribe$1(this, conn);
            return BoxedUnit.UNIT;
        });
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnect = this.getAsyncCallback((Function1 & Serializable)client -> {
            MqttFlowStageLogic.$anonfun$onConnect$1(this, client);
            return BoxedUnit.UNIT;
        });
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost = this.getAsyncCallback((Function1 & Serializable)ex -> {
            this.failStageWith(ex);
            return BoxedUnit.UNIT;
        });
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onMessageAsyncCallback = this.getAsyncCallback((Function1 & Serializable)message -> {
            MqttFlowStageLogic.$anonfun$onMessageAsyncCallback$1(this, message);
            return BoxedUnit.UNIT;
        });
        this.onPublished = this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
            MqttFlowStageLogic.$anonfun$onPublished$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.client = new MqttAsyncClient(connectionSettings.broker(), connectionSettings.clientId(), connectionSettings.persistence());
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$commitCallback = this.getAsyncCallback((Function1 & Serializable)args -> {
            MqttFlowStageLogic.$anonfun$commitCallback$1(this, args);
            return BoxedUnit.UNIT;
        });
        this.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$mqttClient().setCallback((MqttCallback)new MqttCallbackExtended(this){
            private final /* synthetic */ MqttFlowStageLogic $outer;

            public void messageArrived(String topic, org.eclipse.paho.client.mqttv3.MqttMessage pahoMessage) {
                this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$backpressurePahoClient().acquire();
                MqttMessageWithAck message = new MqttMessageWithAck(this, topic, pahoMessage){
                    private final MqttMessage message;
                    private final /* synthetic */ $anon$2 $outer;
                    private final org.eclipse.paho.client.mqttv3.MqttMessage pahoMessage$1;

                    public MqttMessage message() {
                        return this.message;
                    }

                    public Future<Done> ack() {
                        MqttQoS mqttQoS;
                        Promise promise = Promise$.MODULE$.apply();
                        int n = this.pahoMessage$1.getQos();
                        switch (n) {
                            case 0: {
                                mqttQoS = MqttQoS$AtMostOnce$.MODULE$;
                                break;
                            }
                            case 1: {
                                mqttQoS = MqttQoS$AtLeastOnce$.MODULE$;
                                break;
                            }
                            case 2: {
                                mqttQoS = MqttQoS$ExactlyOnce$.MODULE$;
                                break;
                            }
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                            }
                        }
                        MqttQoS qos = mqttQoS;
                        this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$anon$$$outer().akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$commitCallback().invoke((Object)new CommitCallbackArguments(this.pahoMessage$1.getId(), qos, (Promise<Done>)promise));
                        return promise.future();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.pahoMessage$1 = pahoMessage$1;
                        this.message = MqttMessage$.MODULE$.apply(topic$1, ByteString$.MODULE$.fromArrayUnsafe(pahoMessage$1.getPayload()));
                    }
                };
                this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onMessageAsyncCallback().invoke((Object)message);
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                this.$outer.handleDeliveryComplete(token);
            }

            public void connectionLost(Throwable cause) {
                if (!this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$connectionSettings.automaticReconnect()) {
                    this.$outer.log().info("connection lost (you might want to enable `automaticReconnect` in `MqttConnectionSettings`)");
                    this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$onConnectionLost().invoke((Object)cause);
                    return;
                }
                this.$outer.log().info("connection lost, trying to reconnect");
            }

            public void connectComplete(boolean reconnect, String serverURI) {
                this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg().foreach((Function1 & Serializable)msg -> {
                    $anon$2.$anonfun$connectComplete$1(this, msg);
                    return BoxedUnit.UNIT;
                });
                if (reconnect && !this.$outer.hasBeenPulled(this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in)) {
                    this.$outer.pull(this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$in);
                    return;
                }
            }

            public /* synthetic */ MqttFlowStageLogic akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$anon$$$outer() {
                return this.$outer;
            }

            public static final /* synthetic */ void $anonfun$connectComplete$1($anon$2 $this, Object msg) {
                $this.$outer.publishPending(msg);
                $this.$outer.akka$stream$alpakka$mqtt$impl$MqttFlowStageLogic$$pendingMsg_$eq(None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$connectComplete$1$adapted(akka.stream.alpakka.mqtt.impl.MqttFlowStageLogic$$anon$2 java.lang.Object )}, serializedLambda);
            }
        });
        this.setHandlers(in, out, this);
    }

    private static final class CommitCallbackArguments
    implements Product,
    Serializable {
        private final int messageId;
        private final MqttQoS qos;
        private final Promise<Done> promise;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int messageId() {
            return this.messageId;
        }

        public MqttQoS qos() {
            return this.qos;
        }

        public Promise<Done> promise() {
            return this.promise;
        }

        public CommitCallbackArguments copy(int messageId, MqttQoS qos, Promise<Done> promise) {
            return new CommitCallbackArguments(messageId, qos, promise);
        }

        public int copy$default$1() {
            return this.messageId();
        }

        public MqttQoS copy$default$2() {
            return this.qos();
        }

        public Promise<Done> copy$default$3() {
            return this.promise();
        }

        public String productPrefix() {
            return "CommitCallbackArguments";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.messageId());
                }
                case 1: {
                    return this.qos();
                }
                case 2: {
                    return this.promise();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CommitCallbackArguments;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "messageId";
                }
                case 1: {
                    return "qos";
                }
                case 2: {
                    return "promise";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.messageId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.qos()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.promise()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CommitCallbackArguments)) return false;
            boolean bl = true;
            if (!bl) return false;
            CommitCallbackArguments commitCallbackArguments = (CommitCallbackArguments)x$1;
            if (this.messageId() != commitCallbackArguments.messageId()) return false;
            MqttQoS mqttQoS = this.qos();
            MqttQoS mqttQoS2 = commitCallbackArguments.qos();
            if (mqttQoS == null) {
                if (mqttQoS2 != null) {
                    return false;
                }
            } else if (!mqttQoS.equals(mqttQoS2)) return false;
            Promise<Done> promise = this.promise();
            Promise<Done> promise2 = commitCallbackArguments.promise();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public CommitCallbackArguments(int messageId, MqttQoS qos, Promise<Done> promise) {
            this.messageId = messageId;
            this.qos = qos;
            this.promise = promise;
            Product.$init$((Product)this);
        }
    }
}

