/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.headers;

import akka.annotation.InternalApi;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.headers.ServerSideEncryption;
import akka.stream.alpakka.s3.impl.CopyPart$;
import akka.stream.alpakka.s3.impl.GetObject$;
import akka.stream.alpakka.s3.impl.HeadObject$;
import akka.stream.alpakka.s3.impl.InitiateMultipartUpload$;
import akka.stream.alpakka.s3.impl.PutObject$;
import akka.stream.alpakka.s3.impl.S3Request;
import akka.stream.alpakka.s3.impl.UploadPart$;
import java.io.Serializable;
import java.util.Objects;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\u000b\u0016\u0005\u0001B\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\ti\u0001\u0011\t\u0011)A\u0005O!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0011\u0019a\u0004\u0001\"\u0001\u0016{!1a\u0003\u0001C!/\u0005Caa\u0017\u0001\u0005B]a\u0006\"\u00024\u0001\t\u00039\u0007\"B5\u0001\t\u0003Q\u0007\"\u00027\u0001\t\u0013i\u0007b\u00029\u0001#\u0003%I!\u001d\u0005\bw\u0002\t\n\u0011\"\u0003}\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9bB\u0005\u0002 U\t\t\u0011#\u0001\u0002\"\u0019AA#FA\u0001\u0012\u0003\t\u0019\u0003\u0003\u0004=#\u0011\u0005\u00111\u0006\u0005\n\u0003[\t\u0012\u0013!C\u0001+q\u0014AbQ;ti>lWM]&fsNT!AF\f\u0002\u000f!,\u0017\rZ3sg*\u0011\u0001$G\u0001\u0003gNR!AG\u000e\u0002\u000f\u0005d\u0007/Y6lC*\u0011A$H\u0001\u0007gR\u0014X-Y7\u000b\u0003y\tA!Y6lC\u000e\u00011C\u0001\u0001\"!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\u000bTKJ4XM]*jI\u0016,en\u0019:zaRLwN\\\u0001\u0004W\u0016LX#A\u0014\u0011\u0005!\ndBA\u00150!\tQS&D\u0001,\u0015\tas$\u0001\u0004=e>|GO\u0010\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[\u0005!1.Z=!\u0003\riG-N\u000b\u0002oA\u0019\u0001(O\u0014\u000e\u00035J!AO\u0017\u0003\r=\u0003H/[8o\u0003\u0011iG-\u000e\u0011\u0002\rqJg.\u001b;?)\rqt\b\u0011\t\u0003E\u0001AQ!J\u0003A\u0002\u001dBq!N\u0003\u0011\u0002\u0003\u0007q'F\u0001C!\r\u0019\u0005JS\u0007\u0002\t*\u0011QIR\u0001\nS6lW\u000f^1cY\u0016T!aR\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002J\t\n\u00191+Z9\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015!B7pI\u0016d'BA(Q\u0003!\u00198-\u00197bINd'BA)\u001e\u0003\u0011AG\u000f\u001e9\n\u0005Mc%A\u0003%uiBDU-\u00193fe\"\u0012a!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031v\t!\"\u00198o_R\fG/[8o\u0013\tQvKA\u0006J]R,'O\\1m\u0003BL\u0017A\u00035fC\u0012,'o\u001d$peR\u0011!)\u0018\u0005\u0006=\u001e\u0001\raX\u0001\be\u0016\fX/Z:u!\t\u00017-D\u0001b\u0015\t\u0011w#\u0001\u0003j[Bd\u0017B\u00013b\u0005%\u00196GU3rk\u0016\u001cH\u000f\u000b\u0002\b+\u00069q/\u001b;i\u0017\u0016LHC\u0001 i\u0011\u0015)\u0003\u00021\u0001(\u0003\u001d9\u0018\u000e\u001e5NIV\"\"AP6\t\u000bUJ\u0001\u0019A\u0014\u0002\t\r|\u0007/\u001f\u000b\u0004}9|\u0007bB\u0013\u000b!\u0003\u0005\ra\n\u0005\bk)\u0001\n\u00111\u00018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001d\u0016\u0003OM\\\u0013\u0001\u001e\t\u0003kfl\u0011A\u001e\u0006\u0003ob\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005ak\u0013B\u0001>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005i(FA\u001ct\u0003!!xn\u0015;sS:<G#A\u0014\u0002\r\u0015\fX/\u00197t)\u0011\t)!a\u0003\u0011\u0007a\n9!C\u0002\u0002\n5\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u000e9\u0001\r!a\u0004\u0002\u000b=$\b.\u001a:\u0011\u0007a\n\t\"C\u0002\u0002\u00145\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA\r!\rA\u00141D\u0005\u0004\u0003;i#aA%oi\u0006a1)^:u_6,'oS3zgB\u0011!%E\n\u0004#\u0005\u0015\u0002c\u0001\u001d\u0002(%\u0019\u0011\u0011F\u0017\u0003\r\u0005s\u0017PU3g)\t\t\t#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r")
public final class CustomerKeys
extends ServerSideEncryption {
    private final String key;
    private final Option<String> md5;

    public String key() {
        return this.key;
    }

    public Option<String> md5() {
        return this.md5;
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headers() {
        RawHeader rawHeader = new RawHeader("x-amz-server-side-encryption-customer-algorithm", "AES256");
        RawHeader rawHeader2 = new RawHeader("x-amz-server-side-encryption-customer-key", this.key());
        RawHeader rawHeader3 = new RawHeader("x-amz-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable)() -> {
            void var2_2;
            byte[] decodedKey = BinaryUtils.fromBase64((String)this.key());
            String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
            return var2_2;
        }));
        return Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
    }

    @Override
    @InternalApi
    public Seq<HttpHeader> headersFor(S3Request request) {
        Nil$ nil$;
        S3Request s3Request = request;
        boolean bl = GetObject$.MODULE$.equals(s3Request) ? true : (HeadObject$.MODULE$.equals(s3Request) ? true : (PutObject$.MODULE$.equals(s3Request) ? true : (InitiateMultipartUpload$.MODULE$.equals(s3Request) ? true : UploadPart$.MODULE$.equals(s3Request))));
        if (bl) {
            nil$ = this.headers();
        } else if (CopyPart$.MODULE$.equals(s3Request)) {
            RawHeader rawHeader = new RawHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", "AES256");
            RawHeader rawHeader2 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key", this.key());
            RawHeader rawHeader3 = new RawHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", (String)this.md5().getOrElse((Function0 & Serializable)() -> {
                void var2_2;
                byte[] decodedKey = BinaryUtils.fromBase64((String)this.key());
                String md5 = Md5Utils.md5AsBase64((byte[])decodedKey);
                return var2_2;
            }));
            List copyHeaders = Nil$.MODULE$.$colon$colon((Object)rawHeader3).$colon$colon((Object)rawHeader2).$colon$colon((Object)rawHeader);
            Seq<HttpHeader> seq = this.headers();
            nil$ = (Seq)copyHeaders.$plus$plus$colon(seq);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public CustomerKeys withKey(String key) {
        return this.copy(key, this.copy$default$2());
    }

    public CustomerKeys withMd5(String md5) {
        Some x$1 = new Some((Object)md5);
        String x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    private CustomerKeys copy(String key, Option<String> md5) {
        return new CustomerKeys(key, md5);
    }

    private String copy$default$1() {
        return this.key();
    }

    private Option<String> copy$default$2() {
        return this.md5();
    }

    public String toString() {
        return new StringBuilder(35).append("ServerSideEncryption.CustomerKeys(").append(new StringBuilder(5).append("key=").append(this.key()).append(",").toString()).append(new StringBuilder(4).append("md5=").append(this.md5()).toString()).append(")").toString();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof CustomerKeys) {
            CustomerKeys customerKeys = (CustomerKeys)object;
            bl = Objects.equals(this.key(), customerKeys.key()) && Objects.equals(this.md5(), customerKeys.md5());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.md5());
    }

    public CustomerKeys(String key, Option<String> md5) {
        this.key = key;
        this.md5 = md5;
    }
}

