/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl.auth;

import akka.annotation.InternalApi;
import akka.stream.alpakka.s3.impl.auth.CredentialScope;
import akka.stream.alpakka.s3.impl.auth.SigningKey$;
import akka.stream.alpakka.s3.impl.auth.package$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

@ScalaSignature(bytes="\u0006\u0005\tmc!B\u00193\u0005Rr\u0004\u0002C+\u0001\u0005+\u0007I\u0011\u0001,\t\u0011}\u0003!\u0011#Q\u0001\n]C\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\t_\u0002\u0011\t\u0012)A\u0005E\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003s\u0011!9\bA!f\u0001\n\u0003A\b\"CA\u0002\u0001\tE\t\u0015!\u0003z\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fA\u0001\"\u001a\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0016!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001\"CA\u0014\u0001\t\u0007I\u0011AA\u0015\u0011!\ty\u0004\u0001Q\u0001\n\u0005-\u0002\"CA!\u0001\t\u0007I\u0011AA\"\u0011!\tY\u0005\u0001Q\u0001\n\u0005\u0015\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003C\u0002A\u0011AA2\u0011\u0019\t9\u0007\u0001C\u0001q\"Q\u0011\u0011\u000e\u0001\t\u0006\u0004%\t!!\u000b\t\u0015\u0005-\u0004\u0001#b\u0001\n\u0003\tI\u0003\u0003\u0006\u0002n\u0001A)\u0019!C\u0001\u0003SA!\"a\u001c\u0001\u0011\u000b\u0007I\u0011AA\u0015\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!!\u001f\u0001\t\u0013\tY\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0001\u0002\u0004\"I\u0011Q\u0012\u0001\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OC\u0011\"a+\u0001#\u0003%\t!!,\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002P\u0002\t\t\u0011\"\u0001\u0002R\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003[\u0004\u0011\u0011!C\u0001\u0003_D\u0011\"a=\u0001\u0003\u0003%\t%!>\t\u0013\u0005e\b!!A\u0005B\u0005m\b\"CA\u007f\u0001\u0005\u0005I\u0011IA\u0000\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0012\u0019a\u0002\u0006\u0003\u0014I\n\t\u0011#\u00015\u0005+1\u0011\"\r\u001a\u0002\u0002#\u0005AGa\u0006\t\u000f\u0005\u0015\u0011\u0006\"\u0001\u00030!I\u0011Q`\u0015\u0002\u0002\u0013\u0015\u0013q \u0005\n\u0005cI\u0013\u0011!CA\u0005gA\u0011B!\u0010*#\u0003%\t!a-\t\u0013\t}\u0012&!A\u0005\u0002\n\u0005\u0003\"\u0003B(SE\u0005I\u0011AAZ\u0011%\u0011\t&KA\u0001\n\u0013\u0011\u0019F\u0001\u0006TS\u001et\u0017N\\4LKfT!a\r\u001b\u0002\t\u0005,H\u000f\u001b\u0006\u0003kY\nA![7qY*\u0011q\u0007O\u0001\u0003gNR!!\u000f\u001e\u0002\u000f\u0005d\u0007/Y6lC*\u00111\bP\u0001\u0007gR\u0014X-Y7\u000b\u0003u\nA!Y6lCN!\u0001aP#I!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011\u0001IR\u0005\u0003\u000f\u0006\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002J%:\u0011!\n\u0015\b\u0003\u0017>k\u0011\u0001\u0014\u0006\u0003\u001b:\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002\u0005&\u0011\u0011+Q\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002R\u0003\u0006Y!/Z9vKN$H)\u0019;f+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011!\u0018.\\3\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u0019I,\u0017/^3ti\u0012\u000bG/\u001a\u0011\u0002\u0019\r\u0014X\r\u001a)s_ZLG-\u001a:\u0016\u0003\t\u0004\"aY7\u000e\u0003\u0011T!!\u001a4\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\u0006\u0003g\u001dT!\u0001[5\u0002\r\u0005<8o\u001d3l\u0015\tQ7.\u0001\u0004b[\u0006TxN\u001c\u0006\u0002Y\u0006A1o\u001c4uo\u0006\u0014X-\u0003\u0002oI\n1\u0012i^:De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'/A\u0007de\u0016$\u0007K]8wS\u0012,'\u000fI\u0001\u0006g\u000e|\u0007/Z\u000b\u0002eB\u00111\u000f^\u0007\u0002e%\u0011QO\r\u0002\u0010\u0007J,G-\u001a8uS\u0006d7kY8qK\u000611oY8qK\u0002\n\u0011\"\u00197h_JLG\u000f[7\u0016\u0003e\u0004\"A\u001f@\u000f\u0005md\bCA&B\u0013\ti\u0018)\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~\u0003\u0006Q\u0011\r\\4pe&$\b.\u001c\u0011\u0002\rqJg.\u001b;?))\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003g\u0002AQ!V\u0005A\u0002]CQ\u0001Y\u0005A\u0002\tDQ\u0001]\u0005A\u0002IDqa^\u0005\u0011\u0002\u0003\u0007\u00110\u0006\u0002\u0002\u0016A\u00191-a\u0006\n\u0007\u0005eAM\u0001\bBoN\u001c%/\u001a3f]RL\u0017\r\\:\u0002\u0019\r\u0014X\rZ3oi&\fGn\u001d\u0011\u0002\u0013\u0005twN\\=n_V\u001cXCAA\u0011!\r\u0001\u00151E\u0005\u0004\u0003K\t%a\u0002\"p_2,\u0017M\\\u0001\u0007e\u0006<8*Z=\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003wi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005gB,7M\u0003\u0003\u00026\u0005]\u0012AB2ssB$xN\u0003\u0002\u0002:\u0005)!.\u0019<bq&!\u0011QHA\u0018\u00055\u0019Vm\u0019:fi.+\u0017p\u00159fG\u00069!/Y<LKf\u0004\u0013\u0001D:fgNLwN\u001c+pW\u0016tWCAA#!\u0011\u0001\u0015qI=\n\u0007\u0005%\u0013I\u0001\u0004PaRLwN\\\u0001\u000eg\u0016\u001c8/[8o)>\\WM\u001c\u0011\u0002\u0013MLwM\\1ukJ,G\u0003BA)\u0003;\u0002R\u0001QA*\u0003/J1!!\u0016B\u0005\u0015\t%O]1z!\r\u0001\u0015\u0011L\u0005\u0004\u00037\n%\u0001\u0002\"zi\u0016Dq!a\u0018\u0012\u0001\u0004\t\t&A\u0004nKN\u001c\u0018mZ3\u0002'!,\u00070\u00128d_\u0012,GmU5h]\u0006$XO]3\u0015\u0007e\f)\u0007C\u0004\u0002`I\u0001\r!!\u0015\u0002!\r\u0014X\rZ3oi&\fGn\u0015;sS:<\u0017aA6fs\u0006!B-\u0019;f%\u0016<\u0017n\u001c8TKJ4\u0018nY3LKf\fQ\u0002Z1uKJ+w-[8o\u0017\u0016L\u0018a\u00023bi\u0016\\U-_\u0001\u000eoJ\f\u0007oU5h]\u0006$XO]3\u0015\r\u0005-\u0012QOA<\u0011\u001d\ti\u0005\u0007a\u0001\u0003WAq!a\u0018\u0019\u0001\u0004\t\t&A\u0006tS\u001etw+\u001b;i\u0017\u0016LHCBA)\u0003{\ny\bC\u0004\u0002je\u0001\r!a\u000b\t\u000f\u0005}\u0013\u00041\u0001\u0002R\u0005!1m\u001c9z))\tI!!\"\u0002\b\u0006%\u00151\u0012\u0005\b+j\u0001\n\u00111\u0001X\u0011\u001d\u0001'\u0004%AA\u0002\tDq\u0001\u001d\u000e\u0011\u0002\u0003\u0007!\u000fC\u0004x5A\u0005\t\u0019A=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0013\u0016\u0004/\u0006M5FAAK!\u0011\t9*!)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0015)\u0001\u0006b]:|G/\u0019;j_:LA!a)\u0002\u001a\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0004E\u0006M\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003_S3A]AJ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!.+\u0007e\f\u0019*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0003B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\\\u0016\u0001\u00027b]\u001eL1a`A`\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\rE\u0002A\u0003\u0017L1!!4B\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019.!7\u0011\u0007\u0001\u000b).C\u0002\u0002X\u0006\u00131!\u00118z\u0011%\tY.IA\u0001\u0002\u0004\tI-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0004b!a9\u0002j\u0006MWBAAs\u0015\r\t9/Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAv\u0003K\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011EAy\u0011%\tYnIA\u0001\u0002\u0004\t\u0019.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA^\u0003oD\u0011\"a7%\u0003\u0003\u0005\r!!3\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a/\u0002\r\u0015\fX/\u00197t)\u0011\t\tC!\u0002\t\u0013\u0005mw%!AA\u0002\u0005M\u0007f\u0001\u0001\u0003\nA!!1\u0002B\b\u001b\t\u0011iAC\u0002\u0002 rJAA!\u0005\u0003\u000e\tY\u0011J\u001c;fe:\fG.\u00119j\u0003)\u0019\u0016n\u001a8j]\u001e\\U-\u001f\t\u0003g&\u001aR!\u000bB\r\u0005K\u0001\"Ba\u0007\u0003\"]\u0013'/_A\u0005\u001b\t\u0011iBC\u0002\u0003 \u0005\u000bqA];oi&lW-\u0003\u0003\u0003$\tu!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!q\u0005B\u0017\u001b\t\u0011ICC\u0002\u0003,m\u000b!![8\n\u0007M\u0013I\u0003\u0006\u0002\u0003\u0016\u0005)\u0011\r\u001d9msRQ\u0011\u0011\u0002B\u001b\u0005o\u0011IDa\u000f\t\u000bUc\u0003\u0019A,\t\u000b\u0001d\u0003\u0019\u00012\t\u000bAd\u0003\u0019\u0001:\t\u000f]d\u0003\u0013!a\u0001s\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r#1\n\t\u0006\u0001\u0006\u001d#Q\t\t\b\u0001\n\u001dsK\u0019:z\u0013\r\u0011I%\u0011\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t5c&!AA\u0002\u0005%\u0011a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0016\u0011\t\u0005u&qK\u0005\u0005\u00053\nyL\u0001\u0004PE*,7\r\u001e")
@InternalApi
public final class SigningKey
implements Product,
Serializable {
    private SecretKeySpec key;
    private SecretKeySpec dateRegionServiceKey;
    private SecretKeySpec dateRegionKey;
    private SecretKeySpec dateKey;
    private final ZonedDateTime requestDate;
    private final AwsCredentialsProvider credProvider;
    private final CredentialScope scope;
    private final String algorithm;
    private final AwsCredentials credentials;
    private final SecretKeySpec rawKey;
    private final Option<String> sessionToken;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$4() {
        return SigningKey$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<ZonedDateTime, AwsCredentialsProvider, CredentialScope, String>> unapply(SigningKey signingKey) {
        return SigningKey$.MODULE$.unapply(signingKey);
    }

    public static String apply$default$4() {
        return SigningKey$.MODULE$.apply$default$4();
    }

    public static SigningKey apply(ZonedDateTime zonedDateTime, AwsCredentialsProvider awsCredentialsProvider, CredentialScope credentialScope, String string) {
        return SigningKey$.MODULE$.apply(zonedDateTime, awsCredentialsProvider, credentialScope, string);
    }

    public static Function1<Tuple4<ZonedDateTime, AwsCredentialsProvider, CredentialScope, String>, SigningKey> tupled() {
        return SigningKey$.MODULE$.tupled();
    }

    public static Function1<ZonedDateTime, Function1<AwsCredentialsProvider, Function1<CredentialScope, Function1<String, SigningKey>>>> curried() {
        return SigningKey$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ZonedDateTime requestDate() {
        return this.requestDate;
    }

    public AwsCredentialsProvider credProvider() {
        return this.credProvider;
    }

    public CredentialScope scope() {
        return this.scope;
    }

    public String algorithm() {
        return this.algorithm;
    }

    private AwsCredentials credentials() {
        return this.credentials;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean anonymous() {
        String string = this.credentials().secretAccessKey();
        Object object = None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        String string2 = this.credentials().accessKeyId();
        Object object2 = None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (string2 == null) {
            if (object2 == null) return true;
            return false;
        } else {
            if (!string2.equals(object2)) return false;
            return true;
        }
    }

    public SecretKeySpec rawKey() {
        return this.rawKey;
    }

    public Option<String> sessionToken() {
        return this.sessionToken;
    }

    public byte[] signature(byte[] message) {
        return this.signWithKey(this.key(), message);
    }

    public String hexEncodedSignature(byte[] message) {
        return package$.MODULE$.encodeHex(this.signature(message));
    }

    public String credentialString() {
        return new StringBuilder(1).append(this.credentials().accessKeyId()).append("/").append(this.scope().scopeString()).toString();
    }

    private SecretKeySpec key$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.key = this.wrapSignature(this.dateRegionServiceKey(), "aws4_request".getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.key;
    }

    public SecretKeySpec key() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.key$lzycompute() : this.key;
    }

    private SecretKeySpec dateRegionServiceKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateRegionServiceKey = this.wrapSignature(this.dateRegionKey(), this.scope().awsService().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateRegionServiceKey;
    }

    public SecretKeySpec dateRegionServiceKey() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateRegionServiceKey$lzycompute() : this.dateRegionServiceKey;
    }

    private SecretKeySpec dateRegionKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateRegionKey = this.wrapSignature(this.dateKey(), this.scope().awsRegion().id().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateRegionKey;
    }

    public SecretKeySpec dateRegionKey() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dateRegionKey$lzycompute() : this.dateRegionKey;
    }

    private SecretKeySpec dateKey$lzycompute() {
        SigningKey signingKey = this;
        synchronized (signingKey) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dateKey = this.wrapSignature(this.rawKey(), this.scope().formattedDate().getBytes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dateKey;
    }

    public SecretKeySpec dateKey() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dateKey$lzycompute() : this.dateKey;
    }

    private SecretKeySpec wrapSignature(SecretKeySpec signature, byte[] message) {
        return new SecretKeySpec(this.signWithKey(signature, message), this.algorithm());
    }

    private byte[] signWithKey(SecretKeySpec key, byte[] message) {
        Mac mac = Mac.getInstance(this.algorithm());
        mac.init(key);
        return mac.doFinal(message);
    }

    public SigningKey copy(ZonedDateTime requestDate, AwsCredentialsProvider credProvider, CredentialScope scope, String algorithm) {
        return new SigningKey(requestDate, credProvider, scope, algorithm);
    }

    public ZonedDateTime copy$default$1() {
        return this.requestDate();
    }

    public AwsCredentialsProvider copy$default$2() {
        return this.credProvider();
    }

    public CredentialScope copy$default$3() {
        return this.scope();
    }

    public String copy$default$4() {
        return this.algorithm();
    }

    public String productPrefix() {
        return "SigningKey";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.requestDate();
                break;
            }
            case 1: {
                object = this.credProvider();
                break;
            }
            case 2: {
                object = this.scope();
                break;
            }
            case 3: {
                object = this.algorithm();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SigningKey;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "requestDate";
                break;
            }
            case 1: {
                string = "credProvider";
                break;
            }
            case 2: {
                string = "scope";
                break;
            }
            case 3: {
                string = "algorithm";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SigningKey)) return false;
        boolean bl = true;
        if (!bl) return false;
        SigningKey signingKey = (SigningKey)x$1;
        ZonedDateTime zonedDateTime = this.requestDate();
        ZonedDateTime zonedDateTime2 = signingKey.requestDate();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        AwsCredentialsProvider awsCredentialsProvider = this.credProvider();
        AwsCredentialsProvider awsCredentialsProvider2 = signingKey.credProvider();
        if (awsCredentialsProvider == null) {
            if (awsCredentialsProvider2 != null) {
                return false;
            }
        } else if (!awsCredentialsProvider.equals(awsCredentialsProvider2)) return false;
        CredentialScope credentialScope = this.scope();
        CredentialScope credentialScope2 = signingKey.scope();
        if (credentialScope == null) {
            if (credentialScope2 != null) {
                return false;
            }
        } else if (!((Object)credentialScope).equals(credentialScope2)) return false;
        String string = this.algorithm();
        String string2 = signingKey.algorithm();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public SigningKey(ZonedDateTime requestDate, AwsCredentialsProvider credProvider, CredentialScope scope, String algorithm) {
        None$ none$;
        this.requestDate = requestDate;
        this.credProvider = credProvider;
        this.scope = scope;
        this.algorithm = algorithm;
        Product.$init$((Product)this);
        this.credentials = credProvider.resolveCredentials();
        this.rawKey = new SecretKeySpec(new StringBuilder(4).append("AWS4").append(this.credentials().secretAccessKey()).toString().getBytes(), algorithm);
        AwsCredentials awsCredentials = this.credentials();
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials awsSessionCredentials = (AwsSessionCredentials)awsCredentials;
            none$ = new Some((Object)awsSessionCredentials.sessionToken());
        } else {
            none$ = None$.MODULE$;
        }
        this.sessionToken = none$;
    }
}

