/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3;

import akka.http.scaladsl.model.IllegalUriException$;
import akka.stream.alpakka.s3.AccessStyle;
import akka.stream.alpakka.s3.AccessStyle$PathAccessStyle$;
import akka.stream.alpakka.s3.S3Settings;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.util.matching.Regex;

public final class BucketAndKey$ {
    public static final BucketAndKey$ MODULE$ = new BucketAndKey$();
    private static final Regex bucketRegexPathStyle = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(/\\.\\.)|(\\.\\./)"));
    private static final Regex bucketRegexDns = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^a-z0-9\\-\\.]{1,255}|[\\.]{2,}"));

    private Regex bucketRegexPathStyle() {
        return bucketRegexPathStyle;
    }

    private Regex bucketRegexDns() {
        return bucketRegexDns;
    }

    public boolean pathStyleValid(String bucket) {
        return this.bucketRegexPathStyle().findFirstIn((CharSequence)bucket).isEmpty() && !"..".equals(bucket);
    }

    public boolean dnsValid(String bucket) {
        return this.bucketRegexDns().findFirstIn((CharSequence)bucket).isEmpty();
    }

    public void validateBucketName(String bucket, S3Settings conf) {
        AccessStyle accessStyle = conf.accessStyle();
        AccessStyle$PathAccessStyle$ accessStyle$PathAccessStyle$ = AccessStyle$PathAccessStyle$.MODULE$;
        if (!(accessStyle != null ? !accessStyle.equals(accessStyle$PathAccessStyle$) : accessStyle$PathAccessStyle$ != null)) {
            if (!this.pathStyleValid(bucket)) {
                throw IllegalUriException$.MODULE$.apply("The bucket name contains sub-dir selection with `..`", "Selecting sub-directories with `..` is forbidden (and won't work with non-path-style access).");
            }
            return;
        }
        Option option = this.bucketRegexDns().findFirstIn((CharSequence)bucket);
        if (option instanceof Some) {
            Some some = (Some)option;
            String illegalCharacter = (String)some.value();
            throw IllegalUriException$.MODULE$.apply("Bucket name contains non-LDH characters", new StringBuilder(40).append("The following character is not allowed: ").append(illegalCharacter).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean objectKeyValid(String key) {
        return !ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])key.split("/")), (Object)"..");
    }

    public void validateObjectKey(String key, S3Settings conf) {
        if (conf.validateObjectKey() && !this.objectKeyValid(key)) {
            throw IllegalUriException$.MODULE$.apply("The object key contains sub-dir selection with `..`", "Selecting sub-directories with `..` is forbidden (see the `validate-object-key` setting).");
        }
    }

    private BucketAndKey$() {
    }
}

