/*
 * Decompiled with CFR 0.152.
 */
package akka.grpc.internal;

import akka.NotUsed;
import akka.grpc.GrpcProtocol;
import akka.grpc.internal.AbstractGrpcProtocol;
import akka.grpc.internal.Codec;
import akka.grpc.internal.Identity$;
import akka.grpc.internal.MissingParameterException;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.Trailer;
import akka.stream.Graph;
import akka.stream.impl.io.ByteStringParser;
import akka.stream.impl.io.ByteStringParser$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.Integral;
import scala.math.Numeric;

public final class AbstractGrpcProtocol$ {
    public static AbstractGrpcProtocol$ MODULE$;
    private final ByteString notCompressed;
    private final ByteString compressed;

    static {
        new AbstractGrpcProtocol$();
    }

    private ByteString notCompressed() {
        return this.notCompressed;
    }

    private ByteString compressed() {
        return this.compressed;
    }

    public ByteString fieldType(Codec codec) {
        Codec codec2 = codec;
        Identity$ identity$ = Identity$.MODULE$;
        if (!(codec2 != null ? !codec2.equals(identity$) : identity$ != null)) {
            return this.notCompressed();
        }
        return this.compressed();
    }

    private ContentType.Binary adjustCompressibility(ContentType.Binary contentType, Codec codec) {
        Codec codec2;
        return contentType.mediaType().withComp((MediaType.Compressibility)(Identity$.MODULE$.equals(codec2 = codec) ? MediaType.Compressible$.MODULE$ : MediaType.NotCompressible$.MODULE$)).toContentType();
    }

    public ByteString encodeFrameData(ByteString frameType, ByteString data) {
        int length = data.length();
        ByteString encodedLength = ByteString$.MODULE$.fromArrayUnsafe(new byte[]{(byte)(length >> 24), (byte)(length >> 16), (byte)(length >> 8), (byte)length});
        return frameType.$plus$plus(encodedLength).$plus$plus(data);
    }

    public ByteString encodeFrameData(ByteString data, boolean isCompressed, boolean isTrailer) {
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        int length = data.length();
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.sizeHint(5);
        int flags = (isCompressed ? 1 : 0) | (isTrailer ? 128 : 0);
        return builder.putByte((byte)flags).putInt(length, byteOrder).$plus$plus$eq(data).result();
    }

    public GrpcProtocol.GrpcProtocolWriter writer(GrpcProtocol protocol, Codec codec, Function1<GrpcProtocol.Frame, HttpEntity.ChunkStreamPart> encodeFrame, Function3<ByteString, scala.collection.immutable.Seq<HttpHeader>, Trailer, HttpResponse> encodeDataToResponse) {
        return new GrpcProtocol.GrpcProtocolWriter((ContentType)this.adjustCompressibility(protocol.contentType(), codec), codec, encodeFrame, encodeDataToResponse, (Flow<GrpcProtocol.Frame, HttpEntity.ChunkStreamPart, NotUsed>)((Flow)Flow$.MODULE$.apply().map(encodeFrame)));
    }

    public GrpcProtocol.GrpcProtocolReader reader(Codec codec, Function2<Object, ByteString, GrpcProtocol.Frame> decodeFrame, Function1<ByteString, ByteString> preDecodeStrict, Flow<ByteString, ByteString, NotUsed> preDecodeFlow) {
        Function1<ByteString, ByteString> strictAdapter = preDecodeStrict == null ? x -> (ByteString)Predef$.MODULE$.identity(x) : preDecodeStrict;
        Function1 & Serializable & scala.Serializable adapter = preDecodeFlow == null ? (Function1 & Serializable & scala.Serializable)x -> (Flow)Predef$.MODULE$.identity(x) : (Function1 & Serializable & scala.Serializable)x -> Flow$.MODULE$.apply().via((Graph)preDecodeFlow).via((Graph)x);
        return new GrpcProtocol.GrpcProtocolReader(codec, (Function1<ByteString, ByteString>)(Function1 & Serializable & scala.Serializable)bs -> AbstractGrpcProtocol$.decoder$1(bs, strictAdapter, codec), (Flow<ByteString, GrpcProtocol.Frame, NotUsed>)((Flow)adapter.apply((Object)Flow$.MODULE$.fromGraph((Graph)new AbstractGrpcProtocol.GrpcFramingDecoderStage(codec, decodeFrame)))));
    }

    public Function1<ByteString, ByteString> reader$default$3() {
        return null;
    }

    public Flow<ByteString, ByteString, NotUsed> reader$default$4() {
        return null;
    }

    private static final ByteString decoder$1(ByteString bs, Function1 strictAdapter$1, Codec codec$1) {
        ByteString byteString;
        try {
            ByteStringParser.ByteReader reader = new ByteStringParser.ByteReader((ByteString)strictAdapter$1.apply((Object)bs));
            int frameType = reader.readByte();
            int length = reader.readIntBE();
            ByteString data = reader.take(length);
            if (reader.hasRemaining()) {
                throw new IllegalStateException("Unexpected data");
            }
            if ((frameType & 0x80) != 0) {
                throw new IllegalStateException("Cannot read unknown frame");
            }
            byteString = codec$1.uncompress((frameType & 1) == 1, data);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exception exception = ByteStringParser$.MODULE$.NeedMoreData();
            Throwable throwable3 = throwable2;
            if (!(exception != null ? !exception.equals(throwable3) : throwable3 != null)) {
                throw new MissingParameterException();
            }
            throw throwable;
        }
        return byteString;
    }

    private AbstractGrpcProtocol$() {
        MODULE$ = this;
        this.notCompressed = ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), (Integral)Numeric.IntIsIntegral$.MODULE$);
        this.compressed = ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }
}

