/*
 * Copyright (C) 2018-2023 Lightbend Inc. <https://www.lightbend.com>
 */

package akka.grpc.internal

import java.util.concurrent.CompletionStage

import scala.concurrent.Future

import akka.Done
import akka.actor.ClassicActorSystemProvider
import akka.annotation.{ InternalApi, InternalStableApi }
import akka.event.LoggingAdapter
import akka.grpc.{ GrpcChannel, GrpcClientSettings }

/**
 * INTERNAL API
 *
 * Deprecated: This class wraps a GrpcChannel for compatibility with clients generated by previous versions.
 */
@deprecated("Kept for binary compatibility between generated code and runtime", "akka-grpc 2.1.5")
@InternalApi
final class ClientState private (channel: GrpcChannel)(implicit sys: ClassicActorSystemProvider) {

  @InternalStableApi
  val internalChannel: InternalChannel =
    channel.internalChannel

  @InternalStableApi
  def this(settings: GrpcClientSettings, log: LoggingAdapter)(implicit sys: ClassicActorSystemProvider) =
    this(GrpcChannel(settings))

  def closedCS(): CompletionStage[Done] = channel.closedCS()
  def closeCS(): CompletionStage[Done] = channel.closeCS()

  def closed(): Future[Done] = channel.closed()

  def close(): Future[Done] = channel.close()
}

/**
 * INTERNAL API
 * Used from generated code so can't be private.
 *
 * Thrown if a withChannel call is called after closing the internal channel
 */
@InternalApi
final class ClientClosedException() extends RuntimeException("withChannel called after close()")
