/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner;

import akka.annotation.InternalApi;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import com.typesafe.config.Config;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005esAB\u0016-\u0011\u0003a#G\u0002\u00045Y!\u0005A&\u000e\u0005\u0006y\u0005!\tA\u0010\u0004\u0005\u007f\u0005\u0011\u0001\t\u0003\u0005B\u0007\t\u0005\t\u0015!\u0003C\u0011\u0015a4\u0001\"\u0001L\u0011\u001dy5A1A\u0005\u0002ACa\u0001V\u0002!\u0002\u0013\t\u0006bB+\u0004\u0005\u0004%\tA\u0016\u0005\u0007?\u000e\u0001\u000b\u0011B,\t\u000f\u0001\u001c!\u0019!C\u0001!\"1\u0011m\u0001Q\u0001\nECqAY\u0002C\u0002\u0013\u0005a\u000b\u0003\u0004d\u0007\u0001\u0006Ia\u0016\u0005\bI\u000e\u0011\r\u0011\"\u0001W\u0011\u0019)7\u0001)A\u0005/\"9am\u0001b\u0001\n\u00031\u0006BB4\u0004A\u0003%qKB\u00035Y\ta\u0003\u000f\u0003\u0005B%\t\u0005\t\u0015!\u0003C\u0011\u0015a$\u0003\"\u0001r\u0011\u001d!(C1A\u0005\u0002UDaA \n!\u0002\u00131\bbB@\u0013\u0005\u0004%\t!\u001e\u0005\b\u0003\u0003\u0011\u0002\u0015!\u0003w\u0011!\t\u0019A\u0005b\u0001\n\u0003)\bbBA\u0003%\u0001\u0006IA\u001e\u0005\n\u0003\u000f\u0011\"\u0019!C\u0001\u0003\u0013A\u0001\"a\b\u0013A\u0003%\u00111\u0002\u0005\n\u0003C\u0011\"\u0019!C\u0001\u0003\u0013A\u0001\"a\t\u0013A\u0003%\u00111\u0002\u0005\n\u0003K\u0011\"\u0019!C\u0001\u0003\u0013A\u0001\"a\n\u0013A\u0003%\u00111\u0002\u0005\n\u0003S\u0011\"\u0019!C\u0001\u0003WA\u0001\"a\r\u0013A\u0003%\u0011Q\u0006\u0005\t\u0003k\u0011\"\u0019!C\u0001k\"9\u0011q\u0007\n!\u0002\u00131\b\u0002CA\u001d%\t\u0007I\u0011A;\t\u000f\u0005m\"\u0003)A\u0005m\"A\u0011Q\b\nC\u0002\u0013\u0005Q\u000fC\u0004\u0002@I\u0001\u000b\u0011\u0002<\t\u0013\u0005\u0005#C1A\u0005\u0002\u0005\r\u0003\u0002CA+%\u0001\u0006I!!\u0012\u0002\u001fM\u0003\u0018M\u001c8feN+G\u000f^5oONT!!\f\u0018\u0002\u000fM\u0004\u0018M\u001c8fe*\u0011q\u0006M\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u00012\u0003\u0011\t7n[1\u0011\u0005M\nQ\"\u0001\u0017\u0003\u001fM\u0003\u0018M\u001c8feN+G\u000f^5oON\u001c\"!\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u001a\u0003'M+7o]5p]B{w\u000e\\*fiRLgnZ:\u0014\u0005\r1\u0014AB2p]\u001aLw\r\u0005\u0002D\u00136\tAI\u0003\u0002B\u000b*\u0011aiR\u0001\tif\u0004Xm]1gK*\t\u0001*A\u0002d_6L!A\u0013#\u0003\r\r{gNZ5h)\tae\n\u0005\u0002N\u00075\t\u0011\u0001C\u0003B\u000b\u0001\u0007!)A\u0004nCb\u001c\u0016N_3\u0016\u0003E\u0003\"a\u000e*\n\u0005MC$aA%oi\u0006AQ.\u0019=TSj,\u0007%A\nsKR\u0014\u0018p\u0011:fCR,\u0017J\u001c;feZ\fG.F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0005ekJ\fG/[8o\u0015\ta\u0006(\u0001\u0006d_:\u001cWO\u001d:f]RL!AX-\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006!\"/\u001a;ss\u000e\u0013X-\u0019;f\u0013:$XM\u001d<bY\u0002\na#\\1y\u001fV$8\u000f^1oI&twMU3rk\u0016\u001cHo]\u0001\u0018[\u0006Dx*\u001e;ti\u0006tG-\u001b8h%\u0016\fX/Z:ug\u0002\n\u0011C]3ti\u0006\u0014H/T5o\u0005\u0006\u001c7n\u001c4g\u0003I\u0011Xm\u001d;beRl\u0015N\u001c\"bG.|gM\u001a\u0011\u0002#I,7\u000f^1si6\u000b\u0007PQ1dW>4g-\u0001\nsKN$\u0018M\u001d;NCb\u0014\u0015mY6pM\u001a\u0004\u0013!E6fKB\fE.\u001b<f\u0013:$XM\u001d<bY\u0006\u00112.Z3q\u00032Lg/Z%oi\u0016\u0014h/\u00197!Q\t\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002ma\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059\\'aC%oi\u0016\u0014h.\u00197Ba&D#\u0001A5\u0014\u0005I1DC\u0001:t!\t\u0019$\u0003C\u0003B)\u0001\u0007!)A\u0004qe>TWm\u0019;\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\ti\bP\u0001\u0004TiJLgnZ\u0001\taJ|'.Z2uA\u0005A\u0011N\\:uC:\u001cW-A\u0005j]N$\u0018M\\2fA\u0005AA-\u0019;bE\u0006\u001cX-A\u0005eCR\f'-Y:fA\u0005)b-\u001e7msF+\u0018\r\\5gS\u0016$\u0007K]8kK\u000e$XCAA\u0006!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#ATBAA\n\u0015\r\t)\"P\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0001(\u0001\u0004Qe\u0016$WMZ\u0005\u0004{\u0006u!bAA\rq\u00051b-\u001e7msF+\u0018\r\\5gS\u0016$\u0007K]8kK\u000e$\b%\u0001\u0004qCJ,g\u000e^\u0001\ba\u0006\u0014XM\u001c;!\u0003Y1W\u000f\u001c7z#V\fG.\u001b4jK\u0012$\u0015\r^1cCN,\u0017a\u00064vY2L\u0018+^1mS\u001aLW\r\u001a#bi\u0006\u0014\u0017m]3!\u0003\u001d)8/Z!vi\",\"!!\f\u0011\u0007]\ny#C\u0002\u00022a\u0012qAQ8pY\u0016\fg.\u0001\u0005vg\u0016\fU\u000f\u001e5!\u0003\u0015!\u0018M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005qA-\u001a7fi&|gn\u001d+bE2,\u0017a\u00043fY\u0016$\u0018n\u001c8t)\u0006\u0014G.\u001a\u0011\u0002\u0015\u001d\u0014\boY\"mS\u0016tG/A\u0006heB\u001c7\t\\5f]R\u0004\u0013aC:fgNLwN\u001c)p_2,\"!!\u0012\u0011\u0007\u0005\u001d3AD\u0002\u0002J\u0001qA!a\u0013\u0002T9!\u0011QJA)\u001d\u0011\t\t\"a\u0014\n\u0003EJ!a\f\u0019\n\u00055r\u0013\u0001D:fgNLwN\u001c)p_2\u0004\u0003F\u0001\nj\u0001")
@InternalApi
public final class SpannerSettings {
    private final String project;
    private final String instance;
    private final String database;
    private final String fullyQualifiedProject;
    private final String parent;
    private final String fullyQualifiedDatabase;
    private final boolean useAuth;
    private final String table;
    private final String deletionsTable;
    private final String grpcClient;
    private final SessionPoolSettings sessionPool;

    public String project() {
        return this.project;
    }

    public String instance() {
        return this.instance;
    }

    public String database() {
        return this.database;
    }

    public String fullyQualifiedProject() {
        return this.fullyQualifiedProject;
    }

    public String parent() {
        return this.parent;
    }

    public String fullyQualifiedDatabase() {
        return this.fullyQualifiedDatabase;
    }

    public boolean useAuth() {
        return this.useAuth;
    }

    public String table() {
        return this.table;
    }

    public String deletionsTable() {
        return this.deletionsTable;
    }

    public String grpcClient() {
        return this.grpcClient;
    }

    public SessionPoolSettings sessionPool() {
        return this.sessionPool;
    }

    public SpannerSettings(Config config) {
        this.project = config.getString("project");
        this.instance = config.getString("instance");
        this.database = config.getString("database");
        this.fullyQualifiedProject = new StringBuilder(9).append("projects/").append(this.project()).toString();
        this.parent = new StringBuilder(11).append(this.fullyQualifiedProject()).append("/instances/").append(this.instance()).toString();
        this.fullyQualifiedDatabase = new StringBuilder(11).append(this.parent()).append("/databases/").append(this.database()).toString();
        this.useAuth = config.getBoolean("use-auth");
        this.table = config.getString("table");
        this.deletionsTable = config.getString("deletions-table");
        this.grpcClient = config.getString("grpc-client");
        this.sessionPool = new SessionPoolSettings(config.getConfig("session-pool"));
    }

    public static final class SessionPoolSettings {
        private final int maxSize;
        private final FiniteDuration retryCreateInterval;
        private final int maxOutstandingRequests;
        private final FiniteDuration restartMinBackoff;
        private final FiniteDuration restartMaxBackoff;
        private final FiniteDuration keepAliveInterval;

        public int maxSize() {
            return this.maxSize;
        }

        public FiniteDuration retryCreateInterval() {
            return this.retryCreateInterval;
        }

        public int maxOutstandingRequests() {
            return this.maxOutstandingRequests;
        }

        public FiniteDuration restartMinBackoff() {
            return this.restartMinBackoff;
        }

        public FiniteDuration restartMaxBackoff() {
            return this.restartMaxBackoff;
        }

        public FiniteDuration keepAliveInterval() {
            return this.keepAliveInterval;
        }

        public SessionPoolSettings(Config config) {
            this.maxSize = config.getInt("max-size");
            Predef$.MODULE$.require(this.maxSize() <= 100, (Function0 & java.io.Serializable & Serializable)() -> "session-pool.max-size must be <= 100");
            this.retryCreateInterval = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("retry-create-interval")));
            this.maxOutstandingRequests = config.getInt("max-outstanding-requests");
            this.restartMinBackoff = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("restart-min-backoff")));
            this.restartMaxBackoff = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("restart-max-backoff")));
            this.keepAliveInterval = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("keep-alive-interval")));
        }
    }
}

