/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner.internal;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.Behavior;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.StashBuffer;
import akka.actor.typed.scaladsl.TimerScheduler;
import akka.annotation.InternalApi;
import akka.persistence.spanner.SpannerSettings;
import akka.persistence.spanner.internal.SessionPool;
import akka.persistence.spanner.internal.SessionPool$KeepAlive$;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsRequest$;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerClient;
import java.io.Serializable;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.List;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalapb.UnknownFieldSet;

@InternalApi
public final class SessionPool$ {
    public static SessionPool$ MODULE$;

    static {
        new SessionPool$();
    }

    public Behavior<SessionPool.Command> apply(SpannerClient client, SpannerSettings settings) {
        return Behaviors$.MODULE$.withStash(settings.sessionPool().maxOutstandingRequests(), (Function1 & Serializable & scala.Serializable)stash -> Behaviors$.MODULE$.withTimers((Function1 & Serializable & scala.Serializable)timers -> Behaviors$.MODULE$.setup((Function1 & Serializable & scala.Serializable)ctx -> {
            ctx.log().info("Creating pool. Max size [{}]. Stash [{}].", (Object)BoxesRunTime.boxToInteger((int)settings.sessionPool().maxSize()), (Object)BoxesRunTime.boxToInteger((int)settings.sessionPool().maxOutstandingRequests()));
            SessionPool$.akka$persistence$spanner$internal$SessionPool$$createSessions$1(ctx, settings, client);
            return Behaviors$.MODULE$.receiveMessagePartial((PartialFunction)new scala.Serializable((TimerScheduler)timers, settings, (StashBuffer)stash, client, (ActorContext)ctx){
                public static final long serialVersionUID = 0L;
                private final TimerScheduler timers$1;
                private final SpannerSettings settings$1;
                private final StashBuffer stash$1;
                private final SpannerClient client$1;
                private final ActorContext ctx$1;

                public final <A1 extends SessionPool.Command, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof SessionPool.InitialSessions) {
                        SessionPool.InitialSessions initialSessions = (SessionPool.InitialSessions)A1;
                        List<Session> sessions = initialSessions.sessions();
                        this.timers$1.startTimerWithFixedDelay((Object)SessionPool$KeepAlive$.MODULE$, this.settings$1.sessionPool().keepAliveInterval());
                        object = this.stash$1.unstashAll((Behavior)new SessionPool(this.client$1, sessions, (ActorContext<SessionPool.Command>)this.ctx$1, (TimerScheduler<SessionPool.Command>)this.timers$1, (StashBuffer<SessionPool.Command>)this.stash$1, this.settings$1.sessionPool()));
                    } else if (A1 instanceof SessionPool.RetrySessionCreation) {
                        FiniteDuration when;
                        SessionPool.RetrySessionCreation retrySessionCreation = (SessionPool.RetrySessionCreation)A1;
                        FiniteDuration finiteDuration = when = retrySessionCreation.in();
                        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                        if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                            this.ctx$1.log().info("Retrying session creation");
                            SessionPool$.akka$persistence$spanner$internal$SessionPool$$createSessions$1(this.ctx$1, this.settings$1, this.client$1);
                        } else {
                            this.timers$1.startSingleTimer((Object)new SessionPool.RetrySessionCreation(Duration$.MODULE$.Zero()), when);
                        }
                        object = Behaviors$.MODULE$.same();
                    } else if (A1 instanceof SessionPool.GetSession) {
                        StashBuffer stashBuffer;
                        SessionPool.GetSession getSession = (SessionPool.GetSession)A1;
                        ActorRef<SessionPool.Response> replyTo = getSession.replyTo();
                        UUID id = getSession.id();
                        if (this.stash$1.isFull()) {
                            ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)new SessionPool.PoolBusy(id));
                            stashBuffer = BoxedUnit.UNIT;
                        } else {
                            stashBuffer = this.stash$1.stash((Object)getSession);
                        }
                        object = Behaviors$.MODULE$.same();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SessionPool.Command x1) {
                    SessionPool.Command command = x1;
                    boolean bl = command instanceof SessionPool.InitialSessions ? true : (command instanceof SessionPool.RetrySessionCreation ? true : command instanceof SessionPool.GetSession);
                    return bl;
                }
                {
                    this.timers$1 = timers$1;
                    this.settings$1 = settings$1;
                    this.stash$1 = stash$1;
                    this.client$1 = client$1;
                    this.ctx$1 = ctx$1;
                }
            });
        })));
    }

    public static final void akka$persistence$spanner$internal$SessionPool$$createSessions$1(ActorContext ctx$1, SpannerSettings settings$1, SpannerClient client$1) {
        ctx$1.log().info("Creating sessions {} {}", (Object)settings$1.fullyQualifiedDatabase(), (Object)BoxesRunTime.boxToInteger((int)settings$1.sessionPool().maxSize()));
        String x$1 = settings$1.fullyQualifiedDatabase();
        int x$2 = settings$1.sessionPool().maxSize();
        Option<Session> x$3 = BatchCreateSessionsRequest$.MODULE$.apply$default$2();
        UnknownFieldSet x$4 = BatchCreateSessionsRequest$.MODULE$.apply$default$4();
        ctx$1.pipeToSelf(client$1.batchCreateSessions(new BatchCreateSessionsRequest(x$1, x$3, x$2, x$4)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BatchCreateSessionsResponse response = (BatchCreateSessionsResponse)success.value();
                ctx$1.log().info("Sessions created {}", new Object[]{response});
                product = new SessionPool.InitialSessions((List<Session>)response.session().toList());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                ctx$1.log().warn("Session creation failed. Retrying ", t);
                product = new SessionPool.RetrySessionCreation(settings$1.sessionPool().retryCreateInterval());
            } else {
                throw new MatchError((Object)try_);
            }
            return product;
        });
    }

    private SessionPool$() {
        MODULE$ = this;
    }
}

