/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.cassandra;

import akka.persistence.cassandra.testkit.CassandraLauncher;
import akka.persistence.cassandra.testkit.CassandraLauncher$;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u000b\u0017\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0001\r\u0011\"\u00039\u0011\u001d!\u0005\u00011A\u0005\n\u0015Caa\u0013\u0001!B\u0013I\u0004b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007)\u0002\u0001\u000b\u0011\u0002(\t\u000fU\u0003\u0001\u0019!C\u0001-\"9!\f\u0001a\u0001\n\u0003Y\u0006BB/\u0001A\u0003&q\u000bC\u0003_\u0001\u0011\u0005q\fC\u0003k\u0001\u0011\u0005Q\nC\u0003l\u0001\u0011\u0005A\u000e\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\t\t2)Y:tC:$'/\u0019'bk:\u001c\u0007.\u001a:\u000b\u0005]A\u0012!C2bgN\fg\u000e\u001a:b\u0015\tI\"$\u0001\u0005j]R,'O\\1m\u0015\tYB$A\u0003mC\u001e|WN\u0003\u0002\u001e=\u0005IA.[4ii\n,g\u000e\u001a\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u00051\u0012!\u0006$pe\u000e,Gm\u00155vi\u0012|wO\u001c+j[\u0016|W\u000f^\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\tIV\u0014\u0018\r^5p]*\u00111\u0007J\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001b1\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\faCR8sG\u0016$7\u000b[;uI><h\u000eV5nK>,H\u000fI\u0001\u0010G\u0006\u001c8/\u00198ee\u0006$\u0015-Z7p]V\t\u0011\bE\u0002$uqJ!a\u000f\u0013\u0003\r=\u0003H/[8o!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0002j_*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005%\u0019En\\:fC\ndW-A\ndCN\u001c\u0018M\u001c3sC\u0012\u000bW-\\8o?\u0012*\u0017\u000f\u0006\u0002G\u0013B\u00111eR\u0005\u0003\u0011\u0012\u0012A!\u00168ji\"9!*BA\u0001\u0002\u0004I\u0014a\u0001=%c\u0005\u00012-Y:tC:$'/\u0019#bK6|g\u000eI\u0001\u0010I\u00164X)\u001c2fI\u0012,G-W1nYV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0001\u0006!A.\u00198h\u0013\t\u0019\u0006K\u0001\u0004TiJLgnZ\u0001\u0011I\u00164X)\u001c2fI\u0012,G-W1nY\u0002\nA\u0001]8siV\tq\u000b\u0005\u0002$1&\u0011\u0011\f\n\u0002\u0004\u0013:$\u0018\u0001\u00039peR|F%Z9\u0015\u0005\u0019c\u0006b\u0002&\u000b\u0003\u0003\u0005\raV\u0001\u0006a>\u0014H\u000fI\u0001\bC\u0012$'/Z:t+\u0005\u0001\u0007CA1i\u001d\t\u0011g\r\u0005\u0002dI5\tAM\u0003\u0002fA\u00051AH]8pizJ!a\u001a\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u0019\u0016N\u0003\u0002hI\u0005A\u0001n\\:u]\u0006lW-A\u0003ti\u0006\u0014H\u000f\u0006\u0004G[J$\u0018P\u001f\u0005\u0006]:\u0001\ra\\\u0001\u0013G\u0006\u001c8/\u00198ee\u0006$\u0015N]3di>\u0014\u0018\u0010\u0005\u0002>a&\u0011\u0011O\u0010\u0002\u0005\r&dW\rC\u0003t\u001d\u0001\u0007q.\u0001\u0006zC6d7i\u001c8gS\u001eDQ!\u001e\bA\u0002Y\fQa\u00197fC:\u0004\"aI<\n\u0005a$#a\u0002\"p_2,\u0017M\u001c\u0005\u0006+:\u0001\ra\u0016\u0005\u0006w:\u0001\r\u0001`\u0001\u000bUZlw\n\u001d;j_:\u001c\bcA\u0012~A&\u0011a\u0010\n\u0002\u0006\u0003J\u0014\u0018-_\u0001\u001aaJ,\u0007/\u0019:f\u0007\u0006\u001c8/\u00198ee\u0006$\u0015N]3di>\u0014\u0018\u0010F\u0003G\u0003\u0007\t)\u0001C\u0003o\u001f\u0001\u0007q\u000eC\u0003v\u001f\u0001\u0007a/A\u0006ti\u0006\u0014HOR8sW\u0016$G#\u0003$\u0002\f\u0005=\u00111CA\u000b\u0011\u0019\ti\u0001\u0005a\u0001_\u0006Q1m\u001c8gS\u001e4\u0015\u000e\\3\t\r\u0005E\u0001\u00031\u0001p\u0003=\u0019\u0017m]:b]\u0012\u0014\u0018MQ;oI2,\u0007\"B+\u0011\u0001\u00049\u0006\"B>\u0011\u0001\u0004a\u0018\u0001B:u_B$\u0012AR\u0001\re\u0016\fGMU3t_V\u00148-\u001a\u000b\u0004A\u0006}\u0001bBA\u0011%\u0001\u0007\u00111E\u0001\u000fM&dWm\u0014:SKN|WO]2f!\u0019\t)#a\fpA:!\u0011qEA\u0016\u001d\r\u0019\u0017\u0011F\u0005\u0002K%\u0019\u0011Q\u0006\u0013\u0002\u000fA\f7m[1hK&!\u0011\u0011GA\u001a\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011Q\u0006\u0013\u0002\u0017]\u0014\u0018\u000e^3U_\u001aKG.\u001a\u000b\u0006\r\u0006e\u0012Q\b\u0005\u0007\u0003w\u0019\u0002\u0019A8\u0002\t\u0019LG.\u001a\u0005\u0007\u0003\u007f\u0019\u0002\u0019\u00011\u0002\u000f\r|g\u000e^3oi\u0006yA-\u001a7fi\u0016\u0014VmY;sg&4X\rF\u0002G\u0003\u000bBa!a\u000f\u0015\u0001\u0004y\u0007")
public class CassandraLauncher {
    private final FiniteDuration com$lightbend$lagom$internal$cassandra$CassandraLauncher$$ForcedShutdownTimeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).seconds();
    private Option<Closeable> cassandraDaemon = None$.MODULE$;
    private final String devEmbeddedYaml;
    private int port = 0;

    public FiniteDuration com$lightbend$lagom$internal$cassandra$CassandraLauncher$$ForcedShutdownTimeout() {
        return this.com$lightbend$lagom$internal$cassandra$CassandraLauncher$$ForcedShutdownTimeout;
    }

    private Option<Closeable> cassandraDaemon() {
        return this.cassandraDaemon;
    }

    private void cassandraDaemon_$eq(Option<Closeable> x$1) {
        this.cassandraDaemon = x$1;
    }

    private String devEmbeddedYaml() {
        return this.devEmbeddedYaml;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public String address() {
        return new java.lang.StringBuilder(1).append(this.hostname()).append(":").append(this.port()).toString();
    }

    public String hostname() {
        return "127.0.0.1";
    }

    public synchronized void start(File cassandraDirectory, File yamlConfig, boolean clean, int port, String[] jvmOptions) {
        block6: {
            Object object;
            if (!this.cassandraDaemon().isEmpty()) break block6;
            this.prepareCassandraDirectory(cassandraDirectory, clean);
            int storagePort = CassandraLauncher$.MODULE$.freePort();
            Either fileOrResource = package$.MODULE$.Either().cond(yamlConfig == null, (Function0 & Serializable & scala.Serializable)() -> this.devEmbeddedYaml(), (Function0 & Serializable & scala.Serializable)() -> yamlConfig);
            String conf = this.readResource((Either<File, String>)fileOrResource);
            String amendedConf = conf.replace("$PORT", Integer.toString(port)).replace("$STORAGE_PORT", Integer.toString(storagePort)).replace("$DIR", cassandraDirectory.getAbsolutePath());
            File devConfigFile = new File(cassandraDirectory, this.devEmbeddedYaml());
            this.writeToFile(devConfigFile, amendedConf);
            File cassandraBundleFile = new File(cassandraDirectory, "cassandra-bundle.jar");
            if (!cassandraBundleFile.exists()) {
                long l;
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("akka/persistence/cassandra/launcher/cassandra-bundle.jar");){
                    l = Files.copy(is, cassandraBundleFile.toPath(), new CopyOption[0]);
                }
                object = BoxesRunTime.boxToLong((long)l);
            } else {
                object = BoxedUnit.UNIT;
            }
            this.startForked(devConfigFile, cassandraBundleFile, port, jvmOptions);
            this.port_$eq(port);
        }
    }

    private void prepareCassandraDirectory(File cassandraDirectory, boolean clean) {
        block4: {
            if (clean) {
                try {
                    this.deleteRecursive(cassandraDirectory);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        throw new CassandraLauncher.CleanFailedException(e.getMessage(), e);
                    }
                    throw throwable;
                }
            }
            if (cassandraDirectory.exists()) break block4;
            Predef$.MODULE$.require(cassandraDirectory.mkdirs(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Couldn't create Cassandra directory [").append(cassandraDirectory).append("]").toString());
        }
    }

    private void startForked(File configFile, File cassandraBundle, int port, String[] jvmOptions) {
        String $div = File.separator;
        String javaBin = new java.lang.StringBuilder(7).append(System.getProperty("java.home")).append($div).append("bin").append($div).append("java").toString();
        String className = "org.apache.cassandra.service.CassandraDaemon";
        Seq args = (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)javaBin, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jvmOptions)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"-cp", (List)new .colon.colon((Object)cassandraBundle.getAbsolutePath(), (List)new .colon.colon((Object)new java.lang.StringBuilder(24).append("-Dcassandra.config=file:").append(configFile.getAbsoluteFile()).toString(), (List)new .colon.colon((Object)"-Dcassandra-foreground=true", (List)new .colon.colon((Object)className, (List)Nil$.MODULE$))))), Seq$.MODULE$.canBuildFrom());
        ProcessBuilder builder = new ProcessBuilder((String[])args.toArray(ClassTag$.MODULE$.apply(String.class))).inheritIO();
        Process process = builder.start();
        Thread shutdownHook = new Thread(null, process){
            private final Process process$1;

            public void run() {
                this.process$1.destroyForcibly();
            }
            {
                this.process$1 = process$1;
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.cassandraDaemon_$eq((Option<Closeable>)new Some((Object)new Closeable(this, process, shutdownHook){
            private final /* synthetic */ CassandraLauncher $outer;
            private final Process process$1;
            private final Thread shutdownHook$1;

            public void close() {
                this.process$1.destroy();
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook$1);
                if (this.process$1.waitFor(this.$outer.com$lightbend$lagom$internal$cassandra$CassandraLauncher$$ForcedShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                    int exitStatus = this.process$1.exitValue();
                    if (exitStatus != 0 && exitStatus != 143) {
                        throw scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(39).append("Cassandra exited with non zero status: ").append(this.process$1.exitValue()).toString());
                    }
                } else {
                    this.process$1.destroyForcibly();
                    throw scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(48).append("Cassandra process did not stop within ").append(this.$outer.com$lightbend$lagom$internal$cassandra$CassandraLauncher$$ForcedShutdownTimeout()).append(", killing.").toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.process$1 = process$1;
                this.shutdownHook$1 = shutdownHook$1;
            }
        }));
    }

    public synchronized void stop() {
        this.cassandraDaemon().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.cassandraDaemon_$eq((Option<Closeable>)None$.MODULE$);
    }

    private String readResource(Either<File, String> fileOrResource) {
        InputStream inputStream;
        StringBuilder sb = new StringBuilder();
        Either<File, String> either = fileOrResource;
        if (either instanceof Left) {
            Left left = (Left)either;
            File file = (File)left.value();
            Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("file [").append(file).append("] doesn't exist").toString());
            inputStream = new FileInputStream(file);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String resource = (String)right.value();
            InputStream is = this.getClass().getResourceAsStream(new java.lang.StringBuilder(1).append("/").append(resource).toString());
            Predef$.MODULE$.require(is != null, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("resource [").append(resource).append("] doesn't exist").toString());
            inputStream = is;
        } else {
            throw new MatchError(either);
        }
        FileInputStream is = inputStream;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
        }
        return sb.toString();
    }

    private void writeToFile(File file, String content) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));){
            writer.write(content);
        }
    }

    private void deleteRecursive(File file2) {
        if (file2.isDirectory()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                this.deleteRecursive(file);
                return BoxedUnit.UNIT;
            });
        }
        file2.delete();
    }

    public CassandraLauncher() {
        this.devEmbeddedYaml = "dev-embedded-cassandra.yaml";
    }
}

