/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import com.google.common.collect.Lists;
import com.lightbend.lagom.javadsl.api.transport.RequestHeader;
import com.lightbend.lagom.javadsl.api.transport.ResponseHeader;
import java.util.Arrays;
import org.pcollections.PSequence;
import org.pcollections.TreePVector;

public interface HeaderFilter {
    public static final HeaderFilter NONE = new HeaderFilter(){

        @Override
        public RequestHeader transformClientRequest(RequestHeader requestHeader) {
            return requestHeader;
        }

        @Override
        public RequestHeader transformServerRequest(RequestHeader requestHeader) {
            return requestHeader;
        }

        @Override
        public ResponseHeader transformServerResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
            return responseHeader;
        }

        @Override
        public ResponseHeader transformClientResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
            return responseHeader;
        }
    };

    public RequestHeader transformClientRequest(RequestHeader var1);

    public RequestHeader transformServerRequest(RequestHeader var1);

    public ResponseHeader transformServerResponse(ResponseHeader var1, RequestHeader var2);

    public ResponseHeader transformClientResponse(ResponseHeader var1, RequestHeader var2);

    public static HeaderFilter composite(HeaderFilter ... headerFilterArray) {
        return new Composite((PSequence<HeaderFilter>)TreePVector.from(Arrays.asList(headerFilterArray)));
    }

    public static class Composite
    implements HeaderFilter {
        private final PSequence<HeaderFilter> headerFilters;

        public Composite(PSequence<HeaderFilter> pSequence) {
            TreePVector treePVector = TreePVector.empty();
            for (HeaderFilter headerFilter : pSequence) {
                if (headerFilter instanceof Composite) {
                    treePVector = treePVector.plusAll(((Composite)headerFilter).headerFilters);
                    continue;
                }
                treePVector = treePVector.plus((Object)headerFilter);
            }
            this.headerFilters = treePVector;
        }

        @Override
        public RequestHeader transformClientRequest(RequestHeader requestHeader) {
            for (HeaderFilter headerFilter : this.headerFilters) {
                requestHeader = headerFilter.transformClientRequest(requestHeader);
            }
            return requestHeader;
        }

        @Override
        public RequestHeader transformServerRequest(RequestHeader requestHeader) {
            for (HeaderFilter headerFilter : Lists.reverse(this.headerFilters)) {
                requestHeader = headerFilter.transformServerRequest(requestHeader);
            }
            return requestHeader;
        }

        @Override
        public ResponseHeader transformServerResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
            for (HeaderFilter headerFilter : this.headerFilters) {
                responseHeader = headerFilter.transformServerResponse(responseHeader, requestHeader);
            }
            return responseHeader;
        }

        @Override
        public ResponseHeader transformClientResponse(ResponseHeader responseHeader, RequestHeader requestHeader) {
            for (HeaderFilter headerFilter : Lists.reverse(this.headerFilters)) {
                responseHeader = headerFilter.transformClientResponse(responseHeader, requestHeader);
            }
            return responseHeader;
        }
    }
}

