/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TransportErrorCode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TransportErrorCode ProtocolError = new TransportErrorCode(400, 1002, "Protocol Error/Bad Request");
    public static final TransportErrorCode UnsupportedData;
    public static final TransportErrorCode BadRequest;
    public static final TransportErrorCode Unauthorized;
    public static final TransportErrorCode Forbidden;
    public static final TransportErrorCode PolicyViolation;
    public static final TransportErrorCode NotFound;
    public static final TransportErrorCode MethodNotAllowed;
    public static final TransportErrorCode NotAcceptable;
    public static final TransportErrorCode PayloadTooLarge;
    public static final TransportErrorCode UnsupportedMediaType;
    public static final TransportErrorCode TooManyRequests;
    public static final TransportErrorCode UnexpectedCondition;
    public static final TransportErrorCode InternalServerError;
    public static final TransportErrorCode ServiceUnavailable;
    public static final TransportErrorCode GoingAway;
    private static final Map<Integer, TransportErrorCode> HTTP_ERROR_CODE_MAP;
    private static final Map<Integer, TransportErrorCode> WEBSOCKET_ERROR_CODE_MAP;
    private final int http;
    private final int webSocket;
    private final String description;

    public static TransportErrorCode fromHttp(int n) {
        TransportErrorCode transportErrorCode = HTTP_ERROR_CODE_MAP.get(n);
        if (transportErrorCode == null) {
            if (n > 599 || n < 100) {
                throw new IllegalArgumentException("Invalid http status code: " + n);
            }
            if (n < 400) {
                throw new IllegalArgumentException("Invalid http error code: " + n);
            }
            return new TransportErrorCode(n, 4000 + n, "Unknown error code");
        }
        return transportErrorCode;
    }

    public static TransportErrorCode fromWebSocket(int n) {
        TransportErrorCode transportErrorCode = WEBSOCKET_ERROR_CODE_MAP.get(n);
        if (transportErrorCode == null) {
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid WebSocket status code: " + n);
            }
            if (n >= 4400 && n <= 4599) {
                return new TransportErrorCode(n - 4000, n, "Unknown error code");
            }
            return new TransportErrorCode(404, n, "Unknown error code");
        }
        return transportErrorCode;
    }

    private TransportErrorCode(int n, int n2, String string) {
        this.http = n;
        this.webSocket = n2;
        this.description = string;
    }

    public int http() {
        return this.http;
    }

    public int webSocket() {
        return this.webSocket;
    }

    public String description() {
        return this.description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransportErrorCode transportErrorCode = (TransportErrorCode)object;
        if (this.http != transportErrorCode.http) {
            return false;
        }
        return this.webSocket == transportErrorCode.webSocket;
    }

    public int hashCode() {
        int n = this.http;
        n = 31 * n + this.webSocket;
        return n;
    }

    public String toString() {
        return "TransportErrorCode{http=" + this.http + ", webSocket=" + this.webSocket + ", description='" + this.description + '\'' + '}';
    }

    static {
        BadRequest = UnsupportedData = new TransportErrorCode(400, 1003, "Unsupported Data/Bad Request");
        Unauthorized = new TransportErrorCode(401, 4401, "Unauthorized");
        Forbidden = new TransportErrorCode(403, 4403, "Forbidden");
        NotFound = PolicyViolation = new TransportErrorCode(404, 1008, "Policy Violation/Not Found");
        MethodNotAllowed = new TransportErrorCode(405, 4405, "Method Not Allowed");
        NotAcceptable = new TransportErrorCode(406, 4406, "Not Acceptable");
        PayloadTooLarge = new TransportErrorCode(413, 1009, "Payload Too Large");
        UnsupportedMediaType = new TransportErrorCode(415, 4415, "Unsupported Media Type");
        TooManyRequests = new TransportErrorCode(429, 4429, "Too Many Requests");
        InternalServerError = UnexpectedCondition = new TransportErrorCode(500, 1011, "Unexpected Condition/Internal Server Error");
        GoingAway = ServiceUnavailable = new TransportErrorCode(503, 1001, "Going Away/Service Unavailable");
        List<TransportErrorCode> list = Arrays.asList(ProtocolError, UnsupportedData, Forbidden, PolicyViolation, MethodNotAllowed, NotAcceptable, PayloadTooLarge, UnsupportedMediaType, UnexpectedCondition, ServiceUnavailable);
        HashMap hashMap = new HashMap();
        list.forEach(transportErrorCode -> hashMap.put(transportErrorCode.http, transportErrorCode));
        HTTP_ERROR_CODE_MAP = Collections.unmodifiableMap(hashMap);
        HashMap hashMap2 = new HashMap();
        list.forEach(transportErrorCode -> hashMap2.put(transportErrorCode.webSocket, transportErrorCode));
        WEBSOCKET_ERROR_CODE_MAP = Collections.unmodifiableMap(hashMap2);
    }
}

