/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.server;

import akka.japi.Pair;
import com.lightbend.lagom.javadsl.api.ServiceCall;
import com.lightbend.lagom.javadsl.api.transport.RequestHeader;
import com.lightbend.lagom.javadsl.api.transport.ResponseHeader;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface ServerServiceCall<Request, Response>
extends ServiceCall<Request, Response> {
    default public CompletionStage<Pair<ResponseHeader, Response>> invokeWithHeaders(RequestHeader requestHeader, Request Request) {
        return this.invoke(Request).thenApply(object -> Pair.create((Object)ResponseHeader.OK, (Object)object));
    }

    default public <T> ServerServiceCall<Request, T> handleResponseHeader(final BiFunction<ResponseHeader, Response, T> biFunction) {
        final ServerServiceCall serverServiceCall = this;
        return new ServerServiceCall<Request, T>(){

            @Override
            public CompletionStage<Pair<ResponseHeader, T>> invokeWithHeaders(RequestHeader requestHeader, Request Request) {
                return serverServiceCall.invokeWithHeaders(requestHeader, Request).thenApply(pair -> Pair.create((Object)((ResponseHeader)pair.first()), biFunction.apply((ResponseHeader)pair.first(), pair.second())));
            }

            public CompletionStage<T> invoke(Request Request) {
                return serverServiceCall.invokeWithHeaders(RequestHeader.DEFAULT, Request).thenApply(pair -> biFunction.apply((ResponseHeader)pair.first(), pair.second()));
            }
        };
    }

    default public ServerServiceCall<Request, Response> handleRequestHeader(final Function<RequestHeader, RequestHeader> function) {
        final ServerServiceCall serverServiceCall = this;
        return new ServerServiceCall<Request, Response>(){

            @Override
            public CompletionStage<Pair<ResponseHeader, Response>> invokeWithHeaders(RequestHeader requestHeader, Request Request) {
                return serverServiceCall.invokeWithHeaders((RequestHeader)function.apply(requestHeader), Request);
            }

            public CompletionStage<Response> invoke(Request Request) {
                RequestHeader requestHeader = (RequestHeader)function.apply(RequestHeader.DEFAULT);
                return serverServiceCall.invokeWithHeaders(requestHeader, Request).thenApply(Pair::second);
            }
        };
    }
}

