/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.server.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.lightbend.lagom.javadsl.server.status.AbstractCircuitBreakerStatus;
import com.lightbend.lagom.javadsl.server.status.Latency;
import java.time.Instant;
import java.util.ArrayList;

public final class CircuitBreakerStatus
implements AbstractCircuitBreakerStatus {
    private final String id;
    private final Instant timestamp;
    private final String state;
    private final long totalSuccessCount;
    private final long totalFailureCount;
    private final Latency latencyMicros;
    private final double throughputOneMinute;
    private final double failedThroughputOneMinute;

    private CircuitBreakerStatus(Builder builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.totalSuccessCount = builder.totalSuccessCount;
        this.totalFailureCount = builder.totalFailureCount;
        this.latencyMicros = builder.latencyMicros;
        this.throughputOneMinute = builder.throughputOneMinute;
        this.failedThroughputOneMinute = builder.failedThroughputOneMinute;
        this.timestamp = builder.timestamp != null ? builder.timestamp : (Instant)Preconditions.checkNotNull((Object)AbstractCircuitBreakerStatus.super.getTimestamp(), (Object)"timestamp");
    }

    private CircuitBreakerStatus(String string, Instant instant, String string2, long l, long l2, Latency latency, double d, double d2) {
        this.id = string;
        this.timestamp = instant;
        this.state = string2;
        this.totalSuccessCount = l;
        this.totalFailureCount = l2;
        this.latencyMicros = latency;
        this.throughputOneMinute = d;
        this.failedThroughputOneMinute = d2;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty
    public String getState() {
        return this.state;
    }

    @Override
    @JsonProperty
    public long getTotalSuccessCount() {
        return this.totalSuccessCount;
    }

    @Override
    @JsonProperty
    public long getTotalFailureCount() {
        return this.totalFailureCount;
    }

    @Override
    @JsonProperty
    public Latency getLatencyMicros() {
        return this.latencyMicros;
    }

    @Override
    @JsonProperty
    public double getThroughputOneMinute() {
        return this.throughputOneMinute;
    }

    @Override
    @JsonProperty
    public double getFailedThroughputOneMinute() {
        return this.failedThroughputOneMinute;
    }

    public final CircuitBreakerStatus withId(String string) {
        if (this.id == string) {
            return this;
        }
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"id");
        return new CircuitBreakerStatus(string2, this.timestamp, this.state, this.totalSuccessCount, this.totalFailureCount, this.latencyMicros, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withTimestamp(Instant instant) {
        if (this.timestamp == instant) {
            return this;
        }
        Instant instant2 = (Instant)Preconditions.checkNotNull((Object)instant, (Object)"timestamp");
        return new CircuitBreakerStatus(this.id, instant2, this.state, this.totalSuccessCount, this.totalFailureCount, this.latencyMicros, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withState(String string) {
        if (this.state == string) {
            return this;
        }
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"state");
        return new CircuitBreakerStatus(this.id, this.timestamp, string2, this.totalSuccessCount, this.totalFailureCount, this.latencyMicros, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withTotalSuccessCount(long l) {
        if (this.totalSuccessCount == l) {
            return this;
        }
        long l2 = l;
        return new CircuitBreakerStatus(this.id, this.timestamp, this.state, l2, this.totalFailureCount, this.latencyMicros, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withTotalFailureCount(long l) {
        if (this.totalFailureCount == l) {
            return this;
        }
        long l2 = l;
        return new CircuitBreakerStatus(this.id, this.timestamp, this.state, this.totalSuccessCount, l2, this.latencyMicros, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withLatencyMicros(Latency latency) {
        if (this.latencyMicros == latency) {
            return this;
        }
        Latency latency2 = (Latency)Preconditions.checkNotNull((Object)latency, (Object)"latencyMicros");
        return new CircuitBreakerStatus(this.id, this.timestamp, this.state, this.totalSuccessCount, this.totalFailureCount, latency2, this.throughputOneMinute, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withThroughputOneMinute(double d) {
        double d2 = d;
        return new CircuitBreakerStatus(this.id, this.timestamp, this.state, this.totalSuccessCount, this.totalFailureCount, this.latencyMicros, d2, this.failedThroughputOneMinute);
    }

    public final CircuitBreakerStatus withFailedThroughputOneMinute(double d) {
        double d2 = d;
        return new CircuitBreakerStatus(this.id, this.timestamp, this.state, this.totalSuccessCount, this.totalFailureCount, this.latencyMicros, this.throughputOneMinute, d2);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof CircuitBreakerStatus && this.equalTo((CircuitBreakerStatus)object);
    }

    private boolean equalTo(CircuitBreakerStatus circuitBreakerStatus) {
        return this.id.equals(circuitBreakerStatus.id) && this.timestamp.equals(circuitBreakerStatus.timestamp) && this.state.equals(circuitBreakerStatus.state) && this.totalSuccessCount == circuitBreakerStatus.totalSuccessCount && this.totalFailureCount == circuitBreakerStatus.totalFailureCount && this.latencyMicros.equals(circuitBreakerStatus.latencyMicros) && Double.doubleToLongBits(this.throughputOneMinute) == Double.doubleToLongBits(circuitBreakerStatus.throughputOneMinute) && Double.doubleToLongBits(this.failedThroughputOneMinute) == Double.doubleToLongBits(circuitBreakerStatus.failedThroughputOneMinute);
    }

    public int hashCode() {
        int n = 31;
        n = n * 17 + this.id.hashCode();
        n = n * 17 + this.timestamp.hashCode();
        n = n * 17 + this.state.hashCode();
        n = n * 17 + Longs.hashCode((long)this.totalSuccessCount);
        n = n * 17 + Longs.hashCode((long)this.totalFailureCount);
        n = n * 17 + this.latencyMicros.hashCode();
        n = n * 17 + Doubles.hashCode((double)this.throughputOneMinute);
        n = n * 17 + Doubles.hashCode((double)this.failedThroughputOneMinute);
        return n;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CircuitBreakerStatus").add("id", (Object)this.id).add("timestamp", (Object)this.timestamp).add("state", (Object)this.state).add("totalSuccessCount", this.totalSuccessCount).add("totalFailureCount", this.totalFailureCount).add("latencyMicros", (Object)this.latencyMicros).add("throughputOneMinute", this.throughputOneMinute).add("failedThroughputOneMinute", this.failedThroughputOneMinute).toString();
    }

    @Deprecated
    @JsonCreator
    static CircuitBreakerStatus fromJson(Json json) {
        Builder builder = CircuitBreakerStatus.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.totalSuccessCount != null) {
            builder.totalSuccessCount(json.totalSuccessCount);
        }
        if (json.totalFailureCount != null) {
            builder.totalFailureCount(json.totalFailureCount);
        }
        if (json.latencyMicros != null) {
            builder.latencyMicros(json.latencyMicros);
        }
        if (json.throughputOneMinute != null) {
            builder.throughputOneMinute(json.throughputOneMinute);
        }
        if (json.failedThroughputOneMinute != null) {
            builder.failedThroughputOneMinute(json.failedThroughputOneMinute);
        }
        return builder.build();
    }

    public static CircuitBreakerStatus copyOf(AbstractCircuitBreakerStatus abstractCircuitBreakerStatus) {
        if (abstractCircuitBreakerStatus instanceof CircuitBreakerStatus) {
            return (CircuitBreakerStatus)abstractCircuitBreakerStatus;
        }
        return CircuitBreakerStatus.builder().from(abstractCircuitBreakerStatus).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_TOTAL_SUCCESS_COUNT = 4L;
        private static final long INIT_BIT_TOTAL_FAILURE_COUNT = 8L;
        private static final long INIT_BIT_LATENCY_MICROS = 16L;
        private static final long INIT_BIT_THROUGHPUT_ONE_MINUTE = 32L;
        private static final long INIT_BIT_FAILED_THROUGHPUT_ONE_MINUTE = 64L;
        private long initBits = 127L;
        private String id;
        private Instant timestamp;
        private String state;
        private long totalSuccessCount;
        private long totalFailureCount;
        private Latency latencyMicros;
        private double throughputOneMinute;
        private double failedThroughputOneMinute;

        private Builder() {
        }

        public final Builder from(AbstractCircuitBreakerStatus abstractCircuitBreakerStatus) {
            Preconditions.checkNotNull((Object)abstractCircuitBreakerStatus, (Object)"instance");
            this.id(abstractCircuitBreakerStatus.getId());
            this.timestamp(abstractCircuitBreakerStatus.getTimestamp());
            this.state(abstractCircuitBreakerStatus.getState());
            this.totalSuccessCount(abstractCircuitBreakerStatus.getTotalSuccessCount());
            this.totalFailureCount(abstractCircuitBreakerStatus.getTotalFailureCount());
            this.latencyMicros(abstractCircuitBreakerStatus.getLatencyMicros());
            this.throughputOneMinute(abstractCircuitBreakerStatus.getThroughputOneMinute());
            this.failedThroughputOneMinute(abstractCircuitBreakerStatus.getFailedThroughputOneMinute());
            return this;
        }

        public final Builder id(String string) {
            this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timestamp(Instant instant) {
            this.timestamp = (Instant)Preconditions.checkNotNull((Object)instant, (Object)"timestamp");
            return this;
        }

        public final Builder state(String string) {
            this.state = (String)Preconditions.checkNotNull((Object)string, (Object)"state");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder totalSuccessCount(long l) {
            this.totalSuccessCount = l;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder totalFailureCount(long l) {
            this.totalFailureCount = l;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder latencyMicros(Latency latency) {
            this.latencyMicros = (Latency)Preconditions.checkNotNull((Object)latency, (Object)"latencyMicros");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder throughputOneMinute(double d) {
            this.throughputOneMinute = d;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder failedThroughputOneMinute(double d) {
            this.failedThroughputOneMinute = d;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public CircuitBreakerStatus build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new CircuitBreakerStatus(this);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean stateIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean totalSuccessCountIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean totalFailureCountIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean latencyMicrosIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean throughputOneMinuteIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean failedThroughputOneMinuteIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList arrayList = Lists.newArrayList();
            if (!this.idIsSet()) {
                arrayList.add("id");
            }
            if (!this.stateIsSet()) {
                arrayList.add("state");
            }
            if (!this.totalSuccessCountIsSet()) {
                arrayList.add("totalSuccessCount");
            }
            if (!this.totalFailureCountIsSet()) {
                arrayList.add("totalFailureCount");
            }
            if (!this.latencyMicrosIsSet()) {
                arrayList.add("latencyMicros");
            }
            if (!this.throughputOneMinuteIsSet()) {
                arrayList.add("throughputOneMinute");
            }
            if (!this.failedThroughputOneMinuteIsSet()) {
                arrayList.add("failedThroughputOneMinute");
            }
            return "Cannot build CircuitBreakerStatus, some of required attributes are not set " + arrayList;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements AbstractCircuitBreakerStatus {
        String id;
        Instant timestamp;
        String state;
        Long totalSuccessCount;
        Long totalFailureCount;
        Latency latencyMicros;
        Double throughputOneMinute;
        Double failedThroughputOneMinute;

        Json() {
        }

        public void setId(String string) {
            this.id = string;
        }

        public void setTimestamp(Instant instant) {
            this.timestamp = instant;
        }

        public void setState(String string) {
            this.state = string;
        }

        public void setTotalSuccessCount(long l) {
            this.totalSuccessCount = l;
        }

        public void setTotalFailureCount(long l) {
            this.totalFailureCount = l;
        }

        public void setLatencyMicros(Latency latency) {
            this.latencyMicros = latency;
        }

        public void setThroughputOneMinute(double d) {
            this.throughputOneMinute = d;
        }

        public void setFailedThroughputOneMinute(double d) {
            this.failedThroughputOneMinute = d;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalSuccessCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalFailureCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Latency getLatencyMicros() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getThroughputOneMinute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getFailedThroughputOneMinute() {
            throw new UnsupportedOperationException();
        }
    }
}

