/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.server.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.lightbend.lagom.javadsl.server.status.AbstractLatency;
import java.util.ArrayList;

public final class Latency
implements AbstractLatency {
    private final double median;
    private final double percentile98th;
    private final double percentile99th;
    private final double percentile999th;
    private final double mean;
    private final long min;
    private final long max;

    private Latency(double d, double d2, double d3, double d4, double d5, long l, long l2) {
        this.median = d;
        this.percentile98th = d2;
        this.percentile99th = d3;
        this.percentile999th = d4;
        this.mean = d5;
        this.min = l;
        this.max = l2;
    }

    @Override
    @JsonProperty
    public double getMedian() {
        return this.median;
    }

    @Override
    @JsonProperty
    public double getPercentile98th() {
        return this.percentile98th;
    }

    @Override
    @JsonProperty
    public double getPercentile99th() {
        return this.percentile99th;
    }

    @Override
    @JsonProperty
    public double getPercentile999th() {
        return this.percentile999th;
    }

    @Override
    @JsonProperty
    public double getMean() {
        return this.mean;
    }

    @Override
    @JsonProperty
    public long getMin() {
        return this.min;
    }

    @Override
    @JsonProperty
    public long getMax() {
        return this.max;
    }

    public final Latency withMedian(double d) {
        double d2 = d;
        return new Latency(d2, this.percentile98th, this.percentile99th, this.percentile999th, this.mean, this.min, this.max);
    }

    public final Latency withPercentile98th(double d) {
        double d2 = d;
        return new Latency(this.median, d2, this.percentile99th, this.percentile999th, this.mean, this.min, this.max);
    }

    public final Latency withPercentile99th(double d) {
        double d2 = d;
        return new Latency(this.median, this.percentile98th, d2, this.percentile999th, this.mean, this.min, this.max);
    }

    public final Latency withPercentile999th(double d) {
        double d2 = d;
        return new Latency(this.median, this.percentile98th, this.percentile99th, d2, this.mean, this.min, this.max);
    }

    public final Latency withMean(double d) {
        double d2 = d;
        return new Latency(this.median, this.percentile98th, this.percentile99th, this.percentile999th, d2, this.min, this.max);
    }

    public final Latency withMin(long l) {
        if (this.min == l) {
            return this;
        }
        long l2 = l;
        return new Latency(this.median, this.percentile98th, this.percentile99th, this.percentile999th, this.mean, l2, this.max);
    }

    public final Latency withMax(long l) {
        if (this.max == l) {
            return this;
        }
        long l2 = l;
        return new Latency(this.median, this.percentile98th, this.percentile99th, this.percentile999th, this.mean, this.min, l2);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Latency && this.equalTo((Latency)object);
    }

    private boolean equalTo(Latency latency) {
        return Double.doubleToLongBits(this.median) == Double.doubleToLongBits(latency.median) && Double.doubleToLongBits(this.percentile98th) == Double.doubleToLongBits(latency.percentile98th) && Double.doubleToLongBits(this.percentile99th) == Double.doubleToLongBits(latency.percentile99th) && Double.doubleToLongBits(this.percentile999th) == Double.doubleToLongBits(latency.percentile999th) && Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(latency.mean) && this.min == latency.min && this.max == latency.max;
    }

    public int hashCode() {
        int n = 31;
        n = n * 17 + Doubles.hashCode((double)this.median);
        n = n * 17 + Doubles.hashCode((double)this.percentile98th);
        n = n * 17 + Doubles.hashCode((double)this.percentile99th);
        n = n * 17 + Doubles.hashCode((double)this.percentile999th);
        n = n * 17 + Doubles.hashCode((double)this.mean);
        n = n * 17 + Longs.hashCode((long)this.min);
        n = n * 17 + Longs.hashCode((long)this.max);
        return n;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Latency").add("median", this.median).add("percentile98th", this.percentile98th).add("percentile99th", this.percentile99th).add("percentile999th", this.percentile999th).add("mean", this.mean).add("min", this.min).add("max", this.max).toString();
    }

    @Deprecated
    @JsonCreator
    static Latency fromJson(Json json) {
        Builder builder = Latency.builder();
        if (json.median != null) {
            builder.median(json.median);
        }
        if (json.percentile98th != null) {
            builder.percentile98th(json.percentile98th);
        }
        if (json.percentile99th != null) {
            builder.percentile99th(json.percentile99th);
        }
        if (json.percentile999th != null) {
            builder.percentile999th(json.percentile999th);
        }
        if (json.mean != null) {
            builder.mean(json.mean);
        }
        if (json.min != null) {
            builder.min(json.min);
        }
        if (json.max != null) {
            builder.max(json.max);
        }
        return builder.build();
    }

    public static Latency copyOf(AbstractLatency abstractLatency) {
        if (abstractLatency instanceof Latency) {
            return (Latency)abstractLatency;
        }
        return Latency.builder().from(abstractLatency).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEDIAN = 1L;
        private static final long INIT_BIT_PERCENTILE98TH = 2L;
        private static final long INIT_BIT_PERCENTILE99TH = 4L;
        private static final long INIT_BIT_PERCENTILE999TH = 8L;
        private static final long INIT_BIT_MEAN = 16L;
        private static final long INIT_BIT_MIN = 32L;
        private static final long INIT_BIT_MAX = 64L;
        private long initBits = 127L;
        private double median;
        private double percentile98th;
        private double percentile99th;
        private double percentile999th;
        private double mean;
        private long min;
        private long max;

        private Builder() {
        }

        public final Builder from(AbstractLatency abstractLatency) {
            Preconditions.checkNotNull((Object)abstractLatency, (Object)"instance");
            this.median(abstractLatency.getMedian());
            this.percentile98th(abstractLatency.getPercentile98th());
            this.percentile99th(abstractLatency.getPercentile99th());
            this.percentile999th(abstractLatency.getPercentile999th());
            this.mean(abstractLatency.getMean());
            this.min(abstractLatency.getMin());
            this.max(abstractLatency.getMax());
            return this;
        }

        public final Builder median(double d) {
            this.median = d;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder percentile98th(double d) {
            this.percentile98th = d;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder percentile99th(double d) {
            this.percentile99th = d;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder percentile999th(double d) {
            this.percentile999th = d;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder mean(double d) {
            this.mean = d;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder min(long l) {
            this.min = l;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder max(long l) {
            this.max = l;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public Latency build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new Latency(this.median, this.percentile98th, this.percentile99th, this.percentile999th, this.mean, this.min, this.max);
        }

        private boolean medianIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean percentile98thIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean percentile99thIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean percentile999thIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean meanIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean minIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean maxIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList arrayList = Lists.newArrayList();
            if (!this.medianIsSet()) {
                arrayList.add("median");
            }
            if (!this.percentile98thIsSet()) {
                arrayList.add("percentile98th");
            }
            if (!this.percentile99thIsSet()) {
                arrayList.add("percentile99th");
            }
            if (!this.percentile999thIsSet()) {
                arrayList.add("percentile999th");
            }
            if (!this.meanIsSet()) {
                arrayList.add("mean");
            }
            if (!this.minIsSet()) {
                arrayList.add("min");
            }
            if (!this.maxIsSet()) {
                arrayList.add("max");
            }
            return "Cannot build Latency, some of required attributes are not set " + arrayList;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements AbstractLatency {
        Double median;
        Double percentile98th;
        Double percentile99th;
        Double percentile999th;
        Double mean;
        Long min;
        Long max;

        Json() {
        }

        public void setMedian(double d) {
            this.median = d;
        }

        public void setPercentile98th(double d) {
            this.percentile98th = d;
        }

        public void setPercentile99th(double d) {
            this.percentile99th = d;
        }

        public void setPercentile999th(double d) {
            this.percentile999th = d;
        }

        public void setMean(double d) {
            this.mean = d;
        }

        public void setMin(long l) {
            this.min = l;
        }

        public void setMax(long l) {
            this.max = l;
        }

        @Override
        public double getMedian() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getPercentile98th() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getPercentile99th() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getPercentile999th() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getMean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getMax() {
            throw new UnsupportedOperationException();
        }
    }
}

