/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.scaladsl.api.transport;

import com.lightbend.lagom.scaladsl.api.transport.TransportErrorCode;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TransportErrorCode$
implements Serializable {
    public static final TransportErrorCode$ MODULE$ = new TransportErrorCode$();
    private static final TransportErrorCode ProtocolError = MODULE$.apply(400, 1002, "Protocol Error/Bad Request");
    private static final TransportErrorCode UnsupportedData = MODULE$.apply(400, 1003, "Unsupported Data/Bad Request");
    private static final TransportErrorCode BadRequest = MODULE$.UnsupportedData();
    private static final TransportErrorCode Unauthorized = MODULE$.apply(401, 4401, "Unauthorized");
    private static final TransportErrorCode Forbidden = MODULE$.apply(403, 4403, "Forbidden");
    private static final TransportErrorCode PolicyViolation = MODULE$.apply(404, 1008, "Policy Violation/Not Found");
    private static final TransportErrorCode NotFound = MODULE$.PolicyViolation();
    private static final TransportErrorCode MethodNotAllowed = MODULE$.apply(405, 4405, "Method Not Allowed");
    private static final TransportErrorCode NotAcceptable = MODULE$.apply(406, 4406, "Not Acceptable");
    private static final TransportErrorCode PayloadTooLarge = MODULE$.apply(413, 1009, "Payload Too Large");
    private static final TransportErrorCode UnsupportedMediaType = MODULE$.apply(415, 4415, "Unsupported Media Type");
    private static final TransportErrorCode TooManyRequests = MODULE$.apply(429, 4429, "Too Many Requests");
    private static final TransportErrorCode UnexpectedCondition = MODULE$.apply(500, 1011, "Unexpected Condition/Internal Server Error");
    private static final TransportErrorCode InternalServerError = MODULE$.UnexpectedCondition();
    private static final TransportErrorCode ServiceUnavailable = MODULE$.apply(503, 1001, "Going Away/Service Unavailable");
    private static final TransportErrorCode GoingAway = MODULE$.ServiceUnavailable();
    private static final Seq<TransportErrorCode> allErrorCodes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TransportErrorCode[]{MODULE$.ProtocolError(), MODULE$.UnsupportedData(), MODULE$.Unauthorized(), MODULE$.Forbidden(), MODULE$.PolicyViolation(), MODULE$.MethodNotAllowed(), MODULE$.NotAcceptable(), MODULE$.PayloadTooLarge(), MODULE$.UnsupportedMediaType(), MODULE$.TooManyRequests(), MODULE$.UnexpectedCondition(), MODULE$.ServiceUnavailable()}));
    private static final Map<Object, TransportErrorCode> HttpErrorCodeMap = ((IterableOnceOps)MODULE$.allErrorCodes().map((Function1 & Serializable)code -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)code.http())), code))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Map<Object, TransportErrorCode> WebSocketErrorCodeMap = ((IterableOnceOps)MODULE$.allErrorCodes().map((Function1 & Serializable)code -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)code.webSocket())), code))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    public TransportErrorCode apply(int http, int webSocket, String description) {
        return new TransportErrorCode.TransportErrorCodeImpl(http, webSocket, description);
    }

    public TransportErrorCode ProtocolError() {
        return ProtocolError;
    }

    public TransportErrorCode UnsupportedData() {
        return UnsupportedData;
    }

    public TransportErrorCode BadRequest() {
        return BadRequest;
    }

    public TransportErrorCode Unauthorized() {
        return Unauthorized;
    }

    public TransportErrorCode Forbidden() {
        return Forbidden;
    }

    public TransportErrorCode PolicyViolation() {
        return PolicyViolation;
    }

    public TransportErrorCode NotFound() {
        return NotFound;
    }

    public TransportErrorCode MethodNotAllowed() {
        return MethodNotAllowed;
    }

    public TransportErrorCode NotAcceptable() {
        return NotAcceptable;
    }

    public TransportErrorCode PayloadTooLarge() {
        return PayloadTooLarge;
    }

    public TransportErrorCode UnsupportedMediaType() {
        return UnsupportedMediaType;
    }

    public TransportErrorCode TooManyRequests() {
        return TooManyRequests;
    }

    public TransportErrorCode UnexpectedCondition() {
        return UnexpectedCondition;
    }

    public TransportErrorCode InternalServerError() {
        return InternalServerError;
    }

    public TransportErrorCode ServiceUnavailable() {
        return ServiceUnavailable;
    }

    public TransportErrorCode GoingAway() {
        return GoingAway;
    }

    private Seq<TransportErrorCode> allErrorCodes() {
        return allErrorCodes;
    }

    private Map<Object, TransportErrorCode> HttpErrorCodeMap() {
        return HttpErrorCodeMap;
    }

    private Map<Object, TransportErrorCode> WebSocketErrorCodeMap() {
        return WebSocketErrorCodeMap;
    }

    public TransportErrorCode fromHttp(int code) {
        TransportErrorCode transportErrorCode;
        boolean bl = false;
        Option option = null;
        Option option2 = this.HttpErrorCodeMap().get((Object)BoxesRunTime.boxToInteger((int)code));
        if (option2 instanceof Some) {
            TransportErrorCode errorCode;
            Some some = (Some)option2;
            transportErrorCode = errorCode = (TransportErrorCode)some.value();
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (code > 599 || code < 100) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("Invalid http status code: ").append(code).toString());
                }
            }
            if (bl && code < 400) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Invalid http error code: ").append(code).toString());
            }
            if (bl) {
                transportErrorCode = this.apply(code, 4000 + code, "Unknown error code");
            } else {
                throw new MatchError((Object)option2);
            }
        }
        return transportErrorCode;
    }

    public TransportErrorCode fromWebSocket(int code) {
        TransportErrorCode transportErrorCode;
        boolean bl = false;
        Option option = null;
        Option option2 = this.WebSocketErrorCodeMap().get((Object)BoxesRunTime.boxToInteger((int)code));
        if (option2 instanceof Some) {
            TransportErrorCode errorCode;
            Some some = (Some)option2;
            transportErrorCode = errorCode = (TransportErrorCode)some.value();
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (code < 0 || code > 65535) {
                    throw new IllegalArgumentException(new StringBuilder(31).append("Invalid WebSocket status code: ").append(code).toString());
                }
            }
            if (bl && code >= 4400 && code <= 4599) {
                transportErrorCode = this.apply(code - 4000, code, "Unknown error code");
            } else if (bl) {
                transportErrorCode = this.apply(404, code, "Unknown error code");
            } else {
                throw new MatchError((Object)option2);
            }
        }
        return transportErrorCode;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransportErrorCode$.class);
    }

    private TransportErrorCode$() {
    }
}

