/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.scaladsl.persistence.cassandra;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.persistence.query.Offset;
import akka.stream.ActorAttributes$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.lightbend.lagom.internal.persistence.cassandra.CassandraReadSideSettings;
import com.lightbend.lagom.internal.scaladsl.persistence.cassandra.CassandraAutoReadSideHandler$;
import com.lightbend.lagom.scaladsl.persistence.AggregateEvent;
import com.lightbend.lagom.scaladsl.persistence.EventStreamElement;
import com.lightbend.lagom.scaladsl.persistence.ReadSideProcessor;
import com.lightbend.lagom.scaladsl.persistence.cassandra.CassandraSession;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005EeA\u0002\u0007\u000e\u0003\u0003i1\u0004\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006Y!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0007\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u00037\u0001a\u0011CA\u000f\u0011\u001d\t9\u0006\u0001D\t\u00033Bq!!\u001d\u0001\t\u0003\n\u0019H\u0001\rDCN\u001c\u0018M\u001c3sCJ+\u0017\rZ*jI\u0016D\u0015M\u001c3mKJT!AD\b\u0002\u0013\r\f7o]1oIJ\f'B\u0001\t\u0012\u0003-\u0001XM]:jgR,gnY3\u000b\u0005I\u0019\u0012\u0001C:dC2\fGm\u001d7\u000b\u0005Q)\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Y9\u0012!\u00027bO>l'B\u0001\r\u001a\u0003%a\u0017n\u001a5uE\u0016tGMC\u0001\u001b\u0003\r\u0019w.\\\u000b\u00049Y\u00127C\u0001\u0001\u001e!\rq\u0012\u0007\u000e\b\u0003?9r!\u0001\t\u0017\u000f\u0005\u0005ZcB\u0001\u0012+\u001d\t\u0019\u0013F\u0004\u0002%Q5\tQE\u0003\u0002'O\u00051AH]8piz\u001a\u0001!C\u0001\u001b\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011!#F\u0005\u0003!5R!AE\u000b\n\u0005=\u0002\u0014!\u0005*fC\u0012\u001c\u0016\u000eZ3Qe>\u001cWm]:pe*\u0011\u0001#L\u0005\u0003eM\u0012qBU3bINKG-\u001a%b]\u0012dWM\u001d\u0006\u0003_A\u0002\"!\u000e\u001c\r\u0001\u0011)q\u0007\u0001b\u0001q\t)QI^3oiF\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0015\tN\u0007\u0002a%\u0011!\t\r\u0002\u000f\u0003\u001e<'/Z4bi\u0016,e/\u001a8u\u0003\u001d\u0019Xm]:j_:\u0004\"!R$\u000e\u0003\u0019S!A\u0004\u0019\n\u0005!3%\u0001E\"bgN\fg\u000e\u001a:b'\u0016\u001c8/[8o\u0003A\u0011X-\u00193TS\u0012,7+\u001a;uS:<7\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002\u000f\u001b*\u0011\u0001cE\u0005\u0003\u001f2\u0013\u0011dQ1tg\u0006tGM]1SK\u0006$7+\u001b3f'\u0016$H/\u001b8hg\u0006A\u0001.\u00198eY\u0016\u00148\u000f\u0005\u0003S-f\u000bgBA*U!\t!3(\u0003\u0002Vw\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\u00075\u000b\u0007O\u0003\u0002VwA\u0012!L\u0018\t\u0004%nk\u0016B\u0001/Y\u0005\u0015\u0019E.Y:t!\t)d\fB\u0005`\u0007\u0005\u0005\t\u0011!B\u0001A\n\u0019q\fJ\u0019\u0012\u0005e\"\u0004CA\u001bc\t\u0015\u0019\u0007A1\u0001e\u0005\u001dA\u0015M\u001c3mKJ\f\"!O3\u0011\u0005i2\u0017BA4<\u0005\r\te._\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\bC\u0001*k\u0013\tY\u0007L\u0001\u0004TiJLgnZ\u0001\u0003K\u000e\u0004\"A\\9\u000e\u0003=T!\u0001]\u001e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002s_\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\rUL(p_A\u0002)\t1\b\u0010\u0005\u0003x\u0001Q\nW\"A\u0007\t\u000b14\u00019A7\t\u000b\r3\u0001\u0019\u0001#\t\u000b%3\u0001\u0019\u0001&\t\u000bA3\u0001\u0019\u0001?\u0011\tI3V0\u0019\u0019\u0004}\u0006\u0005\u0001c\u0001*\\\u007fB\u0019Q'!\u0001\u0005\u0013}[\u0018\u0011!A\u0001\u0006\u0003\u0001\u0007\"\u00025\u0007\u0001\u0004I\u0017a\u00017pOV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\t\u0019\"A\u0002pe\u001eLA!a\u0006\u0002\u000e\t1Aj\\4hKJ\fA\u0001\\8hA\u00051\u0011N\u001c<pW\u0016$b!a\b\u0002J\u00055\u0003#\u00028\u0002\"\u0005\u0015\u0012bAA\u0012_\n1a)\u001e;ve\u0016\u0004b!a\n\u00022\u0005URBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013%lW.\u001e;bE2,'bAA\u0018w\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0004'\u0016\f\b\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005G>\u0014XM\u0003\u0003\u0002@\u0005\u0005\u0013A\u00023sSZ,'OC\u0002\u0002De\t\u0001\u0002Z1uCN$\u0018\r_\u0005\u0005\u0003\u000f\nID\u0001\bC_VtGm\u0015;bi\u0016lWM\u001c;\t\r\u0005-\u0013\u00021\u0001b\u0003\u001dA\u0017M\u001c3mKJDq!a\u0014\n\u0001\u0004\t\t&A\u0003fm\u0016tG\u000f\u0005\u0003A\u0003'\"\u0014bAA+a\t\u0011RI^3oiN#(/Z1n\u000b2,W.\u001a8u\u0003=ygMZ:fiN#\u0018\r^3nK:$H\u0003BA\u001b\u00037Bq!!\u0018\u000b\u0001\u0004\ty&\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0005\u0003C\ni'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u0015\tX/\u001a:z\u0015\r\u0001\u0012\u0011\u000e\u0006\u0003\u0003W\nA!Y6lC&!\u0011qNA2\u0005\u0019yeMZ:fi\u00061\u0001.\u00198eY\u0016$\"!!\u001e\u0011\u0015\u0005]\u0014qPA)\u0003\u0007\u000bY)\u0004\u0002\u0002z)\u0019!#a\u001f\u000b\t\u0005u\u0014\u0011N\u0001\u0007gR\u0014X-Y7\n\t\u0005\u0005\u0015\u0011\u0010\u0002\u0005\r2|w\u000f\u0005\u0003\u0002\u0006\u0006\u001dUBAA5\u0013\u0011\tI)!\u001b\u0003\t\u0011{g.\u001a\t\u0005\u0003\u000b\u000bi)\u0003\u0003\u0002\u0010\u0006%$a\u0002(piV\u001bX\r\u001a")
public abstract class CassandraReadSideHandler<Event extends AggregateEvent<Event>, Handler>
extends ReadSideProcessor.ReadSideHandler<Event> {
    private final CassandraSession session;
    private final CassandraReadSideSettings readSideSettings;
    private final Map<Class<? extends Event>, Handler> handlers;
    private final String dispatcher;
    private final ExecutionContext ec;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public abstract Future<scala.collection.immutable.Seq<BoundStatement>> invoke(Handler var1, EventStreamElement<Event> var2);

    public abstract BoundStatement offsetStatement(Offset var1);

    public Flow<EventStreamElement<Event>, Done, NotUsed> handle() {
        return ((Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable & scala.Serializable)elem -> {
            Class<?> eventClass = elem.event().getClass();
            Object handler = $this.handlers.getOrElse(eventClass, (Function0 & Serializable & scala.Serializable)() -> {
                block0: {
                    if (!this.log().isDebugEnabled()) break block0;
                    this.log().debug("Unhandled event [{}]", new Object[]{eventClass.getName()});
                }
                return CassandraAutoReadSideHandler$.MODULE$.emptyHandler();
            });
            return this.invoke((Object)handler, (EventStreamElement)elem).flatMap((Function1 & Serializable & scala.Serializable)statements -> this.executeStatements$1((Seq)statements).flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                BoundStatement boundStatement = this.offsetStatement(elem.offset());
                return this.executeStatements$1((Seq)Nil$.MODULE$.$colon$colon((Object)boundStatement)).map((Function1 & Serializable & scala.Serializable)_ -> Done$.MODULE$, $this.ec);
            }, $this.ec), $this.ec);
        })).withAttributes(ActorAttributes$.MODULE$.dispatcher(this.dispatcher));
    }

    private final Future executeStatements$1(Seq statements) {
        BatchStatement batch = new BatchStatement();
        batch.addAll((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(statements).asJava());
        batch.setConsistencyLevel(this.readSideSettings.writeConsistency());
        return this.session.executeWriteBatch(batch);
    }

    public CassandraReadSideHandler(CassandraSession session, CassandraReadSideSettings readSideSettings, Map<Class<? extends Event>, Handler> handlers, String dispatcher, ExecutionContext ec) {
        this.session = session;
        this.readSideSettings = readSideSettings;
        this.handlers = handlers;
        this.dispatcher = dispatcher;
        this.ec = ec;
        this.log = LoggerFactory.getLogger((Class)this.getClass());
    }
}

