/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.scaladsl.persistence;

import akka.actor.ActorSystem;
import akka.persistence.query.Offset;
import akka.stream.Materializer;
import com.lightbend.lagom.internal.persistence.ReadSideConfig;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask;
import com.lightbend.lagom.internal.persistence.cluster.ClusterStartupTask$;
import com.lightbend.lagom.internal.projection.ProjectionRegistry;
import com.lightbend.lagom.internal.projection.ProjectionRegistryActor;
import com.lightbend.lagom.internal.scaladsl.persistence.ReadSideActor$;
import com.lightbend.lagom.scaladsl.persistence.AggregateEvent;
import com.lightbend.lagom.scaladsl.persistence.AggregateEventTag;
import com.lightbend.lagom.scaladsl.persistence.PersistentEntityRegistry;
import com.lightbend.lagom.scaladsl.persistence.ReadSide;
import com.lightbend.lagom.scaladsl.persistence.ReadSideProcessor;
import java.io.Serializable;
import java.net.URLEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ua!B\u0006\r\u0001IA\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011=\u0002!\u0011!Q\u0001\nAB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005P\u0001\t\u0005\t\u0015a\u0003Q\u0011!1\u0006A!A!\u0002\u00179\u0006\"B/\u0001\t\u0003q\u0006\"B5\u0001\t\u0003R\u0007\u0002CA\u0003\u0001\u0011\u0005!#a\u0002\u0003\u0019I+\u0017\rZ*jI\u0016LU\u000e\u001d7\u000b\u00055q\u0011a\u00039feNL7\u000f^3oG\u0016T!a\u0004\t\u0002\u0011M\u001c\u0017\r\\1eg2T!!\u0005\n\u0002\u0011%tG/\u001a:oC2T!a\u0005\u000b\u0002\u000b1\fwm\\7\u000b\u0005U1\u0012!\u00037jO\"$(-\u001a8e\u0015\u00059\u0012aA2p[N\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u00013%D\u0001\"\u0015\ti!E\u0003\u0002\u0010%%\u0011A%\t\u0002\t%\u0016\fGmU5eK\u000611/_:uK6\u001c\u0001\u0001\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)\u0011m\u0019;pe*\tA&\u0001\u0003bW.\f\u0017B\u0001\u0018*\u0005-\t5\r^8s'f\u001cH/Z7\u0002\r\r|gNZ5h!\t\t4'D\u00013\u0015\ti\u0001#\u0003\u00025e\tq!+Z1e'&$WmQ8oM&<\u0017\u0001\u00079feNL7\u000f^3oi\u0016sG/\u001b;z%\u0016<\u0017n\u001d;ssB\u0011\u0001eN\u0005\u0003q\u0005\u0012\u0001\u0004U3sg&\u001cH/\u001a8u\u000b:$\u0018\u000e^=SK\u001eL7\u000f\u001e:z\u0003I\u0001(o\u001c6fGRLwN\u001c*fO&\u001cHO]=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0002\u0012A\u00039s_*,7\r^5p]&\u0011q\b\u0010\u0002\u0013!J|'.Z2uS>t'+Z4jgR\u0014\u00180\u0001\u0003oC6,\u0007c\u0001\u000eC\t&\u00111i\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015ceB\u0001$K!\t95$D\u0001I\u0015\tIe%\u0001\u0004=e>|GOP\u0005\u0003\u0017n\ta\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111jG\u0001\u0003K\u000e\u0004\"!\u0015+\u000e\u0003IS!aU\u000e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002V%\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004[\u0006$\bC\u0001-\\\u001b\u0005I&B\u0001.,\u0003\u0019\u0019HO]3b[&\u0011A,\u0017\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}#WMZ4i)\r\u0001'm\u0019\t\u0003C\u0002i\u0011\u0001\u0004\u0005\u0006\u001f\"\u0001\u001d\u0001\u0015\u0005\u0006-\"\u0001\u001da\u0016\u0005\u0006K!\u0001\ra\n\u0005\u0006_!\u0001\r\u0001\r\u0005\u0006k!\u0001\rA\u000e\u0005\u0006s!\u0001\rA\u000f\u0005\u0006\u0001\"\u0001\r!Q\u0001\te\u0016<\u0017n\u001d;feV\u00111.\u001f\u000b\u0003Y>\u0004\"AG7\n\u00059\\\"\u0001B+oSRDa\u0001]\u0005\u0005\u0002\u0004\t\u0018\u0001\u00059s_\u000e,7o]8s\r\u0006\u001cGo\u001c:z!\rQ\"\u000f^\u0005\u0003gn\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004AU<\u0018B\u0001<\"\u0005E\u0011V-\u00193TS\u0012,\u0007K]8dKN\u001cxN\u001d\t\u0003qfd\u0001\u0001B\u0003{\u0013\t\u00071PA\u0003Fm\u0016tG/\u0005\u0002}\u007fB\u0011!$`\u0005\u0003}n\u0011qAT8uQ&tw\r\u0005\u0003!\u0003\u00039\u0018bAA\u0002C\tq\u0011iZ4sK\u001e\fG/Z#wK:$\u0018a\u0004:fO&\u001cH/\u001a:GC\u000e$xN]=\u0016\t\u0005%\u0011q\u0003\u000b\u0004Y\u0006-\u0001B\u00029\u000b\u0001\u0004\ti\u0001E\u0003\u001b\u0003\u001f\t\u0019\"C\u0002\u0002\u0012m\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0001*\u0018Q\u0003\t\u0004q\u0006]AA\u0002>\u000b\u0005\u0004\tI\"E\u0002}\u00037\u0001R\u0001IA\u0001\u0003+\u0001")
public class ReadSideImpl
implements ReadSide {
    private final ActorSystem system;
    private final ReadSideConfig config;
    private final PersistentEntityRegistry persistentEntityRegistry;
    private final ProjectionRegistry projectionRegistry;
    private final Option<String> name;
    private final Materializer mat;

    @Override
    public <Event extends AggregateEvent<Event>> void register(Function0<ReadSideProcessor<Event>> processorFactory) {
        this.registerFactory(processorFactory);
    }

    public <Event extends AggregateEvent<Event>> void registerFactory(Function0<ReadSideProcessor<Event>> processorFactory) {
        ReadSideProcessor readSideProcessor = (ReadSideProcessor)processorFactory.apply();
        String readSideName = new StringBuilder(0).append((String)this.name.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("-").toString())).append(readSideProcessor.readSideName()).toString();
        Set tags = readSideProcessor.aggregateTags();
        Set entityIds = (Set)tags.map((Function1 & Serializable)x$2 -> x$2.tag());
        Option option = tags.headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(34).append("ReadSideProcessor ").append(readSideProcessor.getClass().getName()).append(" returned 0 tags").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        AggregateEventTag tag = (AggregateEventTag)some.value();
        Class clazz = tag.eventType();
        Class eventClass = clazz;
        String encodedReadSideName = URLEncoder.encode(readSideName, "utf-8");
        ClusterStartupTask globalPrepareTask = ClusterStartupTask$.MODULE$.apply(this.system, new StringBuilder(22).append("readSideGlobalPrepare-").append(encodedReadSideName).toString(), (Function0 & Serializable)() -> ((ReadSideProcessor)processorFactory.apply()).buildHandler().globalPrepare(), this.config.globalPrepareTimeout(), this.config.role(), this.config.minBackoff(), this.config.maxBackoff(), this.config.randomBackoffFactor());
        String projectionName = readSideName;
        Function1 & Serializable readSidePropsFactory = (Function1 & Serializable)coordinates -> ReadSideActor$.MODULE$.props((ProjectionRegistryActor.WorkerCoordinates)coordinates, $this.config, eventClass, globalPrepareTask, (Function2 & Serializable)(aggregateTag, fromOffset) -> $this.persistentEntityRegistry.eventStream(aggregateTag, (Offset)fromOffset), processorFactory, $this.mat);
        this.projectionRegistry.registerProjection(projectionName, entityIds, (Function1)readSidePropsFactory, this.config.role());
    }

    public ReadSideImpl(ActorSystem system, ReadSideConfig config, PersistentEntityRegistry persistentEntityRegistry, ProjectionRegistry projectionRegistry, Option<String> name, ExecutionContext ec, Materializer mat) {
        this.system = system;
        this.config = config;
        this.persistentEntityRegistry = persistentEntityRegistry;
        this.projectionRegistry = projectionRegistry;
        this.name = name;
        this.mat = mat;
    }
}

