/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.scaladsl.server.status;

import akka.NotUsed;
import akka.NotUsed$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.codahale.metrics.Snapshot;
import com.lightbend.lagom.internal.client.CircuitBreakerMetricsImpl;
import com.lightbend.lagom.internal.client.CircuitBreakerMetricsProviderImpl;
import com.lightbend.lagom.internal.spi.CircuitBreakerMetricsProvider;
import com.lightbend.lagom.scaladsl.api.Descriptor;
import com.lightbend.lagom.scaladsl.api.ServiceCall;
import com.lightbend.lagom.scaladsl.api.ServiceCall$;
import com.lightbend.lagom.scaladsl.server.status.CircuitBreakerStatus;
import com.lightbend.lagom.scaladsl.server.status.Latency;
import com.lightbend.lagom.scaladsl.server.status.MetricsService;
import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00194A\u0001C\u0005\u0005-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005+\u0001\t\u0005\t\u0015a\u0003,\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015a\u0006\u0001\"\u0003^\u0005IiU\r\u001e:jGN\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005)Y\u0011AB:uCR,8O\u0003\u0002\r\u001b\u000511/\u001a:wKJT!AD\b\u0002\u0011M\u001c\u0017\r\\1eg2T!\u0001E\t\u0002\u000b1\fwm\\7\u000b\u0005I\u0019\u0012!\u00037jO\"$(-\u001a8e\u0015\u0005!\u0012aA2p[\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0010\u000e\u0003%I!\u0001I\u0005\u0003\u001d5+GO]5dgN+'O^5dK\u0006i2-\u001b:dk&$(I]3bW\u0016\u0014X*\u001a;sS\u000e\u001c\bK]8wS\u0012,'\u000f\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005\u00191\u000f]5\u000b\u0005\u001dz\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005%\"#!H\"je\u000e,\u0018\u000e\u001e\"sK\u0006\\WM]'fiJL7m\u001d)s_ZLG-\u001a:\u0002\u0005\u0015\u001c\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001a\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003a5\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\t\u0019d\u0007\u0006\u00025kA\u0011a\u0004\u0001\u0005\u0006U\r\u0001\u001da\u000b\u0005\u0006C\r\u0001\rAI\u0001\u0017GV\u0014(/\u001a8u\u0007&\u00148-^5u\u0005J,\u0017m[3sgV\t\u0011\b\u0005\u0003;{}*U\"A\u001e\u000b\u0005qj\u0011aA1qS&\u0011ah\u000f\u0002\f'\u0016\u0014h/[2f\u0007\u0006dG\u000e\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0011\t7n[1\n\u0005\u0011\u000b%a\u0002(piV\u001bX\r\u001a\t\u0004\r.kU\"A$\u000b\u0005!K\u0015!C5n[V$\u0018M\u00197f\u0015\tQ\u0015$\u0001\u0006d_2dWm\u0019;j_:L!\u0001T$\u0003\u0007M+\u0017\u000f\u0005\u0002\u001f\u001d&\u0011q*\u0003\u0002\u0015\u0007&\u00148-^5u\u0005J,\u0017m[3s'R\fG/^:\u0002\u001f\rL'oY;ji\n\u0013X-Y6feN,\u0012A\u0015\t\u0005uuz4\u000b\u0005\u0003U1\u0016{T\"A+\u000b\u000591&BA,B\u0003\u0019\u0019HO]3b[&\u0011\u0011,\u0016\u0002\u0007'>,(oY3\u0002/\u0005dGnQ5sGVLGO\u0011:fC.,'o\u0015;biV\u001cX#A#\u0002)\rL'oY;ji\n\u0013X-Y6feN#\u0018\r^;t)\tie\fC\u0003`\u000f\u0001\u0007\u0001-A\u0001n!\t\tG-D\u0001c\u0015\t\u0019g%\u0001\u0004dY&,g\u000e^\u0005\u0003K\n\u0014\u0011dQ5sGVLGO\u0011:fC.,'/T3ue&\u001c7/S7qY\u0002")
public class MetricsServiceImpl
implements MetricsService {
    private final CircuitBreakerMetricsProvider circuitBreakerMetricsProvider;

    @Override
    public Descriptor descriptor() {
        return MetricsService.descriptor$(this);
    }

    @Override
    public ServiceCall<NotUsed, Seq<CircuitBreakerStatus>> currentCircuitBreakers() {
        return ServiceCall$.MODULE$.apply((Function1 & Serializable)x$1 -> Future$.MODULE$.successful(this.allCircuitBreakerStatus()));
    }

    @Override
    public ServiceCall<NotUsed, Source<Seq<CircuitBreakerStatus>, NotUsed>> circuitBreakers() {
        return ServiceCall$.MODULE$.apply((Function1 & Serializable)x$2 -> {
            Source source = ((Source)Source$.MODULE$.tick(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds(), (Object)"tick").map((Function1 & Serializable)x$3 -> this.allCircuitBreakerStatus())).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
            return Future$.MODULE$.successful((Object)source);
        });
    }

    private Seq<CircuitBreakerStatus> allCircuitBreakerStatus() {
        return ((IterableOnceOps)((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(((CircuitBreakerMetricsProviderImpl)this.circuitBreakerMetricsProvider).allMetrics()).asScala()).view().flatMap((Function1 & Serializable)m -> {
            Seq seq;
            try {
                seq = (Seq)new .colon.colon((Object)this.circuitBreakerStatus((CircuitBreakerMetricsImpl)m), (List)Nil$.MODULE$);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Nil$ nil$ = package$.MODULE$.Nil();
                seq = nil$;
            }
            return seq;
        })).toIndexedSeq();
    }

    private CircuitBreakerStatus circuitBreakerStatus(CircuitBreakerMetricsImpl m) {
        Snapshot latencyHistogram = m.latency().getSnapshot();
        double x$1 = latencyHistogram.getMedian();
        double x$2 = latencyHistogram.get98thPercentile();
        double x$3 = latencyHistogram.get99thPercentile();
        double x$4 = latencyHistogram.get999thPercentile();
        long x$5 = latencyHistogram.getMin();
        long x$6 = latencyHistogram.getMax();
        double x$7 = latencyHistogram.getMean();
        Latency latency = new Latency(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
        return new CircuitBreakerStatus(m.breakerId(), Instant.now(), (String)m.state().getValue(), m.successCount().getCount(), m.failureCount().getCount(), m.throughput().getOneMinuteRate(), m.failureThroughput().getOneMinuteRate(), latency);
    }

    public MetricsServiceImpl(CircuitBreakerMetricsProvider circuitBreakerMetricsProvider, ExecutionContext ec) {
        this.circuitBreakerMetricsProvider = circuitBreakerMetricsProvider;
        MetricsService.$init$(this);
    }
}

