/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.scaladsl.testkit;

import com.lightbend.lagom.devmode.ssl.LagomDevModeSSLHolder;
import com.lightbend.lagom.internal.persistence.testkit.AwaitPersistenceInit$;
import com.lightbend.lagom.internal.persistence.testkit.PersistenceTestConfig$;
import com.lightbend.lagom.internal.testkit.CassandraTestServer$;
import com.lightbend.lagom.internal.testkit.TestkitSslSetup;
import com.lightbend.lagom.internal.testkit.TestkitSslSetup$;
import com.lightbend.lagom.scaladsl.server.LagomApplication;
import com.lightbend.lagom.scaladsl.server.LagomApplicationContext;
import com.lightbend.lagom.scaladsl.server.LagomApplicationContext$;
import com.lightbend.lagom.scaladsl.server.RequiresLagomServicePort;
import com.lightbend.lagom.scaladsl.testkit.ServiceTest;
import com.lightbend.lagom.scaladsl.testkit.ServiceTest$SetupImpl$;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import play.api.ApplicationLoader;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Environment$;
import play.api.Mode;
import play.api.Play$;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.DefaultApplicationLifecycle;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerProvider$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class ServiceTest$ {
    public static final ServiceTest$ MODULE$ = new ServiceTest$();
    private static final ServiceTest.Setup defaultSetup = new ServiceTest.SetupImpl(ServiceTest$SetupImpl$.MODULE$.apply$default$1(), ServiceTest$SetupImpl$.MODULE$.apply$default$2(), ServiceTest$SetupImpl$.MODULE$.apply$default$3(), ServiceTest$SetupImpl$.MODULE$.apply$default$4());

    public ServiceTest.Setup defaultSetup() {
        return defaultSetup;
    }

    public <T extends LagomApplication, R> R withServer(ServiceTest.Setup setup, Function1<LagomApplicationContext, T> applicationConstructor, Function1<ServiceTest.TestServer<T>, R> block) {
        Object object;
        ServiceTest.TestServer<T> testServer = this.startServer(setup, applicationConstructor);
        try {
            Object object2;
            Object result;
            Object object3 = result = block.apply(testServer);
            if (object3 instanceof Future) {
                Object object4 = object3;
                object2 = ((Future)object4).andThen((PartialFunction)new Serializable(testServer){
                    private static final long serialVersionUID = 0L;
                    private final ServiceTest.TestServer testServer$1;

                    public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        this.testServer$1.stop();
                        A1 A12 = A1;
                        return (B1)A12;
                    }

                    public final boolean isDefinedAt(Try<Object> x1) {
                        Try<Object> try_ = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.testServer$1 = testServer$1;
                    }
                }, testServer.executionContext());
            } else {
                testServer.stop();
                object2 = object3;
            }
            object = object2;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                testServer.stop();
                throw e;
            }
            throw throwable;
        }
        return (R)object;
    }

    public <T extends LagomApplication> ServiceTest.TestServer<T> startServer(ServiceTest.Setup setup, Function1<LagomApplicationContext, T> applicationConstructor) {
        TestkitSslSetup.Disabled$ disabled$;
        Map map;
        DefaultApplicationLifecycle lifecycle = new DefaultApplicationLifecycle();
        if (setup.cassandra()) {
            String now = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS").format(LocalDateTime.now());
            String testName = new StringBuilder(12).append("ServiceTest_").append(now).toString();
            int cassandraPort = CassandraTestServer$.MODULE$.run(testName, (ApplicationLifecycle)lifecycle);
            map = PersistenceTestConfig$.MODULE$.cassandraConfigMap(testName, cassandraPort);
        } else {
            map = setup.jdbc() ? PersistenceTestConfig$.MODULE$.JdbcConfigMap() : (setup.cluster() ? PersistenceTestConfig$.MODULE$.ClusterConfigMap() : PersistenceTestConfig$.MODULE$.BasicConfigMap());
        }
        Map config = map;
        Environment environment = Environment$.MODULE$.simple(Environment$.MODULE$.simple$default$1(), Environment$.MODULE$.simple$default$2());
        LagomApplication lagomApplication = (LagomApplication)applicationConstructor.apply((Object)LagomApplicationContext$.MODULE$.apply(ApplicationLoader.Context$.MODULE$.create(environment, config, (ApplicationLifecycle)lifecycle, ApplicationLoader.Context$.MODULE$.create$default$4())));
        Play$.MODULE$.start(lagomApplication.application());
        if (setup.ssl()) {
            LagomDevModeSSLHolder sslHolder = new LagomDevModeSSLHolder(environment);
            SSLContext clientSslContext = sslHolder.sslContext();
            disabled$ = TestkitSslSetup$.MODULE$.enabled(sslHolder.keyStoreMetadata(), sslHolder.trustStoreMetadata(), clientSslContext);
        } else {
            disabled$ = TestkitSslSetup.Disabled$.MODULE$;
        }
        TestkitSslSetup.Disabled$ sslSetup = disabled$;
        Properties props = System.getProperties();
        Configuration sslConfig = Configuration$.MODULE$.load(this.getClass().getClassLoader(), props, sslSetup.sslSettings(), true);
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        Option x$2 = sslSetup.sslPort();
        Mode x$3 = lagomApplication.environment().mode();
        Configuration x$4 = sslConfig;
        File x$5 = environment.rootPath();
        String x$6 = "0.0.0.0";
        Properties x$7 = props;
        ServerConfig serverConfig = new ServerConfig(x$5, (Option)x$1, x$2, "0.0.0.0", x$3, x$7, x$4);
        Server server = ServerProvider$.MODULE$.defaultServerProvider().createServer(serverConfig, lagomApplication.application());
        LagomApplication lagomApplication2 = lagomApplication;
        if (lagomApplication2 instanceof RequiresLagomServicePort) {
            LagomApplication lagomApplication3 = lagomApplication2;
            ((RequiresLagomServicePort)lagomApplication3).provideLagomServicePort(BoxesRunTime.unboxToInt((Object)server.httpPort().orElse((Function0 & Serializable)() -> server.httpsPort()).get()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (setup.cassandra() || setup.jdbc()) {
            AwaitPersistenceInit$.MODULE$.awaitPersistenceInit(lagomApplication.actorSystem());
        }
        return new ServiceTest.TestServer<LagomApplication>(lagomApplication, server, (Option<SSLContext>)sslSetup.clientSslContext());
    }

    private ServiceTest$() {
    }
}

