/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.registry;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class RegisteredService {
    private final String name;
    private final URI url;
    private final Optional<String> portName;

    private RegisteredService(String string, URI uRI, Optional<String> optional) {
        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"name");
        this.url = (URI)Preconditions.checkNotNull((Object)uRI, (Object)"url");
        this.portName = optional;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty
    public Optional<String> getPortName() {
        return this.portName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegisteredService registeredService = (RegisteredService)object;
        return Objects.equals(this.name, registeredService.name) && Objects.equals(this.url, registeredService.url) && Objects.equals(this.portName, registeredService.portName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.portName);
    }

    public String toString() {
        return "RegisteredService{name='" + this.name + '\'' + ", url=" + this.url + ", portName=" + this.portName + '}';
    }

    public static RegisteredService of(String string, URI uRI, Optional<String> optional) {
        return new RegisteredService(string, uRI, optional);
    }
}

