/*
 * Decompiled with CFR 0.152.
 */
package play.engineio.protocol;

import akka.util.ByteString;
import akka.util.ByteString$;
import play.engineio.protocol.BinaryEngineIOPacket;
import play.engineio.protocol.EngineIOEncodingException;
import play.engineio.protocol.EngineIOPacket;
import play.engineio.protocol.EngineIOPacketType;
import play.engineio.protocol.EngineIOPacketType$;
import play.engineio.protocol.EngineIOPayload;
import play.engineio.protocol.Utf8EngineIOPacket;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class BinaryEngineIOPayloadEncoding$ {
    public static final BinaryEngineIOPayloadEncoding$ MODULE$;
    private final byte StringPacketByte;
    private final ByteString StringPacketBytes;
    private final byte BinaryPacketByte;
    private final ByteString BinaryPacketBytes;
    private final byte LengthTerminator;
    private final ByteString LengthTerminatorBytes;

    static {
        new BinaryEngineIOPayloadEncoding$();
    }

    public byte StringPacketByte() {
        return this.StringPacketByte;
    }

    public ByteString StringPacketBytes() {
        return this.StringPacketBytes;
    }

    public byte BinaryPacketByte() {
        return this.BinaryPacketByte;
    }

    public ByteString BinaryPacketBytes() {
        return this.BinaryPacketBytes;
    }

    public byte LengthTerminator() {
        return this.LengthTerminator;
    }

    public ByteString LengthTerminatorBytes() {
        return this.LengthTerminatorBytes;
    }

    public ByteString encode(EngineIOPayload payload2) {
        return (ByteString)payload2.packets().foldLeft((Object)ByteString$.MODULE$.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteString apply(ByteString bytes, EngineIOPacket packet) {
                return bytes.$plus$plus(BinaryEngineIOPayloadEncoding$.MODULE$.play$engineio$protocol$BinaryEngineIOPayloadEncoding$$encodePacket(packet));
            }
        });
    }

    public ByteString encodeAsJsonP(String callback, EngineIOPayload payload2) {
        ByteString payloadBytes = this.encode(payload2);
        ByteString payloadCommaSeparatedBytes = ByteString$.MODULE$.apply(((TraversableOnce)payloadBytes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte x0$2) {
                byte by;
                block6: {
                    String string;
                    block5: {
                        block4: {
                            by = x0$2;
                            switch (by) {
                                default: 
                            }
                            if (by < 0) break block4;
                            string = ((Object)BoxesRunTime.boxToByte((byte)by)).toString();
                            break block5;
                        }
                        if (by >= 0) break block6;
                        string = ((Object)BoxesRunTime.boxToInteger((int)(by + 256))).toString();
                    }
                    return string;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(","));
        return ByteString$.MODULE$.apply("___eio[").$plus$plus(ByteString$.MODULE$.apply(callback)).$plus$plus(ByteString$.MODULE$.apply(")]({\"type\":\"Buffer\",\"data\":[")).$plus$plus(payloadCommaSeparatedBytes).$plus$plus(ByteString$.MODULE$.apply("]});"));
    }

    public EngineIOPayload decode(ByteString bytes) {
        return new EngineIOPayload((Seq<EngineIOPacket>)this.decodeP$1(bytes));
    }

    public ByteString play$engineio$protocol$BinaryEngineIOPayloadEncoding$$encodePacket(EngineIOPacket packet) {
        EngineIOPacket engineIOPacket;
        block4: {
            ByteString byteString2;
            block3: {
                block2: {
                    engineIOPacket = packet;
                    if (!(engineIOPacket instanceof BinaryEngineIOPacket)) break block2;
                    BinaryEngineIOPacket binaryEngineIOPacket = (BinaryEngineIOPacket)engineIOPacket;
                    EngineIOPacketType typeId = binaryEngineIOPacket.typeId();
                    ByteString data = binaryEngineIOPacket.data();
                    byteString2 = this.BinaryPacketBytes().$plus$plus(this.encodeInt(data.size() + 1)).$plus$plus(this.LengthTerminatorBytes()).$plus$plus(typeId.binaryEncoded()).$plus$plus(data);
                    break block3;
                }
                if (!(engineIOPacket instanceof Utf8EngineIOPacket)) break block4;
                Utf8EngineIOPacket utf8EngineIOPacket = (Utf8EngineIOPacket)engineIOPacket;
                EngineIOPacketType typeId = utf8EngineIOPacket.typeId();
                String text2 = utf8EngineIOPacket.text();
                ByteString data = ByteString$.MODULE$.apply(text2);
                byteString2 = this.StringPacketBytes().$plus$plus(this.encodeInt(data.size() + 1)).$plus$plus(this.LengthTerminatorBytes()).$plus$plus(ByteString$.MODULE$.apply(typeId.asciiEncoded())).$plus$plus(data);
            }
            return byteString2;
        }
        throw new MatchError((Object)engineIOPacket);
    }

    private ByteString encodeInt(int n) {
        Predef$.MODULE$.assert(n >= 0);
        return ByteString$.MODULE$.apply((Seq)new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToInteger((int)n)).toString())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(char b) {
                return (byte)(b - 48);
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom()));
    }

    private Tuple2<EngineIOPacket, ByteString> decodePacket(ByteString bytes) {
        int n;
        block6: {
            int n2;
            block9: {
                EngineIOPacket engineIOPacket;
                int length;
                int lengthTerminator;
                block8: {
                    ByteString packetBytes;
                    byte packetTypeIdByte;
                    block7: {
                        n = bytes.head();
                        boolean bl = this.StringPacketByte() == n ? true : this.BinaryPacketByte() == n;
                        if (!bl) break block6;
                        lengthTerminator = bytes.indexOf((Object)BoxesRunTime.boxToByte((byte)this.LengthTerminator()));
                        if (lengthTerminator < 0) {
                            throw new EngineIOEncodingException("No length terminator found in packet");
                        }
                        length = this.decodeInt(bytes.slice(1, lengthTerminator));
                        if (bytes.size() < lengthTerminator + length + 1) {
                            throw new EngineIOEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed packet length of ", " but only ", " bytes are available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length), BoxesRunTime.boxToInteger((int)(bytes.size() - lengthTerminator - 1))})));
                        }
                        if (length == 0) {
                            throw new EngineIOEncodingException("Packet length must be at least 1");
                        }
                        packetTypeIdByte = bytes.apply(lengthTerminator + 1);
                        packetBytes = bytes.slice(lengthTerminator + 2, lengthTerminator + length + 1);
                        n2 = n;
                        if (this.StringPacketByte() != n2) break block7;
                        EngineIOPacketType packetTypeId = EngineIOPacketType$.MODULE$.fromChar((char)packetTypeIdByte);
                        engineIOPacket = new Utf8EngineIOPacket(packetTypeId, packetBytes.utf8String());
                        break block8;
                    }
                    if (this.BinaryPacketByte() != n2) break block9;
                    EngineIOPacketType packetTypeId = EngineIOPacketType$.MODULE$.fromBinary(packetTypeIdByte);
                    engineIOPacket = new BinaryEngineIOPacket(packetTypeId, packetBytes);
                }
                Utf8EngineIOPacket packet = engineIOPacket;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)packet), (Object)bytes.drop(lengthTerminator + 1 + length));
                return tuple2;
            }
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)n2));
        }
        int unsigned = n < 0 ? n + 256 : n;
        throw new EngineIOEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected byte at beginning of packet: 0x", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toHexString(unsigned)})));
    }

    private int decodeInt(ByteString bytes) {
        return BoxesRunTime.unboxToInt((Object)bytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int result, byte by) {
                return result * 10 + by;
            }
        }));
    }

    private final List decodeP$1(ByteString bytes) {
        Tuple2<EngineIOPacket, ByteString> tuple2;
        block4: {
            Nil$ nil$;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if (!bytes.isEmpty()) break block2;
                    nil$ = Nil$.MODULE$;
                    break block3;
                }
                tuple2 = this.decodePacket(bytes);
                if (tuple2 == null) break block4;
                EngineIOPacket packet = (EngineIOPacket)tuple2._1();
                ByteString remaining = (ByteString)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)packet, (Object)remaining);
                EngineIOPacket packet2 = (EngineIOPacket)tuple23._1();
                ByteString remaining2 = (ByteString)tuple23._2();
                EngineIOPacket engineIOPacket = packet2;
                nil$ = this.decodeP$1(remaining2).$colon$colon((Object)engineIOPacket);
            }
            return nil$;
        }
        throw new MatchError(tuple2);
    }

    private BinaryEngineIOPayloadEncoding$() {
        MODULE$ = this;
        this.StringPacketByte = 0;
        this.StringPacketBytes = ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.StringPacketByte()}));
        this.BinaryPacketByte = 1;
        this.BinaryPacketBytes = ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.BinaryPacketByte()}));
        this.LengthTerminator = (byte)255;
        this.LengthTerminatorBytes = ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.LengthTerminator()}));
    }
}

