/*
 * Decompiled with CFR 0.152.
 */
package play.engineio.protocol;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.engineio.protocol.BinaryEngineIOPacket;
import play.engineio.protocol.EngineIOEncodingException;
import play.engineio.protocol.EngineIOPacket;
import play.engineio.protocol.EngineIOPacketType;
import play.engineio.protocol.EngineIOPacketType$;
import play.engineio.protocol.EngineIOPayload;
import play.engineio.protocol.Utf8EngineIOPacket;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Utf8EngineIOPayloadEncoding$ {
    public static final Utf8EngineIOPayloadEncoding$ MODULE$;
    private final Pattern PacketHeaderPattern;

    static {
        new Utf8EngineIOPayloadEncoding$();
    }

    public String encode(EngineIOPayload payload2) {
        StringBuilder builder2 = package$.MODULE$.StringBuilder().newBuilder();
        payload2.packets().foreach((Function1)new Serializable(builder2){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;

            public final StringBuilder apply(EngineIOPacket packet) {
                return Utf8EngineIOPayloadEncoding$.MODULE$.play$engineio$protocol$Utf8EngineIOPayloadEncoding$$encodePacket(this.builder$1, packet);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder2.toString();
    }

    public ByteString encodeAsBytes(EngineIOPayload payload2) {
        return ByteString$.MODULE$.apply(this.encode(payload2));
    }

    public ByteString encodeAsJsonP(String callback, EngineIOPayload payload2) {
        ByteString payloadBytes = ByteString$.MODULE$.apply(Json$.MODULE$.toBytes((JsValue)new JsString(this.encode(payload2))));
        return ByteString$.MODULE$.apply("___eio[").$plus$plus(ByteString$.MODULE$.apply(callback)).$plus$plus(ByteString$.MODULE$.apply("](")).$plus$plus(payloadBytes).$plus$plus(ByteString$.MODULE$.apply(");"));
    }

    public StringBuilder play$engineio$protocol$Utf8EngineIOPayloadEncoding$$encodePacket(StringBuilder builder2, EngineIOPacket packet) {
        EngineIOPacket engineIOPacket;
        block6: {
            Tuple2 tuple2;
            block5: {
                block4: {
                    engineIOPacket = packet;
                    if (!(engineIOPacket instanceof Utf8EngineIOPacket)) break block4;
                    Utf8EngineIOPacket utf8EngineIOPacket = (Utf8EngineIOPacket)engineIOPacket;
                    String text2 = utf8EngineIOPacket.text();
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)text2), (Object)BoxesRunTime.boxToInteger((int)text2.codePointCount(0, text2.length())));
                    break block5;
                }
                if (!(engineIOPacket instanceof BinaryEngineIOPacket)) break block6;
                BinaryEngineIOPacket binaryEngineIOPacket = (BinaryEngineIOPacket)engineIOPacket;
                ByteString data = binaryEngineIOPacket.data();
                String text3 = new String(Base64.getEncoder().encode((byte[])data.toArray(ClassTag$.MODULE$.Byte())), "US-ASCII");
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)text3), (Object)BoxesRunTime.boxToInteger((int)(text3.length() + 1)));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                String packetData = (String)tuple22._1();
                int length = tuple22._2$mcI$sp();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)packetData, (Object)BoxesRunTime.boxToInteger((int)length));
                String packetData2 = (String)tuple24._1();
                int length2 = tuple24._2$mcI$sp();
                builder2.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)(length2 + 1))).toString());
                builder2.$plus$eq(':');
                Object object = packet instanceof BinaryEngineIOPacket ? builder2.$plus$eq('b') : BoxedUnit.UNIT;
                builder2.$plus$plus$eq(packet.typeId().asciiEncoded());
                return builder2.$plus$plus$eq(packetData2);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)engineIOPacket);
    }

    public EngineIOPayload decode(String text2) {
        return new EngineIOPayload((Seq<EngineIOPacket>)this.decodePackets(text2, 0));
    }

    private List<EngineIOPacket> decodePackets(String text2, int startIndex) {
        Tuple2<EngineIOPacket, Object> tuple2;
        block4: {
            Nil$ nil$;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if (text2.length() != startIndex) break block2;
                    nil$ = Nil$.MODULE$;
                    break block3;
                }
                tuple2 = this.decodePacket(text2, startIndex);
                if (tuple2 == null) break block4;
                EngineIOPacket packet = (EngineIOPacket)tuple2._1();
                int endIndex = tuple2._2$mcI$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)packet, (Object)BoxesRunTime.boxToInteger((int)endIndex));
                EngineIOPacket packet2 = (EngineIOPacket)tuple23._1();
                int endIndex2 = tuple23._2$mcI$sp();
                EngineIOPacket engineIOPacket = packet2;
                nil$ = this.decodePackets(text2, endIndex2).$colon$colon((Object)engineIOPacket);
            }
            return nil$;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<EngineIOPacket, Object> decodePacket(String text2, int startIndex) {
        block5: {
            Tuple2<String, Object> tuple2;
            block8: {
                Tuple2 tuple22;
                block7: {
                    Tuple2 tuple23;
                    EngineIOPacketType packetType2;
                    int length;
                    Matcher matcher;
                    block6: {
                        matcher = this.PacketHeaderPattern().matcher(text2);
                        if (!matcher.find(startIndex)) break block5;
                        length = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                        String string = matcher.group(2);
                        String string2 = "b";
                        boolean binary2 = !(string != null ? !string.equals(string2) : string2 != null);
                        packetType2 = EngineIOPacketType$.MODULE$.fromChar(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).head()));
                        if (!binary2) break block6;
                        int endOfMessage = matcher.end() + length - 2;
                        if (endOfMessage > text2.length()) {
                            throw new EngineIOEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed packet length of ", " but only ", " bytes are available."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length), BoxesRunTime.boxToInteger((int)(text2.length() - matcher.end() + 2))})));
                        }
                        ByteString data = ByteString$.MODULE$.apply(Base64.getDecoder().decode(text2.substring(matcher.end(), endOfMessage)));
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new BinaryEngineIOPacket(packetType2, data)), (Object)BoxesRunTime.boxToInteger((int)endOfMessage));
                        break block7;
                    }
                    int codePointCount = text2.codePointCount(matcher.end(), text2.length());
                    if (codePointCount < length - 1) {
                        throw new EngineIOEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed packet length of ", " but only ", " bytes are available."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length), BoxesRunTime.boxToInteger((int)(codePointCount + 1))})));
                    }
                    tuple2 = this.extractCodePoints(text2, matcher.end(), length - 1);
                    if (tuple2 == null) break block8;
                    String data = (String)tuple2._1();
                    int endIndex = tuple2._2$mcI$sp();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)data, (Object)BoxesRunTime.boxToInteger((int)endIndex));
                    String data2 = (String)tuple24._1();
                    int endIndex2 = tuple24._2$mcI$sp();
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Utf8EngineIOPacket(packetType2, data2)), (Object)BoxesRunTime.boxToInteger((int)endIndex2));
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        }
        throw new EngineIOEncodingException("Malformed packet");
    }

    private Tuple2<String, Object> extractCodePoints(String text2, int startIndex, int length) {
        int endIndex = startIndex;
        for (int count = 0; count < length; ++count) {
            if (RichChar$.MODULE$.isSurrogate$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text2), endIndex)))) {
                endIndex += 2;
                continue;
            }
            ++endIndex;
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)text2.substring(startIndex, endIndex)), (Object)BoxesRunTime.boxToInteger((int)endIndex));
    }

    public Pattern PacketHeaderPattern() {
        return this.PacketHeaderPattern;
    }

    private Utf8EngineIOPayloadEncoding$() {
        MODULE$ = this;
        this.PacketHeaderPattern = Pattern.compile("(\\d+):(b?)(\\d)");
    }
}

