/*
 * Decompiled with CFR 0.152.
 */
package play.socketio.javadsl;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.BidiFlow;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Sink;
import akka.stream.scaladsl.Source;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import play.engineio.EngineIO;
import play.engineio.EngineIOController;
import play.engineio.EngineIOSessionHandler;
import play.mvc.Http;
import play.socketio.SocketIOConfig;
import play.socketio.SocketIOEvent;
import play.socketio.SocketIOSession;
import play.socketio.javadsl.SocketIOEventCodec;
import play.socketio.javadsl.SocketIOSessionFlowHelper;
import scala.concurrent.ExecutionContext;

public final class SocketIO {
    private final SocketIOConfig config;
    private final EngineIO engineIO;
    private final ExecutionContext ec;
    private final Materializer mat;

    @Inject
    public SocketIO(SocketIOConfig socketIOConfig, EngineIO engineIO, ExecutionContext executionContext, Materializer materializer) {
        this.config = socketIOConfig;
        this.engineIO = engineIO;
        this.ec = executionContext;
        this.mat = materializer;
    }

    public SocketIOBuilder<Object> createBuilder() {
        return new SocketIOBuilder<Object>((requestHeader, string) -> CompletableFuture.completedFuture(NotUsed.getInstance()), throwable -> {
            if (throwable.getMessage() != null) {
                return Optional.of(TextNode.valueOf((String)throwable.getMessage()));
            }
            return Optional.of(TextNode.valueOf((String)throwable.getClass().getName()));
        }, socketIOSession -> Flow.fromSinkAndSource((Graph)Sink.ignore(), (Graph)Source.maybe()), (socketIOSession, string) -> Optional.empty());
    }

    public class SocketIOBuilder<SessionData> {
        private final BiFunction<Http.RequestHeader, String, CompletionStage<SessionData>> connectCallback;
        private final Function<Throwable, Optional<JsonNode>> errorHandler;
        private final Function<SocketIOSession<SessionData>, Flow<SocketIOEvent, SocketIOEvent, NotUsed>> defaultNamespaceCallback;
        private final BiFunction<SocketIOSession<SessionData>, String, Optional<Flow<SocketIOEvent, SocketIOEvent, NotUsed>>> connectToNamespaceCallback;

        private SocketIOBuilder(BiFunction<Http.RequestHeader, String, CompletionStage<SessionData>> biFunction, Function<Throwable, Optional<JsonNode>> function, Function<SocketIOSession<SessionData>, Flow<SocketIOEvent, SocketIOEvent, NotUsed>> function2, BiFunction<SocketIOSession<SessionData>, String, Optional<Flow<SocketIOEvent, SocketIOEvent, NotUsed>>> biFunction2) {
            this.connectCallback = biFunction;
            this.errorHandler = function;
            this.defaultNamespaceCallback = function2;
            this.connectToNamespaceCallback = biFunction2;
        }

        public <S extends SessionData> SocketIOBuilder<S> onConnect(BiFunction<Http.RequestHeader, String, S> biFunction) {
            return this.onConnectAsync((requestHeader, string) -> CompletableFuture.completedFuture(biFunction.apply((Http.RequestHeader)requestHeader, (String)string)));
        }

        public <S extends SessionData> SocketIOBuilder<S> onConnectAsync(BiFunction<Http.RequestHeader, String, CompletionStage<S>> biFunction) {
            return new SocketIOBuilder<SessionData>(biFunction, this.errorHandler, this.defaultNamespaceCallback, this.connectToNamespaceCallback);
        }

        public SocketIOBuilder<SessionData> withErrorHandler(Function<Throwable, Optional<JsonNode>> function) {
            return new SocketIOBuilder<SessionData>(this.connectCallback, throwable -> ((Optional)function.apply((Throwable)throwable)).map(Optional::of).orElseGet(() -> this.errorHandler.apply((Throwable)throwable)), this.defaultNamespaceCallback, this.connectToNamespaceCallback);
        }

        public <In, Out> SocketIOBuilder<SessionData> defaultNamespace(SocketIOEventCodec<In, Out> socketIOEventCodec, Flow<In, Out, ?> flow) {
            return this.defaultNamespace(socketIOEventCodec, (SocketIOSession<SessionData> socketIOSession) -> flow);
        }

        public <In, Out> SocketIOBuilder<SessionData> defaultNamespace(SocketIOEventCodec<In, Out> socketIOEventCodec, Function<SocketIOSession<SessionData>, Flow<In, Out, ?>> function) {
            BidiFlow<SocketIOEvent, In, Out, SocketIOEvent, NotUsed> bidiFlow = socketIOEventCodec.createFlow();
            return new SocketIOBuilder<SessionData>(this.connectCallback, this.errorHandler, function.andThen(arg_0 -> bidiFlow.join(arg_0)), this.connectToNamespaceCallback);
        }

        public <In, Out> SocketIOBuilder<SessionData> addNamespace(String string, SocketIOEventCodec<In, Out> socketIOEventCodec, Flow<In, Out, ?> flow) {
            return this.addNamespace(socketIOEventCodec, (socketIOSession, string2) -> {
                String[] stringArray = string2.split("\\?", 2);
                if (stringArray[0].equals(string)) {
                    return Optional.of(flow);
                }
                return Optional.empty();
            });
        }

        public <In, Out> SocketIOBuilder<SessionData> addNamespace(SocketIOEventCodec<In, Out> socketIOEventCodec, BiFunction<SocketIOSession<SessionData>, String, Optional<Flow<In, Out, ?>>> biFunction) {
            BidiFlow bidiFlow = socketIOEventCodec.createFlow();
            return new SocketIOBuilder<SessionData>(this.connectCallback, this.errorHandler, this.defaultNamespaceCallback, (socketIOSession, string) -> this.connectToNamespaceCallback.apply((SocketIOSession<SessionData>)socketIOSession, (String)string).map(Optional::of).orElseGet(() -> ((Optional)biFunction.apply((SocketIOSession)socketIOSession, (String)string)).map(arg_0 -> ((BidiFlow)bidiFlow).join(arg_0))));
        }

        public EngineIOController createController() {
            EngineIOSessionHandler engineIOSessionHandler = SocketIOSessionFlowHelper.createEngineIOSessionHandler(SocketIO.this.config, this.connectCallback, this.errorHandler, this.defaultNamespaceCallback, this.connectToNamespaceCallback, SocketIO.this.ec, SocketIO.this.mat);
            return SocketIO.this.engineIO.createController(engineIOSessionHandler);
        }
    }
}

