/*
 * Decompiled with CFR 0.152.
 */
package play.socketio.javadsl;

import akka.NotUsed;
import akka.japi.Pair;
import akka.stream.Graph;
import akka.stream.javadsl.BidiFlow;
import akka.stream.javadsl.Flow;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes$;
import play.libs.F;
import play.socketio.SocketIOEvent;
import play.socketio.SocketIOEventAck;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.compat.java8.OptionConverters;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class SocketIOEventCodec<In, Out> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final List<Pair<Predicate<SocketIOEvent>, EventDecoder<? extends In>>> decoders = new ArrayList<Pair<Predicate<SocketIOEvent>, EventDecoder<? extends In>>>();
    private final List<Pair<Predicate<? extends Out>, EventEncoder<? extends Out>>> encoders = new ArrayList<Pair<Predicate<? extends Out>, EventEncoder<? extends Out>>>();

    public final <T extends In> SocketIOEventCodec<In, Out> addDecoder(String string, EventDecoder<T> eventDecoder) {
        return this.addDecoder((SocketIOEvent socketIOEvent) -> socketIOEvent.name().equals(string), eventDecoder);
    }

    public final <T extends In> SocketIOEventCodec<In, Out> addDecoder(Predicate<SocketIOEvent> predicate, EventDecoder<T> eventDecoder) {
        this.decoders.add(Pair.create(predicate, eventDecoder));
        return this;
    }

    public final <T extends Out> SocketIOEventCodec<In, Out> addEncoder(String string, Class<T> clazz, EventEncoder<T> eventEncoder) {
        return this.addEncoder(string, clazz::isInstance, eventEncoder);
    }

    public final <T extends Out> SocketIOEventCodec<In, Out> addEncoder(String string, Predicate<T> predicate, EventEncoder<T> eventEncoder) {
        return this.addEncoder(predicate, eventEncoder.withName(string));
    }

    public final <T extends Out> SocketIOEventCodec<In, Out> addEncoder(Predicate<T> predicate, NamedEventEncoder<T> namedEventEncoder) {
        this.encoders.add(Pair.create(predicate, namedEventEncoder));
        return this;
    }

    public final BidiFlow<SocketIOEvent, In, Out, SocketIOEvent, NotUsed> createFlow() {
        return SocketIOEventCodec.doCreateFlow(ImmutableList.copyOf(this.decoders), ImmutableList.copyOf(this.encoders));
    }

    private static <In, Out> BidiFlow<SocketIOEvent, In, Out, SocketIOEvent, NotUsed> doCreateFlow(List<Pair<Predicate<SocketIOEvent>, EventDecoder<? extends In>>> list, List<Pair<Predicate<? extends Out>, EventEncoder<? extends Out>>> list2) {
        Flow flow = Flow.create().map((akka.japi.function.Function & Serializable)socketIOEvent -> {
            Optional<Pair> optional = list.stream().filter(pair -> ((Predicate)pair.first()).test(socketIOEvent)).findFirst();
            return optional.map(pair -> ((EventDecoder)pair.second()).decodeEvent((SocketIOEvent)socketIOEvent)).orElseGet(() -> {
                throw new RuntimeException("No decoder found to handle event named " + socketIOEvent.name());
            });
        });
        Flow flow2 = Flow.create().map((akka.japi.function.Function & Serializable)object -> {
            Optional<Pair> optional = list2.stream().filter(pair -> ((Predicate)pair.first()).test(object)).findFirst();
            return optional.map(pair -> ((EventEncoder)pair.second()).encodeEvent(object)).orElseGet(() -> {
                throw new RuntimeException("No decoder found to handle event " + object);
            });
        });
        return BidiFlow.fromFlows((Graph)flow, (Graph)flow2);
    }

    public <T> SingleArgumentDecoder<T> decodeJson(Class<T> clazz) {
        ObjectReader objectReader = this.objectMapper.readerFor(clazz);
        return either -> {
            try {
                if (either.isLeft()) {
                    JsonNode jsonNode = (JsonNode)Reads$.MODULE$.JsonNodeReads().reads((JsValue)either.left().get()).get();
                    return objectReader.readValue(jsonNode);
                }
                return objectReader.readValue(((ByteString)either.right().get()).toArray());
            }
            catch (IOException iOException) {
                throw new EventCodecException("Error decoding value", iOException);
            }
        };
    }

    public SingleArgumentDecoder<ByteString> decodeBytes() {
        return either -> (ByteString)either.right().get();
    }

    public MultiArgumentDecoder<NotUsed> decodeNoArgs() {
        return seq -> NotUsed.getInstance();
    }

    public <T> SingleArgumentEncoder<T> encodeJson() {
        return object -> {
            JsonNode jsonNode = this.objectMapper.valueToTree(object);
            return Left.apply((Object)Writes$.MODULE$.JsonNodeWrites().writes(jsonNode));
        };
    }

    public SingleArgumentEncoder<ByteString> encodeBytes() {
        return Right::apply;
    }

    public MultiArgumentEncoder<NotUsed> encodeNoArgs() {
        return notUsed -> List$.MODULE$.empty();
    }

    public static class EventCodecException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        public EventCodecException(String string) {
            super(string);
        }

        public EventCodecException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static interface ThreeArgumentEncoder<T1, T2, T3>
    extends MultiArgumentEncoder<F.Tuple3<T1, T2, T3>> {
        default public <T4> MultiArgumentEncoder<F.Tuple4<T1, T2, T3, T4>> and(SingleArgumentEncoder<T4> singleArgumentEncoder) {
            return tuple4 -> {
                Seq<Either<JsValue, ByteString>> seq = this.encodeArgs(new F.Tuple3(tuple4._1, tuple4._2, tuple4._3));
                ArrayList<Either<JsValue, ByteString>> arrayList = new ArrayList<Either<JsValue, ByteString>>(JavaConverters.asJavaCollectionConverter(seq).asJavaCollection());
                arrayList.add(singleArgumentEncoder.encodeArg(tuple4._4));
                return (Seq)JavaConverters.asScalaBufferConverter(arrayList).asScala();
            };
        }

        default public <A> EventEncoder<F.Tuple4<T1, T2, T3, Consumer<A>>> withAckDecoder(MultiArgumentDecoder<A> multiArgumentDecoder) {
            return tuple4 -> SocketIOEvent.unnamed(this.encodeArgs(new F.Tuple3(tuple4._1, tuple4._2, tuple4._3)), (Option<SocketIOEventAck>)Some.apply(seq -> ((Consumer)tuple4._4).accept(multiArgumentDecoder.decodeArgs((Seq<Either<JsValue, ByteString>>)seq))));
        }
    }

    public static interface TwoArgumentEncoder<T1, T2>
    extends MultiArgumentEncoder<Pair<T1, T2>> {
        default public <T3> ThreeArgumentEncoder<T1, T2, T3> and(SingleArgumentEncoder<T3> singleArgumentEncoder) {
            return tuple3 -> {
                Seq<Either<JsValue, ByteString>> seq = this.encodeArgs(Pair.create((Object)tuple3._1, (Object)tuple3._2));
                ArrayList<Either<JsValue, ByteString>> arrayList = new ArrayList<Either<JsValue, ByteString>>(JavaConverters.asJavaCollectionConverter(seq).asJavaCollection());
                arrayList.add(singleArgumentEncoder.encodeArg(tuple3._3));
                return (Seq)JavaConverters.asScalaBufferConverter(arrayList).asScala();
            };
        }

        default public <A> EventEncoder<F.Tuple3<T1, T2, Consumer<A>>> withAckDecoder(MultiArgumentDecoder<A> multiArgumentDecoder) {
            return tuple3 -> SocketIOEvent.unnamed(this.encodeArgs(Pair.create((Object)tuple3._1, (Object)tuple3._2)), (Option<SocketIOEventAck>)Some.apply(seq -> ((Consumer)tuple3._3).accept(multiArgumentDecoder.decodeArgs((Seq<Either<JsValue, ByteString>>)seq))));
        }
    }

    public static interface SingleArgumentEncoder<T>
    extends MultiArgumentEncoder<T> {
        public Either<JsValue, ByteString> encodeArg(T var1);

        default public <T2> TwoArgumentEncoder<T, T2> and(SingleArgumentEncoder<T2> singleArgumentEncoder) {
            return pair -> (Seq)JavaConverters.asScalaBufferConverter(Arrays.asList(this.encodeArg(pair.first()), singleArgumentEncoder.encodeArg(pair.second()))).asScala();
        }

        default public <A> EventEncoder<Pair<T, Consumer<A>>> withAckDecoder(MultiArgumentDecoder<A> multiArgumentDecoder) {
            return pair -> SocketIOEvent.unnamed(this.encodeArgs(pair.first()), (Option<SocketIOEventAck>)Some.apply(seq -> ((Consumer)pair.second()).accept(multiArgumentDecoder.decodeArgs((Seq<Either<JsValue, ByteString>>)seq))));
        }

        @Override
        default public Seq<Either<JsValue, ByteString>> encodeArgs(T t) {
            return (Seq)JavaConverters.asScalaBufferConverter(Collections.singletonList(this.encodeArg(t))).asScala();
        }
    }

    public static interface MultiArgumentEncoder<T>
    extends EventEncoder<T> {
        public Seq<Either<JsValue, ByteString>> encodeArgs(T var1);

        @Override
        default public SocketIOEvent encodeEvent(T t) {
            return SocketIOEvent.unnamed(this.encodeArgs(t), (Option<SocketIOEventAck>)Option.apply(null));
        }
    }

    public static interface NamedEventEncoder<T>
    extends EventEncoder<T> {
    }

    public static interface EventEncoder<T> {
        public SocketIOEvent encodeEvent(T var1);

        default public <U> EventEncoder<U> contramap(Function<? super U, ? extends T> function) {
            return object -> this.encodeEvent(function.apply((Object)object));
        }

        default public NamedEventEncoder<T> withName(String string) {
            return object -> {
                SocketIOEvent socketIOEvent = this.encodeEvent(object);
                return new SocketIOEvent(string, socketIOEvent.arguments(), socketIOEvent.ack());
            };
        }
    }

    public static interface ThreeArgumentDecoder<T1, T2, T3>
    extends MultiArgumentDecoder<F.Tuple3<T1, T2, T3>> {
        default public <T4> MultiArgumentDecoder<F.Tuple4<T1, T2, T3, T4>> and(SingleArgumentDecoder<T4> singleArgumentDecoder) {
            return seq -> {
                if (seq.size() < 4) {
                    throw new EventCodecException("Needed 4 arguments to decode, but only found " + seq.size());
                }
                F.Tuple3 tuple3 = (F.Tuple3)this.decodeArgs((Seq<Either<JsValue, ByteString>>)seq);
                return new F.Tuple4(tuple3._1, tuple3._2, tuple3._3, singleArgumentDecoder.decodeArg((Either<JsValue, ByteString>)((Either)seq.apply(1))));
            };
        }

        default public <A> EventDecoder<F.Tuple4<T1, T2, T3, Optional<Consumer<A>>>> withMaybeAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> {
                F.Tuple3 tuple3 = (F.Tuple3)this.decodeEvent(socketIOEvent);
                return new F.Tuple4(tuple3._1, tuple3._2, tuple3._3, OptionConverters.toJava(socketIOEvent.ack()).map(socketIOEventAck -> object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object))));
            };
        }

        default public <A> EventDecoder<F.Tuple4<T1, T2, T3, Consumer<A>>> withAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> {
                SocketIOEventAck socketIOEventAck = OptionConverters.toJava(socketIOEvent.ack()).orElseGet(() -> {
                    throw new EventCodecException("Expected ack");
                });
                F.Tuple3 tuple3 = (F.Tuple3)this.decodeEvent(socketIOEvent);
                return new F.Tuple4(tuple3._1, tuple3._2, tuple3._3, object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object)));
            };
        }
    }

    public static interface TwoArgumentDecoder<T1, T2>
    extends MultiArgumentDecoder<Pair<T1, T2>> {
        default public <T3> ThreeArgumentDecoder<T1, T2, T3> and(SingleArgumentDecoder<T3> singleArgumentDecoder) {
            return seq -> {
                if (seq.size() < 3) {
                    throw new EventCodecException("Needed 3 arguments to decode, but only found " + seq.size());
                }
                Pair pair = (Pair)this.decodeArgs((Seq<Either<JsValue, ByteString>>)seq);
                return new F.Tuple3(pair.first(), pair.second(), singleArgumentDecoder.decodeArg((Either<JsValue, ByteString>)((Either)seq.apply(2))));
            };
        }

        default public <A> EventDecoder<F.Tuple3<T1, T2, Optional<Consumer<A>>>> withMaybeAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> {
                Pair pair = (Pair)this.decodeEvent(socketIOEvent);
                return new F.Tuple3(pair.first(), pair.second(), OptionConverters.toJava(socketIOEvent.ack()).map(socketIOEventAck -> object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object))));
            };
        }

        default public <A> EventDecoder<F.Tuple3<T1, T2, Consumer<A>>> withAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> {
                SocketIOEventAck socketIOEventAck = OptionConverters.toJava(socketIOEvent.ack()).orElseGet(() -> {
                    throw new EventCodecException("Expected ack");
                });
                Pair pair = (Pair)this.decodeEvent(socketIOEvent);
                return new F.Tuple3(pair.first(), pair.second(), object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object)));
            };
        }
    }

    public static interface SingleArgumentDecoder<T>
    extends MultiArgumentDecoder<T> {
        public T decodeArg(Either<JsValue, ByteString> var1);

        default public <T2> TwoArgumentDecoder<T, T2> and(SingleArgumentDecoder<T2> singleArgumentDecoder) {
            return seq -> {
                if (seq.size() < 2) {
                    throw new EventCodecException("Needed two arguments to decode, but only found " + seq.size());
                }
                return Pair.create(this.decodeArg((Either<JsValue, ByteString>)((Either)seq.apply(0))), singleArgumentDecoder.decodeArg((Either<JsValue, ByteString>)((Either)seq.apply(1))));
            };
        }

        default public <A> EventDecoder<Pair<T, Optional<Consumer<A>>>> withMaybeAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> Pair.create(this.decodeEvent(socketIOEvent), OptionConverters.toJava(socketIOEvent.ack()).map(socketIOEventAck -> object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object))));
        }

        default public <A> EventDecoder<Pair<T, Consumer<A>>> withAckEncoder(MultiArgumentEncoder<A> multiArgumentEncoder) {
            return socketIOEvent -> {
                SocketIOEventAck socketIOEventAck = OptionConverters.toJava(socketIOEvent.ack()).orElseGet(() -> {
                    throw new EventCodecException("Expected ack");
                });
                return Pair.create(this.decodeEvent(socketIOEvent), object -> socketIOEventAck.apply(multiArgumentEncoder.encodeArgs(object)));
            };
        }

        @Override
        default public T decodeArgs(Seq<Either<JsValue, ByteString>> seq) {
            if (seq.size() < 1) {
                throw new EventCodecException("Tried to decode 1 argument, but there were no arguments to decode");
            }
            return this.decodeArg((Either<JsValue, ByteString>)((Either)seq.head()));
        }
    }

    public static interface MultiArgumentDecoder<T>
    extends EventDecoder<T> {
        public T decodeArgs(Seq<Either<JsValue, ByteString>> var1);

        @Override
        default public T decodeEvent(SocketIOEvent socketIOEvent) {
            return this.decodeArgs(socketIOEvent.arguments());
        }
    }

    public static interface EventDecoder<T> {
        public T decodeEvent(SocketIOEvent var1);

        default public <U> EventDecoder<U> map(Function<? super T, ? extends U> function) {
            return socketIOEvent -> function.apply((T)this.decodeEvent(socketIOEvent));
        }
    }
}

