/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STBlock;
import com.fortify.frontend.nst.nodes.STConditional;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.Visitor;

public class STIfElse
extends STConditional {
    private STExpression predicate;
    private STBlock ifBody;
    private STBlock elseBody;

    public STIfElse() {
    }

    public STIfElse(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    public void setPredicate(STExpression sTExpression) {
        sTExpression.setParent(this);
        this.predicate = sTExpression;
    }

    @Override
    public FList<STNode> getChildren() {
        return this.filterNullChildren(this.predicate, this.ifBody, this.elseBody);
    }

    @Override
    public STExpression getPredicate() {
        return this.predicate;
    }

    public void setIfBody(STBlock sTBlock) {
        sTBlock.setParent(this);
        this.ifBody = sTBlock;
    }

    public STBlock getIfBody() {
        return this.ifBody;
    }

    public void setElseBody(STBlock sTBlock) {
        sTBlock.setParent(this);
        this.elseBody = sTBlock;
    }

    public STBlock getElseBody() {
        return this.elseBody;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("if (").append(this.predicate).append(")");
        if (this.ifBody != null) {
            stringBuilder.append("{ ").append(this.ifBody).append(" }");
        }
        if (this.elseBody != null) {
            stringBuilder.append(" else { ").append(this.elseBody).append(" }");
        }
        return stringBuilder.toString();
    }

    @Override
    public STIfElse clone() {
        return this.clone(new STIfElse(this.getSourceInfo()));
    }

    @Override
    protected STIfElse clone(STNode sTNode) {
        STIfElse sTIfElse = (STIfElse)sTNode;
        super.clone(sTIfElse);
        if (this.elseBody != null) {
            sTIfElse.setElseBody(this.elseBody.clone());
        }
        if (this.ifBody != null) {
            sTIfElse.setIfBody(this.ifBody.clone());
        }
        if (this.predicate != null) {
            sTIfElse.setPredicate(this.predicate.clone());
        }
        return sTIfElse;
    }

    public void addIf(STNode sTNode) {
        this.ifBody.add(sTNode);
    }

    public void addElse(STNode sTNode) {
        this.elseBody.add(sTNode);
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }
}

