/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.FHashMap;
import com.ergy.fset.FHashSet;
import com.ergy.fset.FLinkedHashMap;
import com.ergy.fset.FLinkedHashSet;
import com.ergy.fset.FList;
import com.ergy.fset.FMap;
import com.ergy.fset.FSet;
import com.ergy.fset.FTreeList;
import com.ergy.fset.FTreeMap;
import com.ergy.fset.FTreeSet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TestSuite {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            TestSuite.println("Usage: java TestSuite [n_iterations]");
            TestSuite.exit();
        }
        int n = Integer.decode(stringArray[0]);
        Random random = new Random(244837814094590L);
        for (int i = 0; i < n; ++i) {
            FTreeSet<MyInteger> fTreeSet = TestSuite.testFTreeSet(random, i);
            FHashSet<MyInteger> fHashSet = TestSuite.testFHashSet(random, i);
            TestSuite.testFLinkedHashSet(random, i);
            TestSuite.testFLinkedHashMap(random, i);
            TestSuite.testFTreeMap(random, i, fTreeSet);
            TestSuite.testFHashMap(random, i, fHashSet);
            TestSuite.testFTreeList(random, i);
        }
        TestSuite.println("All tests passed.");
    }

    static FTreeSet<MyInteger> testFTreeSet(Random random, int n) {
        Object object;
        SortedSet<MyInteger> sortedSet;
        Set set;
        Object object2;
        int n2;
        FSet<MyInteger> fSet = new FTreeSet<MyInteger>(TestComparator.Instance);
        TreeSet<MyInteger> treeSet = new TreeSet<MyInteger>();
        for (int i = 0; i < 100; ++i) {
            int n3 = random.nextInt(200);
            MyInteger myInteger = new MyInteger(n3);
            FSet fSet2 = ((FTreeSet)fSet).with(myInteger);
            treeSet.add(myInteger);
            if (!((FTreeSet)fSet2).verify()) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet).dump());
                TestSuite.println("Adding " + myInteger);
                TestSuite.println(((FTreeSet)fSet2).dump());
                TestSuite.exit();
            }
            if (((FTreeSet)fSet2).size() != treeSet.size()) {
                TestSuite.println("FTreeSet size failed on iteration " + n);
                TestSuite.exit();
            }
            if (!((FTreeSet)fSet).isSubset(fSet2) || !((FTreeSet)fSet2).isSuperset(fSet) || !((FTreeSet)fSet).contains(myInteger) && (((FTreeSet)fSet2).isSubset(fSet) || ((FTreeSet)fSet).isSuperset(fSet2))) {
                TestSuite.println("FTreeSet is{Sub,Super}set failed on iteration " + n);
                TestSuite.println(((FTreeSet)fSet).isSubset(fSet2) + ", " + ((FTreeSet)fSet2).isSuperset(fSet) + ", " + ((FTreeSet)fSet).contains(myInteger) + ", " + ((FTreeSet)fSet2).isSubset(fSet) + ", " + ((FTreeSet)fSet).isSuperset(fSet2));
                TestSuite.exit();
            }
            fSet = fSet2;
        }
        FSet<MyInteger> fSet3 = new FTreeSet<MyInteger>(TestComparator.Instance);
        TreeSet<MyInteger> treeSet2 = new TreeSet<MyInteger>();
        for (n2 = 0; n2 < 100; ++n2) {
            int n4 = random.nextInt(200);
            object2 = new MyInteger(n4);
            set = ((FTreeSet)fSet3).with(object2);
            treeSet2.add((MyInteger)object2);
            if (!((FTreeSet)set).verify()) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet3).dump());
                TestSuite.println("Adding " + object2);
                TestSuite.println(((FTreeSet)set).dump());
                TestSuite.exit();
            }
            if (((FTreeSet)set).size() != treeSet2.size()) {
                TestSuite.println("FTreeSet size failed on iteration " + n);
                TestSuite.exit();
            }
            if (!((FTreeSet)fSet3).isSubset(set) || !((FTreeSet)set).isSuperset(fSet3) || !((FTreeSet)fSet3).contains(object2) && (((FTreeSet)set).isSubset(fSet3) || ((FTreeSet)fSet3).isSuperset(set))) {
                TestSuite.println("FTreeSet is{Sub,Super}set failed on iteration " + n);
                TestSuite.println(((FTreeSet)fSet3).isSubset(set) + ", " + ((FTreeSet)set).isSuperset(fSet3) + ", " + ((FTreeSet)fSet3).contains(object2) + ", " + ((FTreeSet)set).isSubset(fSet3) + ", " + ((FTreeSet)fSet3).isSuperset(set));
                TestSuite.exit();
            }
            fSet3 = set;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n5 = random.nextInt(200);
            object2 = new MyInteger(n5);
            if (((FTreeSet)fSet).contains(object2) != treeSet.contains(object2)) {
                TestSuite.println("FTreeSet contains failed (fts0) on iteration " + n);
                TestSuite.exit();
            }
            set = ((FTreeSet)fSet).less(object2);
            treeSet.remove(object2);
            if (!((FTreeSet)set).verify()) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet).dump());
                TestSuite.println("Removing " + object2);
                TestSuite.println(((FTreeSet)set).dump());
                TestSuite.exit();
            }
            if (((FTreeSet)set).size() != treeSet.size()) {
                TestSuite.println("FTreeSet size failed on iteration " + n);
                TestSuite.exit();
            }
            fSet = set;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n6 = random.nextInt(200);
            object2 = new MyInteger(n6);
            if (((FTreeSet)fSet3).contains(object2) != treeSet2.contains(object2)) {
                TestSuite.println("FTreeSet contains failed (fts1) on iteration " + n);
                TestSuite.exit();
            }
            set = ((FTreeSet)fSet3).less(object2);
            treeSet2.remove(object2);
            if (!((FTreeSet)set).verify()) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet3).dump());
                TestSuite.println("Removing " + object2);
                TestSuite.println(((FTreeSet)set).dump());
                TestSuite.exit();
            }
            if (((FTreeSet)set).size() != treeSet2.size()) {
                TestSuite.println("FTreeSet size failed on iteration " + n);
                TestSuite.exit();
            }
            fSet3 = set;
        }
        if (n == 0) {
            FSet fSet4 = ((FTreeSet)fSet).with((Object)null);
            if (!((FTreeSet)fSet4).verify() || !((FTreeSet)fSet4).contains(null) || ((FTreeSet)fSet4).first() != null) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet).dump());
                TestSuite.println("Adding null");
                TestSuite.println(((FTreeSet)fSet4).dump());
                TestSuite.exit();
            }
            if (!((FTreeSet)(fSet4 = ((FTreeSet)fSet4).less((Object)null))).verify() || ((FTreeSet)fSet4).contains(null)) {
                TestSuite.println("FTreeSet Verification failure on iteration " + n);
                TestSuite.println(((FTreeSet)fSet).dump());
                TestSuite.println("Removing null");
                TestSuite.println(((FTreeSet)fSet4).dump());
                TestSuite.exit();
            }
        }
        if (((FTreeSet)fSet).hashCode() != treeSet.hashCode()) {
            TestSuite.println("FTreeSet hashCode failed on fts0 on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(treeSet);
            TestSuite.exit();
        }
        if (((FTreeSet)fSet3).hashCode() != treeSet2.hashCode()) {
            TestSuite.println("FTreeSet hashCode failed on fts1 on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).equals(treeSet)) {
            TestSuite.println("FTreeSet Equality failed (fts0, A) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).equals(new FTreeSet(treeSet))) {
            TestSuite.println("FTreeSet Equality failed (fts0, B) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).equals(new FTreeSet<MyInteger>((Collection<MyInteger>)treeSet, (Comparator<MyInteger>)TestComparator.Instance))) {
            TestSuite.println("FTreeSet Equality failed (fts0, C) on iteration " + n);
            TestSuite.println(fSet);
            FTreeSet<MyInteger> fTreeSet = new FTreeSet<MyInteger>((Collection<MyInteger>)treeSet, (Comparator<MyInteger>)TestComparator.Instance);
            TestSuite.println(fTreeSet);
            TestSuite.println(fTreeSet.dump());
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).equals(new FTreeSet(new ArrayList(treeSet)))) {
            TestSuite.println("FTreeSet construction from ArrayList failed (fts0) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).equals(new FTreeSet((T[])treeSet.toArray(new MyInteger[0])))) {
            TestSuite.println("FTreeSet construction from array failed (fts0) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet3).equals(treeSet2)) {
            TestSuite.println("FTreeSet Equality failed (fts1, A) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet3).equals(new FTreeSet((T[])treeSet2.toArray(new MyInteger[0])))) {
            TestSuite.println("FTreeSet Equality failed (fts1, B) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet3).equals(new FTreeSet<MyInteger>(TestComparator.Instance, (T[])treeSet2.toArray(new MyInteger[0])))) {
            TestSuite.println("FTreeSet Equality failed (fts1, C) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeSet)fSet).first()).intValue() / 2 != ((MyInteger)treeSet.first()).intValue() / 2) {
            TestSuite.println("FTreeSet `first' failed (fts0) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeSet)fSet3).first()).intValue() / 2 != ((MyInteger)treeSet2.first()).intValue() / 2) {
            TestSuite.println("FTreeSet `first' failed (fts1) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeSet)fSet).last()).intValue() / 2 != ((MyInteger)treeSet.last()).intValue() / 2) {
            TestSuite.println("FTreeSet `last' failed (fts0) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeSet)fSet3).last()).intValue() / 2 != ((MyInteger)treeSet2.last()).intValue() / 2) {
            TestSuite.println("FTreeSet `last' failed (fts1) on iteration " + n);
            TestSuite.exit();
        }
        FSet fSet5 = ((FTreeSet)fSet).union(fSet3);
        TreeSet treeSet3 = (TreeSet)treeSet.clone();
        treeSet3.addAll(treeSet2);
        if (!((FTreeSet)fSet5).verify() || !((FTreeSet)fSet5).equals(treeSet3)) {
            TestSuite.println("FTreeSet Union failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(fSet3);
            if (!((FTreeSet)fSet5).verify()) {
                TestSuite.println(((FTreeSet)fSet5).dump());
            }
            TestSuite.println(((FTreeSet)fSet5).size() + ", " + treeSet3.size());
            TestSuite.println(fSet5);
            TestSuite.println(treeSet3);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet5).equals(new FTreeSet(treeSet3))) {
            TestSuite.println("FTreeSet Equality failed (ftsu) on iteration " + n);
        }
        object2 = ((FTreeSet)fSet).intersection(fSet3);
        set = (TreeSet)treeSet.clone();
        ((AbstractCollection)((Object)set)).retainAll(treeSet2);
        if (!((FTreeSet)object2).verify() || !((FTreeSet)object2).equals(set)) {
            TestSuite.println("FTreeSet Intersection failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(fSet3);
            if (!((FTreeSet)object2).verify()) {
                TestSuite.println(((FTreeSet)object2).dump());
            }
            TestSuite.println(((FTreeSet)object2).size() + ", " + ((TreeSet)set).size());
            TestSuite.println(object2);
            TestSuite.println(set);
            TestSuite.exit();
        }
        if (!((FTreeSet)object2).isSubset(fSet) || !((FTreeSet)object2).isSubset(fSet3)) {
            TestSuite.println("FTreeSet isSubset failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)object2).equals(new FTreeSet(set))) {
            TestSuite.println("FTreeSet Equality failed (ftsi) on iteration " + n);
        }
        FSet fSet6 = ((FTreeSet)fSet).difference(fSet3);
        TreeSet treeSet4 = (TreeSet)treeSet.clone();
        treeSet4.removeAll(treeSet2);
        if (!((FTreeSet)fSet6).verify() || !((FTreeSet)fSet6).equals(treeSet4)) {
            TestSuite.println("FTreeSet Difference failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(((FTreeSet)fSet).dump());
            TestSuite.println(fSet3);
            TestSuite.println(((FTreeSet)fSet3).dump());
            TestSuite.println(((FTreeSet)fSet6).size() + ", " + treeSet4.size());
            TestSuite.println(fSet6);
            TestSuite.println(((FTreeSet)fSet6).dump());
            TestSuite.println(treeSet4);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet6).equals(new FTreeSet(treeSet4))) {
            TestSuite.println("FTreeSet Equality failed (ftsd) on iteration " + n);
        }
        FSet<MyInteger> fSet7 = new FTreeSet<MyInteger>((Collection<MyInteger>)fSet, (Comparator<MyInteger>)TestComparator.Instance);
        fSet7 = ((FTreeSet)fSet7).less(TestSuite.pick(random, fSet7));
        FSet fSet8 = ((FTreeSet)fSet).less(TestSuite.pick(random, fSet));
        if (TestSuite.sgn(((FTreeSet)fSet8).compareTo(fSet7)) != TestSuite.compare(fSet8, fSet7)) {
            TestSuite.println("FTreeSet Compare failed (fts0) on iteration " + n);
            TestSuite.println(((FTreeSet)fSet8).dump());
            TestSuite.println(((FTreeSet)fSet7).dump());
            TestSuite.println(fSet8);
            TestSuite.println(fSet7);
            TestSuite.println(((FTreeSet)fSet8).compareTo(fSet7));
            TestSuite.println(TestSuite.compare(fSet8, fSet7));
            TestSuite.exit();
        }
        if (((FTreeSet)fSet8).equals(fSet7) != TestSuite.equals(fSet8, fSet7)) {
            TestSuite.println("FTreeSet equality failed (fts0a) on iteration " + n);
            TestSuite.exit();
        }
        FSet<MyInteger> fSet9 = new FTreeSet<MyInteger>((Collection<MyInteger>)fSet3, (Comparator<MyInteger>)TestComparator.Instance);
        fSet9 = ((FTreeSet)fSet9).less(TestSuite.pick(random, fSet9));
        FSet fSet10 = ((FTreeSet)fSet3).less(TestSuite.pick(random, fSet3));
        if (TestSuite.sgn(((FTreeSet)fSet10).compareTo(fSet9)) != TestSuite.compare(fSet10, fSet9)) {
            TestSuite.println("FTreeSet Compare failed (fts1) on iteration " + n);
            TestSuite.println(((FTreeSet)fSet10).dump());
            TestSuite.println(((FTreeSet)fSet9).dump());
            TestSuite.println(((FTreeSet)fSet10).compareTo(fSet9));
            TestSuite.println(TestSuite.compare(fSet10, fSet9));
            TestSuite.exit();
        }
        if (((FTreeSet)fSet10).equals(fSet9) != TestSuite.equals(fSet10, fSet9)) {
            TestSuite.println("FTreeSet equality failed (fts1a) on iteration " + n);
            TestSuite.exit();
        }
        int n7 = random.nextInt(150) - 25;
        int n8 = random.nextInt(125 - n7) + n7;
        MyInteger myInteger = new MyInteger(n7 *= 2);
        MyInteger myInteger2 = new MyInteger(n8 *= 2);
        SortedSet<MyInteger> sortedSet2 = ((FTreeSet)fSet).subSet(myInteger, myInteger2);
        if (!sortedSet2.equals(sortedSet = treeSet.subSet(myInteger, myInteger2))) {
            TestSuite.println("FTreeSet subSet failed on iteration " + n);
            TestSuite.println("[" + n7 + ", " + n8 + ")");
            TestSuite.println(sortedSet2);
            TestSuite.println(sortedSet);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).headSet(myInteger2).equals(treeSet.headSet(myInteger2))) {
            TestSuite.println("FTreeSet headSet failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeSet)fSet).tailSet(myInteger).equals(treeSet.tailSet(myInteger))) {
            TestSuite.println("FTreeSet tailSet failed on iteration " + n);
            TestSuite.exit();
        }
        while (!((FTreeSet)fSet).isEmpty()) {
            object = (MyInteger)((FTreeSet)fSet).arb();
            if (!((FTreeSet)fSet).contains(object) || !treeSet.contains(object)) {
                TestSuite.println("FTreeSet arb/contains failed on iteration " + n);
                TestSuite.exit();
            }
            fSet = ((FTreeSet)fSet).less(object);
            treeSet.remove(object);
            if (treeSet.isEmpty() == ((FTreeSet)fSet).isEmpty()) continue;
            TestSuite.println("FTreeSet less/isEmpty failed on iteration " + n);
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                object = n == 0 ? fSet : fSet3;
                FileOutputStream fileOutputStream = new FileOutputStream("fts.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("fts.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FSet fSet11 = (FSet)objectInputStream.readObject();
                objectInputStream.close();
                if (!object.equals(fSet11) || object.hashCode() != fSet11.hashCode()) {
                    TestSuite.println("FTreeSet read/write failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FTreeSet read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FTreeSet read/write: exception " + classNotFoundException);
            }
        }
        return fSet3;
    }

    static FHashSet<MyInteger> testFHashSet(Random random, int n) {
        Object object;
        Set set;
        Object object2;
        int n2;
        FSet<MyInteger> fSet = new FHashSet();
        HashSet<MyInteger> hashSet = new HashSet<MyInteger>();
        for (int i = 0; i < 100; ++i) {
            int n3 = random.nextInt(200);
            MyInteger myInteger = n3 == 57 ? null : new MyInteger(n3);
            FSet fSet2 = ((FHashSet)fSet).with(myInteger);
            hashSet.add(myInteger);
            if (!((FHashSet)fSet2).verify()) {
                TestSuite.println("FHashSet Verification failure on iteration " + n);
                TestSuite.println(((FHashSet)fSet).dump());
                TestSuite.println("Adding " + (myInteger == null ? "null" : "" + myInteger));
                TestSuite.println(((FHashSet)fSet2).dump());
                TestSuite.exit();
            }
            if (((FHashSet)fSet2).hashCode() != hashSet.hashCode()) {
                TestSuite.println("FHashSet hashCode failed on fhs0 on iteration " + n);
                TestSuite.println(fSet2);
                TestSuite.println(hashSet);
                TestSuite.println("Adding " + myInteger + "; " + ((FHashSet)fSet2).hashCode() + ", " + hashSet.hashCode());
                TestSuite.exit();
            }
            if (!((FHashSet)fSet).isSubset(fSet2) || !((FHashSet)fSet2).isSuperset(fSet) || !((FHashSet)fSet).contains(myInteger) && (((FHashSet)fSet2).isSubset(fSet) || ((FHashSet)fSet).isSuperset(fSet2))) {
                TestSuite.println("FHashSet is{Sub,Super}set failed (fhs0) on iteration " + n);
                TestSuite.println(((FHashSet)fSet).isSubset(fSet2) + ", " + ((FHashSet)fSet2).isSuperset(fSet) + ", " + ((FHashSet)fSet).contains(myInteger) + ", " + ((FHashSet)fSet2).isSubset(fSet) + ", " + ((FHashSet)fSet).isSuperset(fSet2) + "; " + myInteger);
                TestSuite.println(fSet);
                TestSuite.println(fSet2);
                TestSuite.exit();
            }
            fSet = fSet2;
        }
        FSet<MyInteger> fSet3 = new FHashSet();
        HashSet<MyInteger> hashSet2 = new HashSet<MyInteger>();
        for (n2 = 0; n2 < 100; ++n2) {
            int n4 = random.nextInt(200);
            object2 = n4 == 57 ? null : new MyInteger(n4);
            set = ((FHashSet)fSet3).with(object2);
            hashSet2.add((MyInteger)object2);
            if (!((FHashSet)set).verify()) {
                TestSuite.println("FHashSet Verification failure on iteration " + n);
                TestSuite.println(((FHashSet)fSet3).dump());
                TestSuite.println("Adding " + object2);
                TestSuite.println(((FHashSet)set).dump());
                TestSuite.exit();
            }
            if (((FHashSet)set).hashCode() != hashSet2.hashCode()) {
                TestSuite.println("FHashSet hashCode failed on fhs1 on iteration " + n);
                TestSuite.println(set);
                TestSuite.println(hashSet2);
                TestSuite.println("Adding " + object2 + "; " + ((FHashSet)set).hashCode() + ", " + hashSet2.hashCode());
                TestSuite.exit();
            }
            if (!((FHashSet)fSet3).isSubset(set) || !((FHashSet)set).isSuperset(fSet3) || !((FHashSet)fSet3).contains(object2) && (((FHashSet)set).isSubset(fSet3) || ((FHashSet)fSet3).isSuperset(set))) {
                TestSuite.println("FHashSet is{Sub,Super}set failed (fhs1) on iteration " + n);
                TestSuite.println(((FHashSet)fSet3).isSubset(set) + ", " + ((FHashSet)set).isSuperset(fSet3) + ", " + ((FHashSet)fSet3).contains(object2) + ", " + ((FHashSet)set).isSubset(fSet3) + ", " + ((FHashSet)fSet3).isSuperset(set) + "; " + object2);
                TestSuite.println(fSet3);
                TestSuite.println(set);
                TestSuite.exit();
            }
            fSet3 = set;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n5 = random.nextInt(200);
            object2 = n5 == 57 ? null : new MyInteger(n5);
            set = ((FHashSet)fSet).less(object2);
            hashSet.remove(object2);
            if (!((FHashSet)set).verify()) {
                TestSuite.println("FHashSet Verification failure on iteration " + n);
                TestSuite.println(((FHashSet)fSet).dump());
                TestSuite.println("Removing " + (object2 == null ? "null" : "" + object2));
                TestSuite.println(((FHashSet)set).dump());
                TestSuite.exit();
            }
            fSet = set;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n6 = random.nextInt(200);
            object2 = n6 == 57 ? null : new MyInteger(n6);
            set = ((FHashSet)fSet3).less(object2);
            hashSet2.remove(object2);
            if (!((FHashSet)set).verify()) {
                TestSuite.println("FHashSet Verification failure on iteration " + n);
                TestSuite.println(((FHashSet)fSet3).dump());
                TestSuite.println("Removing " + (object2 == null ? "null" : "" + object2));
                TestSuite.println(((FHashSet)set).dump());
                TestSuite.exit();
            }
            if (((FHashSet)set).hashCode() != hashSet2.hashCode()) {
                TestSuite.println("FHashSet hashCode failed on fhs1 on iteration " + n);
                TestSuite.println(set);
                TestSuite.println(hashSet2);
                TestSuite.println("Removing " + object2 + "; " + ((FHashSet)set).hashCode() + ", " + hashSet2.hashCode());
                TestSuite.exit();
            }
            if (!((FHashSet)set).equals(hashSet2)) {
                TestSuite.println("FHashSet equality failed on fhs1 on iteration " + n);
                TestSuite.println(set);
                TestSuite.println(hashSet2);
                TestSuite.println(new FHashSet(hashSet2));
                TestSuite.println("Removing " + object2 + "; " + ((FHashSet)set).hashCode() + ", " + hashSet2.hashCode());
                TestSuite.exit();
            }
            fSet3 = set;
        }
        if (((FHashSet)fSet).hashCode() != hashSet.hashCode()) {
            TestSuite.println("FHashSet hashCode failed on fhs0 on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(hashSet);
            TestSuite.exit();
        }
        if (((FHashSet)fSet3).hashCode() != hashSet2.hashCode()) {
            TestSuite.println("FHashSet hashCode failed on fhs1 on iteration " + n);
            TestSuite.exit();
        }
        if (!((FHashSet)fSet).equals(hashSet)) {
            TestSuite.println("FHashSet Equality failed (fhs0, A) on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(((FHashSet)fSet).dump());
            TestSuite.println(new TreeSet(hashSet));
            TestSuite.exit();
        }
        if (!((FHashSet)fSet).equals(new FHashSet(hashSet))) {
            TestSuite.println("FHashSet Equality failed (fhs0, B) on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(((FHashSet)fSet).dump());
            FHashSet fHashSet = new FHashSet(hashSet);
            TestSuite.println(fHashSet);
            TestSuite.println(fHashSet.dump());
            TestSuite.exit();
        }
        if (!((FHashSet)fSet).equals(new FHashSet(new ArrayList(hashSet)))) {
            TestSuite.println("FHashSet construction from ArrayList failed (fhs0) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FHashSet)fSet).equals(new FHashSet((T[])hashSet.toArray(new MyInteger[0])))) {
            TestSuite.println("FHashSet construction from array failed (fhs0) on iteration " + n);
            TestSuite.exit();
        }
        if (!((FHashSet)fSet3).equals(hashSet2)) {
            TestSuite.println("FHashSet Equality failed (fhs1, A) on iteration " + n);
            TestSuite.println(fSet3);
            TestSuite.println(hashSet2);
            TestSuite.println(new FHashSet(hashSet2));
            TestSuite.exit();
        }
        if (!((FHashSet)fSet3).equals(new FHashSet((T[])hashSet2.toArray(new MyInteger[0])))) {
            TestSuite.println("FHashSet Equality failed (fhs1, B) on iteration " + n);
            TestSuite.exit();
        }
        FSet fSet4 = ((FHashSet)fSet).union(fSet3);
        HashSet hashSet3 = (HashSet)hashSet.clone();
        hashSet3.addAll(hashSet2);
        if (!((FHashSet)fSet4).verify() || !((FHashSet)fSet4).equals(hashSet3)) {
            TestSuite.println("FHashSet Union failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(fSet3);
            if (!((FHashSet)fSet4).verify()) {
                TestSuite.println(((FHashSet)fSet4).dump());
            }
            TestSuite.println(((FHashSet)fSet4).size() + ", " + hashSet3.size());
            TestSuite.println(fSet4);
            TestSuite.println(hashSet3);
            TestSuite.exit();
        }
        if (!((FHashSet)fSet4).equals(new FHashSet(hashSet3))) {
            TestSuite.println("FHashSet Equality failed (fhsu) on iteration " + n);
        }
        object2 = ((FHashSet)fSet).intersection(fSet3);
        set = (HashSet)hashSet.clone();
        ((AbstractCollection)((Object)set)).retainAll(hashSet2);
        if (!((FHashSet)object2).verify() || !((FHashSet)object2).equals(set)) {
            TestSuite.println("FHashSet Intersection failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(((FHashSet)fSet).dump());
            TestSuite.println(fSet3);
            TestSuite.println(((FHashSet)fSet3).dump());
            if (!((FHashSet)object2).verify()) {
                TestSuite.println(((FHashSet)object2).dump());
            }
            TestSuite.println(((FHashSet)object2).size() + ", " + ((HashSet)set).size());
            TestSuite.println(object2);
            TestSuite.println(new TreeSet(set));
            TestSuite.exit();
        }
        if (!((FHashSet)object2).isSubset(fSet) || !((FHashSet)object2).isSubset(fSet3)) {
            TestSuite.println("FHashSet isSubset failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FHashSet)object2).equals(new FHashSet(set))) {
            TestSuite.println("FHashSet Equality failed (fhsi) on iteration " + n);
        }
        FSet fSet5 = ((FHashSet)fSet).difference(fSet3);
        HashSet hashSet4 = (HashSet)hashSet.clone();
        hashSet4.removeAll(hashSet2);
        if (!((FHashSet)fSet5).verify() || !((FHashSet)fSet5).equals(hashSet4)) {
            TestSuite.println("FHashSet Difference failed on iteration " + n);
            TestSuite.println(fSet);
            TestSuite.println(((FHashSet)fSet).dump());
            TestSuite.println(fSet3);
            TestSuite.println(((FHashSet)fSet3).dump());
            TestSuite.println(((FHashSet)fSet5).size() + ", " + hashSet4.size());
            TestSuite.println(fSet5);
            TestSuite.println(((FHashSet)fSet5).dump());
            TestSuite.println(hashSet4);
            TestSuite.exit();
        }
        if (!((FHashSet)fSet5).equals(new FHashSet(hashSet4))) {
            TestSuite.println("FHashSet Equality failed (fhsd) on iteration " + n);
        }
        FSet<MyInteger> fSet6 = new FHashSet<MyInteger>((Collection<MyInteger>)fSet);
        fSet6 = ((FHashSet)fSet6).less(TestSuite.pick(random, fSet6));
        FSet fSet7 = ((FHashSet)fSet).less(TestSuite.pick(random, fSet));
        if (TestSuite.sgn(((FHashSet)fSet7).compareTo(fSet6)) != TestSuite.compare(fSet7, fSet6)) {
            TestSuite.println("FHashSet Compare failed (fhs0) on iteration " + n);
            TestSuite.println(((FHashSet)fSet7).compareTo(fSet6) + ", " + TestSuite.compare(fSet7, fSet6));
            TestSuite.println(fSet7);
            TestSuite.println(((FHashSet)fSet7).dump());
            TestSuite.println(fSet6);
            TestSuite.println(((FHashSet)fSet6).dump());
            TestSuite.exit();
        }
        if (((FHashSet)fSet7).equals(fSet6) != TestSuite.equals(fSet7, fSet6)) {
            TestSuite.println("FHashSet equality failed (fhs0a) on iteration " + n);
            TestSuite.exit();
        }
        FSet<MyInteger> fSet8 = new FHashSet<MyInteger>((Collection<MyInteger>)fSet3);
        fSet8 = fSet8.less((Object)TestSuite.pick(random, fSet8));
        FSet fSet9 = ((FHashSet)fSet3).less(TestSuite.pick(random, fSet3));
        if (TestSuite.sgn(((FHashSet)fSet9).compareTo(fSet8)) != TestSuite.compare(fSet9, fSet8)) {
            TestSuite.println("FHashSet Compare failed (fhs1) on iteration " + n);
            TestSuite.exit();
        }
        if (((FHashSet)fSet9).equals(fSet8) != TestSuite.equals(fSet9, fSet8)) {
            TestSuite.println("FHashSet equality failed (fhs1a) on iteration " + n);
            TestSuite.exit();
        }
        while (!((FHashSet)fSet).isEmpty()) {
            object = (MyInteger)((FHashSet)fSet).arb();
            if (!((FHashSet)fSet).contains(object) || !hashSet.contains(object)) {
                TestSuite.println("FHashSet arb/contains failed on iteration " + n);
                TestSuite.exit();
            }
            fSet = ((FHashSet)fSet).less(object);
            hashSet.remove(object);
            if (hashSet.isEmpty() == ((FHashSet)fSet).isEmpty()) continue;
            TestSuite.println("FHashSet less/isEmpty failed on iteration " + n);
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                object = n == 0 ? fSet : fSet3;
                FileOutputStream fileOutputStream = new FileOutputStream("fhs.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("fhs.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FSet fSet10 = (FSet)objectInputStream.readObject();
                objectInputStream.close();
                if (!object.equals(fSet10) || object.hashCode() != fSet10.hashCode()) {
                    TestSuite.println("FHashSet read/write failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FHashSet read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FHashSet read/write: exception " + classNotFoundException);
            }
        }
        return fSet3;
    }

    static void testFLinkedHashSet(Random random, int n) {
        FSet fSet = new FLinkedHashSet();
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            int n2 = random.nextInt(200);
            fSet = ((FLinkedHashSet)fSet).with((Object)n2);
            linkedHashSet.add(n2);
        }
        if (((FLinkedHashSet)fSet).size() != linkedHashSet.size()) {
            TestSuite.println("FLinkedHashSet size failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FLinkedHashSet)fSet).equals(linkedHashSet)) {
            TestSuite.println("FLinkedHashSet equals failed on iteration " + n);
            TestSuite.exit();
        }
        Iterator iterator = ((FLinkedHashSet)fSet).iterator();
        Iterator iterator2 = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && ((Integer)iterator.next()).equals(iterator2.next())) continue;
            TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
            TestSuite.exit();
        }
        if (iterator2.hasNext()) {
            TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
            TestSuite.exit();
        }
        FSet fSet2 = new FLinkedHashSet();
        LinkedHashSet<Integer> linkedHashSet2 = new LinkedHashSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            int n3 = random.nextInt(200);
            fSet2 = fSet2.with((Object)n3);
            linkedHashSet2.add(n3);
        }
        fSet = ((FLinkedHashSet)fSet).union((Collection)fSet2);
        linkedHashSet.addAll(linkedHashSet2);
        if (!((FLinkedHashSet)fSet).equals(linkedHashSet)) {
            TestSuite.println("FLinkedHashSet equals failed on iteration " + n);
            TestSuite.exit();
        }
        iterator = ((FLinkedHashSet)fSet).iterator();
        iterator2 = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && ((Integer)iterator.next()).equals(iterator2.next())) continue;
            TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
            TestSuite.exit();
        }
        if (iterator2.hasNext()) {
            TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                FSet fSet3 = fSet;
                FileOutputStream fileOutputStream = new FileOutputStream("flhs.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(fSet3);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("flhs.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FSet fSet4 = (FSet)objectInputStream.readObject();
                objectInputStream.close();
                if (!fSet3.equals(fSet4) || fSet3.hashCode() != fSet4.hashCode()) {
                    TestSuite.println("FLinkedHashSet read/write failed on iteration " + n);
                    TestSuite.exit();
                }
                iterator = ((FLinkedHashSet)fSet).iterator();
                iterator2 = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator2.hasNext() && ((Integer)iterator.next()).equals(iterator2.next())) continue;
                    TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
                    TestSuite.exit();
                }
                if (iterator2.hasNext()) {
                    TestSuite.println("FLinkedHashSet ordering failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FLinkedHashSet read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FLinkedHashSet read/write: exception " + classNotFoundException);
            }
        }
    }

    static void testFTreeMap(Random random, int n, FTreeSet<MyInteger> fTreeSet) {
        SortedMap sortedMap;
        FMap fMap;
        FSet fSet;
        FMap fMap2;
        FMap fMap3;
        FMap fMap4;
        Object object;
        Object object2;
        int n2;
        Object object3 = new FTreeMap(TestComparator.Instance);
        TreeMap<MyInteger, MyInteger> treeMap = new TreeMap<MyInteger, MyInteger>();
        for (int i = 0; i < 100; ++i) {
            int n3 = random.nextInt(200);
            n2 = random.nextInt(3);
            MyInteger myInteger = new MyInteger(n3);
            MyInteger myInteger2 = new MyInteger(n2);
            object2 = ((FTreeMap)object3).with(myInteger, myInteger2);
            treeMap.put(myInteger, myInteger2);
            if (!((FTreeMap)object2).verify()) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Adding " + myInteger + ", " + myInteger2);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.exit();
            }
            if (((FTreeMap)object2).hashCode() != treeMap.hashCode()) {
                TestSuite.println("FTreeMap hashCode failed on ftm0 on iteration " + n);
                TestSuite.println(object3);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Adding " + n3 + " -> " + n2);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.println(treeMap);
                TestSuite.exit();
            }
            object3 = object2;
        }
        Object object4 = new FTreeMap(TestComparator.Instance);
        TreeMap<Object, MyInteger> treeMap2 = new TreeMap<Object, MyInteger>();
        for (n2 = 0; n2 < 100; ++n2) {
            int n4 = random.nextInt(200);
            int n5 = random.nextInt(3);
            object2 = new MyInteger(n4);
            object = new MyInteger(n5);
            fMap4 = ((FTreeMap)object4).with(object2, object);
            treeMap2.put(object2, (MyInteger)object);
            if (!((FTreeMap)fMap4).verify()) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object4).dump());
                TestSuite.println("Adding " + object2 + ", " + object);
                TestSuite.println(((FTreeMap)fMap4).dump());
                TestSuite.exit();
            }
            if (((FTreeMap)fMap4).hashCode() != treeMap2.hashCode()) {
                TestSuite.println("FTreeMap hashCode failed on ftm1 on iteration " + n);
                TestSuite.println(object4);
                TestSuite.println(((FTreeMap)object4).dump());
                TestSuite.println("Adding " + n4 + " -> " + n5);
                TestSuite.println(((FTreeMap)fMap4).dump());
                TestSuite.println(treeMap2);
                TestSuite.exit();
            }
            object4 = fMap4;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n6 = random.nextInt(200);
            MyInteger myInteger = new MyInteger(n6);
            if (!TestSuite.equals(((FTreeMap)object3).get(myInteger), treeMap.get(myInteger))) {
                TestSuite.println("FTreeMap get (ftm0) failed on iteration " + n);
                TestSuite.exit();
            }
            object2 = ((FTreeMap)object3).less(myInteger);
            treeMap.remove(myInteger);
            if (!((FTreeMap)object2).verify()) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Removing " + myInteger);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.exit();
            }
            if (((FTreeMap)object2).hashCode() != treeMap.hashCode()) {
                TestSuite.println("FTreeMap hashCode failed on ftm0 on iteration " + n);
                TestSuite.println(object3);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Removing " + n6);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.println(treeMap);
                TestSuite.exit();
            }
            object3 = object2;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n7 = random.nextInt(200);
            MyInteger myInteger = new MyInteger(n7);
            if (!TestSuite.equals(((FTreeMap)object4).get(myInteger), treeMap2.get(myInteger))) {
                TestSuite.println("FTreeMap get failed (ftm1) on iteration " + n);
                TestSuite.exit();
            }
            object2 = ((FTreeMap)object4).less(myInteger);
            treeMap2.remove(myInteger);
            if (!((FTreeMap)object2).verify()) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object4).dump());
                TestSuite.println("Removing " + myInteger);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.exit();
            }
            if (((FTreeMap)object2).hashCode() != treeMap2.hashCode()) {
                TestSuite.println("FTreeMap hashCode failed on ftm1 on iteration " + n);
                TestSuite.println(object4);
                TestSuite.println(((FTreeMap)object4).dump());
                TestSuite.println("Removing " + n7);
                TestSuite.println(((FTreeMap)object2).dump());
                TestSuite.println(treeMap2);
                TestSuite.exit();
            }
            object4 = object2;
        }
        if (n == 0) {
            FMap fMap5 = ((FTreeMap)object3).with((Object)null, (Object)null);
            if (!((FTreeMap)fMap5).verify() || !((FTreeMap)fMap5).containsKey(null) || ((FTreeMap)fMap5).firstKey() != null) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Adding null");
                TestSuite.println(((FTreeMap)fMap5).dump());
                TestSuite.exit();
            }
            if (!((FTreeMap)(fMap5 = ((FTreeMap)fMap5).less((Object)null))).verify() || ((FTreeMap)fMap5).containsKey(null)) {
                TestSuite.println("FTreeMap Verification failure on iteration " + n);
                TestSuite.println(((FTreeMap)object3).dump());
                TestSuite.println("Removing null");
                TestSuite.println(((FTreeMap)fMap5).dump());
                TestSuite.exit();
            }
        }
        if (((FTreeMap)object3).hashCode() != treeMap.hashCode()) {
            TestSuite.println("FTreeMap hashCode failed on ftm0 on iteration " + n);
            TestSuite.println(object3);
            TestSuite.println(treeMap);
            TestSuite.exit();
        }
        if (((FTreeMap)object4).hashCode() != treeMap2.hashCode()) {
            TestSuite.println("FTreeMap hashCode failed on ftm1 on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeMap)object3).equals(treeMap)) {
            TestSuite.println("FTreeMap Equality failed (ftm0, A) on iteration " + n);
            TestSuite.println(((FTreeMap)object3).dump());
            TestSuite.println(treeMap);
            TestSuite.exit();
        }
        if (!((FTreeMap)object3).equals(new FTreeMap(treeMap))) {
            TestSuite.println("FTreeMap Equality failed (ftm0, B) on iteration " + n);
            TestSuite.println(((FTreeMap)object3).dump());
            TestSuite.println(treeMap);
            TestSuite.exit();
        }
        if (!((FTreeMap)object3).equals(new FTreeMap(treeMap, TestComparator.Instance))) {
            TestSuite.println("FTreeMap Equality failed (ftm0, C) on iteration " + n);
            TestSuite.println(((FTreeMap)object3).dump());
            TestSuite.println(treeMap);
            TestSuite.exit();
        }
        if (!((FTreeMap)object4).equals(treeMap2)) {
            TestSuite.println("FTreeMap Equality failed (ftm1, A) on iteration " + n);
            TestSuite.println(((FTreeMap)object4).dump());
            TestSuite.println(treeMap2);
            TestSuite.exit();
        }
        if (!((FTreeMap)object4).equals(new FTreeMap(treeMap2))) {
            TestSuite.println("FTreeMap Equality failed (ftm1, B) on iteration " + n);
            TestSuite.println(((FTreeMap)object4).dump());
            TestSuite.exit();
        }
        if (!((FTreeMap)object4).equals(new FTreeMap(treeMap2, TestComparator.Instance))) {
            TestSuite.println("FTreeMap Equality failed (ftm1, C) on iteration " + n);
            TestSuite.println(((FTreeMap)object4).dump());
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeMap)object3).firstKey()).intValue() / 2 != ((MyInteger)treeMap.firstKey()).intValue() / 2) {
            TestSuite.println("FTreeMap `firstKey' failed (ftm0) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeMap)object4).firstKey()).intValue() / 2 != ((MyInteger)treeMap2.firstKey()).intValue() / 2) {
            TestSuite.println("FTreeMap `firstKey' failed (ftm1) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeMap)object3).lastKey()).intValue() / 2 != ((MyInteger)treeMap.lastKey()).intValue() / 2) {
            TestSuite.println("FTreeMap `lastKey' failed (ftm0) on iteration " + n);
            TestSuite.exit();
        }
        if (((MyInteger)((FTreeMap)object4).lastKey()).intValue() / 2 != ((MyInteger)treeMap2.lastKey()).intValue() / 2) {
            TestSuite.println("FTreeMap `lastKey' failed (ftm1) on iteration " + n);
            TestSuite.exit();
        }
        FMap fMap6 = ((FTreeMap)object3).union((FMap)object4);
        TreeMap treeMap3 = (TreeMap)treeMap.clone();
        treeMap3.putAll(treeMap2);
        if (!((FTreeMap)fMap6).verify() || !((FTreeMap)fMap6).equals(treeMap3)) {
            TestSuite.println("FTreeMap Union failed on iteration " + n);
            TestSuite.println(object3);
            TestSuite.println(((FTreeMap)object3).dump());
            TestSuite.println(object4);
            TestSuite.println(((FTreeMap)object4).dump());
            TestSuite.println(((FTreeMap)fMap6).size() + ", " + treeMap3.size());
            TestSuite.println(fMap6);
            TestSuite.println(((FTreeMap)fMap6).dump());
            TestSuite.println(treeMap3);
            TestSuite.exit();
        }
        if (!((FTreeMap)fMap6).equals(new FTreeMap(treeMap3))) {
            TestSuite.println("FTreeMap Equality failed (ftmm) on iteration " + n);
            TestSuite.exit();
        }
        FMap fMap7 = ((FTreeMap)object3).restrictedTo(fTreeSet);
        object2 = (TreeMap)treeMap.clone();
        object = ((TreeMap)object2).keySet().iterator();
        while (object.hasNext()) {
            fMap4 = object.next();
            if (fTreeSet.contains(fMap4)) continue;
            object.remove();
        }
        if (!((FTreeMap)fMap7).verify() || !((FTreeMap)fMap7).equals(object2)) {
            TestSuite.println("FTreeMap restrictedTo failed on iteration " + n);
            TestSuite.exit();
        }
        fMap7 = ((FTreeMap)object3).restrictedFrom(fTreeSet);
        object2 = (TreeMap)treeMap.clone();
        object = ((TreeMap)object2).keySet().iterator();
        while (object.hasNext()) {
            fMap4 = object.next();
            if (!fTreeSet.contains(fMap4)) continue;
            object.remove();
        }
        if (!((FTreeMap)fMap7).verify() || !((FTreeMap)fMap7).equals(object2)) {
            TestSuite.println("FTreeMap restrictedFrom failed on iteration " + n);
            TestSuite.exit();
        }
        if (TestSuite.sgn(((FTreeMap)(fMap4 = ((FTreeMap)((FTreeMap)(object3 = ((FTreeMap)object3).less((Object)null))).less(TestSuite.pick(random, (FSet<MyInteger>)(object = ((FTreeMap)object3).domain())))).with(TestSuite.pick(random, (FSet<MyInteger>)object), new MyInteger(random.nextInt(3))))).compareTo(fMap3 = ((FTreeMap)((FTreeMap)object3).less(TestSuite.pick(random, (FSet<MyInteger>)object))).with(TestSuite.pick(random, (FSet<MyInteger>)object), new MyInteger(random.nextInt(3))))) != TestSuite.compare(fMap4, fMap3)) {
            TestSuite.println("FTreeMap Compare failed (ftm0) on iteration " + n);
            TestSuite.println(((FTreeMap)fMap4).dump());
            TestSuite.println(((FTreeMap)fMap3).dump());
            TestSuite.println(fMap4);
            TestSuite.println(fMap3);
            TestSuite.println(((FTreeMap)fMap4).compareTo((FTreeMap<MyInteger, MyInteger>)fMap3));
            TestSuite.println(TestSuite.compare(fMap4, fMap3));
            TestSuite.exit();
        }
        if (TestSuite.sgn(((FTreeMap)(fMap2 = ((FTreeMap)((FTreeMap)(object4 = ((FTreeMap)object4).less((Object)null))).less(TestSuite.pick(random, fSet = ((FTreeMap)object4).domain()))).with(TestSuite.pick(random, fSet), new MyInteger(random.nextInt(3))))).compareTo(fMap = ((FTreeMap)((FTreeMap)object4).less(TestSuite.pick(random, fSet))).with(TestSuite.pick(random, fSet), new MyInteger(random.nextInt(3))))) != TestSuite.compare(fMap2, fMap)) {
            TestSuite.println("FTreeMap Compare failed (ftm1) on iteration " + n);
            TestSuite.println(((FTreeMap)fMap2).dump());
            TestSuite.println(((FTreeMap)fMap).dump());
            TestSuite.println(fMap2);
            TestSuite.println(fMap);
            TestSuite.println(((FTreeMap)fMap2).compareTo(fMap));
            TestSuite.println(TestSuite.compare(fMap2, fMap));
            TestSuite.exit();
        }
        int n8 = random.nextInt(150) - 25;
        int n9 = random.nextInt(125 - n8) + n8;
        MyInteger myInteger = new MyInteger(n8 *= 2);
        MyInteger myInteger3 = new MyInteger(n9 *= 2);
        SortedMap sortedMap2 = ((FTreeMap)object3).subMap(myInteger, myInteger3);
        if (!sortedMap2.equals(sortedMap = treeMap.subMap(myInteger, myInteger3))) {
            TestSuite.println("FTreeMap subMap failed on iteration " + n);
            TestSuite.println("[" + n8 + ", " + n9 + ")");
            TestSuite.println(sortedMap2);
            TestSuite.println(sortedMap);
            TestSuite.exit();
        }
        if (!((FTreeMap)object3).headMap(myInteger3).equals(treeMap.headMap(myInteger3))) {
            TestSuite.println("FTreeMap headMap failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeMap)object3).tailMap(myInteger).equals(treeMap.tailMap(myInteger))) {
            TestSuite.println("FTreeMap tailMap failed on iteration " + n);
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                Object object5 = n == 0 ? new FTreeMap(TestComparator.Instance) : object3;
                FileOutputStream fileOutputStream = new FileOutputStream("ftm.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object5);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("ftm.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FMap fMap8 = (FMap)objectInputStream.readObject();
                objectInputStream.close();
                if (!object5.equals(fMap8) || object5.hashCode() != fMap8.hashCode()) {
                    TestSuite.println("FTreeMap read/write failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FTreeMap read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FTreeMap read/write: exception " + classNotFoundException);
            }
        }
    }

    static void testFHashMap(Random random, int n, FHashSet<MyInteger> fHashSet) {
        FMap fMap;
        FSet fSet;
        FMap fMap2;
        FMap fMap3;
        FMap fMap4;
        Object object;
        Object object2;
        int n2;
        Object object3 = new FHashMap();
        HashMap<MyInteger, MyInteger> hashMap = new HashMap<MyInteger, MyInteger>();
        for (int i = 0; i < 100; ++i) {
            int n3 = random.nextInt(200);
            n2 = random.nextInt(3);
            MyInteger myInteger = n3 == 57 ? null : new MyInteger(n3);
            MyInteger myInteger2 = new MyInteger(n2);
            object2 = ((FHashMap)object3).with(myInteger, myInteger2);
            hashMap.put(myInteger, myInteger2);
            if (!((FHashMap)object2).verify()) {
                TestSuite.println("FHashMap Verification failure on iteration " + n);
                TestSuite.println(((FHashMap)object3).dump());
                TestSuite.println("Adding " + myInteger + ", " + myInteger2);
                TestSuite.println(((FHashMap)object2).dump());
                TestSuite.exit();
            }
            object3 = object2;
        }
        Object object4 = new FHashMap();
        HashMap<Object, MyInteger> hashMap2 = new HashMap<Object, MyInteger>();
        for (n2 = 0; n2 < 100; ++n2) {
            int n4 = random.nextInt(200);
            int n5 = random.nextInt(3);
            object2 = n4 == 57 ? null : new MyInteger(n4);
            object = new MyInteger(n5);
            fMap4 = ((FHashMap)object4).with(object2, object);
            hashMap2.put(object2, (MyInteger)object);
            if (!((FHashMap)fMap4).verify()) {
                TestSuite.println("FHashMap Verification failure on iteration " + n);
                TestSuite.println(((FHashMap)object4).dump());
                TestSuite.println("Adding " + object2 + ", " + object);
                TestSuite.println(((FHashMap)fMap4).dump());
                TestSuite.exit();
            }
            object4 = fMap4;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n6 = random.nextInt(200);
            MyInteger myInteger = n6 == 57 ? null : new MyInteger(n6);
            object2 = ((FHashMap)object3).less(myInteger);
            hashMap.remove(myInteger);
            if (!((FHashMap)object2).verify()) {
                TestSuite.println("FHashMap Verification failure on iteration " + n);
                TestSuite.println(((FHashMap)object3).dump());
                TestSuite.println("Removing " + myInteger);
                TestSuite.println(((FHashMap)object2).dump());
                TestSuite.exit();
            }
            object3 = object2;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            int n7 = random.nextInt(200);
            MyInteger myInteger = n7 == 57 ? null : new MyInteger(n7);
            object2 = ((FHashMap)object4).less(myInteger);
            hashMap2.remove(myInteger);
            if (!((FHashMap)object2).verify()) {
                TestSuite.println("FHashMap Verification failure on iteration " + n);
                TestSuite.println(((FHashMap)object4).dump());
                TestSuite.println("Removing " + myInteger);
                TestSuite.println(((FHashMap)object2).dump());
                TestSuite.exit();
            }
            object4 = object2;
        }
        if (!((FHashMap)object3).equals(hashMap)) {
            TestSuite.println("FHashMap Equality failed (fhm0, A) on iteration " + n);
            TestSuite.println(((FHashMap)object3).dump());
            TestSuite.println(object3);
            TestSuite.println(hashMap);
            TestSuite.exit();
        }
        if (!((FHashMap)object3).equals(new FHashMap(hashMap))) {
            TestSuite.println("FHashMap Equality failed (fhm0, B) on iteration " + n);
            TestSuite.println(((FHashMap)object3).dump());
            TestSuite.println(hashMap);
            TestSuite.exit();
        }
        if (!((FHashMap)object4).equals(hashMap2)) {
            TestSuite.println("FHashMap Equality failed (fhm1, A) on iteration " + n);
            TestSuite.println(((FHashMap)object4).dump());
            TestSuite.println(object4);
            TestSuite.println(hashMap2);
            TestSuite.exit();
        }
        if (!((FHashMap)object4).equals(new FHashMap(hashMap2))) {
            TestSuite.println("FHashMap Equality failed (fhm1, B) on iteration " + n);
            TestSuite.println(((FHashMap)object4).dump());
            TestSuite.exit();
        }
        FMap fMap5 = ((FHashMap)object3).union((FMap)object4);
        HashMap hashMap3 = (HashMap)hashMap.clone();
        hashMap3.putAll(hashMap2);
        if (!((FHashMap)fMap5).verify() || !((FHashMap)fMap5).equals(hashMap3)) {
            TestSuite.println("FHashMap Union failed on iteration " + n);
            TestSuite.println(object3);
            TestSuite.println(((FHashMap)object3).dump());
            TestSuite.println(object4);
            TestSuite.println(((FHashMap)object4).dump());
            TestSuite.println(((FHashMap)fMap5).size() + ", " + hashMap3.size());
            TestSuite.println(fMap5);
            TestSuite.println(((FHashMap)fMap5).dump());
            TestSuite.println(hashMap3);
            TestSuite.exit();
        }
        if (!((FHashMap)fMap5).equals(new FHashMap(hashMap3))) {
            TestSuite.println("FHashMap Equality failed (fhmm) on iteration " + n);
        }
        FMap fMap6 = ((FHashMap)object3).restrictedTo(fHashSet);
        object2 = (HashMap)hashMap.clone();
        object = ((HashMap)object2).keySet().iterator();
        while (object.hasNext()) {
            fMap4 = object.next();
            if (fHashSet.contains(fMap4)) continue;
            object.remove();
        }
        if (!((FHashMap)fMap6).verify() || !((FHashMap)fMap6).equals(object2)) {
            TestSuite.println("FHashMap restrictedTo failed on iteration " + n);
            TestSuite.println(fMap6);
            TestSuite.println(object2);
            TestSuite.exit();
        }
        fMap6 = ((FHashMap)object3).restrictedFrom(fHashSet);
        object2 = (HashMap)hashMap.clone();
        object = ((HashMap)object2).keySet().iterator();
        while (object.hasNext()) {
            fMap4 = object.next();
            if (!fHashSet.contains(fMap4)) continue;
            object.remove();
        }
        if (!((FHashMap)fMap6).verify() || !((FHashMap)fMap6).equals(object2)) {
            TestSuite.println("FHashMap restrictedFrom failed on iteration " + n);
            TestSuite.println(fMap6);
            TestSuite.println(object2);
            TestSuite.exit();
        }
        if (TestSuite.sgn(((FHashMap)(fMap4 = ((FHashMap)((FHashMap)(object3 = ((FHashMap)object3).less((Object)null))).less(TestSuite.pick(random, (FSet<MyInteger>)(object = ((FHashMap)object3).domain())))).with(TestSuite.pick(random, (FSet<MyInteger>)object), new MyInteger(random.nextInt(3))))).compareTo(fMap3 = ((FHashMap)((FHashMap)object3).less(TestSuite.pick(random, (FSet<MyInteger>)object))).with(TestSuite.pick(random, (FSet<MyInteger>)object), new MyInteger(random.nextInt(3))))) != TestSuite.compare(fMap4, fMap3)) {
            TestSuite.println("FHashMap Compare failed (fhm0) on iteration " + n);
            TestSuite.println(((FHashMap)fMap4).dump());
            TestSuite.println(((FHashMap)fMap3).dump());
            TestSuite.println(fMap4);
            TestSuite.println(fMap3);
            TestSuite.println(((FHashMap)fMap4).compareTo((FHashMap<MyInteger, MyInteger>)fMap3));
            TestSuite.println(TestSuite.compare(fMap4, fMap3));
            TestSuite.exit();
        }
        if (TestSuite.sgn(((FHashMap)(fMap2 = ((FHashMap)((FHashMap)(object4 = ((FHashMap)object4).less((Object)null))).less(TestSuite.pick(random, fSet = ((FHashMap)object4).domain()))).with(TestSuite.pick(random, fSet), new MyInteger(random.nextInt(3))))).compareTo(fMap = ((FHashMap)((FHashMap)object4).less(TestSuite.pick(random, fSet))).with(TestSuite.pick(random, fSet), new MyInteger(random.nextInt(3))))) != TestSuite.compare(fMap2, fMap)) {
            TestSuite.println("FHashMap Compare failed (fhm1) on iteration " + n);
            TestSuite.println(((FHashMap)fMap2).dump());
            TestSuite.println(((FHashMap)fMap).dump());
            TestSuite.println(fMap2);
            TestSuite.println(fMap);
            TestSuite.println(((FHashMap)fMap2).compareTo(fMap));
            TestSuite.println(TestSuite.compare(fMap2, fMap));
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                Object object5 = n == 0 ? new FHashMap() : object3;
                FileOutputStream fileOutputStream = new FileOutputStream("fhm.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object5);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("fhm.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FMap fMap7 = (FMap)objectInputStream.readObject();
                objectInputStream.close();
                if (!object5.equals(fMap7) || object5.hashCode() != fMap7.hashCode()) {
                    TestSuite.println("FHashMap read/write failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FHashMap read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FHashMap read/write: exception " + classNotFoundException);
            }
        }
    }

    static void testFLinkedHashMap(Random random, int n) {
        FMap fMap = new FLinkedHashMap();
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < 10; ++i) {
            int n2 = random.nextInt(200);
            int n3 = random.nextInt(100);
            fMap = ((FLinkedHashMap)fMap).with((Object)n2, (Object)n3);
            linkedHashMap.put(n2, n3);
        }
        if (((FLinkedHashMap)fMap).size() != linkedHashMap.size()) {
            TestSuite.println("FLinkedHashMap size failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FLinkedHashMap)fMap).equals(linkedHashMap)) {
            TestSuite.println("FLinkedHashMap equals failed on iteration " + n);
            TestSuite.exit();
        }
        Iterator iterator = ((FLinkedHashMap)fMap).iterator();
        Iterator iterator2 = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && iterator.next().equals(iterator2.next())) continue;
            TestSuite.println("FLinkedHashMap ordering failed on iteration " + n);
            TestSuite.exit();
        }
        if (iterator2.hasNext()) {
            TestSuite.println("FLinkedHashMap ordering failed on iteration " + n);
            TestSuite.exit();
        }
        FMap fMap2 = new FLinkedHashMap();
        LinkedHashMap<Integer, Integer> linkedHashMap2 = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < 10; ++i) {
            int n4 = random.nextInt(200);
            int n5 = random.nextInt(100);
            fMap2 = fMap2.with((Object)n4, (Object)n5);
            linkedHashMap2.put(n4, n5);
        }
        if (n % 50 == 0) {
            try {
                FMap fMap3 = fMap;
                FileOutputStream fileOutputStream = new FileOutputStream("flhm.tmp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(fMap3);
                objectOutputStream.close();
                FileInputStream fileInputStream = new FileInputStream("flhm.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FMap fMap4 = (FMap)objectInputStream.readObject();
                objectInputStream.close();
                if (!fMap3.equals(fMap4) || fMap3.hashCode() != fMap4.hashCode()) {
                    TestSuite.println("FLinkedHashMap read/write failed on iteration " + n);
                    TestSuite.exit();
                }
                iterator = ((FLinkedHashMap)fMap).iterator();
                iterator2 = linkedHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator2.hasNext() && iterator.next().equals(iterator2.next())) continue;
                    TestSuite.println("FLinkedHashMap ordering failed on iteration " + n);
                    TestSuite.exit();
                }
                if (iterator2.hasNext()) {
                    TestSuite.println("FLinkedHashMap ordering failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FLinkedHashMap read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FLinkedHashMap read/write: exception " + classNotFoundException);
            }
        }
    }

    static void testFTreeList(Random random, int n) {
        Object object;
        Object object2;
        FList fList;
        int n2;
        int n3;
        FList fList2;
        List<Object> list;
        int n4;
        FList fList3 = new FTreeList();
        ArrayList<MyInteger> arrayList = new ArrayList<MyInteger>();
        for (int i = 0; i < 100; ++i) {
            FList fList4;
            int n5 = random.nextInt(200);
            MyInteger myInteger = n5 == 57 ? null : new MyInteger(n5);
            n4 = arrayList.isEmpty() ? 0 : random.nextInt(arrayList.size());
            int n6 = random.nextInt(6);
            if (((FTreeList)fList3).indexOf(myInteger) != arrayList.indexOf(myInteger)) {
                TestSuite.println("FTreeList indexOf failed (ftl0) on iteration " + n);
                TestSuite.exit();
            }
            if (n6 == 0 && !arrayList.isEmpty()) {
                if (!TestSuite.equals(((FTreeList)fList3).get(n4), arrayList.get(n4))) {
                    TestSuite.println("FTreeList get failed (ftl0) on iteration " + n);
                    TestSuite.exit();
                }
                fList4 = ((FTreeList)fList3).with(n4, myInteger);
                arrayList.set(n4, myInteger);
            } else if (n6 == 1 && !arrayList.isEmpty()) {
                fList4 = ((FTreeList)fList3).less(n4);
                arrayList.remove(n4);
            } else {
                fList4 = ((FTreeList)fList3).withInserted(n4, myInteger);
                arrayList.add(n4, myInteger);
            }
            if (!((FTreeList)fList4).verify()) {
                TestSuite.println("FTreeList Verification failed on iteration " + n);
                TestSuite.println(((FTreeList)fList3).dump());
                if (n6 == 1) {
                    TestSuite.println("Deleting at " + n4);
                } else {
                    TestSuite.println((n6 == 0 ? "Writing " : "Inserting ") + myInteger + " at " + n4);
                }
                TestSuite.println(((FTreeList)fList4).dump());
                TestSuite.exit();
            }
            if (((FTreeList)fList4).hashCode() != arrayList.hashCode()) {
                TestSuite.println("FTreeList hashCode failed on iteration " + n);
                TestSuite.println(fList3);
                TestSuite.println(((FTreeList)fList3).dump());
                if (n6 == 1) {
                    TestSuite.println("Deleting at " + n4);
                } else {
                    TestSuite.println((n6 == 0 ? "Writing " : "Inserting ") + myInteger + " at " + n4);
                }
                TestSuite.println(fList4);
                TestSuite.println(((FTreeList)fList4).dump());
                TestSuite.println(arrayList);
                TestSuite.println(((FTreeList)fList4).hashCode() + ", " + arrayList.hashCode());
                TestSuite.exit();
            }
            fList3 = fList4;
        }
        FList fList5 = new FTreeList();
        ArrayList<MyInteger> arrayList2 = new ArrayList<MyInteger>();
        for (int i = 0; i < 100; ++i) {
            n4 = random.nextInt(200);
            MyInteger myInteger = n4 == 57 ? null : new MyInteger(n4);
            int n7 = arrayList2.isEmpty() ? 0 : random.nextInt(arrayList2.size());
            int n8 = random.nextInt(5);
            if (((FTreeList)fList5).lastIndexOf(myInteger) != arrayList2.lastIndexOf(myInteger)) {
                TestSuite.println("FTreeList lastIndexOf failed (ftl1) on iteration " + n);
                TestSuite.exit();
            }
            if (n8 == 0 && !arrayList2.isEmpty()) {
                if (!TestSuite.equals(((FTreeList)fList5).get(n7), arrayList2.get(n7))) {
                    TestSuite.println("FTreeList get failed (ftl1) on iteration " + n);
                    TestSuite.exit();
                }
                list = ((FTreeList)fList5).with(n7, myInteger);
                arrayList2.set(n7, myInteger);
            } else if (n8 == 1 && !arrayList2.isEmpty()) {
                list = ((FTreeList)fList5).less(n7);
                arrayList2.remove(n7);
            } else {
                list = ((FTreeList)fList5).withInserted(n7, myInteger);
                arrayList2.add(n7, myInteger);
            }
            if (!((FTreeList)list).verify()) {
                TestSuite.println("FTreeList Verification failed on iteration " + n);
                TestSuite.println(((FTreeList)fList5).dump());
                if (n8 == 1) {
                    TestSuite.println("Deleting at " + n7);
                } else {
                    TestSuite.println((n8 == 0 ? "Writing " : "Inserting ") + myInteger + " at " + n7);
                }
                TestSuite.println(((FTreeList)list).dump());
                TestSuite.exit();
            }
            if (((FTreeList)list).hashCode() != arrayList2.hashCode()) {
                TestSuite.println("FTreeList hashCode failed on iteration " + n);
                TestSuite.println(list);
                TestSuite.println(((FTreeList)list).hashCode() + ", " + arrayList2.hashCode());
                TestSuite.exit();
            }
            fList5 = list;
        }
        if (!((FTreeList)fList3).equals(arrayList)) {
            TestSuite.println("FTreeList Equality failed (ftl0, A) on iteration " + n);
            TestSuite.println(((FTreeList)fList3).dump());
            TestSuite.println(fList3);
            TestSuite.println(arrayList);
            TestSuite.exit();
        }
        if (!((FTreeList)fList3).equals(new FTreeList(arrayList))) {
            TestSuite.println("FTreeList Equality failed (ftl0, B) on iteration " + n);
            TestSuite.println(((FTreeList)fList3).dump());
            TestSuite.println(arrayList);
            TestSuite.exit();
        }
        if (!((FTreeList)fList5).equals(arrayList2)) {
            TestSuite.println("FTreeList Equality failed (ftl1, A) on iteration " + n);
            TestSuite.println(((FTreeList)fList5).dump());
            TestSuite.println(arrayList2);
            TestSuite.exit();
        }
        if (!((FTreeList)fList5).equals(new FTreeList(arrayList2))) {
            TestSuite.println("FTreeList Equality failed (ftl1, B) on iteration " + n);
            TestSuite.println(((FTreeList)fList5).dump());
            TestSuite.exit();
        }
        FList fList6 = ((FTreeList)fList3).concat((List)fList5);
        ArrayList arrayList3 = (ArrayList)arrayList.clone();
        arrayList3.addAll(arrayList3.size(), arrayList2);
        if (!((FTreeList)fList6).equals(arrayList3)) {
            TestSuite.println("FTreeList concat failed on iteration " + n);
            TestSuite.exit();
        }
        if (!((FTreeList)(fList2 = ((FTreeList)fList3).subseq(n3 = random.nextInt(arrayList.size()), n2 = random.nextInt(arrayList.size() - n3) + n3))).equals(list = arrayList.subList(n3, n2))) {
            TestSuite.println("FTreeList subseq failed on iteration " + n);
            TestSuite.println(fList3);
            TestSuite.println(((FTreeList)fList3).dump());
            TestSuite.println(n3 + ", " + n2);
            TestSuite.println(fList2);
            TestSuite.println(list);
            TestSuite.exit();
        }
        int n9 = random.nextInt(((FTreeList)fList3).size());
        FList fList7 = ((FTreeList)fList3).less(n9);
        List list2 = (List)arrayList.clone();
        list2.remove(n9);
        if (!((FTreeList)fList7).equals(list2)) {
            TestSuite.println("FTreeList less failed on iteration " + n);
            TestSuite.println(fList3);
            TestSuite.println(((FTreeList)fList3).dump());
            TestSuite.println("Removing at " + n9);
            TestSuite.println(fList7);
            TestSuite.println(((FTreeList)fList7).dump());
            TestSuite.exit();
        }
        if (TestSuite.sgn(((FTreeList)fList7).compareTo(fList = ((FTreeList)fList3).less(random.nextInt(((FTreeList)fList3).size())))) != TestSuite.compare(fList7, fList)) {
            TestSuite.println("FTreeList compareTo failed on iteration " + n);
            TestSuite.println(fList7);
            TestSuite.println(fList);
            TestSuite.println(((FTreeList)fList7).compareTo(fList));
            TestSuite.println(TestSuite.compare(fList7, fList));
            TestSuite.exit();
        }
        FList fList8 = ((FTreeList)fList3).sorted((Comparator)TestComparator.Instance);
        ArrayList arrayList4 = (ArrayList)arrayList.clone();
        arrayList4.sort(TestComparator.Instance);
        if (!((FTreeList)fList8).equals(arrayList4)) {
            TestSuite.println("FTreeList sort failed on iteration " + n);
            TestSuite.println(fList8);
            TestSuite.println(arrayList4);
            TestSuite.exit();
        }
        ListIterator listIterator = ((FTreeList)fList3).listIterator();
        ListIterator listIterator2 = arrayList.listIterator();
        for (int i = 0; i < 400; ++i) {
            int n10 = random.nextInt(2);
            if (listIterator.nextIndex() != listIterator2.nextIndex()) {
                TestSuite.println("FTreeList nextIndex failed on iteration " + n + "." + i);
                TestSuite.exit();
            }
            if (n10 == 0 && listIterator2.hasPrevious()) {
                if (!listIterator.hasPrevious()) {
                    TestSuite.println("FTreeList hasPrevious failed false on iteration " + n + "." + i);
                    TestSuite.exit();
                }
                object2 = (MyInteger)listIterator.previous();
                object = (MyInteger)listIterator2.previous();
                if (!(object2 == null ? object != null : !((MyInteger)object2).equals(object))) continue;
                TestSuite.println("FTreeList previous failed on iteration " + n + "." + i);
                TestSuite.exit();
                continue;
            }
            if (listIterator2.hasNext()) {
                if (!listIterator2.hasPrevious() && listIterator.hasPrevious()) {
                    TestSuite.println("FTreeList hasPrevious failed true on iteration " + n + "." + i);
                    TestSuite.exit();
                }
                if (!listIterator.hasNext()) {
                    TestSuite.println("FTreeList hasNext failed false on iteration " + n + "." + i);
                    TestSuite.exit();
                }
                object2 = (MyInteger)listIterator.next();
                object = (MyInteger)listIterator2.next();
                if (!(object2 == null ? object != null : !((MyInteger)object2).equals(object))) continue;
                TestSuite.println("FTreeList next failed on iteration " + n + "." + i);
                TestSuite.exit();
                continue;
            }
            if (!listIterator.hasNext()) continue;
            TestSuite.println("FTreeList hasNext failed true on iteration " + n + "." + i);
            TestSuite.exit();
        }
        if (!new FTreeList(((FTreeList)fList3).prefix(((FTreeList)fList3).size() - 3)).isPrefix(fList3)) {
            TestSuite.println("FTreeList prefix or isPrefix failed on iteration " + n);
            TestSuite.exit();
        }
        if (((FTreeList)((FTreeList)fList3).suffix(3)).size() != 3) {
            TestSuite.println("FTreeList suffix failed on iteration " + n);
            TestSuite.exit();
        }
        if (((FTreeList)((FTreeList)fList3).suffixFrom(3)).size() != ((FTreeList)fList3).size() - 3) {
            TestSuite.println("FTreeList suffixFrom failed on iteration " + n);
            TestSuite.exit();
        }
        if (!new FTreeList(((FTreeList)fList3).suffix(((FTreeList)fList3).size() - 3)).isSuffix(fList3)) {
            TestSuite.println("FTreeList suffix or isSuffix failed on iteration " + n);
            TestSuite.exit();
        }
        if (n % 50 == 0) {
            try {
                FTreeList fTreeList = n == 0 ? new FTreeList() : fList3;
                FileOutputStream fileOutputStream = new FileOutputStream("ftl.tmp");
                object2 = new ObjectOutputStream(fileOutputStream);
                ((ObjectOutputStream)object2).writeObject(fTreeList);
                ((ObjectOutputStream)object2).writeObject(fTreeList);
                ((ObjectOutputStream)object2).close();
                object = new FileInputStream("ftl.tmp");
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                FList fList9 = (FList)objectInputStream.readObject();
                FList fList10 = (FList)objectInputStream.readObject();
                objectInputStream.close();
                if (!((Object)fTreeList).equals(fList9) || !((Object)fTreeList).equals(fList10) || ((Object)fTreeList).hashCode() != fList9.hashCode()) {
                    TestSuite.println("FTreeList read/write failed on iteration " + n);
                    TestSuite.exit();
                }
            }
            catch (IOException iOException) {
                TestSuite.println("FTreeList read/write: exception " + iOException);
                TestSuite.exit();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TestSuite.println("FTreeList read/write: exception " + classNotFoundException);
            }
        }
    }

    static MyInteger[] conv(int[] nArray) {
        MyInteger[] myIntegerArray = new MyInteger[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            myIntegerArray[i] = new MyInteger(nArray[i]);
        }
        return myIntegerArray;
    }

    static MyInteger pick(Random random, FSet<MyInteger> fSet) {
        int n;
        MyInteger myInteger;
        if (fSet.isEmpty()) {
            throw new IllegalStateException();
        }
        while (!fSet.contains(myInteger = new MyInteger(n = random.nextInt(200)))) {
        }
        return myInteger;
    }

    static int compare(FSet<MyInteger> fSet, FSet<MyInteger> fSet2) {
        if (fSet.size() < fSet2.size()) {
            return -1;
        }
        if (fSet.size() > fSet2.size()) {
            return 1;
        }
        Iterator iterator = fSet2.iterator();
        Iterator iterator2 = fSet.iterator();
        while (iterator2.hasNext()) {
            MyInteger myInteger;
            int n;
            int n2;
            MyInteger myInteger2;
            int n3;
            int n4;
            if (!iterator.hasNext()) {
                TestSuite.println("Set iterator disagreement");
                TestSuite.exit();
            }
            if ((n4 = (n3 = (myInteger2 = (MyInteger)iterator2.next()) == null ? 0 : myInteger2.intValue()) / 2) < (n2 = (n = (myInteger = (MyInteger)iterator.next()) == null ? 0 : myInteger.intValue()) / 2)) {
                return -1;
            }
            if (n4 <= n2) continue;
            return 1;
        }
        if (iterator.hasNext()) {
            TestSuite.println("Set iterator disagreement");
            TestSuite.exit();
        }
        return 0;
    }

    static boolean equals(FSet<MyInteger> fSet, FSet<MyInteger> fSet2) {
        if (fSet.size() != fSet2.size()) {
            return false;
        }
        Iterator iterator = fSet.iterator();
        while (iterator.hasNext()) {
            if (fSet2.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    static int compare(FList<MyInteger> fList, FList<MyInteger> fList2) {
        if (fList.size() < fList2.size()) {
            return -1;
        }
        if (fList.size() > fList2.size()) {
            return 1;
        }
        Iterator iterator = fList2.iterator();
        for (MyInteger myInteger : fList) {
            int n;
            MyInteger myInteger2 = (MyInteger)iterator.next();
            int n2 = myInteger == null ? -1 : myInteger.intValue();
            int n3 = n = myInteger2 == null ? -1 : myInteger2.intValue();
            if (n2 < n) {
                return -1;
            }
            if (n2 <= n) continue;
            return 1;
        }
        return 0;
    }

    static int compare(FMap<MyInteger, MyInteger> fMap, FMap<MyInteger, MyInteger> fMap2) {
        if (fMap.size() < fMap2.size()) {
            return -1;
        }
        if (fMap.size() > fMap2.size()) {
            return 1;
        }
        Iterator<Map.Entry<MyInteger, MyInteger>> iterator = fMap.iterator();
        Iterator<Map.Entry<MyInteger, MyInteger>> iterator2 = fMap2.iterator();
        Map.Entry<MyInteger, MyInteger> entry = null;
        Map.Entry<MyInteger, MyInteger> entry2 = null;
        while (iterator.hasNext() || entry != null) {
            int n;
            Map.Entry<MyInteger, MyInteger> entry3 = entry != null ? entry : iterator.next();
            Map.Entry<MyInteger, MyInteger> entry4 = entry2 != null ? entry2 : iterator2.next();
            entry2 = null;
            entry = null;
            int n2 = entry3.getKey().intValue();
            int n3 = entry4.getKey().intValue();
            Map.Entry<MyInteger, MyInteger> entry5 = null;
            Map.Entry<MyInteger, MyInteger> entry6 = null;
            if (n2 >> 1 < n3 >> 1) {
                return -1;
            }
            if (n2 >> 1 > n3 >> 1) {
                return 1;
            }
            if (iterator.hasNext()) {
                entry5 = iterator.next();
            }
            if (iterator2.hasNext()) {
                entry6 = iterator2.next();
            }
            if (entry5 != null && entry5.getKey().intValue() >> 1 > n2 >> 1) {
                entry = entry5;
                entry5 = null;
            }
            if (entry6 != null && entry6.getKey().intValue() >> 1 > n3 >> 1) {
                entry2 = entry6;
                entry6 = null;
            }
            if (entry5 != null && entry6 == null) {
                return -1;
            }
            if (entry5 == null && entry6 != null) {
                return 1;
            }
            if (entry5 == null && entry6 == null) {
                int n4;
                int n5 = entry3.getValue().intValue();
                if (n5 < (n4 = entry4.getValue().intValue())) {
                    return -1;
                }
                if (n5 <= n4) continue;
                return 1;
            }
            if (fMap instanceof FTreeMap) {
                FSet fSet = FTreeSet.emptySet();
                fSet = ((FTreeSet)((FTreeSet)fSet).with(entry3.getValue())).with(entry5.getValue());
                FSet fSet2 = FTreeSet.emptySet();
                n = ((FTreeSet)fSet).compareTo(fSet2 = ((FTreeSet)fSet2.with(entry4.getValue())).with(entry6.getValue()));
                if (n == 0) continue;
                return n;
            }
            FSet fSet = FHashSet.emptySet();
            fSet = ((FHashSet)((FHashSet)fSet).with(entry3.getValue())).with(entry5.getValue());
            FSet fSet3 = FHashSet.emptySet();
            n = ((FHashSet)fSet).compareTo(fSet3 = ((FHashSet)fSet3.with(entry4.getValue())).with(entry6.getValue()));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static int sgn(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void println(Object object) {
        System.out.println(object);
    }

    static void println(int n) {
        System.out.println(n);
    }

    static void println(boolean bl) {
        System.out.println(bl);
    }

    static void exit() {
        System.exit(1);
    }

    static class TestComparator
    implements Comparator<MyInteger>,
    Serializable {
        public static final TestComparator Instance = new TestComparator();

        private TestComparator() {
        }

        @Override
        public int compare(MyInteger myInteger, MyInteger myInteger2) {
            int n = myInteger == null ? 0 : myInteger.intValue();
            int n2 = myInteger2 == null ? 0 : myInteger2.intValue();
            return n / 2 - n2 / 2;
        }
    }

    static class MyInteger
    implements Comparable<MyInteger>,
    Serializable {
        private int value;

        MyInteger(int n) {
            this.value = n;
        }

        public int intValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MyInteger)) {
                return false;
            }
            return this.value == ((MyInteger)object).value;
        }

        public int hashCode() {
            return this.value >> 1;
        }

        @Override
        public int compareTo(MyInteger myInteger) {
            return this.value < myInteger.value ? -1 : (this.value > myInteger.value ? 1 : 0);
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

