/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.opentelemetry.common;

import com.lightstep.opentelemetry.common.Version;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;

public class VariablesConverter {
    private static final Logger logger = Logger.getLogger(VariablesConverter.class.getName());
    public static final String DEFAULT_OTEL_EXPORTER_OTLP_TRACES_ENDPOINT = "https://ingest.lightstep.com:443";
    public static final String DEFAULT_OTEL_EXPORTER_OTLP_METRICS_ENDPOINT = "https://ingest.lightstep.com:443";
    public static final long DEFAULT_LS_DEADLINE_MILLIS = 30000L;
    public static final boolean DEFAULT_METRICS_ENABLED = false;
    @Deprecated
    public static final boolean DEFAULT_OTEL_EXPORTER_OTLP_INSECURE = false;
    public static final String DEFAULT_PROPAGATOR = "b3multi";
    public static final String DEFAULT_OTEL_LOG_LEVEL = "info";
    static final String OTEL_SERVICE_NAME = "OTEL_SERVICE_NAME";
    @Deprecated
    static final String LS_ACCESS_TOKEN = "LS_ACCESS_TOKEN";
    static final String LS_SERVICE_NAME = "LS_SERVICE_NAME";
    static final String LS_SERVICE_VERSION = "LS_SERVICE_VERSION";
    static final String LS_METRICS_ENABLED = "LS_METRICS_ENABLED";
    @Deprecated
    static final String OTEL_EXPORTER_OTLP_SPAN_ENDPOINT = "OTEL_EXPORTER_OTLP_SPAN_ENDPOINT";
    static final String OTEL_EXPORTER_OTLP_TRACES_ENDPOINT = "OTEL_EXPORTER_OTLP_TRACES_ENDPOINT";
    static final String OTEL_EXPORTER_OTLP_METRICS_ENDPOINT = "OTEL_EXPORTER_OTLP_METRICS_ENDPOINT";
    static final String OTEL_PROPAGATORS = "OTEL_PROPAGATORS";
    @Deprecated
    static final String OTEL_EXPORTER_OTLP_SPAN_INSECURE = "OTEL_EXPORTER_OTLP_SPAN_INSECURE";
    @Deprecated
    static final String OTEL_EXPORTER_OTLP_METRIC_INSECURE = "OTEL_EXPORTER_OTLP_METRIC_INSECURE";
    static final String OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE = "OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE";
    static final String OTEL_LOG_LEVEL = "OTEL_LOG_LEVEL";
    static final String OTEL_RESOURCE_ATTRIBUTES = "OTEL_RESOURCE_ATTRIBUTES";
    static final String OTEL_METRIC_EXPORT_INTERVAL = "OTEL_METRIC_EXPORT_INTERVAL";

    public static void setSystemProperties(Configuration configuration, boolean isAgent) {
        String hostname;
        if (configuration.tracesEndpoint == null || configuration.tracesEndpoint.isEmpty()) {
            String msg = "Invalid configuration: traces endpoint missing. Set environment variable OTEL_EXPORTER_OTLP_TRACES_ENDPOINT";
            msg = isAgent ? msg + "." : msg + " or call setTracesEndpoint in the code.";
            logger.severe(msg);
            throw new IllegalStateException(msg);
        }
        configuration.tracesEndpoint = VariablesConverter.normalizeEndpoint(configuration.tracesEndpoint, configuration.tracesInsecureTransport);
        configuration.metricsEndpoint = VariablesConverter.normalizeEndpoint(configuration.metricsEndpoint, configuration.metricsInsecureTransport);
        if (configuration.serviceName == null || configuration.serviceName.isEmpty()) {
            String msg = "Invalid configuration: service name missing. Set environment variable OTEL_SERVICE_NAME";
            msg = isAgent ? msg + "." : msg + " or call setServiceName in the code.";
            logger.severe(msg);
            throw new IllegalStateException(msg);
        }
        if (VariablesConverter.isTokenRequired(configuration.tracesEndpoint) && (configuration.accessToken == null || configuration.accessToken.isEmpty())) {
            String msg = "Invalid configuration: token missing. Must be set to send data to " + configuration.tracesEndpoint + ". Set environment variable " + LS_ACCESS_TOKEN;
            msg = isAgent ? msg + "." : msg + " or call setAccessToken in the code.";
            logger.severe(msg);
            throw new IllegalStateException(msg);
        }
        if (!VariablesConverter.isValidToken(configuration.accessToken)) {
            String msg = "Invalid configuration: invalid token. Token must be a 32, 84 or 104 character long string.";
            logger.severe(msg);
            throw new IllegalStateException(msg);
        }
        System.setProperty("otel.exporter.otlp.endpoint", configuration.tracesEndpoint);
        System.setProperty("otel.exporter.otlp.traces.endpoint", configuration.tracesEndpoint);
        System.setProperty("otel.exporter.otlp.timeout", String.valueOf(30000L));
        if (configuration.accessToken != null && !configuration.accessToken.isEmpty()) {
            System.setProperty("otel.exporter.otlp.headers", "lightstep-access-token=" + configuration.accessToken);
        }
        if (configuration.propagators != null) {
            System.setProperty("otel.propagators", configuration.propagators);
        }
        String otelResourceAttributes = "telemetry.distro.name=lightstep,telemetry.distro.version=" + Version.get() + ",service.name=" + configuration.serviceName;
        if (configuration.serviceVersion != null) {
            otelResourceAttributes = otelResourceAttributes + ",service.version=" + configuration.serviceVersion;
        }
        if (!(configuration.resourceAttributes != null && !configuration.resourceAttributes.isEmpty() && configuration.resourceAttributes.contains("host.name=") || (hostname = VariablesConverter.getHostName()) == null || hostname.isEmpty())) {
            otelResourceAttributes = otelResourceAttributes + ",host.name=" + hostname;
        }
        if (configuration.resourceAttributes != null && !configuration.resourceAttributes.isEmpty()) {
            otelResourceAttributes = otelResourceAttributes + "," + configuration.resourceAttributes;
        }
        System.setProperty("otel.resource.attributes", otelResourceAttributes);
        if (configuration.logLevel != null) {
            System.setProperty("io.opentelemetry.javaagent.slf4j.simpleLogger.defaultLogLevel", configuration.logLevel);
            if (configuration.logLevel.equals("debug")) {
                String msg = "tracesEndpoint: " + configuration.tracesEndpoint;
                if (configuration.propagators != null) {
                    msg = msg + ", propagators: " + configuration.propagators;
                }
                msg = msg + ", accessToken: " + configuration.accessToken + ", serviceName: " + configuration.serviceName;
                logger.info(msg);
            }
        }
        System.setProperty("otel.traces.exporter", "otlp");
        if (configuration.metricsEnabled) {
            if (configuration.metricsEndpoint != null) {
                System.setProperty("otel.exporter.otlp.metrics.endpoint", configuration.metricsEndpoint);
            }
            if (configuration.metricsExportInterval != null) {
                System.setProperty("otel.metric.export.interval", String.valueOf(configuration.metricsExportInterval));
            }
            if (configuration.metricsTemporality != null) {
                System.setProperty("otel.exporter.otlp.metrics.temporality.preference", configuration.metricsTemporality);
            }
            System.setProperty("otel.exporter.otlp.metrics.default.histogram.aggregation", "exponential_bucket_histogram");
            System.setProperty("otel.metrics.exporter", "otlp");
        } else {
            System.setProperty("otel.metrics.exporter", "none");
        }
    }

    static String normalizeEndpoint(String endpoint, boolean insecureTransport) {
        if (endpoint.toLowerCase().startsWith("http://") || endpoint.toLowerCase().startsWith("https://")) {
            return endpoint;
        }
        String prefix = insecureTransport ? "http://" : "https://";
        return prefix + endpoint;
    }

    static boolean isValidToken(String token) {
        return token == null || token.isEmpty() || token.length() == 32 || token.length() == 84 || token.length() == 104;
    }

    static boolean isTokenRequired(String tracesEndpoint) {
        return "https://ingest.lightstep.com:443".equals(tracesEndpoint);
    }

    public static void convertFromEnv() {
        VariablesConverter.setSystemProperties(new Configuration().withTracesEndpoint(VariablesConverter.getTracesEndpoint()).withMetricsEndpoint(VariablesConverter.getMetricsEndpoint()).withTracesInsecureTransport(VariablesConverter.useTracesInsecureTransport()).withMetricsInsecureTransport(VariablesConverter.useMetricsInsecureTransport()).withAccessToken(VariablesConverter.getAccessToken()).withPropagators(VariablesConverter.getPropagator()).withLogLevel(VariablesConverter.getLogLevel()).withServiceName(VariablesConverter.getServiceName()).withServiceVersion(VariablesConverter.getServiceVersion()).withResourceAttributes(VariablesConverter.getResourceAttributes()).withMetricsExportInterval(VariablesConverter.getMetricsExportInterval()).withMetricsTemporalityPreference(VariablesConverter.getMetricsTemporalityPreference()).withMetricsEnabled(VariablesConverter.getMetricsEnabled()), true);
    }

    public static boolean getMetricsEnabled() {
        return Boolean.parseBoolean(VariablesConverter.getProperty(LS_METRICS_ENABLED, String.valueOf(false)));
    }

    public static Long getMetricsExportInterval() {
        String interval = VariablesConverter.getProperty(OTEL_METRIC_EXPORT_INTERVAL, null);
        if (interval != null) {
            return Long.parseLong(interval);
        }
        return null;
    }

    public static String getMetricsTemporalityPreference() {
        return VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE, null);
    }

    public static String getAccessToken() {
        return VariablesConverter.getProperty(LS_ACCESS_TOKEN, null);
    }

    public static String getServiceName() {
        return VariablesConverter.getProperty(OTEL_SERVICE_NAME, VariablesConverter.getProperty(LS_SERVICE_NAME, null));
    }

    public static String getServiceVersion() {
        return VariablesConverter.getProperty(LS_SERVICE_VERSION, null);
    }

    public static String getLogLevel() {
        return VariablesConverter.getProperty(OTEL_LOG_LEVEL, DEFAULT_OTEL_LOG_LEVEL);
    }

    public static String getTracesEndpoint() {
        return VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_TRACES_ENDPOINT, VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_SPAN_ENDPOINT, "https://ingest.lightstep.com:443"));
    }

    public static String getMetricsEndpoint() {
        return VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_METRICS_ENDPOINT, "https://ingest.lightstep.com:443");
    }

    public static String getPropagator() {
        return VariablesConverter.getProperty(OTEL_PROPAGATORS, DEFAULT_PROPAGATOR);
    }

    @Deprecated
    public static boolean useTracesInsecureTransport() {
        return Boolean.parseBoolean(VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_SPAN_INSECURE, String.valueOf(false)));
    }

    @Deprecated
    public static boolean useMetricsInsecureTransport() {
        return Boolean.parseBoolean(VariablesConverter.getProperty(OTEL_EXPORTER_OTLP_METRIC_INSECURE, String.valueOf(false)));
    }

    public static String getResourceAttributes() {
        return VariablesConverter.getProperty(OTEL_RESOURCE_ATTRIBUTES, null);
    }

    private static String getProperty(String name, String defaultValue) {
        String val = System.getProperty(name.toLowerCase().replaceAll("_", "."), System.getenv(name));
        if (val == null || val.isEmpty()) {
            return defaultValue;
        }
        return val;
    }

    static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static class Configuration {
        private String tracesEndpoint;
        private String metricsEndpoint;
        @Deprecated
        private boolean tracesInsecureTransport;
        @Deprecated
        private boolean metricsInsecureTransport;
        private String accessToken;
        private String propagators;
        private String logLevel;
        private String serviceName;
        private String serviceVersion;
        private String resourceAttributes;
        private boolean metricsEnabled;
        private Long metricsExportInterval;
        private String metricsTemporality;

        public Configuration withTracesEndpoint(String tracesEndpoint) {
            this.tracesEndpoint = tracesEndpoint;
            return this;
        }

        public Configuration withMetricsEndpoint(String metricsEndpoint) {
            this.metricsEndpoint = metricsEndpoint;
            return this;
        }

        public Configuration withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Configuration withPropagators(String propagators) {
            this.propagators = propagators;
            return this;
        }

        public Configuration withLogLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Configuration withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Configuration withServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Configuration withResourceAttributes(String resourceAttributes) {
            this.resourceAttributes = resourceAttributes;
            return this;
        }

        public Configuration withMetricsExportInterval(Long metricsExportInterval) {
            this.metricsExportInterval = metricsExportInterval;
            return this;
        }

        public Configuration withMetricsTemporalityPreference(String metricsTemporality) {
            this.metricsTemporality = metricsTemporality;
            return this;
        }

        @Deprecated
        public Configuration withTracesInsecureTransport(boolean insecureTransport) {
            this.tracesInsecureTransport = insecureTransport;
            return this;
        }

        @Deprecated
        public Configuration withMetricsInsecureTransport(boolean insecureTransport) {
            this.metricsInsecureTransport = insecureTransport;
            return this;
        }

        public Configuration withMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }
    }
}

