/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.opentelemetry.launcher;

import com.lightstep.opentelemetry.common.VariablesConverter;
import com.lightstep.opentelemetry.launcher.Propagator;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class OpenTelemetryConfiguration {
    private static final Logger logger = Logger.getLogger(OpenTelemetryConfiguration.class.getName());

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String accessToken;
        private String serviceName;
        private String serviceVersion;
        private String tracesEndpoint;
        private String metricsEndpoint;
        private String resourceAttributes;
        @Deprecated
        private boolean tracesInsecureTransport;
        private boolean metricsInsecureTransport;
        private final List<Propagator> propagators = new ArrayList<Propagator>();

        private Builder() {
            this.readEnvVariablesAndSystemProperties();
        }

        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder setTracesEndpoint(String tracesEndpoint) {
            this.tracesEndpoint = tracesEndpoint;
            return this;
        }

        public Builder setPropagator(Propagator propagator) {
            this.propagators.add(propagator);
            return this;
        }

        @Deprecated
        public Builder useInsecureTransport(boolean insecureTransport) {
            this.tracesInsecureTransport = insecureTransport;
            return this;
        }

        public AutoConfiguredOpenTelemetrySdk buildOpenTelemetry() {
            if (this.propagators.isEmpty()) {
                String[] propagatorsArray;
                String propagatorFromEnv = VariablesConverter.getPropagator();
                for (String propagatorLabel : propagatorsArray = propagatorFromEnv.split("\\s*,\\s*")) {
                    Propagator propagator = Propagator.valueOfLabel(propagatorLabel);
                    if (propagator == null) {
                        logger.warning("Unsupported propagator " + propagatorLabel);
                        continue;
                    }
                    this.propagators.add(propagator);
                }
            }
            VariablesConverter.setSystemProperties((VariablesConverter.Configuration)new VariablesConverter.Configuration().withTracesEndpoint(this.tracesEndpoint).withTracesInsecureTransport(this.tracesInsecureTransport).withMetricsEndpoint(this.metricsEndpoint).withMetricsInsecureTransport(this.metricsInsecureTransport).withAccessToken(this.accessToken).withServiceName(this.serviceName).withServiceVersion(this.serviceVersion).withPropagators(this.propagators.stream().map(Propagator::label).collect(Collectors.joining(","))).withResourceAttributes(this.resourceAttributes), (boolean)false);
            return AutoConfiguredOpenTelemetrySdk.initialize();
        }

        public void install() {
            this.buildOpenTelemetry();
        }

        private void readEnvVariablesAndSystemProperties() {
            this.accessToken = VariablesConverter.getAccessToken();
            this.serviceName = VariablesConverter.getServiceName();
            this.serviceVersion = VariablesConverter.getServiceVersion();
            this.tracesEndpoint = VariablesConverter.getTracesEndpoint();
            this.metricsEndpoint = VariablesConverter.getMetricsEndpoint();
            this.resourceAttributes = VariablesConverter.getResourceAttributes();
            this.tracesInsecureTransport = VariablesConverter.useTracesInsecureTransport();
            this.metricsInsecureTransport = VariablesConverter.useMetricsInsecureTransport();
        }

        List<Propagator> getPropagators() {
            return this.propagators;
        }
    }
}

