/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Util;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.Map;

public class B3Propagator
implements Propagator {
    private static final String TRACE_ID_NAME = "X-B3-TraceId";
    private static final String SPAN_ID_NAME = "X-B3-SpanId";
    private static final String SAMPLED_NAME = "X-B3-Sampled";

    @Override
    public <C> void inject(SpanContext spanContext, C carrier) {
        if (!(carrier instanceof TextMapInject)) {
            return;
        }
        TextMapInject textCarrier = (TextMapInject)carrier;
        long traceId = spanContext.getTraceId();
        long spanId = spanContext.getSpanId();
        String foreignTraceId = spanContext.getForeignTraceId();
        if (foreignTraceId != null) {
            textCarrier.put(TRACE_ID_NAME, foreignTraceId);
        } else {
            textCarrier.put(TRACE_ID_NAME, Util.toHexString(traceId));
        }
        textCarrier.put(SPAN_ID_NAME, Util.toHexString(spanId));
        textCarrier.put(SAMPLED_NAME, "1");
    }

    @Override
    public <C> SpanContext extract(C carrier) {
        if (!(carrier instanceof TextMapExtract)) {
            return null;
        }
        Long traceId = null;
        Long spanId = null;
        String foreignTraceId = null;
        for (Map.Entry entry : (TextMapExtract)carrier) {
            if (((String)entry.getKey()).equalsIgnoreCase(TRACE_ID_NAME)) {
                foreignTraceId = (String)entry.getValue();
                traceId = Util.fromHexString(B3Propagator.normalizeTraceId(foreignTraceId));
                continue;
            }
            if (!((String)entry.getKey()).equalsIgnoreCase(SPAN_ID_NAME)) continue;
            spanId = Util.fromHexString((String)entry.getValue());
        }
        if (null != traceId && null != spanId) {
            return new SpanContext(traceId, spanId, foreignTraceId);
        }
        return null;
    }

    static String normalizeTraceId(String traceId) {
        if (traceId.length() > 16) {
            return traceId.substring(traceId.length() - 16);
        }
        return traceId;
    }
}

