/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClient;
import com.lightstep.tracer.shared.Options;
import com.lightstep.tracer.shared.Warner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class CollectorClientProvider {
    public static CollectorClientProvider provider(Options.CollectorClient type, Warner warner) throws ProviderNotFoundException {
        CollectorClientProvider provider = CollectorClientProvider.load(type, warner);
        if (provider == null) {
            throw new ProviderNotFoundException("No functional collector client provider found. Try adding a dependency on the tracer-okhttp or tracer-grpc artifact");
        }
        return provider;
    }

    private static CollectorClientProvider load(Options.CollectorClient type, Warner warner) {
        Iterable<CollectorClientProvider> candidates = CollectorClientProvider.loadCandidates();
        CollectorClientProvider candidate = null;
        for (CollectorClientProvider current : candidates) {
            if (current.type().equals((Object)type)) {
                return current;
            }
            if (candidate != null && current.priority() <= candidate.priority()) continue;
            candidate = current;
        }
        if (type != null) {
            warner.warn("expected " + (Object)((Object)type) + " collector client was not present in classpath. Using " + (Object)((Object)candidate.type()) + " instead.");
        }
        return candidate;
    }

    private static ClassLoader getCorrectClassLoader() {
        if (CollectorClientProvider.isAndroid()) {
            return CollectorClientProvider.class.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Iterable<CollectorClientProvider> loadCandidates() {
        if (CollectorClientProvider.isAndroid()) {
            return CollectorClientProvider.getCandidatesViaHardCoded(CollectorClientProvider.getCorrectClassLoader());
        }
        return CollectorClientProvider.getCandidatesViaServiceLoader();
    }

    private static Collection<CollectorClientProvider> getCandidatesViaHardCoded(ClassLoader loader) {
        ArrayList<CollectorClientProvider> list = new ArrayList<CollectorClientProvider>(2);
        try {
            list.add(CollectorClientProvider.create(Class.forName("com.lightstep.tracer.shared.GrpcCollectorClientProvider", true, loader)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            list.add(CollectorClientProvider.create(Class.forName("com.lightstep.tracer.shared.HttpCollectorClientProvider", true, loader)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    private static Iterable<CollectorClientProvider> getCandidatesViaServiceLoader() {
        return ServiceLoader.load(CollectorClientProvider.class);
    }

    private static CollectorClientProvider create(Class<?> rawClass) {
        try {
            return rawClass.asSubclass(CollectorClientProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new ServiceConfigurationError("Provider " + rawClass.getName() + " could not be instantiated: " + t, t);
        }
    }

    protected abstract int priority();

    protected abstract Options.CollectorClient type();

    abstract CollectorClient forOptions(AbstractTracer var1, Options var2);

    public static class ProviderNotFoundException
    extends RuntimeException {
        public ProviderNotFoundException(String message) {
            super(message);
        }
    }
}

