/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.google.protobuf.InvalidProtocolBufferException;
import com.lightstep.tracer.grpc.propagation.Lightstep;
import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.SpanContext;
import io.opentracing.propagation.BinaryExtract;
import io.opentracing.propagation.BinaryInject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class EnvoyPropagator
implements Propagator {
    @Override
    public <C> void inject(SpanContext spanContext, C carrier) {
        if (!(carrier instanceof BinaryInject)) {
            return;
        }
        Lightstep.BasicTracerCarrier.Builder basicCarrierBuilder = Lightstep.BasicTracerCarrier.newBuilder().setTraceId(spanContext.getTraceId()).setSpanId(spanContext.getSpanId()).setSampled(true);
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            basicCarrierBuilder.putBaggageItems(entry.getKey(), entry.getValue());
        }
        Lightstep.BinaryCarrier bCarrier = Lightstep.BinaryCarrier.newBuilder().setBasicCtx(basicCarrierBuilder.build()).build();
        byte[] buff = bCarrier.toByteArray();
        ByteBuffer byteBuff = ((BinaryInject)carrier).injectionBuffer(buff.length);
        byteBuff.put(buff);
    }

    @Override
    public <C> SpanContext extract(C carrier) {
        if (!(carrier instanceof BinaryExtract)) {
            return null;
        }
        ByteBuffer byteBuff = ((BinaryExtract)carrier).extractionBuffer();
        if (byteBuff == null || !byteBuff.hasRemaining()) {
            return null;
        }
        Lightstep.BasicTracerCarrier basicCarrier = null;
        try {
            basicCarrier = Lightstep.BinaryCarrier.parseFrom(byteBuff).getBasicCtx();
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
        HashMap<String, String> baggage = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : basicCarrier.getBaggageItemsMap().entrySet()) {
            baggage.put(entry.getKey(), entry.getValue());
        }
        return new SpanContext((Long)basicCarrier.getTraceId(), (Long)basicCarrier.getSpanId(), baggage);
    }
}

