/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.Util;
import io.opentracing.ScopeManager;
import io.opentracing.propagation.Format;
import io.opentracing.util.ThreadLocalScopeManager;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class Options {
    private static final String COMPONENT_NAME_SYSTEM_PROPERTY_KEY = "sun.java.command";
    public static final int DEFAULT_MAX_BUFFERED_SPANS = 1000;
    private static final long DEFAULT_REPORTING_INTERVAL_MILLIS = 3000L;
    private static final long DEFAULT_DEADLINE_MILLIS = 30000L;
    static final Map<Format<?>, Propagator> BUILTIN_PROPAGATORS = Collections.unmodifiableMap(new HashMap<Format<?>, Propagator>(){
        {
            this.put(Format.Builtin.HTTP_HEADERS, Propagator.HTTP_HEADERS);
            this.put(Format.Builtin.TEXT_MAP, Propagator.TEXT_MAP);
            this.put(Format.Builtin.TEXT_MAP_INJECT, Propagator.TEXT_MAP);
            this.put(Format.Builtin.TEXT_MAP_EXTRACT, Propagator.TEXT_MAP);
            this.put(Format.Builtin.BINARY, Propagator.BINARY);
            this.put(Format.Builtin.BINARY_INJECT, Propagator.BINARY);
            this.put(Format.Builtin.BINARY_EXTRACT, Propagator.BINARY);
        }
    });
    public static final int VERBOSITY_DEBUG = 4;
    public static final int VERBOSITY_INFO = 3;
    public static final int VERBOSITY_ERRORS_ONLY = 2;
    public static final int VERBOSITY_FIRST_ERROR_ONLY = 1;
    public static final int VERBOSITY_NONE = 0;
    final boolean disableMetaEventLogging;
    final String accessToken;
    final String serviceVersion;
    final URL collectorUrl;
    final Map<String, Object> tags;
    final long maxReportingIntervalMillis;
    final int maxBufferedSpans;
    final int verbosity;
    final boolean disableReportingLoop;
    final boolean resetClient;
    final boolean useClockCorrection;
    final ScopeManager scopeManager;
    final Map<Format<?>, Propagator> propagators;
    final CollectorClient collectorClient;
    final String grpcCollectorTarget;
    final boolean grpcRoundRobin;
    final OkHttpDns okhttpDns;
    final String metricsUrl;
    final boolean disableMetricsReporting;
    final long deadlineMillis;

    private Options(String accessToken, String serviceVersion, URL collectorUrl, long maxReportingIntervalMillis, int maxBufferedSpans, int verbosity, boolean disableReportingLoop, boolean resetClient, Map<String, Object> tags, boolean useClockCorrection, ScopeManager scopeManager, long deadlineMillis, Map<Format<?>, Propagator> propagators, String metricsUrl, boolean disableMetricsReporting, CollectorClient collectorClient, String grpcCollectorTarget, boolean grpcRoundRobin, OkHttpDns okhttpDns, boolean disableMetaEventLogging) {
        this.accessToken = accessToken;
        this.serviceVersion = serviceVersion;
        this.collectorUrl = collectorUrl;
        this.maxReportingIntervalMillis = maxReportingIntervalMillis;
        this.maxBufferedSpans = maxBufferedSpans;
        this.verbosity = verbosity;
        this.disableReportingLoop = disableReportingLoop;
        this.resetClient = resetClient;
        this.tags = tags;
        this.useClockCorrection = useClockCorrection;
        this.scopeManager = scopeManager;
        this.deadlineMillis = deadlineMillis;
        this.propagators = propagators;
        this.metricsUrl = metricsUrl;
        this.disableMetricsReporting = disableMetricsReporting;
        this.collectorClient = collectorClient;
        this.grpcCollectorTarget = grpcCollectorTarget;
        this.grpcRoundRobin = grpcRoundRobin;
        this.okhttpDns = okhttpDns;
        this.disableMetaEventLogging = disableMetaEventLogging;
    }

    long getGuid() {
        return (Long)this.tags.get("lightstep.guid");
    }

    String getComponentName() {
        return (String)this.tags.get("lightstep.component_name");
    }

    public Options setDefaultReportingIntervalMillis(int value) {
        if (this.maxReportingIntervalMillis != 3000L) {
            return this;
        }
        try {
            return new OptionsBuilder(this).withMaxReportingIntervalMillis(value).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unexpected error when building a new set ofoptions from a valid set of existing options. collectorUrl=" + this.collectorUrl);
        }
    }

    public Options disableResetClient() {
        try {
            return new OptionsBuilder(this).withResetClient(false).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unexpected error when building a new set ofoptions from a valid set of existing options. collectorUrl=" + this.collectorUrl);
        }
    }

    public static class OptionsBuilder {
        private String accessToken = "";
        private String serviceVersion = "";
        private String collectorProtocol = "https";
        private String collectorHost = "collector-grpc.lightstep.com";
        private int collectorPort = -1;
        private long maxReportingIntervalMillis;
        private int maxBufferedSpans = -1;
        private int verbosity = 1;
        private boolean disableReportingLoop = false;
        private boolean resetClient = true;
        private boolean useClockCorrection = true;
        private Map<String, Object> tags = new HashMap<String, Object>();
        private ScopeManager scopeManager;
        private long deadlineMillis = -1L;
        private Map<Format<?>, Propagator> propagators = new HashMap();
        private boolean disableMetaEventLogging = false;
        private String metricsUrl = "https://ingest.lightstep.com:443/metrics";
        private boolean disableMetricsReporting = false;
        private CollectorClient collectorClient;
        private String grpcCollectorTarget;
        private boolean grpcRoundRobin = false;
        private OkHttpDns okhttpDns;

        public OptionsBuilder() {
        }

        public OptionsBuilder(Options options) {
            this.accessToken = options.accessToken;
            this.serviceVersion = options.serviceVersion;
            this.collectorProtocol = options.collectorUrl.getProtocol();
            this.collectorHost = options.collectorUrl.getHost();
            this.collectorPort = options.collectorUrl.getPort();
            this.maxReportingIntervalMillis = options.maxReportingIntervalMillis;
            this.maxBufferedSpans = options.maxBufferedSpans;
            this.verbosity = options.verbosity;
            this.disableReportingLoop = options.disableReportingLoop;
            this.resetClient = options.resetClient;
            this.tags = options.tags;
            this.scopeManager = options.scopeManager;
            this.useClockCorrection = options.useClockCorrection;
            this.deadlineMillis = options.deadlineMillis;
            this.propagators = options.propagators;
            this.metricsUrl = options.metricsUrl;
            this.disableMetricsReporting = options.disableMetricsReporting;
            this.disableMetaEventLogging = options.disableMetaEventLogging;
            this.collectorClient = options.collectorClient;
            this.grpcCollectorTarget = options.grpcCollectorTarget;
            this.grpcRoundRobin = options.grpcRoundRobin;
            this.okhttpDns = options.okhttpDns;
        }

        public <T> OptionsBuilder withPropagator(Format<T> format, Propagator propagator) {
            if (format == null) {
                throw new IllegalArgumentException("format cannot be null");
            }
            if (propagator == null) {
                throw new IllegalArgumentException("propagator cannot be null");
            }
            this.propagators.put(format, propagator);
            return this;
        }

        public OptionsBuilder withAccessToken(String accessToken) {
            if (accessToken == null) {
                accessToken = "";
            }
            this.accessToken = accessToken;
            return this;
        }

        public OptionsBuilder withServiceVersion(String serviceVersion) {
            if (serviceVersion == null) {
                throw new IllegalArgumentException("serviceVersion cannot be null");
            }
            this.serviceVersion = serviceVersion;
            return this;
        }

        public OptionsBuilder withCollectorProtocol(String protocol) {
            if (!"https".equals(protocol) && !"http".equals(protocol)) {
                throw new IllegalArgumentException("Invalid protocol for collector: " + protocol);
            }
            this.collectorProtocol = protocol;
            return this;
        }

        public OptionsBuilder withCollectorHost(String collectorHost) {
            if (collectorHost == null || "".equals(collectorHost.trim())) {
                throw new IllegalArgumentException("Invalid collector host: " + collectorHost);
            }
            this.collectorHost = collectorHost;
            return this;
        }

        public OptionsBuilder withCollectorPort(int collectorPort) {
            if (collectorPort <= 0) {
                throw new IllegalArgumentException("Invalid collector port: " + collectorPort);
            }
            this.collectorPort = collectorPort;
            return this;
        }

        public OptionsBuilder withCollectorClient(CollectorClient collectorClient) {
            this.collectorClient = collectorClient;
            return this;
        }

        public OptionsBuilder withGrpcCollectorTarget(String grpcCollectorTarget) {
            if (grpcCollectorTarget == null) {
                throw new IllegalArgumentException("Invalid grpc collector target: " + grpcCollectorTarget);
            }
            this.grpcCollectorTarget = grpcCollectorTarget;
            return this;
        }

        public OptionsBuilder withGrpcRoundRobin(boolean grpcRoundRobin) {
            this.grpcRoundRobin = grpcRoundRobin;
            return this;
        }

        public OptionsBuilder withOkHttpDns(OkHttpDns okhttpDns) {
            if (okhttpDns == null) {
                throw new IllegalArgumentException("dns cannot be null");
            }
            this.okhttpDns = okhttpDns;
            return this;
        }

        public OptionsBuilder withScopeManager(ScopeManager scopeManager) {
            if (scopeManager == null) {
                throw new IllegalArgumentException("scopeManager cannot be null");
            }
            this.scopeManager = scopeManager;
            return this;
        }

        public OptionsBuilder withComponentName(String name) {
            return this.withTag("lightstep.component_name", name);
        }

        public OptionsBuilder withTag(String key, Object value) {
            this.tags.put(key, value);
            return this;
        }

        public OptionsBuilder withMaxReportingIntervalMillis(int maxReportingIntervalMillis) {
            this.maxReportingIntervalMillis = maxReportingIntervalMillis;
            return this;
        }

        public OptionsBuilder withMaxBufferedSpans(int maxBufferedSpans) {
            this.maxBufferedSpans = maxBufferedSpans;
            return this;
        }

        public OptionsBuilder withVerbosity(int verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public OptionsBuilder withDisableReportingLoop(boolean disable) {
            this.disableReportingLoop = disable;
            return this;
        }

        public OptionsBuilder withResetClient(boolean reset) {
            this.resetClient = reset;
            return this;
        }

        public OptionsBuilder withDeadlineMillis(long deadlineMillis) {
            this.deadlineMillis = deadlineMillis;
            return this;
        }

        public OptionsBuilder withMetricsUrl(String metricsUrl) {
            if (metricsUrl == null) {
                throw new IllegalArgumentException("metricsUrl cannot be null");
            }
            this.metricsUrl = metricsUrl;
            return this;
        }

        public OptionsBuilder withDisableMetricsReporting(boolean disable) {
            this.disableMetricsReporting = disable;
            return this;
        }

        public OptionsBuilder withDisableMetaEventLogging(boolean disableMetaEventLogging) {
            this.disableMetaEventLogging = disableMetaEventLogging;
            return this;
        }

        public OptionsBuilder withClockSkewCorrection(boolean clockCorrection) {
            this.useClockCorrection = clockCorrection;
            return this;
        }

        public Options build() throws MalformedURLException {
            this.defaultComponentName();
            this.defaultGuid();
            this.defaultMaxReportingIntervalMillis();
            this.defaultMaxBufferedSpans();
            this.defaultPropagators();
            this.defaultScopeManager();
            this.defaultDeadlineMillis();
            return new Options(this.accessToken, this.serviceVersion, this.getCollectorUrl(), this.maxReportingIntervalMillis, this.maxBufferedSpans, this.verbosity, this.disableReportingLoop, this.resetClient, this.tags, this.useClockCorrection, this.scopeManager, this.deadlineMillis, this.propagators, this.metricsUrl, this.disableMetricsReporting, this.collectorClient, this.grpcCollectorTarget, this.grpcRoundRobin, this.okhttpDns, this.disableMetaEventLogging);
        }

        private void defaultScopeManager() {
            if (this.scopeManager == null) {
                this.scopeManager = new ThreadLocalScopeManager();
            }
        }

        private void defaultMaxReportingIntervalMillis() {
            if (this.maxReportingIntervalMillis <= 0L) {
                this.maxReportingIntervalMillis = 3000L;
            }
        }

        private void defaultMaxBufferedSpans() {
            if (this.maxBufferedSpans < 0) {
                this.maxBufferedSpans = 1000;
            }
        }

        private void defaultGuid() {
            if (this.tags.get("lightstep.guid") == null) {
                this.withTag("lightstep.guid", Util.generateRandomGUID());
            }
        }

        private void defaultComponentName() {
            StringTokenizer st;
            String componentNameSystemProperty;
            if (this.tags.get("lightstep.component_name") == null && (componentNameSystemProperty = System.getProperty(Options.COMPONENT_NAME_SYSTEM_PROPERTY_KEY)) != null && (st = new StringTokenizer(componentNameSystemProperty)).hasMoreTokens()) {
                String name = st.nextToken();
                this.withComponentName(name);
            }
        }

        private void defaultDeadlineMillis() {
            if (this.deadlineMillis < 0L) {
                this.deadlineMillis = 30000L;
            }
        }

        private void defaultPropagators() {
            for (Map.Entry<Format<?>, Propagator> entry : BUILTIN_PROPAGATORS.entrySet()) {
                Format<?> format = entry.getKey();
                if (this.propagators.containsKey(format)) continue;
                this.propagators.put(format, entry.getValue());
            }
        }

        private int getPort() {
            if (this.collectorPort > 0) {
                return this.collectorPort;
            }
            if (this.collectorProtocol.equals("https")) {
                return 443;
            }
            return 80;
        }

        private URL getCollectorUrl() throws MalformedURLException {
            int port = this.getPort();
            return new URL(this.collectorProtocol, this.collectorHost, port, "/api/v2/reports");
        }
    }

    public static interface OkHttpDns {
        public List<InetAddress> lookup(String var1);
    }

    public static enum CollectorClient {
        HTTP,
        GRPC;

    }
}

