/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.SpanContext;
import io.opentracing.propagation.Format;
import java.util.LinkedList;
import java.util.List;

public final class PropagatorStack
implements Propagator {
    Format format;
    List<Propagator> propagators;

    public PropagatorStack(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("format cannot be null");
        }
        this.format = format;
        this.propagators = new LinkedList<Propagator>();
    }

    public Format format() {
        return this.format;
    }

    public PropagatorStack pushPropagator(Propagator propagator) {
        if (propagator == null) {
            throw new IllegalArgumentException("propagator cannot be null");
        }
        this.propagators.add(propagator);
        return this;
    }

    @Override
    public <C> SpanContext extract(C carrier) {
        for (int i = this.propagators.size() - 1; i >= 0; --i) {
            SpanContext context = this.propagators.get(i).extract(carrier);
            if (context == null) continue;
            return context;
        }
        return null;
    }

    @Override
    public <C> void inject(SpanContext context, C carrier) {
        for (int i = 0; i < this.propagators.size(); ++i) {
            this.propagators.get(i).inject(context, carrier);
        }
    }
}

